/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.AddressFieldOptionsPropertyEditor;
import ghidra.app.util.viewer.field.AddressFieldOptionsWrappedOption;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.beans.PropertyEditor;
import java.math.BigInteger;

public class AddressFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Address";
    public static final Color DEFAULT_COLOR = Color.BLACK;
    private static final String GROUP_TITLE = "Address Field";
    public static final String DISPLAY_BLOCK_NAME = "Address Field.Display Block Name";
    public static final String ADDRESS_DISPLAY_OPTIONS_NAME = "Address Field.Address Display Options";
    private boolean displayBlockName;
    private boolean padZeros;
    private int minHexDigits;
    private boolean rightJustify;
    private PropertyEditor addressFieldOptionsEditor = new AddressFieldOptionsPropertyEditor();

    public AddressFieldFactory() {
        super(FIELD_NAME);
    }

    private AddressFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.initOptions(fieldOptions);
    }

    private void initOptions(Options fieldOptions) {
        HelpLocation helpLoc = new HelpLocation("CodeBrowserPlugin", "Address_Field");
        fieldOptions.registerOption(ADDRESS_DISPLAY_OPTIONS_NAME, OptionType.CUSTOM_TYPE, (Object)new AddressFieldOptionsWrappedOption(), helpLoc, null, this.addressFieldOptionsEditor);
        CustomOption customOption = fieldOptions.getCustomOption(ADDRESS_DISPLAY_OPTIONS_NAME, null);
        if (!(customOption instanceof AddressFieldOptionsWrappedOption)) {
            throw new AssertException("Someone set an option for Address Field.Address Display Options that is not the expected " + AddressFieldOptionsWrappedOption.class.getName() + " type.");
        }
        AddressFieldOptionsWrappedOption afowo = (AddressFieldOptionsWrappedOption)customOption;
        this.padZeros = afowo.padWithZeros();
        this.minHexDigits = afowo.getMinimumHexDigits();
        this.displayBlockName = afowo.showBlockName();
        this.rightJustify = afowo.rightJustify();
        fieldOptions.getOptions(GROUP_TITLE).setOptionsHelpLocation(helpLoc);
    }

    @Override
    public Color getDefaultColor() {
        return DEFAULT_COLOR;
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionsName, Object oldValue, Object newValue) {
        if (optionsName.equals(ADDRESS_DISPLAY_OPTIONS_NAME)) {
            AddressFieldOptionsWrappedOption afowo = (AddressFieldOptionsWrappedOption)newValue;
            this.padZeros = afowo.padWithZeros();
            this.minHexDigits = afowo.getMinimumHexDigits();
            this.displayBlockName = afowo.showBlockName();
            this.rightJustify = afowo.rightJustify();
            this.model.update();
        }
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        String text = this.getAddressString(cu);
        TextFieldElement as = new TextFieldElement(new AttributedString(text, this.color, this.getMetrics()), 0, 0);
        ListingTextField ltf = this.rightJustify ? ListingTextField.createSingleLineTextFieldWithReverseClipping(this, proxy, (FieldElement)as, this.startX + varWidth, this.width, this.hlProvider) : ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)as, this.startX + varWidth, this.width, this.hlProvider);
        ltf.setPrimary(true);
        return ltf;
    }

    private String getAddressString(CodeUnit cu) {
        Address addr = cu.getMinAddress();
        AddressSpace space = addr.getAddressSpace();
        if (this.displayBlockName) {
            String text = addr.toString(false, this.padZeros ? 16 : this.minHexDigits);
            MemoryBlock block = cu.getProgram().getMemory().getBlock(addr);
            if (block != null) {
                return block.getName() + ":" + text;
            }
        }
        return addr.toString(space.showSpaceName(), this.padZeros ? 16 : this.minHexDigits);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField lf) {
        Object obj = lf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Address addr = cu.getMinAddress();
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        return new AddressFieldLocation(cu.getProgram(), addr, cpath, addr.toString(), col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField lf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Object obj = lf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        if (loc.getClass() == ProgramLocation.class) {
            if (loc.getComponentPath() == null || this.hasSamePath(lf, loc)) {
                return new FieldLocation(index, fieldNum, 0, 0);
            }
        } else {
            if (loc.getClass() == CodeUnitLocation.class) {
                return new FieldLocation(index, fieldNum, 0, 0);
            }
            if (loc instanceof AddressFieldLocation && this.hasSamePath(lf, loc)) {
                return new FieldLocation(index, fieldNum, 0, ((AddressFieldLocation)loc).getCharOffset());
            }
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5 || category == 6;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel newModel, HighlightProvider highlightStringProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new AddressFieldFactory(newModel, highlightStringProvider, (Options)displayOptions, (Options)fieldOptions);
    }
}

