/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitledPanel
extends JPanel {
    private JLabel title;
    private JPanel titlePanel;
    private JPanel iconPanel;
    private JComponent bottomComp;
    private List<JComponent> titleComps = new ArrayList<JComponent>();

    public TitledPanel(String name, JComponent panel, int margin) {
        super(new BorderLayout());
        this.titlePanel = new JPanel(new BorderLayout());
        this.iconPanel = new JPanel(new FlowLayout(1, 4, 1));
        this.iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.title = new JLabel(name);
        this.title.setToolTipText(name);
        JLabel filler = new JLabel();
        filler.setPreferredSize(new Dimension(margin, filler.getPreferredSize().height));
        this.titlePanel.add((Component)filler, "West");
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.titlePanel.add((Component)this.title, "Center");
        this.titlePanel.add((Component)this.iconPanel, "East");
        this.add((Component)this.titlePanel, "North");
        this.add((Component)panel, "Center");
    }

    public void setTitleName(String name) {
        this.title.setText(name);
        this.title.setToolTipText(name);
    }

    public void addTitleComponent(JComponent comp) {
        this.titleComps.add(0, comp);
        this.iconPanel.removeAll();
        for (int i = 0; i < this.titleComps.size(); ++i) {
            this.iconPanel.add(this.titleComps.get(i));
        }
    }

    public void setBottomComponent(JComponent comp) {
        if (comp == this.bottomComp) {
            return;
        }
        if (this.bottomComp != null) {
            this.remove(this.bottomComp);
            this.bottomComp = null;
        }
        if (comp != null) {
            this.bottomComp = comp;
            this.add((Component)this.bottomComp, "South");
        }
    }
}

