/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.tasks;

import docking.widgets.OptionDialog;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.util.DateUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import utilities.util.FileUtilities;

public class GFileSystemExtractAllTask
extends Task {
    private FSRL srcFSRL;
    private File outputDirectory;
    private Component parentComponent;
    private int totalFilesExportedCount;
    private int totalDirExportedCount;
    private long totalBytesExportedCount;
    private boolean skipAllErrors;
    private Map<FSRL, String> errorredFiles = new LinkedHashMap<FSRL, String>();

    public GFileSystemExtractAllTask(FSRL srcFSRL, File outputDirectory, Component parentComponent) {
        super("Extracting directory...", true, false, true);
        this.srcFSRL = srcFSRL;
        this.outputDirectory = outputDirectory;
        this.parentComponent = parentComponent;
    }

    public void run(TaskMonitor monitor) {
        long start_ts = System.currentTimeMillis();
        monitor.setMessage("Extracting all...");
        try (RefdFile refdFile = FileSystemService.getInstance().getRefdFile(this.srcFSRL, monitor);){
            GFileSystem fs = refdFile.fsRef.getFilesystem();
            GFile file = refdFile.file;
            if (!file.isDirectory()) {
                Msg.warn((Object)((Object)this), (Object)("Extract All source not a directory!  " + file.getFSRL()));
                return;
            }
            File destDir = this.getDestDir(file.getName());
            if (destDir != null) {
                this.processDirectory(fs, file, destDir, monitor);
            }
        }
        catch (CancelledException ce) {
            Msg.warn((Object)((Object)this), (Object)"Extract all task canceled");
        }
        catch (IOException | UnsupportedOperationException e) {
            Msg.showError((Object)((Object)this), (Component)this.parentComponent, (String)"Error extracting file", (Object)e.getMessage());
        }
        Msg.info((Object)((Object)this), (Object)("Exported " + this.totalFilesExportedCount + " files, " + this.totalDirExportedCount + " directories, " + this.totalBytesExportedCount + " bytes"));
        long elapsed = System.currentTimeMillis() - start_ts;
        int option = OptionDialog.showOptionDialog((Component)this.parentComponent, (String)"Export Summary", (String)("<html><div style='margin-bottom: 20pt; text-align: center; font-weight: bold'>Export files summary:</div><div style='margin-bottom: 20pt'>Source location:</div><div style='margin-bottom: 20pt; margin-left: 50pt'>" + HTMLUtilities.friendlyEncodeHTML((String)this.srcFSRL.toPrettyString()) + "</div><div style='margin-bottom: 20pt;'>Destination:</div><div style='margin-bottom: 20pt; margin-left: 50pt'>" + HTMLUtilities.friendlyEncodeHTML((String)this.outputDirectory.getPath()) + "</div><div style='margin-bottom: 20pt;'>Elapsed time: " + DateUtils.formatDuration((long)elapsed) + "</div><table style='margin-bottom: 20pt;' width='100%'><tr><td></td><td>Files</td><td>Directories</td><td>Bytes</td></tr><tr><td>Successful</td><td>" + this.totalFilesExportedCount + "</td><td>" + this.totalDirExportedCount + "</td><td>" + FileUtilities.formatLength((long)this.totalBytesExportedCount) + "</td></tr><tr><td>Failed</td><td>" + this.errorredFiles.size() + "</td><td></td><td></td></tr></table></div></html>"), (String)"OK", (String)"Show exported files");
        if (option == 2) {
            try {
                FileUtilities.openNative((File)this.outputDirectory);
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), (Component)this.parentComponent, (String)"Problem Starting Explorer", (Object)("Problem starting file explorer: " + e.getMessage()));
            }
        }
    }

    private File getDestDir(String destDirName) {
        int answer;
        File destDir;
        boolean isSameName = destDirName.equals(this.outputDirectory.getName());
        File file = destDir = isSameName ? this.outputDirectory : new File(this.outputDirectory, destDirName);
        if (destDir.isFile()) {
            Msg.showError((Object)((Object)this), (Component)this.parentComponent, (String)"Export Destination Error", (Object)("Unable to export to " + destDir + " as it is a file"));
            return null;
        }
        if (destDir.exists() && destDir.list().length > 0 && (answer = OptionDialog.showYesNoDialog((Component)this.parentComponent, (String)"Verify Export Destination", (String)(destDir.getAbsolutePath() + "\nThe directory is not empty.\nDo you want to overwrite the contents?"))) == 2) {
            return null;
        }
        return destDir;
    }

    private void processDirectory(GFileSystem fs, GFile srcGFileDirectory, File destDirectory, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.isSpecialDirectory(srcGFileDirectory)) {
            return;
        }
        if (!FileUtilities.isPathContainedWithin((File)this.outputDirectory, (File)destDirectory)) {
            String srcPath = srcGFileDirectory != null ? srcGFileDirectory.getPath() : "/";
            throw new IOException("Extracted directory " + srcPath + " [" + destDirectory + "] would be outside of root destination directory: " + this.outputDirectory);
        }
        if (!destDirectory.isDirectory() && !destDirectory.mkdirs()) {
            throw new IOException("Failed to create destination directory " + destDirectory);
        }
        ++this.totalDirExportedCount;
        for (GFile file : fs.getListing(srcGFileDirectory)) {
            monitor.checkCanceled();
            String fname = FSUtilities.getSafeFilename(file.getName());
            File destFSFile = new File(destDirectory, fname);
            if (file.isDirectory()) {
                this.processDirectory(fs, file, destFSFile, monitor);
                continue;
            }
            try {
                if (!FileUtilities.isPathContainedWithin((File)this.outputDirectory, (File)destFSFile)) {
                    throw new IOException("Extracted file " + file.getPath() + " [" + destFSFile + "] would be outside of root destination directory: " + this.outputDirectory);
                }
                this.extractFile(file, destFSFile.getCanonicalFile(), monitor);
            }
            catch (CancelledException | IOCancelledException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.handleUnexpectedException(file, e)) continue;
                throw e;
            }
        }
    }

    private boolean handleUnexpectedException(GFile file, Exception e) {
        this.errorredFiles.put(file.getFSRL(), e.getMessage());
        if (this.skipAllErrors) {
            return true;
        }
        int option = OptionDialog.showOptionDialog((Component)this.parentComponent, (String)"Error Extracting File", (String)("There was a problem copying file " + file.getPath() + "\n\n" + e.getMessage() + "\n\nSkip this file and continue or cancel entire operation?"), (String)"Skip && Continue", (String)"Skip All");
        if (option == 2) {
            this.skipAllErrors = true;
        }
        return this.skipAllErrors || option == 1;
    }

    private boolean isSpecialDirectory(GFile directory) {
        if (directory == null) {
            return false;
        }
        switch (directory.getName()) {
            case "\u0000\u0000\u0000\u0000HFS+ Private Data": 
            case ".HFS+ Private Directory Data\r": {
                return true;
            }
        }
        return false;
    }

    private void extractFile(GFile file, File outputFile, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (file.getLength() == 0L) {
            return;
        }
        monitor.setMessage(file.getName());
        File cacheFile = FileSystemService.getInstance().getFile(file.getFSRL(), monitor);
        if (cacheFile == null) {
            return;
        }
        try (FileInputStream in = new FileInputStream(cacheFile);
             FileOutputStream out = new FileOutputStream(outputFile);){
            long bytesCopied = FileUtilities.copyStreamToStream((InputStream)in, (OutputStream)out, (TaskMonitor)monitor);
            if (file.getLength() != -1L && bytesCopied != file.getLength()) {
                throw new IOException("Failed to copy the correct number of bytes from " + file.getFSRL() + " to " + outputFile + ".  Expected " + file.getLength() + ", bytes copied " + bytesCopied);
            }
            this.totalBytesExportedCount += bytesCopied;
            ++this.totalFilesExportedCount;
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)("Error when copying file " + file.getFSRL() + " to " + outputFile), (Throwable)e);
        }
    }
}

