/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.util.UnsignedDataUtils;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.framework.model.DomainObject;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.OpBehaviorFactory;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ProgramContextImpl;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class SymbolicPropogator {
    private static final int _POINTER_MIN_BOUNDS = 256;
    private static long[] maskSize = new long[]{255L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    protected List<AddressSpace> memorySpaces;
    private boolean defaultSpacesAreTheSame = false;
    protected ContextEvaluator evaluator = null;
    protected Program program;
    protected ProgramContext programContext;
    protected ProgramContext spaceContext;
    protected ProgramContext savedProgramContext;
    protected ProgramContext savedSpaceContext;
    protected boolean canceled = false;
    protected boolean readExecutableAddress;
    protected VarnodeContext context;
    protected boolean conflict;
    protected boolean hitCodeFlow = false;
    protected boolean debug = false;
    private static final NotFoundException valueTooBigException = new NotFoundException("Value too big to fit in Scalar");
    private static final NotFoundException divideByZeroException = new NotFoundException("Divide by zero");
    private long pointerMask;
    private AddressRange externalBlockRange;
    protected static final int MAX_EXACT_INSTRUCTIONS = 100;
    protected int lastFullHashCode = 0;
    protected int lastInstrCode = -1;
    protected int sameInstrCount = 0;
    private boolean checkForParamRefs = true;
    private boolean checkForReturnRefs = true;
    private boolean checkForStoredRefs = true;
    HashMap<Address, PcodeOp[]> pcodeCache = new HashMap();
    HashMap<Address, Instruction> instructionAtCache = new HashMap();
    HashMap<Address, Instruction> instructionContainingCache = new HashMap();
    HashMap<Address, Address[]> instructionFlowsCache = new HashMap();

    public SymbolicPropogator(Program program) {
        this.program = program;
        Register[] regs = program.getLanguage().getRegisters();
        this.programContext = new ProgramContextImpl(regs);
        this.spaceContext = new ProgramContextImpl(regs);
        this.setPointerMask(program);
        this.setExternalRange(program);
        this.context = new VarnodeContext(program, this.programContext, this.spaceContext);
        this.context.setDebug(this.debug);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.context.setDebug(debug);
    }

    private void setPointerMask(Program program) {
        int ptrSize = program.getDefaultPointerSize();
        if (ptrSize > 8) {
            ptrSize = 8;
        }
        this.pointerMask = maskSize[ptrSize];
    }

    private void setExternalRange(Program program) {
        MemoryBlock block = program.getMemory().getBlock("EXTERNAL");
        if (block != null) {
            this.externalBlockRange = new AddressRangeImpl(block.getStart(), block.getEnd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSet flowConstants(Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, boolean saveContext, TaskMonitor monitor) throws CancelledException {
        Register[] regWithVals;
        this.evaluator = eval;
        AddressSpace defaultDataSpace = this.program.getLanguage().getDefaultDataSpace();
        AddressSpace defaultSpace = this.program.getLanguage().getDefaultSpace();
        this.defaultSpacesAreTheSame = defaultSpace.equals(defaultDataSpace);
        AddressSpace defaultAddrSpace = this.program.getAddressFactory().getDefaultAddressSpace();
        this.memorySpaces = new ArrayList<AddressSpace>();
        for (AddressSpace space : this.program.getAddressFactory().getAddressSpaces()) {
            if (!space.isLoadedMemorySpace()) continue;
            if (space == defaultAddrSpace) {
                this.memorySpaces.add(0, space);
                continue;
            }
            this.memorySpaces.add(space);
        }
        this.savedProgramContext = this.programContext;
        this.savedSpaceContext = this.spaceContext;
        if (!saveContext) {
            this.context = this.saveOffCurrentContext(startAddr);
        }
        for (Register regWithVal : regWithVals = this.program.getProgramContext().getRegistersWithValues()) {
            RegisterValue regVal = this.program.getProgramContext().getRegisterValue(regWithVal, startAddr);
            if (regVal == null || !regVal.hasValue()) continue;
            this.context.setFutureRegisterValue(startAddr, regVal);
            if (!regVal.getRegister().getAddress().isMemoryAddress()) continue;
            Register reg = regVal.getRegister();
            this.context.putValue(this.context.getRegisterVarnode(reg), this.context.createConstantVarnode(regVal.getUnsignedValue().longValue(), reg.getMinimumByteSize()), false);
        }
        AddressSet bodyDone = null;
        try {
            bodyDone = this.flowConstants(startAddr, restrictSet, eval, this.context, monitor);
        }
        finally {
            this.programContext = this.savedProgramContext;
            this.spaceContext = this.savedSpaceContext;
        }
        this.readExecutableAddress = this.context.readExecutableCode();
        return bodyDone;
    }

    protected VarnodeContext saveOffCurrentContext(Address startAddr) {
        Register[] regWithVals;
        ProgramContextImpl newValueContext = new ProgramContextImpl(this.programContext.getRegisters());
        ProgramContextImpl newSpaceContext = new ProgramContextImpl(this.programContext.getRegisters());
        VarnodeContext newContext = new VarnodeContext(this.program, (ProgramContext)newValueContext, (ProgramContext)newSpaceContext);
        newContext.setDebug(this.debug);
        int constantSpaceID = this.program.getAddressFactory().getConstantSpace().getBaseSpaceID();
        for (Register regWithVal : regWithVals = this.programContext.getRegistersWithValues()) {
            RegisterValue regVal = this.programContext.getRegisterValue(regWithVal, startAddr);
            RegisterValue spRegVal = this.spaceContext.getRegisterValue(regWithVal, startAddr);
            if (regVal == null || spRegVal != null && (spRegVal.getUnsignedValue() == null || spRegVal.getUnsignedValue().longValue() != (long)constantSpaceID)) continue;
            newContext.setFutureRegisterValue(startAddr, regVal);
        }
        this.programContext = newValueContext;
        this.spaceContext = newSpaceContext;
        return newContext;
    }

    public Value getRegisterValue(Address toAddr, Register reg) {
        Varnode val = this.context.getRegisterVarnodeValue(reg, Address.NO_ADDRESS, toAddr, true);
        if (val == null) {
            return null;
        }
        if (val.isConstant()) {
            return new Value(val.getOffset());
        }
        AddressSpace space = val.getAddress().getAddressSpace();
        if (space.getName().startsWith("track_")) {
            return new Value(val.getOffset());
        }
        Register relativeReg = this.program.getRegister(space.getName());
        if (relativeReg != null) {
            return new Value(relativeReg, val.getOffset());
        }
        return null;
    }

    public String getRegisterValueRepresentation(Address addr, Register reg) {
        Varnode val = this.context.getRegisterVarnodeValue(reg, Address.NO_ADDRESS, addr, true);
        if (val == null) {
            return "-";
        }
        if (val.isConstant()) {
            return this.context.getRegisterValue(reg, Address.NO_ADDRESS, addr).toString();
        }
        AddressSpace space = val.getAddress().getAddressSpace();
        if (space.getName().startsWith("track_")) {
            return reg + "+" + BigInteger.valueOf(val.getOffset()).toString(16);
        }
        if (this.context.isSymbol(val)) {
            return val.getAddress().getAddressSpace().getName() + " + " + val.getOffset();
        }
        return "-";
    }

    public void setRegister(Address addr, Register stackReg) {
        this.context.flowStart(Address.NO_ADDRESS, addr);
        int spaceID = this.context.getAddressSpace(stackReg.getName());
        Varnode vnode = this.context.createVarnode(0L, spaceID, stackReg.getBitLength() / 8);
        this.context.putValue(this.context.getRegisterVarnode(stackReg), vnode, false);
        this.context.propogateResults(false);
        this.context.flowEnd(addr);
    }

    public AddressSet flowConstants(Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, VarnodeContext vContext, TaskMonitor monitor) throws CancelledException {
        return this.flowConstants(Address.NO_ADDRESS, startAddr, restrictSet, eval, vContext, monitor);
    }

    public AddressSet flowConstants(Address fromAddr, Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, VarnodeContext vContext, TaskMonitor monitor) throws CancelledException {
        boolean callCouldCauseBadStackDepth;
        AddressSet body = new AddressSet();
        AddressSet conflicts = new AddressSet();
        Stack<SavedFlowState> contextStack = new Stack<SavedFlowState>();
        contextStack.push(new SavedFlowState(fromAddr, startAddr, true));
        this.canceled = false;
        boolean bl = callCouldCauseBadStackDepth = this.program.getCompilerSpec().getDefaultCallingConvention().getExtrapop() == 32768;
        while (!contextStack.isEmpty()) {
            monitor.checkCanceled();
            if (this.canceled) {
                body.add((AddressSetView)conflicts);
                return body;
            }
            boolean hitOtherFlow = false;
            SavedFlowState nextFlow = (SavedFlowState)contextStack.pop();
            Address nextAddr = nextFlow.getDestination();
            Address flowFromAddr = nextFlow.getSource();
            boolean continueAfterHittingFlow = nextFlow.isContinueAfterHittingFlow();
            if (body.contains(nextAddr)) {
                hitOtherFlow = true;
                if (!continueAfterHittingFlow) continue;
            }
            vContext.flowStart(flowFromAddr, nextAddr);
            this.lastFullHashCode = 0;
            this.lastInstrCode = -1;
            this.sameInstrCount = 0;
            Address maxAddr = null;
            while (nextAddr != null) {
                Function func;
                Instruction instr;
                monitor.checkCanceled();
                if (body.contains(nextAddr)) {
                    hitOtherFlow = true;
                    if (!continueAfterHittingFlow) break;
                }
                if (restrictSet != null && !restrictSet.contains(nextAddr) || (instr = this.getInstructionAt(nextAddr)) == null) break;
                FlowType originalFlowType = instr.getFlowType();
                if (this.checkSameInstructionRun(instr)) break;
                maxAddr = instr.getMaxAddress();
                if (instr.getPrototype().hasDelaySlots()) {
                    maxAddr = instr.getMinAddress().add((long)(instr.getDefaultFallThroughOffset() - 1));
                }
                vContext.setCurrentInstruction(instr);
                vContext.flowToAddress(flowFromAddr, maxAddr);
                if (this.evaluator != null && this.evaluator.evaluateContextBefore(vContext, instr)) {
                    body.add((AddressSetView)conflicts);
                    return body;
                }
                this.conflict = false;
                Address retAddr = this.applyPcode(vContext, instr, monitor);
                body.addRange(instr.getMinAddress(), maxAddr);
                if (this.evaluator != null && this.evaluator.evaluateContext(vContext, instr)) {
                    body.add((AddressSetView)conflicts);
                    return body;
                }
                FlowType instrFlow = instr.getFlowType();
                if (!originalFlowType.equals((Object)instrFlow) && instrFlow.isCall()) {
                    Address[] targets;
                    for (Address address : targets = this.getInstructionFlows(instr)) {
                        this.handleFunctionSideEffects(instr, address, monitor);
                    }
                }
                Address inlineCall = null;
                boolean simpleFlow = this.isSimpleFallThrough(instrFlow);
                this.hitCodeFlow |= !simpleFlow;
                boolean doFallThruLast = false;
                if (!simpleFlow) {
                    Address[] flows = this.getInstructionFlows(instr);
                    if (flows != null && flows.length > 0) {
                        if (hitOtherFlow) {
                            nextAddr = null;
                            break;
                        }
                        if (!instrFlow.isCall()) {
                            for (Address flow : flows) {
                                contextStack.push(new SavedFlowState(instr.getMinAddress(), flow, continueAfterHittingFlow));
                            }
                        } else if (flows.length > 1) {
                            Reference[] referenceArray;
                            for (Reference flowRef : referenceArray = instr.getReferencesFrom()) {
                                RefType referenceType = flowRef.getReferenceType();
                                if (!referenceType.isComputed() || !referenceType.isJump()) continue;
                                contextStack.push(new SavedFlowState(instr.getMinAddress(), flowRef.getToAddress(), continueAfterHittingFlow));
                            }
                        } else {
                            inlineCall = flows[0];
                        }
                    } else if (instrFlow.isComputed() && instrFlow.isCall()) {
                        doFallThruLast = true;
                    }
                }
                if (inlineCall != null && (func = this.program.getFunctionManager().getFunctionAt(inlineCall)) != null && func.isInline()) {
                    vContext.mergeToFutureFlowState(maxAddr, inlineCall);
                    vContext.flowEnd(maxAddr);
                    this.flowConstants(maxAddr, inlineCall, func.getBody(), eval, vContext, monitor);
                    vContext.mergeToFutureFlowState(instr.getMinAddress(), maxAddr);
                    vContext.flowStart(instr.getMinAddress(), maxAddr);
                }
                Address fallThru = instr.getFallThrough();
                nextAddr = null;
                if (retAddr != null) {
                    contextStack.push(new SavedFlowState(instr.getMinAddress(), retAddr, continueAfterHittingFlow));
                    fallThru = null;
                }
                if (fallThru == null) continue;
                if (doFallThruLast) {
                    contextStack.add(0, new SavedFlowState(instr.getMinAddress(), fallThru, !callCouldCauseBadStackDepth));
                    continue;
                }
                if (fallThru.compareTo((Object)maxAddr) < 0) {
                    contextStack.add(0, new SavedFlowState(instr.getMinAddress(), fallThru, false));
                    continue;
                }
                nextAddr = fallThru;
                fallThru = null;
            }
            vContext.flowEnd(maxAddr);
        }
        body.add((AddressSetView)conflicts);
        return body;
    }

    private boolean isSimpleFallThrough(FlowType instrFlow) {
        return !instrFlow.isCall() && !instrFlow.isJump() && !instrFlow.isTerminal() && instrFlow.hasFallthrough();
    }

    private boolean checkSameInstructionRun(Instruction instr) {
        if (this.lastInstrCode == instr.getPrototype().hashCode()) {
            if (this.lastFullHashCode == 0) {
                this.lastFullHashCode = -1;
            } else {
                int instrByteHashCode = -1;
                try {
                    instrByteHashCode = Arrays.hashCode(instr.getBytes());
                }
                catch (MemoryAccessException e) {
                    instrByteHashCode = instr.toString().hashCode();
                }
                if (this.lastFullHashCode == -1) {
                    this.lastFullHashCode = instrByteHashCode;
                }
                if (this.lastFullHashCode == instrByteHashCode) {
                    ++this.sameInstrCount;
                    if (this.sameInstrCount > 100) {
                        return true;
                    }
                } else {
                    this.lastFullHashCode = 0;
                    this.sameInstrCount = 0;
                }
            }
        } else {
            this.sameInstrCount = 0;
            this.lastFullHashCode = 0;
        }
        this.lastInstrCode = instr.getPrototype().hashCode();
        return false;
    }

    private PcodeOp[] getInstructionPcode(Instruction instruction) {
        PcodeOp[] ops = this.pcodeCache.get(instruction.getMinAddress());
        if (ops == null) {
            ops = instruction.getPcode(true);
            this.pcodeCache.put(instruction.getMinAddress(), ops);
        }
        return ops;
    }

    private Instruction getInstructionAt(Address addr) {
        Instruction instr = this.instructionAtCache.get(addr);
        if (instr != null) {
            return instr;
        }
        if (this.instructionAtCache.containsKey(addr)) {
            return null;
        }
        instr = this.program.getListing().getInstructionAt(addr);
        this.instructionAtCache.put(addr, instr);
        if (instr != null) {
            this.instructionContainingCache.put(instr.getMaxAddress(), instr);
        }
        return instr;
    }

    private Instruction getInstructionContaining(Address addr) {
        Instruction instr = this.getInstructionAt(addr);
        if (instr != null) {
            return instr;
        }
        instr = this.instructionContainingCache.get(addr);
        if (instr != null) {
            return instr;
        }
        if (this.instructionContainingCache.containsKey(addr)) {
            return null;
        }
        instr = this.program.getListing().getInstructionContaining(addr);
        this.instructionContainingCache.put(addr, instr);
        return instr;
    }

    private Address[] getInstructionFlows(Instruction instruction) {
        Address addr = instruction.getMinAddress();
        Address[] flows = this.instructionFlowsCache.get(addr);
        if (flows != null) {
            return flows;
        }
        flows = instruction.getFlows();
        this.instructionFlowsCache.put(addr, flows);
        return flows;
    }

    /*
     * Unable to fully structure code
     */
    private Address applyPcode(VarnodeContext vContext, Instruction instruction, TaskMonitor monitor) {
        nextAddr = null;
        if (instruction == null) {
            return nextAddr;
        }
        ops = this.getInstructionPcode(instruction);
        if (ops.length <= 0) {
            return nextAddr;
        }
        if (this.debug) {
            Msg.info((Object)this, (Object)(instruction.getMinAddress() + "   " + instruction));
        }
        mustClearAllUntil_PcodeIndex = -1;
        mustClearAll = false;
        injected = false;
        ptype = 0;
        block53: for (pcodeIndex = 0; pcodeIndex < ops.length; ++pcodeIndex) {
            mustClearAll = pcodeIndex < mustClearAllUntil_PcodeIndex;
            ptype = ops[pcodeIndex].getOpcode();
            out = ops[pcodeIndex].getOutput();
            in = ops[pcodeIndex].getInputs();
            if (this.debug) {
                Msg.info((Object)this, (Object)("   " + ops[pcodeIndex]));
            }
            try {
                switch (ptype) {
                    case 1: {
                        if (in[0].isAddress() && !in[0].getAddress().getAddressSpace().hasMappedRegisters()) {
                            this.makeReference(vContext, instruction, ptype, -1, in[0], RefType.READ, monitor);
                        }
                        vContext.copy(out, in[0], mustClearAll, this.evaluator);
                        break;
                    }
                    case 2: {
                        val1 = vContext.getValue(in[0], this.evaluator);
                        val2 = vContext.getValue(in[1], this.evaluator);
                        vt = vContext.getVarnode(in[0], val2, out.getSize(), this.evaluator);
                        this.addLoadStoreReference(vContext, instruction, ptype, vt, in[0], in[1], RefType.READ, monitor);
                        memVal = vContext.getValue(vt, this.evaluator);
                        vContext.putValue(out, memVal, mustClearAll);
                        break;
                    }
                    case 3: {
                        out = this.getStoredLocation(vContext, in);
                        this.addLoadStoreReference(vContext, instruction, ptype, out, in[0], in[1], RefType.WRITE, monitor);
                        val3 = vContext.getValue(in[2], null);
                        if (!injected) {
                            this.addStoredReferences(vContext, instruction, out, val3, monitor);
                        }
                        vContext.putValue(out, val3, mustClearAll);
                        break;
                    }
                    case 6: {
                        try {
                            val1 = vContext.getValue(in[0], this.evaluator);
                            lval1 = vContext.getConstant(val1, this.evaluator);
                            vt = vContext.getVarnode(instruction.getMinAddress().getAddressSpace().getBaseSpaceID(), lval1, 0);
                            this.makeReference(vContext, instruction, ptype, -1, vt, (RefType)instruction.getFlowType(), monitor);
                        }
                        catch (NotFoundException var25_26) {
                            // empty catch block
                        }
                        vContext.propogateResults(false);
                        for (Reference flowRef : flowRefs = instruction.getReferencesFrom()) {
                            referenceType = flowRef.getReferenceType();
                            if (!referenceType.isComputed() || !referenceType.isJump()) continue;
                            this.conflict |= vContext.mergeToFutureFlowState(flowRef.getFromAddress(), flowRef.getToAddress());
                        }
                        if (this.evaluator == null || !this.evaluator.evaluateDestination(vContext, instruction)) continue block53;
                        this.canceled = true;
                        return null;
                    }
                    case 7: 
                    case 8: {
                        target = null;
                        func = null;
                        val1 = in[0];
                        if (ptype != 8) ** GOTO lbl80
                        try {
                            val1 = vContext.getValue(val1, this.evaluator);
                            if (val1.isConstant()) {
                                target = instruction.getAddress().getNewTruncatedAddress(val1.getOffset(), true);
                            } else if (val1.isAddress()) {
                                target = this.resolveFunctionReference(val1.getAddress());
                            }
                            if (!(target == null || !val1.isAddress() && !val1.isConstant() || (refs = instruction.getReferencesFrom()).length > 0 && refs[0].getToAddress().equals((Object)target))) {
                                this.makeReference(vContext, instruction, -1, target.getAddressSpace().getBaseSpaceID(), target.getAddressableWordOffset(), val1.getSize(), (RefType)instruction.getFlowType(), ptype, true, monitor);
                            }
                            ** GOTO lbl81
                        }
                        catch (NotFoundException e) {
                            val1 = null;
                        }
                        ** GOTO lbl81
lbl80:
                        // 1 sources

                        target = val1.getAddress();
lbl81:
                        // 4 sources

                        prog = instruction.getProgram();
                        if (target != null) {
                            if (target.isMemoryAddress()) {
                                vContext.propogateResults(false);
                                this.conflict |= vContext.mergeToFutureFlowState(instruction.getMinAddress(), target);
                            }
                            if ((func = prog.getFunctionManager().getFunctionAt(target)) == null && ptype == 8 && (refs = instruction.getReferencesFrom()) != null && refs.length > 0 && ((firstRef = refs[0]).getReferenceType().isData() || firstRef.getReferenceType().isIndirect())) {
                                target = firstRef.getToAddress();
                                func = prog.getFunctionManager().getFunctionAt(target);
                            }
                            if ((injectionPcode = this.checkForCallFixup(prog, func, instruction)) != null && injectionPcode.length > 0) {
                                ops = this.injectPcode(ops, pcodeIndex, injectionPcode);
                                pcodeIndex = -1;
                                injected = true;
                                continue block53;
                            }
                        }
                        this.handleFunctionSideEffects(instruction, target, monitor);
                        injectionPcode = this.checkForUponReturnCallMechanismInjection(prog, func, target, instruction);
                        if (injectionPcode == null || injectionPcode.length <= 0) continue block53;
                        ops = this.injectPcode(ops, pcodeIndex, injectionPcode);
                        pcodeIndex = -1;
                        injected = true;
                        continue block53;
                    }
                    case 9: {
                        opName = this.program.getLanguage().getUserDefinedOpName((int)in[0].getOffset());
                        if (opName.equals("segment") && in.length > 2) {
                            this.checkSegmented(out, in[1], in[2], mustClearAll);
                            break;
                        }
                        if (out == null) continue block53;
                        vContext.putValue(out, vContext.createBadVarnode(), mustClearAll);
                        break;
                    }
                    case 4: {
                        if (in[0].isConstant()) {
                            sequenceOffset = (int)in[0].getOffset();
                            if (sequenceOffset < 0) {
                                pcodeIndex = ops.length;
                                break;
                            }
                            pcodeIndex += sequenceOffset - 1;
                            ptype = 0;
                            break;
                        }
                        if (!in[0].isAddress()) {
                            throw new AssertException("Not a valid Address on instruction at " + instruction.getAddress());
                        }
                        vContext.propogateResults(false);
                        this.conflict |= vContext.mergeToFutureFlowState(instruction.getMinAddress(), in[0].getAddress());
                        pcodeIndex = ops.length;
                        break;
                    }
                    case 5: {
                        vt = null;
                        internalBranch = in[0].isConstant();
                        if (internalBranch) {
                            sequenceOffset = (int)in[0].getOffset();
                            if (pcodeIndex + sequenceOffset >= ops.length) {
                                vContext.propogateResults(false);
                                this.conflict |= vContext.mergeToFutureFlowState(instruction.getMinAddress(), instruction.getFallThrough());
                            }
                        } else if (in[0].isAddress()) {
                            vt = in[0];
                            vContext.propogateResults(false);
                            this.conflict |= vContext.mergeToFutureFlowState(instruction.getMinAddress(), in[0].getAddress());
                        }
                        condition = null;
                        try {
                            condition = vContext.getValue(in[1], null);
                        }
                        catch (NotFoundException e) {
                            fallThru = instruction.getFallThrough();
                            if (fallThru != null && vt != null && vt.getOffset() == fallThru.getOffset()) {
                                op = ops[ops.length - 1].getOpcode();
                                if (op == 4 || op == 10 || op == 6) {
                                    ptype = op;
                                } else {
                                    mustClearAllUntil_PcodeIndex = ops.length;
                                }
                            } else if (internalBranch) {
                                sequenceOffset = (int)in[0].getOffset();
                                for (i = pcodeIndex + 1; i < sequenceOffset && !this.isBranch(ops[i]); ++i) {
                                }
                                if (i == sequenceOffset) {
                                    if (fallThru != null) {
                                        vContext.propogateResults(true);
                                        this.conflict |= vContext.mergeToFutureFlowState(instruction.getMinAddress(), instruction.getFallThrough());
                                    }
                                    mustClearAllUntil_PcodeIndex = sequenceOffset;
                                    break;
                                }
                            }
                            throw e;
                        }
                        lval1 = vContext.getConstant(condition, null);
                        if (lval1 == 0L) continue block53;
                        if (internalBranch) {
                            sequenceOffset = (int)in[0].getOffset();
                            if (sequenceOffset > 0) {
                                pcodeIndex += sequenceOffset - 1;
                                break;
                            }
                            if (this.evaluator.followFalseConditionalBranches()) continue block53;
                            pcodeIndex = ops.length;
                            break;
                        }
                        if (this.evaluator.followFalseConditionalBranches()) continue block53;
                        nextAddr = in[0].getAddress();
                        pcodeIndex = ops.length;
                        break;
                    }
                    case 10: {
                        this.addReturnReferences(instruction, vContext, monitor);
                        break;
                    }
                    case 17: {
                        if (in[0].isAddress()) {
                            this.makeReference(vContext, instruction, ptype, -1, in[0], RefType.READ, monitor);
                        }
                        val1 = vContext.extendValue(out, in, false, this.evaluator);
                        vContext.putValue(out, val1, mustClearAll);
                        break;
                    }
                    case 18: {
                        if (in[0].isAddress()) {
                            this.makeReference(vContext, instruction, ptype, -1, in[0], RefType.READ, monitor);
                        }
                        val1 = vContext.extendValue(out, in, true, this.evaluator);
                        vContext.putValue(out, val1, mustClearAll);
                        break;
                    }
                    case 19: {
                        try {
                            val1 = vContext.getValue(in[0], false, this.evaluator);
                        }
                        catch (NotFoundException exc) {
                            val1 = vContext.createBadVarnode();
                        }
                        try {
                            val2 = vContext.getValue(in[1], false, this.evaluator);
                        }
                        catch (NotFoundException exc) {
                            val2 = vContext.createBadVarnode();
                        }
                        if (val1.equals((Object)val2)) {
                            v = vContext.getConstant(val1, this.evaluator);
                            val1 = val2 = vContext.createConstantVarnode(v, val1.getSize());
                        }
                        result = vContext.add(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 20: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.subtract(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: {
                        binaryBehavior = (BinaryOpBehavior)OpBehaviorFactory.getOpBehavior((int)ptype);
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = binaryBehavior.evaluateBinary(out.getSize(), in[0].getSize(), vContext.getConstant(val1, this.evaluator), vContext.getConstant(val2, this.evaluator));
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 24: {
                        unaryBehavior = (UnaryOpBehavior)OpBehaviorFactory.getOpBehavior((int)ptype);
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        lresult = unaryBehavior.evaluateUnary(out.getSize(), in[0].getSize(), vContext.getConstant(val1, this.evaluator));
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 25: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        result = vContext.createConstantVarnode(vContext.getConstant(val1, this.evaluator) ^ -1L, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 26: {
                        if (in[0].isRegister() && in[0].equals((Object)in[1])) {
                            result = vContext.createConstantVarnode(0L, out.getSize());
                        } else {
                            val1 = vContext.getValue(in[0], false, this.evaluator);
                            val2 = vContext.getValue(in[1], false, this.evaluator);
                            lresult = vContext.getConstant(val1, this.evaluator) ^ vContext.getConstant(val2, this.evaluator);
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 27: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = val1.equals((Object)val2) != false ? val1 : vContext.and(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 28: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        if (!val1.equals((Object)val2)) {
                            lresult = vContext.getConstant(val1, this.evaluator) | vContext.getConstant(val2, this.evaluator);
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        } else {
                            result = val1;
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 29: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.left(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 30: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) >> (int)vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 31: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) >>> (int)vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 32: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) * vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 33: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 / lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 34: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 / lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 35: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 % lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 36: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 % lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 63: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        subbyte = 8L * vContext.getConstant(val2, this.evaluator);
                        if (vContext.isSymbol(val1) & subbyte == 0L && out.getSize() == instruction.getAddress().getPointerSize()) {
                            result = val1;
                        } else {
                            if (out.getSize() > 8) {
                                throw SymbolicPropogator.valueTooBigException;
                            }
                            lresult = vContext.getConstant(val1, this.evaluator) >> (int)subbyte & SymbolicPropogator.maskSize[out.getSize()];
                            result = vContext.createConstantVarnode(lresult, out.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 15: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        lresult = UnsignedDataUtils.unsignedLessThan((long)lval1, (long)lval2) != false ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 13: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) < vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 16: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        lresult = UnsignedDataUtils.unsignedLessThanOrEqual((long)lval1, (long)lval2) != false ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 14: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) <= vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 11: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) == vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 12: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) != vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 37: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) == 0L ? 1 : 0;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 38: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) ^ vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 39: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) & vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 40: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) | vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    default: {
                        if (out == null) continue block53;
                        vContext.putValue(out, null, false);
                    }
                }
                continue;
            }
            catch (NotFoundException e) {
                if (out == null) continue;
                vContext.putValue(out, vContext.createBadVarnode(), false);
                continue;
            }
            catch (AddressOutOfBoundsException e) {
                if (out == null) continue;
                vContext.putValue(out, null, false);
            }
        }
        vContext.propogateResults(true);
        fallthru = instruction.getFallThrough();
        if (ptype == 4 || ptype == 10 || ptype == 6) {
            nextAddr = fallthru;
        } else if (fallthru != null) {
            this.conflict |= vContext.mergeToFutureFlowState(instruction.getMinAddress(), fallthru);
        }
        return nextAddr;
    }

    private Varnode getStoredLocation(VarnodeContext vContext, Varnode[] in) {
        Varnode out = null;
        try {
            Varnode val = vContext.getValue(in[1], true, this.evaluator);
            out = vContext.getVarnode(in[0], val, in[2].getSize(), this.evaluator);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return out;
    }

    private void handleFunctionSideEffects(Instruction instruction, Address target, TaskMonitor monitor) {
        Address fallThruAddr;
        Function targetFunc = null;
        if (target != null) {
            targetFunc = this.program.getFunctionManager().getFunctionAt(target);
        }
        if ((fallThruAddr = instruction.getFallThrough()) == null || target == null || target.getOffset() != fallThruAddr.getOffset()) {
            Varnode[] returnVarnodes;
            if (this.checkForParamRefs && this.evaluator != null && this.evaluator.evaluateReference(this.context, instruction, 0, target == null ? Address.NO_ADDRESS : target, 0, (RefType)RefType.UNCONDITIONAL_CALL)) {
                this.addParamReferences(targetFunc, target, instruction, this.context, monitor);
            }
            if ((returnVarnodes = this.context.getReturnVarnode(targetFunc)) != null) {
                for (Varnode varnode : returnVarnodes) {
                    this.context.putValue(varnode, this.context.createBadVarnode(), false);
                }
            }
        }
        if (targetFunc != null && targetFunc.isInline()) {
            return;
        }
        Varnode outStack = this.context.getStackVarnode();
        if (!(outStack == null || targetFunc != null && targetFunc.isInline())) {
            int purge = this.getFunctionPurge(this.program, targetFunc);
            purge = this.addStackOverride(this.program, instruction.getMinAddress(), purge);
            if (purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) {
                Varnode curVal = null;
                if (fallThruAddr != null) {
                    Address[] knownFlowToAddresses;
                    for (Address knownFlowToAddresse : knownFlowToAddresses = this.context.getKnownFlowToAddresses(fallThruAddr)) {
                        curVal = this.context.getRegisterVarnodeValue(this.context.getStackRegister(), knownFlowToAddresse, fallThruAddr, false);
                        if (curVal != null) break;
                    }
                }
                if (curVal != null) {
                    this.context.putValue(outStack, curVal, false);
                } else if (instruction.getLength() != 1) {
                    this.context.putValue(outStack, null, false);
                }
            } else if (purge != 0) {
                try {
                    Varnode purgeVar = this.context.createConstantVarnode(purge, outStack.getSize());
                    Varnode val1 = this.context.getValue(outStack, true, this.evaluator);
                    Varnode varnode = this.context.add(val1, purgeVar, this.evaluator);
                    this.context.putValue(outStack, varnode, false);
                }
                catch (NotFoundException e) {
                    this.context.putValue(outStack, this.context.createBadVarnode(), false);
                }
            }
        }
    }

    private boolean isBranch(PcodeOp pcodeOp) {
        if (pcodeOp.isAssignment()) {
            return false;
        }
        int opcode = pcodeOp.getOpcode();
        return opcode != 3 && opcode != 2;
    }

    private Address resolveFunctionReference(Address addr) {
        Address extAddr = null;
        for (Reference ref : this.program.getReferenceManager().getReferencesFrom(addr)) {
            if (ref.isExternalReference()) {
                extAddr = ref.getToAddress();
                continue;
            }
            if (!ref.isMemoryReference() || !ref.getReferenceType().isCall()) continue;
            return ref.getToAddress();
        }
        return extAddr;
    }

    private PcodeOp[] checkForCallFixup(Program prog, Function func, Instruction instr) {
        if (func == null) {
            return null;
        }
        String callFixupName = func.getCallFixup();
        if (callFixupName == null) {
            return null;
        }
        PcodeInjectLibrary snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(1, callFixupName, prog, null);
        if (payload == null) {
            return null;
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = func.getEntryPoint();
        return payload.getPcode(prog, con);
    }

    private PcodeOp[] checkForUponReturnCallMechanismInjection(Program prog, Function func, Address target, Instruction instr) {
        PrototypeModel callingConvention = null;
        if (func != null) {
            callingConvention = func.getCallingConvention();
        }
        if (callingConvention == null) {
            callingConvention = prog.getCompilerSpec().getDefaultCallingConvention();
        }
        String injectionName = callingConvention.getName() + "@@inject_uponreturn";
        PcodeInjectLibrary snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(3, injectionName, prog, null);
        if (payload == null) {
            return null;
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = target;
        return payload.getPcode(prog, con);
    }

    private PcodeOp[] injectPcode(PcodeOp[] currentPcode, int pcodeIndex, PcodeOp[] replacePcode) {
        int opsRemaining = currentPcode.length - pcodeIndex - 1;
        if (opsRemaining == 0) {
            currentPcode = replacePcode;
        } else {
            PcodeOp[] replacePcodeExpanded = new PcodeOp[replacePcode.length + opsRemaining];
            System.arraycopy(replacePcode, 0, replacePcodeExpanded, 0, replacePcode.length);
            System.arraycopy(currentPcode, pcodeIndex + 1, replacePcodeExpanded, replacePcode.length, opsRemaining);
            currentPcode = replacePcodeExpanded;
        }
        return currentPcode;
    }

    private void checkSegmented(Varnode out, Varnode in1, Varnode in2, boolean mustClearAll) throws NotFoundException {
        Varnode vval1 = this.context.getValue(in1, this.evaluator);
        Varnode vval2 = this.context.getValue(in2, this.evaluator);
        if (vval1.isConstant() && vval2.isConstant()) {
            int bitsize = this.program.getAddressFactory().getDefaultAddressSpace().getSize();
            long segBase = bitsize > 24 ? this.context.getConstant(vval1, this.evaluator) << 16 : (bitsize == 24 ? this.context.getConstant(vval1, this.evaluator) << 8 : this.context.getConstant(vval1, this.evaluator) << 4);
            vval1 = this.context.createConstantVarnode(segBase, out.getSize());
            vval2 = this.context.createConstantVarnode(vval2.getOffset(), out.getSize());
            Varnode segmentedValue = this.context.add(vval1, vval2, this.evaluator);
            this.context.putValue(out, segmentedValue, mustClearAll);
        }
    }

    private int getFunctionPurge(Program prog, Function function) {
        if (function == null) {
            return this.getDefaultStackDepthChange(prog, Integer.MAX_VALUE);
        }
        int depth = function.getStackPurgeSize();
        if (function.isStackPurgeSizeValid()) {
            return this.getDefaultStackDepthChange(prog, depth);
        }
        PrototypeModel conv = function.getCallingConvention();
        if (conv == null) {
            conv = prog.getCompilerSpec().getDefaultCallingConvention();
        }
        if (conv != null) {
            int callStackMod = conv.getExtrapop();
            int callStackShift = conv.getStackshift();
            if (callStackMod != 32768) {
                return callStackShift;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int getDefaultStackDepthChange(Program prog, int depth) {
        int callStackMod = prog.getCompilerSpec().getCallStackMod();
        int callStackShift = prog.getCompilerSpec().getCallStackShift();
        if (callStackMod != 32768) {
            return callStackShift;
        }
        if (depth == Integer.MAX_VALUE || depth == 0x7FFFFFFE) {
            return Integer.MAX_VALUE;
        }
        return callStackShift + depth;
    }

    private int addStackOverride(Program prog, Address addr, int purge) {
        Integer stackDepthChange = CallDepthChangeInfo.getStackDepthChange(prog, addr);
        if (stackDepthChange == null) {
            return purge;
        }
        int extrapop = CallDepthChangeInfo.getStackDepthChange(prog, addr);
        if (purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) {
            return extrapop;
        }
        return purge + extrapop;
    }

    private void addParamReferences(Function func, Address callTarget, Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor) {
        boolean trustSignature;
        if (!this.checkForParamRefs) {
            return;
        }
        if (callTarget != null && callTarget.isExternalAddress()) {
            return;
        }
        PrototypeModel conv = this.program.getCompilerSpec().getDefaultCallingConvention();
        Parameter[] params = new Parameter[]{};
        SourceType signatureSource = SourceType.DEFAULT;
        if (func != null) {
            PrototypeModel funcConv = func.getCallingConvention();
            if (funcConv != null) {
                conv = funcConv;
            }
            params = func.getParameters();
            signatureSource = func.getSignatureSource();
        }
        long callOffset = callTarget == null ? 0L : callTarget.getOffset();
        boolean signatureAssigned = signatureSource != SourceType.DEFAULT;
        boolean bl = trustSignature = signatureAssigned || params.length > 0;
        if (trustSignature) {
            for (Parameter param : params) {
                Parameter p = param;
                if (!p.isRegisterVariable()) continue;
                this.createVariableStorageReference(instruction, varnodeContext, monitor, p.getVariableStorage(), callOffset);
            }
        } else {
            VariableStorage[] vars;
            for (VariableStorage var : vars = conv.getPotentialInputRegisterStorage(this.program)) {
                this.createVariableStorageReference(instruction, varnodeContext, monitor, var, callOffset);
            }
        }
    }

    private void addReturnReferences(Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor) {
        if (!this.checkForReturnRefs) {
            return;
        }
        Function func = this.program.getFunctionManager().getFunctionContaining(instruction.getMinAddress());
        VariableStorage returnLoc = this.getReturnLocationStorage(func);
        if (returnLoc == null) {
            return;
        }
        this.createVariableStorageReference(instruction, varnodeContext, monitor, returnLoc, 0L);
    }

    private void addLoadStoreReference(VarnodeContext vContext, Instruction instruction, int pcodeType, Varnode refLocation, Varnode targetSpaceID, Varnode assigningVarnode, RefType reftype, TaskMonitor monitor) {
        if (refLocation == null) {
            return;
        }
        int opIndex = this.findOperandWithVarnodeAssignment(instruction, assigningVarnode);
        if (instruction.getFlowType().isCall()) {
            this.makeReference(vContext, instruction, pcodeType, opIndex, refLocation, reftype, monitor);
        } else {
            int spaceID = refLocation.getSpace();
            if (vContext.isSymbolicSpace(spaceID)) {
                Address constant;
                Address newTarget;
                long offset = refLocation.getOffset();
                if (this.evaluator != null && !vContext.isStackSymbolicSpace(refLocation) && this.evaluator != null && (newTarget = this.evaluator.evaluateConstant(vContext, instruction, pcodeType, constant = this.program.getAddressFactory().getAddress((int)targetSpaceID.getOffset(), offset), 0, reftype)) != null) {
                    this.makeReference(vContext, instruction, -1, newTarget.getAddressSpace().getBaseSpaceID(), newTarget.getOffset(), 0, reftype, pcodeType, false, monitor);
                    return;
                }
            }
            this.makeReference(vContext, instruction, pcodeType, opIndex, refLocation, reftype, monitor);
        }
    }

    private int findOperandWithVarnodeAssignment(Instruction instruction, Varnode assigningVarnode) {
        if (!assigningVarnode.isUnique()) {
            return -1;
        }
        for (int opIndex = 0; opIndex < instruction.getNumOperands(); ++opIndex) {
            PcodeOp[] pcode = instruction.getPcode(opIndex);
            for (int j = pcode.length - 1; j >= 0; --j) {
                if (!assigningVarnode.equals((Object)pcode[j].getOutput())) continue;
                return opIndex;
            }
        }
        return -1;
    }

    private boolean checkPossibleOffsetAddr(long offset) {
        long maxAddrOffset = this.pointerMask;
        return (offset < 0L || offset >= 256L) && Math.abs(maxAddrOffset - offset) >= 256L;
    }

    private void addStoredReferences(VarnodeContext vContext, Instruction instruction, Varnode storageLocation, Varnode valueToStore, TaskMonitor monitor) {
        if (!this.checkForStoredRefs) {
            return;
        }
        if (storageLocation != null && storageLocation.isRegister()) {
            return;
        }
        if (!valueToStore.isConstant()) {
            return;
        }
        long valueOffset = valueToStore.getOffset();
        this.makeReference(vContext, instruction, -1, -1L, valueOffset, 0, RefType.DATA, 3, false, monitor);
    }

    private void createVariableStorageReference(Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor, VariableStorage storage, long callOffset) {
        if (!storage.isRegisterStorage()) {
            return;
        }
        Register reg = storage.getRegister();
        RegisterValue rval = varnodeContext.getRegisterValue(reg);
        if (rval == null || !rval.hasValue()) {
            return;
        }
        this.createRegisterStorageReference(instruction, varnodeContext, monitor, callOffset, rval);
    }

    private void createRegisterStorageReference(Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor, long callOffset, RegisterValue rval) {
        RegisterValue lastRval;
        BigInteger bval;
        Register reg = rval.getRegister();
        Address lastSetAddr = varnodeContext.getLastSetLocation(reg, bval = rval.getUnsignedValue());
        if (!(lastSetAddr == null || !instruction.getPrototype().hasDelaySlots() || (lastRval = varnodeContext.getRegisterValue(reg, lastSetAddr)) != null && lastRval.hasAnyValue() && lastRval.equals((Object)rval))) {
            lastSetAddr = instruction.getMaxAddress();
        }
        if (lastSetAddr == null) {
            lastSetAddr = instruction.getMaxAddress();
        }
        if (bval == null) {
            return;
        }
        long val = bval.longValue();
        if (val == callOffset) {
            return;
        }
        if (lastSetAddr != null) {
            Instruction instr = instruction;
            if (!instr.contains(lastSetAddr)) {
                instr = this.getInstructionContaining(lastSetAddr);
            }
            Reference[] refs = instr.getReferencesFrom();
            boolean found = false;
            for (Reference ref : refs) {
                Address refAddr = ref.getToAddress();
                Address addr = refAddr.getAddressSpace().getTruncatedAddress(val, true);
                if (refAddr.getOffset() != addr.getOffset()) continue;
                found = true;
                break;
            }
            if (!found) {
                RefType refType = callOffset == 0L ? RefType.DATA : RefType.PARAM;
                this.makeReference(varnodeContext, instr, -1, -1L, val, 0, refType, 0, false, monitor);
            }
        }
    }

    private VariableStorage getReturnLocationStorage(Function func) {
        VariableStorage returnLoc = null;
        int pointerSize = this.program.getDefaultPointerSize();
        PrototypeModel conv = null;
        if (func != null) {
            conv = func.getCallingConvention();
            DataType returnType = func.getReturnType();
            if (returnType != null && !(returnType instanceof DefaultDataType) && returnType.getLength() < pointerSize) {
                return null;
            }
        }
        if (conv == null) {
            conv = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        returnLoc = conv.getReturnLocation(Undefined.getUndefinedDataType((int)pointerSize), this.program);
        return returnLoc;
    }

    private int getReferenceSpaceID(Instruction instruction, long offset) {
        if (offset <= 4L && offset >= -1L) {
            return -1;
        }
        AddressSpace defaultSpace = this.program.getLanguage().getDefaultDataSpace();
        if (this.memorySpaces.size() == 1) {
            return defaultSpace.getUniqueSpaceID();
        }
        int realMemSpaceCnt = 0;
        int containingMemSpaceCnt = 0;
        Address containingAddr = null;
        int symbolTargetCnt = 0;
        Address symbolTarget = null;
        AddressSpace instrSpace = instruction.getMinAddress().getAddressSpace();
        if (instrSpace.isOverlaySpace() && instrSpace.getBaseSpaceID() == defaultSpace.getUniqueSpaceID()) {
            defaultSpace = instrSpace;
        }
        for (AddressSpace space : this.memorySpaces) {
            if (space.isOverlaySpace()) {
                if (space != instrSpace) {
                    continue;
                }
            } else {
                ++realMemSpaceCnt;
            }
            Address addr = space.getTruncatedAddress(offset, true);
            if (space.isOverlaySpace() && !addr.getAddressSpace().equals(space)) continue;
            if (space.hasMappedRegisters() && this.program.getRegister(addr) != null) {
                if (space.isOverlaySpace()) continue;
                --realMemSpaceCnt;
                continue;
            }
            if (this.program.getMemory().contains(addr)) {
                ++containingMemSpaceCnt;
                containingAddr = addr;
            }
            if (!this.program.getReferenceManager().hasReferencesTo(addr) && this.program.getSymbolTable().getPrimarySymbol(addr) == null) continue;
            ++symbolTargetCnt;
            symbolTarget = addr;
        }
        if (containingMemSpaceCnt == 1 && containingAddr != null) {
            return containingAddr.getAddressSpace().getUniqueSpaceID();
        }
        if (symbolTargetCnt == 1 && symbolTarget != null) {
            return symbolTarget.getAddressSpace().getUniqueSpaceID();
        }
        if (realMemSpaceCnt != 1 && !this.defaultSpacesAreTheSame) {
            return -1;
        }
        return defaultSpace.getUniqueSpaceID();
    }

    public void makeReference(VarnodeContext varnodeContext, Instruction instruction, int pcodeop, int opIndex, Varnode vt, RefType refType, TaskMonitor monitor) {
        if (!vt.isAddress()) {
            if (this.evaluator != null) {
                this.evaluator.evaluateSymbolicReference(varnodeContext, instruction, vt.getAddress());
            }
            return;
        }
        this.makeReference(varnodeContext, instruction, opIndex, vt.getSpace(), vt.getWordOffset(), vt.getSize(), refType, pcodeop, true, monitor);
    }

    public void makeReference(VarnodeContext vContext, Instruction instruction, int opIndex, long knownSpaceID, long wordOffset, int size, RefType refType, int pcodeop, boolean knownReference, TaskMonitor monitor) {
        Data udata;
        Address target;
        long spaceID = knownSpaceID;
        if (spaceID == -1L && (spaceID = (long)this.getReferenceSpaceID(instruction, wordOffset)) == -1L) {
            return;
        }
        Address instructionAddress = instruction.getMinAddress();
        try {
            AddressSpace space = this.program.getAddressFactory().getAddressSpace((int)spaceID);
            if (space.isExternalSpace()) {
                target = space.getAddress(wordOffset, true);
            } else {
                if (!space.isLoadedMemorySpace()) {
                    return;
                }
                if (wordOffset == 0L) {
                    return;
                }
                target = wordOffset < 0L ? space.getTruncatedAddress(wordOffset, true) : space.getAddress(wordOffset, true);
                wordOffset = target.getAddressableWordOffset();
                if (space.hasMappedRegisters() && this.program.getRegister(target) != null) {
                    return;
                }
                target = instructionAddress.getAddressSpace().getOverlayAddress(target);
                if (!(knownReference || this.program.getMemory().contains(target) || this.program.getReferenceManager().hasReferencesTo(target))) {
                    return;
                }
            }
            if (refType.isCall() && !refType.isComputed()) {
                return;
            }
            if (this.evaluator != null) {
                if (knownSpaceID == -1L || !knownReference) {
                    Address constant = this.program.getAddressFactory().getConstantAddress(wordOffset);
                    Address newTarget = this.evaluator.evaluateConstant(vContext, instruction, pcodeop, constant, size, refType);
                    if (newTarget == null) {
                        return;
                    }
                    if (newTarget != constant) {
                        target = newTarget;
                    }
                } else if (!this.evaluator.evaluateReference(vContext, instruction, pcodeop, target, size, refType)) {
                    return;
                }
            }
            if (refType.isData() && !this.evaluatePureDataRef(instruction, wordOffset, refType, target)) {
                return;
            }
            if (refType.isJump() && refType.isComputed()) {
                Address[] flows = this.getInstructionFlows(instruction);
                if (flows.length > 1) {
                    return;
                }
                for (Address address : flows) {
                    if (!address.equals((Object)target)) continue;
                    return;
                }
            }
        }
        catch (AddressOutOfBoundsException e) {
            return;
        }
        if ((opIndex = this.findOpIndexForRef(vContext, instruction, opIndex, wordOffset, refType)) == -1 && instruction.getPrototype().hasDelaySlots() && !instruction.getFlowType().equals((Object)refType)) {
            if ((instruction = instruction.getNext()) == null) {
                return;
            }
            opIndex = this.findOpIndexForRef(vContext, instruction, opIndex, wordOffset, refType);
        }
        if (opIndex == -1 && (!refType.isFlow() || target.isExternalAddress())) {
            opIndex = instruction.getNumOperands() - 1;
            List list = instruction.getDefaultOperandRepresentationList(opIndex);
            if (list == null || list.size() == 0) {
                opIndex = -1;
            }
            if (target.isExternalAddress() && instruction.getReferencesFrom().length != 0) {
                opIndex = -1;
            }
        }
        if (opIndex == -1) {
            instruction.addMnemonicReference(target, refType, SourceType.ANALYSIS);
        } else {
            instruction.addOperandReference(opIndex, target, refType, SourceType.ANALYSIS);
        }
        if (refType.isData()) {
            this.createData(target, size);
        }
        if (!(!refType.isFlow() || refType.isIndirect() || this.externalBlockRange != null && this.externalBlockRange.contains(target) || (udata = this.program.getListing().getUndefinedDataAt(target)) == null)) {
            DisassembleCommand cmd = new DisassembleCommand(target, null, true);
            cmd.applyTo((DomainObject)this.program, monitor);
        }
    }

    private boolean evaluatePureDataRef(Instruction instruction, long wordOffset, RefType refType, Address target) {
        Instruction targetInstr;
        long fallAddrOffset;
        if (refType.isRead() || refType.isWrite()) {
            return true;
        }
        if ((instruction.hasFallthrough() || instruction.getFlowOverride() != FlowOverride.NONE) && (fallAddrOffset = instruction.getMinAddress().getOffset() + (long)instruction.getDefaultFallThroughOffset()) == wordOffset) {
            return false;
        }
        if (this.program.getMemory().contains(target) && (targetInstr = this.getInstructionContaining(target)) != null) {
            if (!targetInstr.getMinAddress().equals((Object)target)) {
                return false;
            }
            if (targetInstr.isInDelaySlot()) {
                return false;
            }
            Function func = this.program.getFunctionManager().getFunctionContaining(target);
            if (func != null && !func.getEntryPoint().equals((Object)target)) {
                return false;
            }
        }
        return true;
    }

    private int createData(Address address, int size) {
        if (!this.program.getListing().isUndefined(address, address)) {
            return 0;
        }
        if (size < 1 || size > 8) {
            return 0;
        }
        DataType dt = Undefined.getUndefinedDataType((int)size);
        Data data = null;
        try {
            data = this.program.getListing().createData(address, dt);
        }
        catch (CodeUnitInsertionException e) {
            data = this.program.getListing().getDefinedDataAt(address);
        }
        catch (DataTypeConflictException e) {
            // empty catch block
        }
        int addrByteSize = dt.getLength();
        return addrByteSize;
    }

    private int findOpIndexForRef(VarnodeContext context, Instruction instruction, int opIndex, long wordOffset, RefType refType) {
        boolean foundExactValue = false;
        int numOperands = instruction.getNumOperands();
        for (int i = 0; opIndex == -1 && i < numOperands; ++i) {
            List list;
            int len;
            long val;
            Scalar s;
            Address opAddr;
            int opType = instruction.getOperandType(i);
            if ((opType & 0x2000) != 0 && (opAddr = instruction.getAddress(i)) != null && opAddr.getAddressableWordOffset() == wordOffset) {
                opIndex = i;
                foundExactValue = true;
                break;
            }
            if ((opType & 0x200) != 0) {
                Register reg = instruction.getRegister(i);
                if (refType.isFlow() && reg != null && reg.isProgramCounter()) {
                    opIndex = i;
                    break;
                }
                if (reg != null) {
                    if (this.checkOffByOne(reg, wordOffset)) {
                        opIndex = i;
                        foundExactValue = true;
                        if (refType.isFlow()) break;
                    }
                    if (this.checkOffByOne(reg.getParentRegister(), wordOffset)) {
                        opIndex = i;
                        foundExactValue = true;
                        if (refType.isFlow()) break;
                    }
                }
            }
            if ((s = instruction.getScalar(i)) != null && ((val = s.getUnsignedValue()) == wordOffset || val == wordOffset >> 1)) {
                opIndex = i;
                foundExactValue = true;
                break;
            }
            if ((opType & 0x400000) == 0 || (len = (list = instruction.getDefaultOperandRepresentationList(i)).size()) <= 0) continue;
            long baseRegVal = 0L;
            long offset_residue_pos = wordOffset;
            long offset_residue_neg = wordOffset;
            for (int idx = 0; idx < len; ++idx) {
                Register reg;
                BigInteger val2;
                Object obj = list.get(idx);
                if (obj instanceof Scalar) {
                    long val3 = ((Scalar)obj).getUnsignedValue();
                    if (val3 == wordOffset || val3 == wordOffset >> 1 || val3 + baseRegVal == wordOffset) {
                        opIndex = i;
                        foundExactValue = true;
                        break;
                    }
                    val3 = ((Scalar)obj).getSignedValue();
                    offset_residue_neg -= val3;
                    offset_residue_pos += val3;
                }
                if (!(obj instanceof Register) || (val2 = context.getValue(reg = (Register)obj, false)) == null) continue;
                baseRegVal = val2.longValue();
                if ((baseRegVal & this.pointerMask) == wordOffset) {
                    opIndex = i;
                }
                offset_residue_neg -= baseRegVal;
                offset_residue_pos -= baseRegVal;
            }
            if (offset_residue_neg == 0L || offset_residue_pos == 0L) {
                opIndex = i;
                foundExactValue = true;
                break;
            }
            if (opIndex != -1 || i != numOperands - 1) continue;
            opIndex = i;
        }
        return opIndex;
    }

    private boolean checkOffByOne(Register reg, long wordOffset) {
        if (reg == null) {
            return false;
        }
        BigInteger val = this.context.getValue(reg, false);
        if (val == null) {
            return false;
        }
        long lval = val.longValue() & this.pointerMask;
        return lval == wordOffset || (lval ^ wordOffset) == 1L;
    }

    public boolean encounteredBranch() {
        return this.hitCodeFlow;
    }

    public boolean readExecutable() {
        return this.readExecutableAddress;
    }

    public void setParamRefCheck(boolean checkParamRefsOption) {
        this.checkForParamRefs = checkParamRefsOption;
    }

    public void setReturnRefCheck(boolean checkReturnRefsOption) {
        this.checkForReturnRefs = checkReturnRefsOption;
    }

    public void setStoredRefCheck(boolean checkStoredRefsOption) {
        this.checkForStoredRefs = checkStoredRefsOption;
    }

    protected class SavedFlowState {
        Address source;
        Address destination;
        boolean continueAfterHittingFlow;

        public SavedFlowState(Address source, Address destination, boolean continueAfterHittingFlow) {
            this.source = source;
            this.destination = destination;
            this.continueAfterHittingFlow = continueAfterHittingFlow;
        }

        public Address getSource() {
            return this.source;
        }

        public Address getDestination() {
            return this.destination;
        }

        public boolean isContinueAfterHittingFlow() {
            return this.continueAfterHittingFlow;
        }
    }

    public class Value {
        final Register relativeRegister;
        final long value;

        Value(Register relativeRegister, long value) {
            this.relativeRegister = relativeRegister;
            this.value = value;
        }

        Value(long value) {
            this.relativeRegister = null;
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isRegisterRelativeValue() {
            return this.relativeRegister != null;
        }

        public Register getRelativeRegister() {
            return this.relativeRegister;
        }
    }
}

