/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import docking.DockWinListener;
import docking.DockingWindowManager;
import ghidra.framework.model.Project;
import ghidra.framework.model.Tool;
import ghidra.framework.project.tool.GhidraTool;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;

public class TestTool
extends GhidraTool {
    public static final String NAME = "Test Tool";

    public TestTool(Project project) {
        super(project, NAME);
        this.winMgr.setWindowsOnTop(true);
    }

    protected DockingWindowManager createDockingWindowManager(boolean isDockable, boolean hasStatus, boolean isModal) {
        return new DockingWindowManager("EMPTY", null, (DockWinListener)this, isModal, isDockable, hasStatus, null);
    }

    public void close() {
        if (this.isExecutingCommand()) {
            throw new AssertException("Attempted to close tool while background command running");
        }
        Runnable r = () -> {
            this.exit();
            if (this.getProject().getToolServices() != null) {
                this.getProject().getToolServices().closeTool((Tool)this);
            }
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }
}

