/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.plugin;

import docking.DialogComponentProvider;
import ghidra.feature.fid.db.FidFile;
import ghidra.util.HelpLocation;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ActiveFidConfigureDialog
extends DialogComponentProvider {
    private List<FidFile> fidFiles;
    private List<JCheckBox> checkboxes = new ArrayList<JCheckBox>();

    public ActiveFidConfigureDialog(List<FidFile> fidFiles) {
        super("Select Active Fid Databases", true, false, true, false);
        this.fidFiles = new ArrayList<FidFile>(fidFiles);
        Collections.sort(fidFiles);
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.setOkButtonText("Dismiss");
        this.setRememberSize(false);
        this.setPreferredSize(400, 400);
        this.setHelpLocation(new HelpLocation("FunctionID", "chooseactivemenu"));
    }

    protected void okCallback() {
        this.close();
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildCheckboxPanelScroller(), "Center");
        panel.add(this.buildButtonPanel(), "South");
        return panel;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(2));
        JButton allButton = new JButton("Select All");
        JButton noneButton = new JButton("Select None");
        allButton.addActionListener(e -> this.selectAllCheckboxes(true));
        noneButton.addActionListener(e -> this.selectAllCheckboxes(false));
        panel.add(allButton);
        panel.add(noneButton);
        return panel;
    }

    private void selectAllCheckboxes(boolean b) {
        for (JCheckBox jCheckBox : this.checkboxes) {
            jCheckBox.setSelected(b);
        }
    }

    private Component buildCheckboxPanelScroller() {
        JScrollPane scrollPane = new JScrollPane(this.buildCheckBoxPanel());
        return scrollPane;
    }

    private Component buildCheckBoxPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setOpaque(true);
        panel.setBackground(Color.WHITE);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (FidFile fidFile : this.fidFiles) {
            JCheckBox checkbox = new JCheckBox(fidFile.getName());
            checkbox.setToolTipText(fidFile.getPath());
            this.checkboxes.add(checkbox);
            checkbox.setSelected(fidFile.isActive());
            checkbox.addItemListener(e -> fidFile.setActive(checkbox.isSelected()));
            panel.add(checkbox);
        }
        return panel;
    }
}

