/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingTool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RemoteAdapterListener;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.EditActionManager;
import ghidra.framework.main.FileActionManager;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.LogPanel;
import ghidra.framework.main.ProgramaticUseOnly;
import ghidra.framework.main.ProjectActionManager;
import ghidra.framework.main.ProjectDataPanel;
import ghidra.framework.main.ProjectToolBar;
import ghidra.framework.main.ToolActionManager;
import ghidra.framework.main.ToolButton;
import ghidra.framework.main.ToolButtonTransferable;
import ghidra.framework.main.WorkspacePanel;
import ghidra.framework.main.datatable.ProjectDataTablePanel;
import ghidra.framework.main.datatree.ClearCutAction;
import ghidra.framework.main.datatree.ProjectDataTreePanel;
import ghidra.framework.main.projectdata.actions.FindCheckoutsAction;
import ghidra.framework.main.projectdata.actions.ProjectDataCollapseAction;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyAction;
import ghidra.framework.main.projectdata.actions.ProjectDataCutAction;
import ghidra.framework.main.projectdata.actions.ProjectDataDeleteAction;
import ghidra.framework.main.projectdata.actions.ProjectDataExpandAction;
import ghidra.framework.main.projectdata.actions.ProjectDataNewFolderAction;
import ghidra.framework.main.projectdata.actions.ProjectDataOpenDefaultToolAction;
import ghidra.framework.main.projectdata.actions.ProjectDataOpenToolAction;
import ghidra.framework.main.projectdata.actions.ProjectDataPasteAction;
import ghidra.framework.main.projectdata.actions.ProjectDataReadOnlyAction;
import ghidra.framework.main.projectdata.actions.ProjectDataRefreshAction;
import ghidra.framework.main.projectdata.actions.ProjectDataRenameAction;
import ghidra.framework.main.projectdata.actions.ProjectDataSelectAction;
import ghidra.framework.main.projectdata.actions.VersionControlAddAction;
import ghidra.framework.main.projectdata.actions.VersionControlCheckInAction;
import ghidra.framework.main.projectdata.actions.VersionControlCheckOutAction;
import ghidra.framework.main.projectdata.actions.VersionControlShowHistoryAction;
import ghidra.framework.main.projectdata.actions.VersionControlUndoCheckOutAction;
import ghidra.framework.main.projectdata.actions.VersionControlUndoHijackAction;
import ghidra.framework.main.projectdata.actions.VersionControlUpdateAction;
import ghidra.framework.main.projectdata.actions.VersionControlViewCheckOutAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolSet;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.remote.User;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.xml.GenericXMLOutputter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.STABLE, packageName="Ghidra Core", category="Common", shortDescription="Front End", description="Front End Components for Ghidra", servicesProvided={FrontEndService.class})
public class FrontEndPlugin
extends Plugin
implements FrontEndService,
RemoteAdapterListener,
ProgramaticUseOnly {
    private static final String TITLE_PREFIX = "Ghidra: ";
    private static final String EXPORT_TOOL_ACTION_NAME = "Export Tool";
    private static final String DELETE_TOOL_ACTION_NAME = "Delete Tool";
    private static final String CLOSE_TOOL_ACTION_NAME = "Close Tool";
    private static final String PROPERTIES_ACTION_NAME = "Configure Plugins";
    private JPanel mainGuiPanel;
    private ProjectToolBar toolBar;
    private ProjectDataTreePanel dataTreePanel;
    private ProjectDataTablePanel dataTablePanel;
    private ToolButtonTransferable toolButtonTransferable;
    private WorkspacePanel workspacePanel;
    private Project activeProject;
    private ProjectManager projectManager;
    private ProjectDataPanel projectDataPanel;
    private LogPanel statusPanel;
    private String projectName;
    private GhidraFileChooser exportFileChooser;
    private FileActionManager fileActionManager;
    private ProjectActionManager projectActionManager;
    private ToolActionManager toolActionManager;
    private static String PROJECT_EXTENSION = ProjectLocator.getProjectExtension().substring(1);
    private DockingAction closeToolAction;
    private DockingAction exportToolAction;
    private DockingAction deleteToolAction;
    private DockingAction propertiesAction;
    private ToolButtonAction renameToolAction;
    private JLabel repositoryLabel;
    private JLabel connectionLabel;
    private JPanel connectionIconPanel;
    private JButton connectionButton;
    static final Icon CONNECTED_ICON = ResourceManager.loadImage((String)"images/connected.gif");
    static final Icon DISCONNECTED_ICON = ResourceManager.loadImage((String)"images/disconnected.gif");
    private Icon emptyIcon = ResourceManager.loadImage((String)"images/EmptyIcon.gif");
    private FrontEndProvider frontEndProvider;
    private ProjectDataCutAction cutAction;
    private ClearCutAction clearCutAction;
    private ProjectDataCopyAction copyAction;
    private ProjectDataPasteAction pasteAction;
    private ProjectDataRenameAction renameAction;
    private ProjectDataOpenDefaultToolAction openAction;
    private ProjectDataExpandAction expandAction;
    private ProjectDataCollapseAction collapseAction;
    private ProjectDataSelectAction selectAction;
    private ProjectDataReadOnlyAction readOnlyAction;
    private ProjectDataRefreshAction refreshAction;
    private ProjectDataNewFolderAction newFolderAction;
    private ProjectDataDeleteAction deleteAction;
    protected List<DockingAction> openActions = new ArrayList<DockingAction>();
    private VersionControlAddAction addAction;
    private VersionControlUpdateAction mergeAction;
    private VersionControlCheckInAction checkInAction;
    private VersionControlCheckOutAction checkOutAction;
    private VersionControlUndoCheckOutAction undoCheckOutsAction;
    private VersionControlShowHistoryAction historyAction;
    private VersionControlViewCheckOutAction viewCheckOutAction;
    private VersionControlUndoHijackAction undoHijackAction;
    private FindCheckoutsAction findCheckoutsAction;
    private ToolChestChangeListener toolChestChangeListener;

    public FrontEndPlugin(PluginTool tool) {
        super(tool);
        SystemUtilities.assertTrue((boolean)(tool instanceof FrontEndTool), (String)"FrontEndPlugin requires a FrontEndTool");
        this.projectActionManager = new ProjectActionManager(this);
        this.frontEndProvider = new FrontEndProvider(tool);
        tool.addComponentProvider(this.frontEndProvider, true);
        tool.setDefaultComponent(this.frontEndProvider);
        new EditActionManager(this);
        this.buildGui();
        this.toolChestChangeListener = new MyToolChestChangeListener();
        this.fileActionManager = new FileActionManager(this);
        this.toolActionManager = new ToolActionManager(this);
        this.setProjectName();
        this.createActions();
        this.createVersionControlActions();
        this.createToolSpecificOpenActions();
    }

    protected void createToolSpecificOpenActions() {
        ToolTemplate[] templates;
        for (DockingAction action : this.openActions) {
            this.tool.removeAction((DockingActionIf)action);
        }
        if (this.activeProject == null) {
            return;
        }
        ToolChest toolChest = this.activeProject.getLocalToolChest();
        if (toolChest == null) {
            return;
        }
        this.tool.setMenuGroup(new String[]{"Open With"}, "Open");
        for (ToolTemplate toolTemplate : templates = toolChest.getToolTemplates()) {
            String toolName = toolTemplate.getName();
            ProjectDataOpenToolAction toolAction = new ProjectDataOpenToolAction(this.getName(), "Open", toolName, toolTemplate.getIcon());
            this.tool.addAction((DockingActionIf)toolAction);
            this.openActions.add(toolAction);
        }
    }

    private void createActions() {
        String owner = this.getName();
        String groupName = "Cut/copy/paste/new1";
        this.newFolderAction = new ProjectDataNewFolderAction(owner, groupName);
        groupName = "Cut/copy/paste/new2";
        this.cutAction = new ProjectDataCutAction(owner, groupName);
        this.clearCutAction = new ClearCutAction(owner);
        this.copyAction = new ProjectDataCopyAction(owner, groupName);
        this.pasteAction = new ProjectDataPasteAction(owner, groupName);
        groupName = "Delete/Rename";
        this.renameAction = new ProjectDataRenameAction(owner, groupName);
        this.deleteAction = new ProjectDataDeleteAction(owner, groupName);
        this.openAction = new ProjectDataOpenDefaultToolAction(owner, "Open");
        groupName = "Expand/Collapse";
        this.expandAction = new ProjectDataExpandAction(owner, groupName);
        this.collapseAction = new ProjectDataCollapseAction(owner, groupName);
        groupName = "Select/Toggle";
        this.selectAction = new ProjectDataSelectAction(owner, groupName);
        this.readOnlyAction = new ProjectDataReadOnlyAction(owner, groupName);
        groupName = "XRefresh";
        this.refreshAction = new ProjectDataRefreshAction(owner, groupName);
        this.tool.addAction((DockingActionIf)this.newFolderAction);
        this.tool.addAction((DockingActionIf)this.cutAction);
        this.tool.addAction((DockingActionIf)this.clearCutAction);
        this.tool.addAction((DockingActionIf)this.copyAction);
        this.tool.addAction((DockingActionIf)this.pasteAction);
        this.tool.addAction((DockingActionIf)this.deleteAction);
        this.tool.addAction((DockingActionIf)this.openAction);
        this.tool.addAction((DockingActionIf)this.renameAction);
        this.tool.addAction((DockingActionIf)this.expandAction);
        this.tool.addAction((DockingActionIf)this.collapseAction);
        this.tool.addAction((DockingActionIf)this.selectAction);
        this.tool.addAction((DockingActionIf)this.readOnlyAction);
        this.tool.addAction((DockingActionIf)this.refreshAction);
    }

    private void createVersionControlActions() {
        String owner = this.getName();
        this.addAction = new VersionControlAddAction(this);
        this.checkOutAction = new VersionControlCheckOutAction(this);
        this.mergeAction = new VersionControlUpdateAction(this);
        this.checkInAction = new VersionControlCheckInAction(this, this.projectDataPanel);
        this.undoCheckOutsAction = new VersionControlUndoCheckOutAction(this);
        this.historyAction = new VersionControlShowHistoryAction(this);
        this.viewCheckOutAction = new VersionControlViewCheckOutAction(this);
        this.undoHijackAction = new VersionControlUndoHijackAction(this);
        this.findCheckoutsAction = new FindCheckoutsAction(owner, this);
        this.tool.addAction((DockingActionIf)this.addAction);
        this.tool.addAction((DockingActionIf)this.checkOutAction);
        this.tool.addAction((DockingActionIf)this.mergeAction);
        this.tool.addAction((DockingActionIf)this.checkInAction);
        this.tool.addAction((DockingActionIf)this.undoCheckOutsAction);
        this.tool.addAction((DockingActionIf)this.historyAction);
        this.tool.addAction((DockingActionIf)this.viewCheckOutAction);
        this.tool.addAction((DockingActionIf)this.undoHijackAction);
        this.tool.addAction((DockingActionIf)this.findCheckoutsAction);
    }

    FrontEndProvider getFrontEndProvider() {
        return this.frontEndProvider;
    }

    FrontEndTool getFrontEndTool() {
        return (FrontEndTool)this.tool;
    }

    public JComponent getComponent() {
        return this.mainGuiPanel;
    }

    public static String getDescriptiveName() {
        return "Front End";
    }

    public static String getDescription() {
        return "Front End Components for Ghidra";
    }

    public static String getCategory() {
        return "FrontEnd";
    }

    public void connectionStateChanged(Object adapter) {
        RepositoryAdapter repository;
        if (this.activeProject != null && (repository = this.activeProject.getRepository()) == adapter) {
            Runnable r = () -> {
                this.updateConnectionPanel(this.activeProject);
                this.projectActionManager.connectionStateChanged((RepositoryAdapter)adapter);
                if (!this.activeProject.isClosed() && !repository.isConnected() && repository.hadUnexpectedDisconnect()) {
                    this.showDisconnectedDialog(repository);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    private void showDisconnectedDialog(RepositoryAdapter repository) {
        String message = "The Ghidra Server repository unexpectedly disconnected: " + repository + "\nThis can occur if your system becomes suspended or due to a server/network problem.\n \nRepository status and actions will be unavailable until\nthe server connection is re-established.  Any files opened from the\nserver may be forced to close as a result.";
        OptionDialog info = new OptionDialog("Ghidra Server Error", message, -1, DISCONNECTED_ICON);
        info.show((Component)this.tool.getToolFrame());
    }

    void setProjectManager(ProjectManager pm) {
        this.projectManager = pm;
    }

    void setActiveProject(Project project) {
        RepositoryAdapter repository;
        ToolChest toolChest;
        if (this.activeProject != null) {
            toolChest = this.activeProject.getLocalToolChest();
            toolChest.removeToolChestChangeListener(this.toolActionManager);
            toolChest.removeToolChestChangeListener(this.toolBar);
            toolChest.removeToolChestChangeListener(this.toolChestChangeListener);
            repository = this.activeProject.getRepository();
            if (repository != null) {
                repository.removeListener((RemoteAdapterListener)this);
            }
        }
        this.activeProject = project;
        this.enableProjectMenuItems(project != null);
        this.toolBar.setActiveProject(project);
        this.projectDataPanel.setActiveProject(project);
        this.fileActionManager.setActiveProject(this.activeProject);
        this.projectActionManager.setActiveProject(this.activeProject);
        this.toolActionManager.setActiveProject(this.activeProject);
        if (project != null) {
            GenericRunInfo.setProjectsDirPath((String)project.getProjectLocator().getLocation());
        }
        this.workspacePanel.setActiveProject(project);
        this.setProjectName();
        this.updateConnectionPanel(project);
        if (this.activeProject != null) {
            toolChest = project.getLocalToolChest();
            toolChest.addToolChestChangeListener(this.toolActionManager);
            toolChest.addToolChestChangeListener(this.toolBar);
            toolChest.addToolChestChangeListener(this.toolChestChangeListener);
            this.createToolSpecificOpenActions();
            repository = this.activeProject.getRepository();
            if (repository != null) {
                repository.addListener((RemoteAdapterListener)this);
            }
        }
    }

    void setProjectName() {
        this.projectName = this.activeProject == null ? "NO ACTIVE PROJECT" : this.activeProject.getName();
        String title = TITLE_PREFIX + this.projectName;
        this.tool.setToolName(title);
        this.projectDataPanel.setBorder(this.projectName);
    }

    @Override
    public void writeDataState(SaveState saveState) {
        this.projectDataPanel.writeDataState(saveState);
    }

    @Override
    public void readDataState(SaveState saveState) {
        this.projectDataPanel.readDataState(saveState);
    }

    void exitGhidra() {
        boolean okToExit = this.closeActiveProject();
        if (okToExit) {
            System.exit(0);
        } else if (!this.tool.isVisible()) {
            this.tool.setVisible(true);
        }
    }

    private boolean closeActiveProject() {
        if (this.activeProject == null) {
            return true;
        }
        try {
            return this.fileActionManager.closeProject(true);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Close Project Failed", (String)("Error Description: [ " + e + " ]\n=====> Do you wish to exit Ghidra, possibly losing changes? <====="), (String)"Exit Ghidra (Possibly Lose Changes)", (int)0);
            return result != 0;
        }
    }

    ProjectLocator chooseProject(GhidraFileChooser fileChooser, String mode, String preferenceName) {
        boolean create = mode.equals("Create");
        fileChooser.setTitle(mode + " a Ghidra Project");
        fileChooser.setApproveButtonText(mode + " Project");
        fileChooser.setApproveButtonToolTipText(mode + " a Ghidra Project");
        fileChooser.setSelectedFile(null);
        boolean validInput = false;
        while (!validInput) {
            File file = fileChooser.getSelectedFile();
            if (file != null) {
                String path = file.getAbsoluteFile().getParent();
                String filename = file.getName();
                if (filename.endsWith(PROJECT_EXTENSION)) {
                    filename = filename.substring(0, filename.lastIndexOf(PROJECT_EXTENSION) - 1);
                } else if (!create && filename.lastIndexOf(".") > path.lastIndexOf(File.separator)) {
                    Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Invalid Project File", (Object)("Cannot open '" + file.getName() + "' as a Ghidra Project"));
                    continue;
                }
                if (!NamingUtilities.isValidName((String)filename)) {
                    Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Invalid Project Name", (Object)(filename + " is not a valid project name"));
                    continue;
                }
                Preferences.setProperty((String)preferenceName, (String)path);
                try {
                    Preferences.store();
                }
                catch (Exception e) {
                    Msg.debug((Object)this, (Object)("Unexpected exception storing preferences to" + Preferences.getFilename()), (Throwable)e);
                }
                return new ProjectLocator(path, filename);
            }
            return null;
        }
        return null;
    }

    boolean confirmDelete(String message) {
        int option = OptionDialog.showOptionDialogWithCancelAsDefaultButton((Component)this.tool.getToolFrame(), (String)"Confirm Delete", (String)("Are you sure you want to delete\n" + message), (String)"Delete", (int)3);
        return option != 0;
    }

    void selectFiles(Set<DomainFile> files) {
        SwingUtilities.invokeLater(() -> {
            Set<DomainFile> unmodifiableFiles = Collections.unmodifiableSet(files);
            this.dataTreePanel.selectDomainFiles(unmodifiableFiles);
            this.dataTablePanel.setSelectedDomainFiles(unmodifiableFiles);
        });
    }

    final ProjectDataTreePanel getActiveDataTree() {
        return this.dataTreePanel;
    }

    final Project getActiveProject() {
        return this.activeProject;
    }

    final ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public final Workspace getActiveWorkspace() {
        return this.workspacePanel.getActiveWorkspace();
    }

    final ProjectActionManager getProjectActionManager() {
        return this.projectActionManager;
    }

    final ToolActionManager getToolActionManager() {
        return this.toolActionManager;
    }

    final WorkspacePanel getWorkspacePanel() {
        return this.workspacePanel;
    }

    final ProjectDataPanel getProjectDataPanel() {
        return this.projectDataPanel;
    }

    final FileActionManager getFileActionManager() {
        return this.fileActionManager;
    }

    LogPanel getStatusPanel() {
        return this.statusPanel;
    }

    ActionContext getActionContext(ComponentProvider provider, MouseEvent e) {
        Component source;
        ActionContext actionContext = this.projectDataPanel.getActionContext(provider, e);
        if (actionContext == null && e != null && (source = (Component)e.getSource()) instanceof ToolButton) {
            return new ActionContext(provider, (Object)source);
        }
        return actionContext;
    }

    final boolean isGuiShowing() {
        return this.mainGuiPanel.isShowing();
    }

    ToolButtonTransferable getToolButtonTransferable() {
        return this.toolButtonTransferable;
    }

    void setToolButtonTransferable(ToolButtonTransferable t) {
        if (t == null && this.toolButtonTransferable != null) {
            this.toolButtonTransferable.clearTransferData();
        }
        this.toolButtonTransferable = t;
    }

    void updateToolConnectionDialog() {
        this.toolActionManager.updateConnectionDialog();
    }

    void rebuildRecentMenus() {
        this.fileActionManager.buildRecentProjectsMenu();
        this.projectActionManager.buildRecentViewsActions();
    }

    void newProject() {
        this.fileActionManager.newProject();
    }

    URL[] getRecentViewedProjects() {
        return this.projectManager.getRecentViewedProjects();
    }

    ProjectLocator[] getRecentProjects() {
        return this.projectManager.getRecentProjects();
    }

    void exportToolConfig(ToolTemplate template, String msgSource) {
        try {
            int result;
            GhidraFileChooser fileChooser = this.getFileChooser(template);
            File selectedFile = fileChooser.getSelectedFile(true);
            if (selectedFile == null) {
                return;
            }
            Preferences.setProperty((String)"LastToolExportDirectory", (String)selectedFile.getParent());
            if (selectedFile.exists() && (result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Overwrite?", (String)"File exists. Do you want to overwrite?", (String)"Yes", (String)"No", (int)3)) == 2) {
                this.exportToolConfig(template, msgSource);
                return;
            }
            this.exportToolTemplate(selectedFile, template, msgSource);
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error Exporting Tool", (Object)("Error exporting tool: " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error exporting tool", (Throwable)e);
        }
    }

    private GhidraFileChooser getFileChooser(ToolTemplate template) {
        if (this.exportFileChooser == null) {
            this.exportFileChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
            this.exportFileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter("tool", "Tools"));
            this.exportFileChooser.setApproveButtonText("Export");
            String exportDir = Preferences.getProperty((String)"LastToolExportDirectory");
            if (exportDir != null) {
                this.exportFileChooser.setCurrentDirectory(new File(exportDir));
            } else {
                String importDir = Preferences.getProperty((String)"LastToolImportDirectory");
                if (importDir != null) {
                    this.exportFileChooser.setCurrentDirectory(new File(importDir));
                }
            }
        }
        this.exportFileChooser.setTitle("Export " + template.getName());
        return this.exportFileChooser;
    }

    private void exportToolTemplate(File location, ToolTemplate template, String msgSource) throws FileNotFoundException, IOException {
        String filename = location.getName();
        if (filename.endsWith(".tool")) {
            filename = filename.substring(0, filename.length() - 5);
        }
        FileOutputStream f = new FileOutputStream(location.getParent() + File.separator + filename + ".tool");
        BufferedOutputStream bf = new BufferedOutputStream(f);
        Document doc = new Document(template.saveToXml());
        GenericXMLOutputter xmlout = new GenericXMLOutputter();
        xmlout.output(doc, (OutputStream)bf);
        bf.close();
        Msg.info((Object)this, (Object)(msgSource + ": Successfully exported " + template.getName() + " to " + location.getAbsolutePath()));
    }

    private void updateConnectionPanel(Project project) {
        this.repositoryLabel.setText("     ");
        this.connectionIconPanel.remove(this.connectionLabel);
        if (this.connectionButton != null) {
            this.connectionIconPanel.remove(this.connectionButton);
        }
        if (project == null || project.getRepository() == null) {
            this.connectionLabel = new JLabel(this.emptyIcon);
            this.connectionIconPanel.add(this.connectionLabel);
            return;
        }
        RepositoryAdapter repository = project.getRepository();
        User user = null;
        boolean isConnected = repository.isConnected();
        this.connectionButton = new JButton(isConnected ? CONNECTED_ICON : DISCONNECTED_ICON);
        this.connectionButton.addActionListener(e -> this.connect());
        this.connectionButton.setContentAreaFilled(false);
        this.connectionButton.setSelected(isConnected);
        this.connectionButton.setBorder(isConnected ? BorderFactory.createBevelBorder(1) : BorderFactory.createBevelBorder(0));
        this.connectionIconPanel.add(this.connectionButton);
        if (isConnected) {
            try {
                user = repository.getUser();
            }
            catch (IOException e2) {
                Msg.debug((Object)this, (Object)"Unexpected exception retrieving user from repository", (Throwable)e2);
            }
        }
        this.repositoryLabel.setText("Project Repository:   " + repository.getName() + this.getAccessString(user));
        String serverName = repository.getServerInfo().getServerName();
        this.connectionButton.setToolTipText((String)(isConnected ? "Connected as '" + repository.getServer().getUser() + "' to " + serverName : HTMLUtilities.toHTML((String)("Disconnected from " + serverName + "\nActivate this button to connect"))));
    }

    private void connect() {
        RepositoryAdapter repository = this.activeProject.getRepository();
        if (repository != null && !repository.isConnected()) {
            try {
                repository.connect();
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"Repository Connection", (Component)this.getTool().getToolFrame());
            }
        }
    }

    private String getAccessString(User user) {
        if (user == null) {
            return "";
        }
        if (user.isAdmin()) {
            return "   (Administrator)";
        }
        if (user.isReadOnly()) {
            return "   (Read Only)";
        }
        return "   (Read/Write)";
    }

    GhidraFileChooser createFileChooser(String preferenceName) {
        String dirPath;
        File projectDir = new File(GenericRunInfo.getProjectsDirPath());
        if (preferenceName != null && (dirPath = Preferences.getProperty((String)preferenceName, null, (boolean)true)) != null) {
            projectDir = new File(dirPath);
        }
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
        fileChooser.setCurrentDirectory(projectDir);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        fileChooser.setFileFilter(new GhidraFileFilter(){

            public String getDescription() {
                return "Ghidra Projects (*" + ProjectLocator.getProjectExtension() + ")";
            }

            public boolean accept(File pathname, GhidraFileChooserModel model) {
                String lowerCaseName = pathname.getName().toLowerCase();
                if (model.isDirectory(pathname)) {
                    return !lowerCaseName.endsWith(ProjectLocator.getProjectDirExtension());
                }
                return lowerCaseName.endsWith(ProjectLocator.getProjectExtension());
            }
        });
        fileChooser.rescanCurrentDirectory();
        return fileChooser;
    }

    private void enableProjectMenuItems(boolean enabled) {
        this.toolActionManager.enableActions(enabled);
        this.projectActionManager.enableActions(enabled);
        this.fileActionManager.enableActions(enabled);
    }

    private void buildGui() {
        this.toolBar = new ProjectToolBar(this);
        this.buildPanels();
        this.createToolButtonActions();
    }

    @Override
    protected void dispose() {
        this.dataTablePanel.dispose();
        this.dataTreePanel.dispose();
    }

    private void buildPanels() {
        this.statusPanel = new LogPanel(this);
        this.statusPanel.setHelpLocation(new HelpLocation("FrontEndPlugin", "StatusWindow"));
        this.dataTreePanel = new ProjectDataTreePanel(this);
        this.dataTablePanel = new ProjectDataTablePanel(this);
        this.dataTreePanel.setHelpLocation(new HelpLocation(this.getName(), "ProjectDataTree"));
        this.dataTablePanel.setHelpLocation(new HelpLocation(this.getName(), "ProjectDataTable"));
        this.workspacePanel = new WorkspacePanel(this);
        this.projectDataPanel = new ProjectDataPanel(this, this.dataTreePanel, this.dataTablePanel, this.projectName);
        JPanel connectionPanel = new JPanel();
        connectionPanel.setLayout(new BorderLayout());
        this.repositoryLabel = new JLabel("");
        this.repositoryLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.connectionIconPanel = new JPanel();
        this.connectionLabel = new JLabel("");
        this.connectionIconPanel.add(this.connectionLabel);
        connectionPanel.add((Component)this.repositoryLabel, "Center");
        connectionPanel.add((Component)this.connectionIconPanel, "East");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.toolBar, "North");
        mainPanel.add((Component)this.projectDataPanel, "Center");
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new BoxLayout(bottomPane, 1));
        bottomPane.add(this.workspacePanel);
        bottomPane.add(Box.createVerticalGlue());
        bottomPane.add(Box.createVerticalStrut(2));
        bottomPane.add(connectionPanel);
        bottomPane.add(this.statusPanel);
        bottomPane.add(Box.createVerticalGlue());
        this.mainGuiPanel = new JPanel(new BorderLayout(5, 5));
        this.mainGuiPanel.add((Component)mainPanel, "Center");
        this.mainGuiPanel.add((Component)bottomPane, "South");
    }

    private void createToolButtonActions() {
        this.exportToolAction = new ToolButtonAction(EXPORT_TOOL_ACTION_NAME){

            public void actionPerformed(ActionContext context) {
                ToolButton tb = (ToolButton)((Object)context.getContextObject());
                FrontEndPlugin.this.exportToolConfig(tb.getToolTemplate(), "ToolButton");
            }

            @Override
            boolean isEnabledForContext(ToolButton toolButton) {
                return !toolButton.isRunningTool();
            }
        };
        this.exportToolAction.setPopupMenuData(new MenuData(new String[]{"Export..."}, "tool"));
        this.exportToolAction.setHelpLocation(new HelpLocation("Tool", EXPORT_TOOL_ACTION_NAME));
        this.deleteToolAction = new ToolButtonAction(DELETE_TOOL_ACTION_NAME){

            public void actionPerformed(ActionContext context) {
                ToolButton tb = (ToolButton)((Object)context.getContextObject());
                FrontEndPlugin.this.delete(tb.getToolTemplate().getName());
            }

            @Override
            boolean isEnabledForContext(ToolButton toolButton) {
                return !toolButton.isRunningTool();
            }
        };
        this.deleteToolAction.setPopupMenuData(new MenuData(new String[]{"Delete..."}, "tool"));
        this.deleteToolAction.setHelpLocation(new HelpLocation("Tool", DELETE_TOOL_ACTION_NAME));
        this.closeToolAction = new ToolButtonAction(CLOSE_TOOL_ACTION_NAME){

            public void actionPerformed(ActionContext context) {
                ToolButton tb = (ToolButton)((Object)context.getContextObject());
                tb.closeTool();
            }

            @Override
            public boolean isEnabledForContext(ToolButton toolButton) {
                return toolButton.isRunningTool();
            }
        };
        this.closeToolAction.setPopupMenuData(new MenuData(new String[]{"Close"}, "tool"));
        this.closeToolAction.setHelpLocation(new HelpLocation("Tool", CLOSE_TOOL_ACTION_NAME));
        this.renameToolAction = new ToolButtonAction("Rename Tool"){

            public void actionPerformed(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof ToolButton)) {
                    return;
                }
                ToolButton toolButton = (ToolButton)((Object)contextObject);
                ToolTemplate toolTemplate = toolButton.getToolTemplate();
                if (this.isToolRunning(toolTemplate)) {
                    Msg.showWarn((Object)((Object)this), (Component)((Object)toolButton), (String)"Unable to Rename", (Object)"You must first close any running instances of a tool before you can rename");
                    return;
                }
                String oldName = toolTemplate.getName();
                String newName = this.getNewToolName(oldName);
                if (newName == null) {
                    return;
                }
                ToolChest localToolChest = FrontEndPlugin.this.activeProject.getLocalToolChest();
                localToolChest.remove(oldName);
                toolTemplate.setName(newName);
                localToolChest.addToolTemplate(toolTemplate);
            }

            private String getNewToolName(String currentName) {
                InputDialog inputDialog = new InputDialog("Rename Tool", "Please enter a new name: ", currentName);
                FrontEndPlugin.this.tool.showDialog((DialogComponentProvider)inputDialog);
                if (inputDialog.isCanceled()) {
                    return null;
                }
                String newName = inputDialog.getValue();
                if (currentName.equals(newName)) {
                    return null;
                }
                return newName;
            }

            @Override
            public boolean isEnabledForContext(ToolButton toolButton) {
                return true;
            }

            private boolean isToolRunning(ToolTemplate template) {
                Tool[] runningTools;
                ToolManager toolManager = FrontEndPlugin.this.activeProject.getToolManager();
                for (Tool runningTool : runningTools = toolManager.getRunningTools()) {
                    if (!runningTool.getToolName().equals(template.getName())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isValidContext(ToolButton toolButton) {
                return !toolButton.isRunningTool();
            }
        };
        this.renameToolAction.setPopupMenuData(new MenuData(new String[]{"Rename..."}, "tool"));
        this.renameToolAction.setHelpLocation(new HelpLocation("Tool", "Rename Tool"));
        this.propertiesAction = new ToolButtonAction(PROPERTIES_ACTION_NAME){

            public void actionPerformed(ActionContext context) {
                ToolButton tb = (ToolButton)((Object)context.getContextObject());
                PluginTool pluginTool = (PluginTool)tb.getRunningTool();
                pluginTool.showConfig(true, false);
            }

            @Override
            boolean isEnabledForContext(ToolButton toolButton) {
                if (toolButton.isRunningTool()) {
                    PluginTool pluginTool = (PluginTool)toolButton.getRunningTool();
                    return pluginTool.isConfigurable();
                }
                return false;
            }
        };
        this.propertiesAction.setPopupMenuData(new MenuData(new String[]{"Configure Plugins..."}, "zproperties"));
        this.propertiesAction.setHelpLocation(new HelpLocation("Tool", "Configure_Tool"));
        this.tool.addLocalAction(this.frontEndProvider, (DockingActionIf)this.exportToolAction);
        this.tool.addLocalAction(this.frontEndProvider, (DockingActionIf)this.renameToolAction);
        this.tool.addLocalAction(this.frontEndProvider, (DockingActionIf)this.deleteToolAction);
        this.tool.addLocalAction(this.frontEndProvider, (DockingActionIf)this.closeToolAction);
        this.tool.addLocalAction(this.frontEndProvider, (DockingActionIf)this.propertiesAction);
    }

    private void delete(String toolName) {
        if (!this.confirmDelete(toolName + " from your local tool chest?")) {
            return;
        }
        this.activeProject.getLocalToolChest().remove(toolName);
    }

    @Override
    public void addProjectListener(ProjectListener l) {
        ((FrontEndTool)this.tool).addProjectListener(l);
    }

    @Override
    public void removeProjectListener(ProjectListener l) {
        if (this.tool != null) {
            ((FrontEndTool)this.tool).removeProjectListener(l);
        }
    }

    public void openDomainFile(DomainFile domainFile) {
        Project project = this.tool.getProject();
        ToolServices toolServices = project.getToolServices();
        ToolTemplate defaultToolTemplate = toolServices.getDefaultToolTemplate(domainFile);
        if (defaultToolTemplate == null) {
            Msg.showInfo((Object)this, (Component)this.tool.getToolFrame(), (String)"Cannot Find Tool", (Object)("<html>Cannot find tool to open file: <b>" + domainFile.getName() + "</b>.<br><br>Make sure you have an appropriate tool installed <br>from the <b>Tools->Import Default Tools...</b> menu.  Alternatively, you can use <b>Tool->Set Tool Associations</b> menu to change how Ghidra opens this type of file"));
            return;
        }
        ToolButton button = this.toolBar.getToolButtonForToolConfig(defaultToolTemplate);
        button.launchTool(domainFile);
    }

    private class MyToolChestChangeListener
    implements ToolChestChangeListener {
        private MyToolChestChangeListener() {
        }

        @Override
        public void toolTemplateAdded(ToolTemplate toolTemplate) {
            FrontEndPlugin.this.createToolSpecificOpenActions();
        }

        @Override
        public void toolSetAdded(ToolSet toolset) {
            FrontEndPlugin.this.createToolSpecificOpenActions();
        }

        @Override
        public void toolRemoved(String toolName) {
            FrontEndPlugin.this.createToolSpecificOpenActions();
        }
    }

    class FrontEndProvider
    extends ComponentProvider {
        public FrontEndProvider(PluginTool tool) {
            super((DockingTool)tool, "FrontEnd", "FrontEnd Tool");
            this.setTitle("Project Window");
            this.setDefaultWindowPosition(WindowPosition.TOP);
        }

        public JComponent getComponent() {
            return FrontEndPlugin.this.getComponent();
        }

        public ActionContext getActionContext(MouseEvent e) {
            return FrontEndPlugin.this.getActionContext(this, e);
        }

        public HelpLocation getHelpLocation() {
            return new HelpLocation(FrontEndPlugin.this.getName(), "Project_Window");
        }
    }

    private abstract class ToolButtonAction
    extends DockingAction {
        ToolButtonAction(String name) {
            super(name, FrontEndPlugin.this.getName(), false);
            this.setEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object contextObject = context.getContextObject();
            if (contextObject instanceof ToolButton) {
                return this.isEnabledForContext((ToolButton)((Object)contextObject));
            }
            return false;
        }

        public boolean isAddToPopup(ActionContext context) {
            if (!(context.getContextObject() instanceof ToolButton)) {
                return false;
            }
            return this.isValidContext((ToolButton)((Object)context.getContextObject()));
        }

        abstract boolean isEnabledForContext(ToolButton var1);

        boolean isValidContext(ToolButton toolButton) {
            return this.isEnabledForContext(toolButton);
        }
    }
}

