/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ToolTipManager;
import ghidra.framework.model.ServerInfo;
import ghidra.util.MessageType;
import ghidra.util.StatusListener;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServerInfoComponent
extends JPanel {
    private JTextField nameField;
    private JTextField portNumberField;
    private int portNumber = -1;
    private DocumentListener portDocListener;
    private DocumentListener nameDocListener;
    private StatusListener statusListener;
    private ChangeListener listener;

    public ServerInfoComponent() {
        super(new BorderLayout(10, 10));
        this.buildMainPanel();
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    public String getServerName() {
        return this.nameField.getText();
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setServerInfo(ServerInfo info) {
        if (info != null) {
            this.nameField.setText(info.getServerName());
            this.portNumberField.setText(Integer.toString(info.getPortNumber()));
        } else {
            this.nameField.setText("");
            this.portNumberField.setText(Integer.toString(13100));
        }
    }

    private void buildMainPanel() {
        JLabel nameLabel = new JLabel("Server Name:", 4);
        this.nameField = new JTextField(20);
        this.nameField.setName("Server Name");
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerInfoComponent.this.nameField.transferFocus();
            }
        });
        this.nameDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ServerInfoComponent.this.notifyChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ServerInfoComponent.this.notifyChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ServerInfoComponent.this.notifyChange();
            }
        };
        this.nameField.getDocument().addDocumentListener(this.nameDocListener);
        JLabel portLabel = new JLabel("Port Number:", 4);
        this.portNumberField = new JTextField(20);
        this.portNumberField.setName("Port Number");
        this.portNumberField.setText(Integer.toString(13100));
        this.portNumberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerInfoComponent.this.portNumberField.transferFocus();
            }
        });
        this.portDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ServerInfoComponent.this.notifyChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ServerInfoComponent.this.notifyChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ServerInfoComponent.this.notifyChange();
            }
        };
        this.portNumberField.getDocument().addDocumentListener(this.portDocListener);
        ToolTipManager.setToolTipText((JComponent)this.portNumberField, (String)"Enter port number");
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 10));
        panel.add(nameLabel);
        panel.add(this.nameField);
        panel.add(portLabel);
        panel.add(this.portNumberField);
        this.add((Component)panel, "Center");
    }

    private void setStatus(String text) {
        if (this.statusListener == null) {
            return;
        }
        if (text == null || text.length() == 0) {
            this.statusListener.clearStatusText();
        } else {
            this.statusListener.setStatusText(text, MessageType.ERROR);
        }
    }

    private void notifyChange() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    private boolean checkPortNumber() {
        this.portNumber = -1;
        String portStr = this.portNumberField.getText();
        String msg = null;
        try {
            this.portNumber = Integer.parseInt(portStr);
            if (this.portNumber < 0 || this.portNumber > 65536) {
                this.portNumber = -1;
                msg = "Port number must in range of 0 to 65536";
            }
        }
        catch (NumberFormatException e) {
            msg = "Invalid port number entered";
        }
        this.setStatus(msg);
        return msg == null;
    }

    private boolean checkServerName() {
        String name = this.nameField.getText();
        String msg = null;
        if (name.length() == 0) {
            msg = "Enter the server name";
        }
        this.setStatus(msg);
        return msg == null;
    }

    public boolean isValidInformation() {
        return this.checkServerName() && this.checkPortNumber();
    }
}

