/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.framework.main.datatable.DomainFileProvider;
import ghidra.framework.main.datatree.ChangedFilesDialog;
import ghidra.framework.main.datatree.CheckInTask;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class VersionControlCheckInAction
extends VersionControlAction {
    private Component parent;

    public VersionControlCheckInAction(Plugin plugin, Component parent) {
        super("CheckIn", plugin.getName(), plugin.getTool());
        this.parent = parent;
        ImageIcon icon = ResourceManager.loadImage((String)"images/vcCheckIn.png");
        this.setPopupMenuData(new MenuData(new String[]{"Check In..."}, (Icon)icon, "Repository"));
        this.setToolBarData(new ToolBarData((Icon)icon, "Repository"));
        this.setDescription("Check in file");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileProvider context) {
        this.doCheckIn(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileProvider context) {
        List<DomainFile> domainFiles = context.getSelectedFiles();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.isCheckedOut() || !domainFile.modifiedSinceCheckout()) continue;
            return true;
        }
        return false;
    }

    private void doCheckIn(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        ArrayList<DomainFile> checkedOut = new ArrayList<DomainFile>();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.isCheckedOut() || !domainFile.modifiedSinceCheckout()) continue;
            checkedOut.add(domainFile);
        }
        if (checkedOut.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.parent, (String)"No Modified Files", (Object)"No checked-out and modified files in the given selection");
            return;
        }
        if (checkedOut.size() > 0) {
            this.checkIn(checkedOut);
        }
    }

    public void checkIn(List<DomainFile> fileList) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        ArrayList<DomainFile> changedList = new ArrayList<DomainFile>();
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (int i = 0; i < fileList.size(); ++i) {
            DomainFile df = fileList.get(i);
            if (df == null || !df.canCheckin() || !this.canCloseDomainFile(df)) continue;
            list.add(df);
            if (!df.isChanged()) continue;
            changedList.add(df);
        }
        if (changedList.size() > 0) {
            ChangedFilesDialog dialog = new ChangedFilesDialog(this.tool, changedList);
            dialog.setCancelToolTipText("Cancel Check In");
            if (!dialog.showDialog()) {
                this.tool.setStatusInfo("Checkin canceled");
                return;
            }
            for (int i = 0; i < changedList.size(); ++i) {
                DomainFile df = changedList.get(i);
                if (!df.isChanged()) continue;
                list.remove(df);
            }
        }
        if (list.size() > 0) {
            this.tool.execute(new CheckInTask(this.tool, list, this.parent));
        } else {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Checkin Failed", (Object)"Unable to checkin file(s)");
        }
    }
}

