/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.cmd.formats.MachoBinaryAnalysisCommand;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.ios.dyldcache.DyldArchitecture;
import ghidra.file.formats.ios.dyldcache.DyldCacheData;
import ghidra.file.formats.ios.dyldcache.DyldCacheHeader;
import ghidra.file.formats.ios.dyldcache.DyldCacheUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class DyldCacheAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Address headerAddress = program.getMinAddress();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), headerAddress);
        DyldArchitecture architecture = DyldArchitecture.getArchitecture((ByteProvider)provider);
        if (architecture == null) {
            log.appendMsg("Invalid DYLD cache file.");
            return false;
        }
        BinaryReader reader = new BinaryReader((ByteProvider)provider, architecture.getEndianness() == Endian.LITTLE);
        DyldCacheHeader header = new DyldCacheHeader(reader);
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, headerAddress, headerDataType);
        this.createFragment(program, headerDataType.getName(), headerData.getMinAddress(), headerData.getMaxAddress().add(1L));
        reader.setPointerIndex(header.getStartAddress());
        Address address = this.toAddr(program, header.getStartAddress());
        for (int i = 0; i < header.getLibraryCount() && !monitor.isCancelled(); ++i) {
            DyldCacheData data = new DyldCacheData(reader);
            DataType dataDataType = data.toDataType();
            Data dataData = this.createData(program, address, dataDataType);
            this.createFragment(program, dataDataType.getName(), dataData.getMinAddress(), dataData.getMaxAddress().add(1L));
            Address fileOffset = this.toAddr(program, data.getFileOffset());
            Data fileData = this.createData(program, fileOffset, (DataType)new StringDataType());
            this.createFragment(program, "LibraryNames", fileData.getMinAddress(), fileData.getMaxAddress().add(1L));
            String filePath = (String)fileData.getValue();
            Address libraryOffsetAddress = this.toAddr(program, data.getLibraryOffset() - header.getBaseAddress());
            MachoBinaryAnalysisCommand command = new MachoBinaryAnalysisCommand(libraryOffsetAddress, false, program.getListing().getDefaultRootModule());
            command.applyTo(program, monitor);
            this.setPlateComment(program, address, filePath);
            this.setPlateComment(program, libraryOffsetAddress, filePath);
            address = address.add((long)dataDataType.getLength());
        }
        this.updateImageBase(program, header);
        return false;
    }

    private void updateImageBase(Program program, DyldCacheHeader header) throws Exception {
        long imageBaseValue = header.getBaseAddress();
        Address imageBase = this.toAddr(program, imageBaseValue);
        program.setImageBase(imageBase, true);
    }

    public boolean canAnalyze(Program program) {
        return DyldCacheUtil.isDyldCache(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return DyldCacheUtil.isDyldCache(program);
    }

    public String getDescription() {
        return "Annotates an DYLD Cache file.";
    }

    public String getName() {
        return "DYLD Cache Annotation";
    }

    public boolean isPrototype() {
        return true;
    }
}

