/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.bitpatterns.gui.ByteSequenceAnalyzerProvider;
import ghidra.bitpatterns.gui.ByteSequenceTableModel;
import ghidra.bitpatterns.gui.ClosedPatternRowObject;
import ghidra.bitpatterns.gui.ClosedPatternTableDialog;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.SequenceMiningParamsInputDialog;
import ghidra.bitpatterns.info.ByteSequenceRowObject;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.closedpatternmining.SequenceMiningParams;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class PatternMiningAnalyzerProvider
extends ByteSequenceAnalyzerProvider {
    private static final String TITLE = "Analyzing Sequences";
    private static final String MINE_PATTERNS_BUTTON_TEXT = "Mine Closed Sequential Patterns";
    private static final String ENTER_PARAMS_TITLE = "Set Mining Parameters";
    private DockingAction mineClosedPatternsAction;

    public PatternMiningAnalyzerProvider(FunctionBitPatternsExplorerPlugin plugin, List<ByteSequenceRowObject> rowObjects, Component parent, PatternType type, ContextRegisterFilter cRegFilter) {
        super(TITLE, plugin, rowObjects, parent, type, cRegFilter, null);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Mining_Closed_Sequential_Patterns");
        this.setHelpLocation(helpLocation);
        this.addMiningAction();
    }

    private void addMiningAction() {
        this.mineClosedPatternsAction = new DockingAction(MINE_PATTERNS_BUTTON_TEXT, this.title, false){

            public void actionPerformed(ActionContext context) {
                List lastSelectedObjects = PatternMiningAnalyzerProvider.this.byteSequenceTable.getLastSelectedObjects();
                SequenceMiningParamsInputDialog paramsCreater = new SequenceMiningParamsInputDialog(PatternMiningAnalyzerProvider.ENTER_PARAMS_TITLE, PatternMiningAnalyzerProvider.this.mainPanel);
                if (paramsCreater.isCanceled()) {
                    return;
                }
                SequenceMiningParams params = paramsCreater.getSequenceMiningParams();
                List<ClosedPatternRowObject> closedPatternRowObjects = ClosedPatternRowObject.mineClosedPatterns(lastSelectedObjects, params.getMinPercentage(), params.getRequiredBitsOfCheck(), params.getUseBinary(), PatternMiningAnalyzerProvider.this.type, PatternMiningAnalyzerProvider.this.cRegFilter, PatternMiningAnalyzerProvider.this.mainPanel);
                new ClosedPatternTableDialog(PatternMiningAnalyzerProvider.this.plugin, closedPatternRowObjects, PatternMiningAnalyzerProvider.this.mainPanel, PatternMiningAnalyzerProvider.this.type, PatternMiningAnalyzerProvider.this.cRegFilter);
            }

            public boolean isEnabledForContext(ActionContext context) {
                List lastSelectedObjects = PatternMiningAnalyzerProvider.this.byteSequenceTable.getLastSelectedObjects();
                if (lastSelectedObjects == null) {
                    return false;
                }
                return !lastSelectedObjects.isEmpty();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)"images/magnifier.png");
        this.mineClosedPatternsAction.setPopupMenuData(new MenuData(new String[]{"Mine Sequential Patterns"}, (Icon)icon));
        this.mineClosedPatternsAction.setDescription("Mine Sequential Patterns");
        this.addAction((DockingActionIf)this.mineClosedPatternsAction);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Mining_Closed_Sequential_Patterns");
        this.mineClosedPatternsAction.setHelpLocation(helpLocation);
    }

    @Override
    ByteSequenceTableModel createByteSequenceTable(FunctionBitPatternsExplorerPlugin fPlugin, List<ByteSequenceRowObject> rowObjects) {
        return new ByteSequenceTableModel(this.plugin, rowObjects);
    }
}

