/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableFilter;
import ghidra.app.util.SymbolInspector;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationMarkupStatus;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.EmptyVTSession;
import ghidra.feature.vt.gui.editors.DisplayableAddress;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.markuptable.DisplayableListingAddress;
import ghidra.feature.vt.gui.provider.matchtable.DisplayableLabel;
import ghidra.feature.vt.gui.provider.matchtable.MatchMarkupStatusBatteryRenderer;
import ghidra.feature.vt.gui.provider.matchtable.MatchMarkupStatusRenderer;
import ghidra.feature.vt.gui.provider.matchtable.MultipleLabelsRenderer;
import ghidra.feature.vt.gui.util.MungedAssocationAndMarkupItemStatus;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;

public abstract class AbstractVTMatchTableModel
extends AddressBasedTableModel<VTMatch> {
    protected Comparator<VTMatch> markupStatusColumnComparator = new MarkupStatusColumnComparator();
    protected VTSession session;
    private Set<Filter<VTMatch>> allFilters = new HashSet<Filter<VTMatch>>();
    protected final VTController controller;

    public AbstractVTMatchTableModel(String title, VTController controller) {
        super(title, controller.getServiceProvider(), null, null);
        this.controller = controller;
    }

    public void sessionChanged() {
        this.cancelAllUpdates();
        VTSession newSession = this.controller.getSession();
        if (newSession == null) {
            newSession = new EmptyVTSession();
        }
        this.setSession(newSession);
    }

    private void setSession(VTSession session) {
        this.session = session;
        super.setProgram(session.getSourceProgram());
        this.reload();
    }

    public Address getAddress(int row) {
        VTMatch match = (VTMatch)this.getRowObject(row);
        VTAssociation association = match.getAssociation();
        return association.getSourceAddress();
    }

    protected abstract void doLoad(Accumulator<VTMatch> var1, TaskMonitor var2) throws CancelledException;

    public void clearData() {
        super.clearData();
    }

    private List<Filter<VTMatch>> getFilters() {
        ArrayList<Filter<VTMatch>> appliedFilters = new ArrayList<Filter<VTMatch>>();
        for (Filter<VTMatch> filter : this.allFilters) {
            Filter.FilterShortcutState state = filter.getFilterShortcutState();
            if (state == Filter.FilterShortcutState.NEVER_PASSES) {
                return null;
            }
            if (state != Filter.FilterShortcutState.REQUIRES_CHECK) continue;
            Filter<VTMatch> copy = filter.createCopy();
            appliedFilters.add(copy);
        }
        return appliedFilters;
    }

    public void updateFilter() {
        this.rebuildFilter();
    }

    public void addFilter(Filter<VTMatch> filter) {
        this.allFilters.add(filter);
        this.rebuildFilter();
    }

    private void rebuildFilter() {
        List<Filter<VTMatch>> appliedFilters = this.getFilters();
        MatchTablePassthroughFilter passThroughFilter = new MatchTablePassthroughFilter(appliedFilters);
        this.setTableFilter(passThroughFilter);
    }

    public static class RelatedMatchCountColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Integer> {
        public String getColumnName() {
            return "# Conflicting";
        }

        public String getColumnDescription() {
            return "# Conflicting - The number of unique associations with either the same source or same destination address";
        }

        public Integer getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getAssociation().getRelatedAssociations().size() - 1;
        }

        public int getColumnPreferredWidth() {
            return 30;
        }
    }

    public static class ImpliedMatchCountColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Integer> {
        public String getColumnName() {
            return "Votes";
        }

        public String getColumnDescription() {
            return "Votes - The number of references from from previously accepted matches that would suggest that this is a correct match";
        }

        public Integer getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getAssociation().getVoteCount();
        }

        public int getColumnPreferredWidth() {
            return 30;
        }
    }

    public static class TagTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, String> {
        public String getColumnName() {
            return "Tag";
        }

        public String getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            VTMatchTag tag = rowObject.getTag();
            if (tag == null) {
                return null;
            }
            return tag.getName();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    public static class SessionNumberTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Integer> {
        public String getColumnName() {
            return "Session ID";
        }

        public Integer getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            VTMatchSet matchSet = rowObject.getMatchSet();
            int id = matchSet.getID();
            if (id < 1) {
                return null;
            }
            return id;
        }

        public int getColumnPreferredWidth() {
            return 30;
        }
    }

    public static class AlgorithmTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, String> {
        public String getColumnName() {
            return "Algorithm";
        }

        public String getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            VTMatchSet matchSet = rowObject.getMatchSet();
            VTProgramCorrelatorInfo info = matchSet.getProgramCorrelatorInfo();
            return info.getName();
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    public static class LengthDeltaTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Integer> {
        public String getColumnName() {
            return "Length Delta";
        }

        public Integer getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            int destinationLength = rowObject.getDestinationLength();
            int sourceLength = rowObject.getSourceLength();
            int max = Math.max(destinationLength, sourceLength);
            int min = Math.min(destinationLength, sourceLength);
            return max - min;
        }

        public int getColumnPreferredWidth() {
            return 30;
        }
    }

    public static class DestinationLengthTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Integer> {
        public String getColumnName() {
            return "Dest Length";
        }

        public Integer getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getDestinationLength();
        }

        public int getColumnPreferredWidth() {
            return 35;
        }
    }

    public static class SourceLengthTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Integer> {
        public String getColumnName() {
            return "Source Length";
        }

        public Integer getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSourceLength();
        }

        public int getColumnPreferredWidth() {
            return 35;
        }
    }

    public static class DestinationAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, DisplayableAddress> {
        private SymbolInspector symbolInspector;
        private GColumnRenderer<DisplayableAddress> addressCellRenderer = new AbstractGColumnRenderer<DisplayableAddress>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                DisplayableListingAddress displayableAddress = (DisplayableListingAddress)value;
                String addressString = displayableAddress.getDisplayString();
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)addressString);
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                Program program = displayableAddress.getProgram();
                Address address = displayableAddress.getAddress();
                if (!address.isMemoryAddress() && symbolInspector != null) {
                    Symbol s = program.getSymbolTable().getPrimarySymbol(address);
                    symbolInspector.setProgram(program);
                    Color c = s != null ? symbolInspector.getColor(s) : Color.RED;
                    this.setForeground(c);
                } else if (!program.getMemory().contains(address)) {
                    this.setForeground(Color.RED);
                }
                renderer.setOpaque(true);
                return renderer;
            }

            public String getFilterString(DisplayableAddress t, Settings settings) {
                return t.getDisplayString();
            }
        };

        public String getColumnName() {
            return "Dest Address";
        }

        public DisplayableListingAddress getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            if (this.symbolInspector == null) {
                this.symbolInspector = new SymbolInspector(serviceProvider, null);
            }
            VTAssociation association = rowObject.getAssociation();
            Address destinationAddress = association.getDestinationAddress();
            Program destinationProgram = rowObject.getMatchSet().getSession().getDestinationProgram();
            return new DisplayableListingAddress(destinationProgram, destinationAddress);
        }

        public GColumnRenderer<DisplayableAddress> getColumnRenderer() {
            return this.addressCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    public static class DestinationLabelSourceTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, String> {
        public String getColumnName() {
            return "Dest Label Type";
        }

        public String getValue(VTMatch rowObject, Settings settings, Program localProgram, ServiceProvider localServiceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)localServiceProvider.getService(VTController.class);
            Symbol symbol = controller.getDestinationSymbol(association);
            if (symbol == null) {
                return "<No Symbol>";
            }
            return symbol.getSource().getDisplayString();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    public static class DestinationNamespaceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, String> {
        public String getColumnName() {
            return "Dest Namespace";
        }

        public String getValue(VTMatch rowObject, Settings settings, Program localProgram, ServiceProvider localServiceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)localServiceProvider.getService(VTController.class);
            Symbol symbol = controller.getDestinationSymbol(association);
            if (symbol == null) {
                return "";
            }
            return symbol.getParentNamespace().getName(true);
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    public static class DestinationLabelTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, DisplayableLabel> {
        private SymbolInspector symbolInspector;
        private GColumnRenderer<DisplayableLabel> labelCellRenderer = new AbstractGColumnRenderer<DisplayableLabel>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                DisplayableLabel displayableLabel = (DisplayableLabel)value;
                String labelString = displayableLabel.getDisplayString();
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)labelString);
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                renderer.setToolTipText(null);
                Symbol symbol = displayableLabel.getSymbol();
                if (symbol != null) {
                    Namespace parentNamespace = symbol.getParentNamespace();
                    if (!parentNamespace.isGlobal()) {
                        renderer.setToolTipText(symbol.getName(true));
                    }
                    if (symbolInspector != null) {
                        symbolInspector.setProgram(symbol.getProgram());
                        renderer.setForeground(symbolInspector.getColor(symbol));
                    }
                } else {
                    renderer.setForeground(Color.RED);
                }
                renderer.setOpaque(true);
                this.setBold();
                return renderer;
            }

            public String getFilterString(DisplayableLabel t, Settings settings) {
                return t.getDisplayString();
            }
        };

        public String getColumnName() {
            return "Dest Label";
        }

        public DisplayableLabel getValue(VTMatch rowObject, Settings settings, Program localProgram, ServiceProvider localServiceProvider) throws IllegalArgumentException {
            if (this.symbolInspector == null) {
                this.symbolInspector = new SymbolInspector(localServiceProvider, null);
            }
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)localServiceProvider.getService(VTController.class);
            Symbol symbol = controller.getDestinationSymbol(association);
            return new DisplayableLabel(symbol);
        }

        public GColumnRenderer<DisplayableLabel> getColumnRenderer() {
            return this.labelCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    public static class MultipleDestinationLabelsTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Symbol[]> {
        private MultipleLabelsRenderer renderer = new MultipleLabelsRenderer(MultipleLabelsRenderer.MultipleLabelsRendererType.DESTINATION);

        public String getColumnName() {
            return "Multiple Dest Labels?";
        }

        public GColumnRenderer<Symbol[]> getColumnRenderer() {
            return this.renderer;
        }

        public int getColumnPreferredWidth() {
            return 30;
        }

        public Symbol[] getValue(VTMatch rowObject, Settings settings, Program data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)serviceProvider.getService(VTController.class);
            Program destinationProgram = controller.getDestinationProgram();
            Address destinationAddress = association.getDestinationAddress();
            Symbol[] symbols = destinationProgram.getSymbolTable().getSymbols(destinationAddress);
            return symbols;
        }
    }

    public static class SourceAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, DisplayableAddress> {
        private SymbolInspector symbolInspector;
        private GColumnRenderer<DisplayableAddress> addressCellRenderer = new AbstractGColumnRenderer<DisplayableAddress>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                DisplayableListingAddress displayableAddress = (DisplayableListingAddress)value;
                String addressString = displayableAddress.getDisplayString();
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)addressString);
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                Program program = displayableAddress.getProgram();
                Address address = displayableAddress.getAddress();
                if (!address.isMemoryAddress() && symbolInspector != null) {
                    Symbol s = program.getSymbolTable().getPrimarySymbol(address);
                    symbolInspector.setProgram(program);
                    Color c = s != null ? symbolInspector.getColor(s) : Color.RED;
                    this.setForeground(c);
                } else if (!program.getMemory().contains(address)) {
                    this.setForeground(Color.RED);
                }
                renderer.setOpaque(true);
                return renderer;
            }

            public String getFilterString(DisplayableAddress t, Settings settings) {
                return t.getDisplayString();
            }
        };

        public String getColumnName() {
            return "Source Address";
        }

        public DisplayableListingAddress getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            if (this.symbolInspector == null) {
                this.symbolInspector = new SymbolInspector(serviceProvider, null);
            }
            VTAssociation association = rowObject.getAssociation();
            Address sourceAddress = association.getSourceAddress();
            Program sourceProgram = rowObject.getMatchSet().getSession().getSourceProgram();
            return new DisplayableListingAddress(sourceProgram, sourceAddress);
        }

        public GColumnRenderer<DisplayableAddress> getColumnRenderer() {
            return this.addressCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    public static class SourceLabelSourceTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, String> {
        public String getColumnName() {
            return "Source Label Type";
        }

        public String getValue(VTMatch rowObject, Settings settings, Program localProgram, ServiceProvider localServiceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)localServiceProvider.getService(VTController.class);
            Symbol symbol = controller.getSourceSymbol(association);
            if (symbol == null) {
                return "<No Symbol>";
            }
            return symbol.getSource().getDisplayString();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    public static class SourceNamespaceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, String> {
        public String getColumnName() {
            return "Source Namespace";
        }

        public String getValue(VTMatch rowObject, Settings settings, Program localProgram, ServiceProvider localServiceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)localServiceProvider.getService(VTController.class);
            Symbol symbol = controller.getSourceSymbol(association);
            if (symbol == null) {
                return "";
            }
            return symbol.getParentNamespace().getName(true);
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    public static class SourceLabelTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, DisplayableLabel> {
        private SymbolInspector symbolInspector;
        private GColumnRenderer<DisplayableLabel> labelCellRenderer = new AbstractGColumnRenderer<DisplayableLabel>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                DisplayableLabel displayableLabel = (DisplayableLabel)value;
                String labelString = displayableLabel.getDisplayString();
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)labelString);
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                renderer.setToolTipText(null);
                Symbol symbol = displayableLabel.getSymbol();
                if (symbol != null) {
                    Namespace parentNamespace = symbol.getParentNamespace();
                    if (!parentNamespace.isGlobal()) {
                        renderer.setToolTipText(symbol.getName(true));
                    }
                    if (symbolInspector != null) {
                        symbolInspector.setProgram(symbol.getProgram());
                        renderer.setForeground(symbolInspector.getColor(symbol));
                    }
                } else {
                    renderer.setForeground(Color.RED);
                }
                renderer.setOpaque(true);
                this.setBold();
                return renderer;
            }

            public String getFilterString(DisplayableLabel t, Settings settings) {
                return t.getDisplayString();
            }
        };

        public String getColumnName() {
            return "Source Label";
        }

        public DisplayableLabel getValue(VTMatch rowObject, Settings settings, Program localProgram, ServiceProvider localServiceProvider) throws IllegalArgumentException {
            if (this.symbolInspector == null) {
                this.symbolInspector = new SymbolInspector(localServiceProvider, null);
            }
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)localServiceProvider.getService(VTController.class);
            Symbol symbol = controller.getSourceSymbol(association);
            return new DisplayableLabel(symbol);
        }

        public GColumnRenderer<DisplayableLabel> getColumnRenderer() {
            return this.labelCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    public static class MultipleSourceLabelsTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, Symbol[]> {
        private MultipleLabelsRenderer renderer = new MultipleLabelsRenderer(MultipleLabelsRenderer.MultipleLabelsRendererType.SOURCE);

        public String getColumnName() {
            return "Multiple Source Labels?";
        }

        public GColumnRenderer<Symbol[]> getColumnRenderer() {
            return this.renderer;
        }

        public int getColumnPreferredWidth() {
            return 30;
        }

        public Symbol[] getValue(VTMatch rowObject, Settings settings, Program data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            VTController controller = (VTController)serviceProvider.getService(VTController.class);
            Program sourceProgram = controller.getSourceProgram();
            Address sourceAddress = association.getSourceAddress();
            Symbol[] symbols = sourceProgram.getSymbolTable().getSymbols(sourceAddress);
            return symbols;
        }
    }

    public static class ConfidenceScoreTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, VTScore> {
        private GColumnRenderer<VTScore> renderer = new AbstractGColumnRenderer<VTScore>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                Object value = data.getValue();
                VTScore score = (VTScore)value;
                if (score == null) {
                    label.setText("N/A");
                } else {
                    label.setText(score.getFormattedLog10Score());
                }
                label.setOpaque(true);
                return label;
            }

            public String getFilterString(VTScore t, Settings settings) {
                if (t == null) {
                    return "N/A";
                }
                return t.getFormattedLog10Score();
            }
        };

        public String getColumnName() {
            return "Confidence (log10)";
        }

        public String getColumnDescription() {
            return "Confidence (log10) - confidence level that the items are a valid match";
        }

        public VTScore getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getConfidenceScore();
        }

        public int getColumnPreferredWidth() {
            return 55;
        }

        public GColumnRenderer<VTScore> getColumnRenderer() {
            return this.renderer;
        }
    }

    public static class ScoreTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, VTScore> {
        private GColumnRenderer<VTScore> renderer = new AbstractGColumnRenderer<VTScore>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                Object value = data.getValue();
                VTScore score = (VTScore)value;
                if (score == null) {
                    label.setText("N/A");
                } else {
                    label.setText(score.getFormattedScore());
                }
                label.setOpaque(true);
                return label;
            }

            public String getFilterString(VTScore t, Settings settings) {
                if (t == null) {
                    return "N/A";
                }
                return t.getFormattedScore();
            }
        };

        public String getColumnName() {
            return "Score";
        }

        public String getColumnDescription() {
            return "Score - score of match similarity";
        }

        public VTScore getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSimilarityScore();
        }

        public int getColumnPreferredWidth() {
            return 55;
        }

        public GColumnRenderer<VTScore> getColumnRenderer() {
            return this.renderer;
        }
    }

    public static class MatchTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, String> {
        public String getColumnName() {
            return "Type";
        }

        public String getColumnDescription() {
            return "Type - type of match";
        }

        public String getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getAssociation().getType().toString();
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    public static class AppliedMarkupStatusTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, VTMatch> {
        private MatchMarkupStatusRenderer renderer = new MatchMarkupStatusRenderer();

        public String getColumnName() {
            return "Markup Status";
        }

        public VTMatch getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject;
        }

        public int getColumnPreferredWidth() {
            return 60;
        }

        public GColumnRenderer<VTMatch> getColumnRenderer() {
            return this.renderer;
        }
    }

    public static class AppliedMarkupStatusBatteryTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, VTMatch> {
        private MatchMarkupStatusBatteryRenderer renderer = new MatchMarkupStatusBatteryRenderer();

        public String getColumnName() {
            return "Markup Status - Deprecated";
        }

        public VTMatch getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject;
        }

        public int getColumnPreferredWidth() {
            return 40;
        }

        public GColumnRenderer<VTMatch> getColumnRenderer() {
            return this.renderer;
        }
    }

    public static class StatusTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMatch, MungedAssocationAndMarkupItemStatus> {
        public String getColumnName() {
            return "Status";
        }

        public MungedAssocationAndMarkupItemStatus getValue(VTMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            VTAssociationStatus associationStatus = association.getStatus();
            switch (associationStatus) {
                case ACCEPTED: {
                    VTAssociationMarkupStatus markupStatus = association.getMarkupStatus();
                    if (markupStatus.isFullyApplied()) {
                        return MungedAssocationAndMarkupItemStatus.ACCEPTED_FULLY_APPLIED;
                    }
                    if (markupStatus.hasErrors()) {
                        return MungedAssocationAndMarkupItemStatus.ACCEPTED_HAS_ERRORS;
                    }
                    if (markupStatus.hasUnexaminedMarkup()) {
                        return MungedAssocationAndMarkupItemStatus.ACCEPTED_SOME_UNEXAMINED;
                    }
                    return MungedAssocationAndMarkupItemStatus.ACCEPTED_NO_UNEXAMINED;
                }
                case AVAILABLE: {
                    return MungedAssocationAndMarkupItemStatus.AVAILABLE;
                }
                case BLOCKED: {
                    return MungedAssocationAndMarkupItemStatus.BLOCKED;
                }
                case REJECTED: {
                    return MungedAssocationAndMarkupItemStatus.REJECTED;
                }
            }
            throw new IllegalArgumentException("Unexpected and unhandled VTAssociationStatus");
        }

        public int getColumnPreferredWidth() {
            return 30;
        }
    }

    public static class DestinationAddressComparator
    implements Comparator<VTMatch> {
        @Override
        public int compare(VTMatch o1, VTMatch o2) {
            VTAssociation association1 = o1.getAssociation();
            VTAssociation association2 = o2.getAssociation();
            Address address1 = association1.getDestinationAddress();
            Address address2 = association2.getDestinationAddress();
            return address1.compareTo((Object)address2);
        }
    }

    public static class SourceAddressComparator
    implements Comparator<VTMatch> {
        @Override
        public int compare(VTMatch o1, VTMatch o2) {
            VTAssociation association1 = o1.getAssociation();
            VTAssociation association2 = o2.getAssociation();
            Address address1 = association1.getSourceAddress();
            Address address2 = association2.getSourceAddress();
            return address1.compareTo((Object)address2);
        }
    }

    static class MarkupStatusColumnComparator
    implements Comparator<VTMatch> {
        MarkupStatusColumnComparator() {
        }

        @Override
        public int compare(VTMatch o1, VTMatch o2) {
            VTAssociationStatus status2;
            VTAssociation association1 = o1.getAssociation();
            VTAssociation association2 = o2.getAssociation();
            VTAssociationStatus status1 = association1.getStatus();
            int result = status1.compareTo(status2 = association2.getStatus());
            if (result == 0) {
                VTAssociationMarkupStatus markupStatus1 = association1.getMarkupStatus();
                VTAssociationMarkupStatus markupStatus2 = association2.getMarkupStatus();
                result = markupStatus1.compareTo(markupStatus2);
            }
            return result;
        }
    }

    private class MatchTablePassthroughFilter
    implements TableFilter<VTMatch> {
        private List<Filter<VTMatch>> appliedFilters;

        MatchTablePassthroughFilter(List<Filter<VTMatch>> appliedFilters) {
            this.appliedFilters = appliedFilters;
        }

        public boolean acceptsRow(VTMatch match) {
            if (this.appliedFilters == null) {
                return false;
            }
            if (this.appliedFilters.isEmpty()) {
                return true;
            }
            return this.rowMatchesFilters(this.appliedFilters, match);
        }

        private boolean rowMatchesFilters(List<Filter<VTMatch>> filters, VTMatch match) {
            for (Filter<VTMatch> filter : filters) {
                if (filter.passesFilter(match)) continue;
                return false;
            }
            return true;
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            if (!(tableFilter instanceof MatchTablePassthroughFilter)) {
                return false;
            }
            MatchTablePassthroughFilter otherMatchFilter = (MatchTablePassthroughFilter)tableFilter;
            if (this.appliedFilters == null || otherMatchFilter.appliedFilters == null) {
                return false;
            }
            if (this.appliedFilters.size() != otherMatchFilter.appliedFilters.size()) {
                return false;
            }
            int n = this.appliedFilters.size();
            for (int i = 0; i < n; ++i) {
                Filter<VTMatch> otherFilter;
                Filter<VTMatch> myFilter = this.appliedFilters.get(i);
                if (myFilter.isSubFilterOf(otherFilter = otherMatchFilter.appliedFilters.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

