/* gmime-3.0.vapi generated by vapigen-0.46, do not modify. */

[CCode (cprefix = "GMime", gir_namespace = "GMime", gir_version = "3.0", lower_case_cprefix = "g_mime_")]
namespace GMime {
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_application_pkcs7_mime_get_type ()")]
	public class ApplicationPkcs7Mime : GMime.Part {
		public GMime.SecureMimeType smime_type;
		[CCode (has_construct_function = false)]
		public ApplicationPkcs7Mime (GMime.SecureMimeType type);
		public GMime.Object? decrypt (GMime.DecryptFlags flags, string session_key, GMime.DecryptResult result) throws GLib.Error;
		public static GMime.ApplicationPkcs7Mime? encrypt (GMime.Object entity, GMime.EncryptFlags flags, GLib.GenericArray<string> recipients) throws GLib.Error;
		public GMime.SecureMimeType get_smime_type ();
		public static GMime.ApplicationPkcs7Mime? sign (GMime.Object entity, string userid) throws GLib.Error;
		public GMime.SignatureList? verify (GMime.VerifyFlags flags, out GMime.Object entity) throws GLib.Error;
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_autocrypt_header_get_type ()")]
	public class AutocryptHeader : GLib.Object {
		public weak GMime.InternetAddressMailbox address;
		public weak GLib.DateTime effective_date;
		public weak GLib.Bytes keydata;
		public GMime.AutocryptPreferEncrypt prefer_encrypt;
		[CCode (has_construct_function = false)]
		public AutocryptHeader ();
		public void clone (GMime.AutocryptHeader src);
		public int compare (GMime.AutocryptHeader ah2);
		[CCode (has_construct_function = false)]
		public AutocryptHeader.from_string (string string);
		public unowned GMime.InternetAddressMailbox get_address ();
		public unowned string get_address_as_string ();
		public unowned GLib.DateTime get_effective_date ();
		public unowned GLib.Bytes get_keydata ();
		public GMime.AutocryptPreferEncrypt get_prefer_encrypt ();
		public bool is_complete ();
		public void set_address (GMime.InternetAddressMailbox address);
		public void set_address_from_string (string address);
		public void set_effective_date (GLib.DateTime effective_date);
		public void set_keydata (GLib.Bytes data);
		public void set_prefer_encrypt (GMime.AutocryptPreferEncrypt pref);
		public string to_string (bool gossip);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_autocrypt_header_list_get_type ()")]
	public class AutocryptHeaderList : GLib.Object {
		[CCode (has_construct_function = false)]
		public AutocryptHeaderList ();
		public void add (GMime.AutocryptHeader header);
		public uint add_missing_addresses (GMime.InternetAddressList addresses);
		public uint get_count ();
		public unowned GMime.AutocryptHeader get_header_at (uint index);
		public unowned GMime.AutocryptHeader get_header_for_address (GMime.InternetAddressMailbox mailbox);
		public void remove_incomplete ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_certificate_get_type ()")]
	public class Certificate : GLib.Object {
		public long created;
		public GMime.DigestAlgo digest_algo;
		public weak string email;
		public long expires;
		public weak string fingerprint;
		public GMime.Validity id_validity;
		public weak string issuer_name;
		public weak string issuer_serial;
		public weak string keyid;
		public weak string name;
		public GMime.PubKeyAlgo pubkey_algo;
		public GMime.Trust trust;
		public weak string user_id;
		[CCode (has_construct_function = false)]
		public Certificate ();
		public long get_created ();
		public int64 get_created64 ();
		public GMime.DigestAlgo get_digest_algo ();
		public unowned string get_email ();
		public long get_expires ();
		public int64 get_expires64 ();
		public unowned string get_fingerprint ();
		public GMime.Validity get_id_validity ();
		public unowned string get_issuer_name ();
		public unowned string get_issuer_serial ();
		public unowned string get_key_id ();
		public unowned string get_name ();
		public GMime.PubKeyAlgo get_pubkey_algo ();
		public GMime.Trust get_trust ();
		public unowned string get_user_id ();
		public void set_created (long created);
		public void set_digest_algo (GMime.DigestAlgo algo);
		public void set_email (string email);
		public void set_expires (long expires);
		public void set_fingerprint (string fingerprint);
		public void set_id_validity (GMime.Validity validity);
		public void set_issuer_name (string issuer_name);
		public void set_issuer_serial (string issuer_serial);
		public void set_key_id (string key_id);
		public void set_name (string name);
		public void set_pubkey_algo (GMime.PubKeyAlgo algo);
		public void set_trust (GMime.Trust trust);
		public void set_user_id (string user_id);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_certificate_list_get_type ()")]
	public class CertificateList : GLib.Object {
		public weak GLib.GenericArray<void*> array;
		[CCode (has_construct_function = false)]
		public CertificateList ();
		public int add (GMime.Certificate cert);
		public void clear ();
		public bool contains (GMime.Certificate cert);
		public GMime.Certificate get_certificate (int index);
		public int index_of (GMime.Certificate cert);
		public void insert (int index, GMime.Certificate cert);
		public int length ();
		public bool remove (GMime.Certificate cert);
		public bool remove_at (int index);
		public void set_certificate (int index, GMime.Certificate cert);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_content_disposition_get_type ()")]
	public class ContentDisposition : GLib.Object {
		public weak string disposition;
		public weak GMime.ParamList @params;
		[CCode (has_construct_function = false)]
		public ContentDisposition ();
		public string encode (GMime.FormatOptions? options);
		public unowned string get_disposition ();
		public unowned string get_parameter (string name);
		public unowned GMime.ParamList get_parameters ();
		public bool is_attachment ();
		public static GMime.ContentDisposition parse (GMime.ParserOptions? options, string str);
		public void set_disposition (string value);
		public void set_parameter (string name, string value);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_content_type_get_type ()")]
	public class ContentType : GLib.Object {
		public weak GMime.ParamList @params;
		public weak string subtype;
		public weak string type;
		[CCode (has_construct_function = false)]
		public ContentType (string type, string subtype);
		public string encode (GMime.FormatOptions? options);
		public unowned string get_media_subtype ();
		public unowned string get_media_type ();
		public string get_mime_type ();
		public unowned string get_parameter (string name);
		public unowned GMime.ParamList get_parameters ();
		public bool is_type (string type, string subtype);
		public static GMime.ContentType parse (GMime.ParserOptions? options, string str);
		public void set_media_subtype (string subtype);
		public void set_media_type (string type);
		public void set_parameter (string name, string value);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_crypto_context_get_type ()")]
	public class CryptoContext : GLib.Object {
		public weak GMime.PasswordRequestFunc request_passwd;
		[CCode (has_construct_function = false)]
		public CryptoContext (string protocol);
		public virtual GMime.DecryptResult decrypt (GMime.DecryptFlags flags, string? session_key, GMime.Stream istream, GMime.Stream ostream) throws GLib.Error;
		public virtual GMime.DigestAlgo digest_id (string name);
		public virtual unowned string? digest_name (GMime.DigestAlgo digest);
		public virtual int encrypt (bool sign, string? userid, GMime.EncryptFlags flags, GLib.GenericArray<string> recipients, GMime.Stream istream, GMime.Stream ostream) throws GLib.Error;
		public virtual int export_keys (string keys, GMime.Stream ostream) throws GLib.Error;
		public virtual unowned string? get_encryption_protocol ();
		public virtual unowned string? get_key_exchange_protocol ();
		public virtual unowned string? get_signature_protocol ();
		public virtual int import_keys (GMime.Stream istream) throws GLib.Error;
		public virtual int sign (bool detach, string userid, GMime.Stream istream, GMime.Stream ostream) throws GLib.Error;
		public virtual GMime.SignatureList? verify (GMime.VerifyFlags flags, GMime.Stream istream, GMime.Stream? sigstream, GMime.Stream? ostream) throws GLib.Error;
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_data_wrapper_get_type ()")]
	public class DataWrapper : GLib.Object {
		public GMime.ContentEncoding encoding;
		public weak GMime.Stream stream;
		[CCode (has_construct_function = false)]
		public DataWrapper ();
		public GMime.ContentEncoding get_encoding ();
		public unowned GMime.Stream get_stream ();
		public void set_encoding (GMime.ContentEncoding encoding);
		public void set_stream (GMime.Stream stream);
		[CCode (has_construct_function = false)]
		public DataWrapper.with_stream (GMime.Stream stream, GMime.ContentEncoding encoding);
		public virtual ssize_t write_to_stream (GMime.Stream stream);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_decrypt_result_get_type ()")]
	public class DecryptResult : GLib.Object {
		public GMime.CipherAlgo cipher;
		public GMime.DigestAlgo mdc;
		public weak GMime.CertificateList recipients;
		public weak string session_key;
		public weak GMime.SignatureList signatures;
		[CCode (has_construct_function = false)]
		public DecryptResult ();
		public GMime.CipherAlgo get_cipher ();
		public GMime.DigestAlgo get_mdc ();
		public unowned GMime.CertificateList get_recipients ();
		public unowned string? get_session_key ();
		public unowned GMime.SignatureList? get_signatures ();
		public void set_cipher (GMime.CipherAlgo cipher);
		public void set_mdc (GMime.DigestAlgo mdc);
		public void set_recipients (GMime.CertificateList recipients);
		public void set_session_key (string? session_key);
		public void set_signatures (GMime.SignatureList signatures);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_get_type ()")]
	public abstract class Filter : GLib.Object {
		[CCode (array_length_cname = "backsize", array_length_type = "gsize")]
		public uint8[] backbuf;
		public size_t backlen;
		public size_t backsize;
		[CCode (array_length_cname = "outsize", array_length_type = "gsize")]
		public weak uint8[] outbuf;
		public size_t outpre;
		[CCode (array_length = false)]
		public weak uint8[] outptr;
		[CCode (array_length = false)]
		public uint8[] outreal;
		public size_t outsize;
		[CCode (has_construct_function = false)]
		protected Filter ();
		public void backup ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] data);
		public virtual void complete ([CCode (array_length_cname = "inlen", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] inbuf, size_t prespace, [CCode (array_length_cname = "outlen", array_length_pos = 3.5, array_length_type = "gsize")] out unowned uint8[] outbuf, out size_t outprespace);
		public virtual GMime.Filter copy ();
		public virtual void filter ([CCode (array_length_cname = "inlen", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] inbuf, size_t prespace, [CCode (array_length_cname = "outlen", array_length_pos = 3.5, array_length_type = "gsize")] out unowned uint8[] outbuf, out size_t outprespace);
		public virtual void reset ();
		public void set_size (size_t size, bool keep);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_basic_get_type ()")]
	public class FilterBasic : GMime.Filter {
		public GMime.Encoding encoder;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterBasic (GMime.ContentEncoding encoding, bool encode);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_best_get_type ()")]
	public class FilterBest : GMime.Filter {
		public GMime.Charset charset;
		public uint count0;
		public uint count8;
		public GMime.FilterBestFlags flags;
		[CCode (array_length = false)]
		public weak uint8 frombuf[6];
		public uint fromlen;
		public uint hadfrom;
		public uint linelen;
		public uint maxline;
		public uint midline;
		public uint startline;
		public uint total;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterBest (GMime.FilterBestFlags flags);
		public GMime.ContentEncoding encoding (GMime.EncodingConstraint constraint);
		[CCode (cname = "g_mime_filter_best_charset")]
		public unowned string get_charset ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_charset_get_type ()")]
	public class FilterCharset : GMime.Filter {
		public weak string from_charset;
		public weak string to_charset;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterCharset (string from_charset, string to_charset);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_checksum_get_type ()")]
	public class FilterChecksum : GMime.Filter {
		public weak GLib.Checksum checksum;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterChecksum (GLib.ChecksumType type);
		public size_t get_digest (uint8 digest, size_t len);
		public string get_string ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", lower_case_csuffix = "filter_dos2unix", type_id = "g_mime_filter_dos2unix_get_type ()")]
	public class FilterDos2Unix : GMime.Filter {
		public bool ensure_newline;
		public char pc;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterDos2Unix (bool ensure_newline);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_enriched_get_type ()")]
	public class FilterEnriched : GMime.Filter {
		public uint32 flags;
		public int nofill;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterEnriched (uint32 flags);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_from_get_type ()")]
	public class FilterFrom : GMime.Filter {
		public bool midline;
		public GMime.FilterFromMode mode;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterFrom (GMime.FilterFromMode mode);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_gzip_get_type ()")]
	public class FilterGZip : GMime.Filter {
		public int level;
		public GMime.FilterGZipMode mode;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterGZip (GMime.FilterGZipMode mode, int level);
		[Version (since = "3.2")]
		public unowned string get_comment ();
		[Version (since = "3.2")]
		public unowned string get_filename ();
		[Version (since = "3.2")]
		public void set_comment (string comment);
		[Version (since = "3.2")]
		public void set_filename (string filename);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_html_get_type ()")]
	public class FilterHTML : GMime.Filter {
		public uint32 citation_depth;
		public uint32 colour;
		public uint32 column;
		public uint32 flags;
		public uint32 pre_open;
		public void* scanner;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterHTML (uint32 flags, uint32 colour);
	}
	[CCode (cheader_filename = "gmime/gmime.h", lower_case_csuffix = "filter_openpgp", type_id = "g_mime_filter_openpgp_get_type ()")]
	[Version (since = "3.2")]
	public class FilterOpenPGP : GMime.Filter {
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterOpenPGP ();
		public int64 get_begin_offset ();
		public GMime.OpenPGPData get_data_type ();
		public int64 get_end_offset ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_smtp_data_get_type ()")]
	public class FilterSmtpData : GMime.Filter {
		public bool bol;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterSmtpData ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_strip_get_type ()")]
	public class FilterStrip : GMime.Filter {
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterStrip ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", lower_case_csuffix = "filter_unix2dos", type_id = "g_mime_filter_unix2dos_get_type ()")]
	public class FilterUnix2Dos : GMime.Filter {
		public bool ensure_newline;
		public char pc;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterUnix2Dos (bool ensure_newline);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_windows_get_type ()")]
	public class FilterWindows : GMime.Filter {
		public weak string claimed_charset;
		public bool is_windows;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterWindows (string claimed_charset);
		public bool is_windows_charset ();
		public unowned string real_charset ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_filter_yenc_get_type ()")]
	public class FilterYenc : GMime.Filter {
		public uint32 crc;
		public bool encode;
		public int part;
		public uint32 pcrc;
		public int state;
		[CCode (has_construct_function = false, type = "GMimeFilter*")]
		public FilterYenc (bool encode);
		public uint32 get_crc ();
		public uint32 get_pcrc ();
		public void set_crc (uint32 crc);
		public void set_state (int state);
	}
	[CCode (cheader_filename = "gmime/gmime.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "g_mime_format_options_get_type ()")]
	[Compact]
	public class FormatOptions {
		[CCode (has_construct_function = false)]
		public FormatOptions ();
		public void add_hidden_header (string header);
		public void clear_hidden_headers ();
		public GMime.FormatOptions clone ();
		public GMime.Filter create_newline_filter (bool ensure_newline);
		public void free ();
		public static GMime.FormatOptions get_default ();
		public unowned string get_newline ();
		public GMime.NewLineFormat get_newline_format ();
		public GMime.ParamEncodingMethod get_param_encoding_method ();
		public bool is_hidden_header (string header);
		public void remove_hidden_header (string header);
		public void set_newline_format (GMime.NewLineFormat newline);
		public void set_param_encoding_method (GMime.ParamEncodingMethod method);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_gpg_context_get_type ()")]
	public class GpgContext : GMime.CryptoContext {
		[CCode (has_construct_function = false, type = "GMimeCryptoContext*")]
		public GpgContext ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_header_get_type ()")]
	public class Header : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Header ();
		public string format_addrlist (GMime.FormatOptions? options, string value, string charset);
		public string format_content_disposition (GMime.FormatOptions? options, string value, string charset);
		public string format_content_type (GMime.FormatOptions? options, string value, string charset);
		public string format_default (GMime.FormatOptions? options, string value, string charset);
		public string format_message_id (GMime.FormatOptions? options, string value, string charset);
		public string format_received (GMime.FormatOptions? options, string value, string charset);
		public string format_references (GMime.FormatOptions? options, string value, string charset);
		public unowned string get_name ();
		public int64 get_offset ();
		public unowned string get_raw_name ();
		public unowned string get_raw_value ();
		public unowned string get_value ();
		public void set_raw_value (string raw_value);
		public void set_value (GMime.FormatOptions? options, string value, string charset);
		public ssize_t write_to_stream (GMime.FormatOptions? options, GMime.Stream stream);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_header_list_get_type ()")]
	public class HeaderList : GLib.Object {
		[CCode (has_construct_function = false)]
		public HeaderList (GMime.ParserOptions? options);
		public void append (string name, string value, string charset);
		public void clear ();
		public bool contains (string name);
		public int get_count ();
		public unowned GMime.Header get_header (string name);
		public unowned GMime.Header get_header_at (int index);
		public void prepend (string name, string value, string charset);
		public bool remove (string name);
		public void remove_at (int index);
		public void @set (string name, string value, string charset);
		public string to_string (GMime.FormatOptions? options);
		public ssize_t write_to_stream (GMime.FormatOptions? options, GMime.Stream stream);
	}
	[CCode (cheader_filename = "gmime/gmime.h", cname = "InternetAddress", type_id = "internet_address_get_type ()")]
	public abstract class InternetAddress : GLib.Object {
		public weak string charset;
		public weak string name;
		[CCode (has_construct_function = false)]
		protected InternetAddress ();
		[CCode (cname = "internet_address_get_charset")]
		public unowned string? get_charset ();
		[CCode (cname = "internet_address_get_name")]
		public unowned string? get_name ();
		[CCode (cname = "internet_address_set_charset")]
		public void set_charset (string? charset);
		[CCode (cname = "internet_address_set_name")]
		public void set_name (string name);
		[CCode (cname = "internet_address_to_string")]
		public string to_new_string (GMime.FormatOptions? options, bool encode);
		[NoWrapper]
		public virtual void to_string (GMime.FormatOptions options, uint32 flags, size_t linelen, GLib.StringBuilder str);
	}
	[CCode (cheader_filename = "gmime/gmime.h", cname = "InternetAddressGroup", type_id = "internet_address_group_get_type ()")]
	public class InternetAddressGroup : GMime.InternetAddress {
		public weak GMime.InternetAddressList members;
		[CCode (cname = "internet_address_group_new", has_construct_function = false, type = "InternetAddress*")]
		public InternetAddressGroup (string name);
		[CCode (cname = "internet_address_group_add_member")]
		public int add_member (GMime.InternetAddress member);
		[CCode (cname = "internet_address_group_get_members")]
		public unowned GMime.InternetAddressList get_members ();
		[CCode (cname = "internet_address_group_set_members")]
		public void set_members (GMime.InternetAddressList members);
	}
	[CCode (cheader_filename = "gmime/gmime.h", cname = "InternetAddressList", type_id = "internet_address_list_get_type ()")]
	public class InternetAddressList : GLib.Object {
		public weak GLib.GenericArray<void*> array;
		[CCode (cname = "internet_address_list_new", has_construct_function = false)]
		public InternetAddressList ();
		[CCode (cname = "internet_address_list_add")]
		public int add (GMime.InternetAddress ia);
		[CCode (cname = "internet_address_list_append")]
		public void append (GMime.InternetAddressList append);
		[CCode (cname = "internet_address_list_clear")]
		public void clear ();
		[CCode (cname = "internet_address_list_contains")]
		public bool contains (GMime.InternetAddress ia);
		[CCode (cname = "internet_address_list_encode")]
		public void encode (GMime.FormatOptions? options, GLib.StringBuilder str);
		[CCode (cname = "internet_address_list_get_address")]
		public unowned GMime.InternetAddress get_address (int index);
		[CCode (cname = "internet_address_list_index_of")]
		public int index_of (GMime.InternetAddress ia);
		[CCode (cname = "internet_address_list_insert")]
		public void insert (int index, GMime.InternetAddress ia);
		[CCode (cname = "internet_address_list_length")]
		public int length ();
		[CCode (cname = "internet_address_list_parse")]
		public static GMime.InternetAddressList? parse (GMime.ParserOptions? options, string str);
		[CCode (cname = "internet_address_list_prepend")]
		public void prepend (GMime.InternetAddressList prepend);
		[CCode (cname = "internet_address_list_remove")]
		public bool remove (GMime.InternetAddress ia);
		[CCode (cname = "internet_address_list_remove_at")]
		public bool remove_at (int index);
		[CCode (cname = "internet_address_list_set_address")]
		public void set_address (int index, GMime.InternetAddress ia);
		[CCode (cname = "internet_address_list_to_string")]
		public string? to_string (GMime.FormatOptions? options, bool encode);
	}
	[CCode (cheader_filename = "gmime/gmime.h", cname = "InternetAddressMailbox", type_id = "internet_address_mailbox_get_type ()")]
	public class InternetAddressMailbox : GMime.InternetAddress {
		public weak string addr;
		public int at;
		public weak string idn_addr;
		[CCode (cname = "internet_address_mailbox_new", has_construct_function = false, type = "InternetAddress*")]
		public InternetAddressMailbox (string name, string addr);
		[CCode (cname = "internet_address_mailbox_get_addr")]
		public unowned string get_addr ();
		[CCode (cname = "internet_address_mailbox_get_idn_addr")]
		public unowned string get_idn_addr ();
		[CCode (cname = "internet_address_mailbox_set_addr")]
		public void set_addr (string addr);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_message_get_type ()")]
	public class Message : GMime.Object {
		public weak GMime.InternetAddressList addrlists;
		public weak GLib.DateTime date;
		public weak string message_id;
		public weak GMime.Object mime_part;
		public weak string subject;
		[CCode (has_construct_function = false)]
		public Message (bool pretty_headers);
		public void add_mailbox (GMime.AddressType type, string name, string addr);
		public void @foreach (GMime.ObjectForeachFunc callback);
		public unowned GMime.InternetAddressList get_addresses (GMime.AddressType type);
		public GMime.InternetAddressList get_all_recipients ();
		public GMime.AutocryptHeaderList get_autocrypt_gossip_headers (GLib.DateTime now, GMime.DecryptFlags flags, string session_key) throws GLib.Error;
		public GMime.AutocryptHeaderList get_autocrypt_gossip_headers_from_inner_part (GLib.DateTime now, GMime.Object inner_part);
		public GMime.AutocryptHeader get_autocrypt_header (GLib.DateTime now);
		public unowned GMime.InternetAddressList get_bcc ();
		public unowned GMime.Object get_body ();
		public unowned GMime.InternetAddressList get_cc ();
		public GLib.DateTime get_date ();
		public unowned GMime.InternetAddressList get_from ();
		public unowned string get_message_id ();
		public unowned GMime.Object? get_mime_part ();
		public unowned GMime.InternetAddressList get_reply_to ();
		public unowned GMime.InternetAddressList get_sender ();
		public unowned string get_subject ();
		public unowned GMime.InternetAddressList get_to ();
		public GMime.Message? partial_split_message (size_t max_size, out size_t nparts);
		public void set_date (GLib.DateTime date);
		public void set_message_id (string message_id);
		public void set_mime_part (GMime.Object mime_part);
		public void set_subject (string subject, string charset);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_message_part_get_type ()")]
	public class MessagePart : GMime.Object {
		public weak GMime.Message message;
		[CCode (has_construct_function = false)]
		public MessagePart (string subtype);
		public unowned GMime.Message get_message ();
		public void set_message (GMime.Message message);
		[CCode (has_construct_function = false)]
		public MessagePart.with_message (string subtype, GMime.Message message);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_message_partial_get_type ()")]
	public class MessagePartial : GMime.Part {
		public weak string id;
		public int number;
		public int total;
		[CCode (has_construct_function = false)]
		public MessagePartial (string id, int number, int total);
		public unowned string get_id ();
		public int get_number ();
		public int get_total ();
		public static GMime.Message reconstruct_message (GMime.MessagePartial partials, size_t num);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_multipart_get_type ()")]
	public class Multipart : GMime.Object {
		public weak string boundary;
		public weak GLib.GenericArray<void*> children;
		public weak string epilogue;
		public weak string prologue;
		[CCode (has_construct_function = false)]
		public Multipart ();
		public virtual void add (GMime.Object part);
		public virtual void clear ();
		public virtual bool contains (GMime.Object part);
		public void @foreach (GMime.ObjectForeachFunc callback);
		public virtual unowned string get_boundary ();
		public virtual int get_count ();
		public unowned string get_epilogue ();
		public virtual unowned GMime.Object get_part (int index);
		public unowned string get_prologue ();
		public unowned GMime.Object get_subpart_from_content_id (string content_id);
		public virtual int index_of (GMime.Object part);
		public virtual void insert (int index, GMime.Object part);
		public virtual bool remove (GMime.Object part);
		public virtual GMime.Object remove_at (int index);
		public GMime.Object replace (int index, GMime.Object replacement);
		public virtual void set_boundary (string boundary);
		public void set_epilogue (string epilogue);
		public void set_prologue (string prologue);
		[CCode (has_construct_function = false)]
		public Multipart.with_subtype (string subtype);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_multipart_encrypted_get_type ()")]
	public class MultipartEncrypted : GMime.Multipart {
		[CCode (has_construct_function = false)]
		public MultipartEncrypted ();
		public GMime.Object? decrypt (GMime.DecryptFlags flags, string session_key, out GMime.DecryptResult result) throws GLib.Error;
		public static GMime.MultipartEncrypted? encrypt (GMime.CryptoContext ctx, GMime.Object entity, bool sign, string? userid, GMime.EncryptFlags flags, GLib.GenericArray<string> recipients) throws GLib.Error;
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_multipart_signed_get_type ()")]
	public class MultipartSigned : GMime.Multipart {
		[CCode (has_construct_function = false)]
		public MultipartSigned ();
		public static GMime.MultipartSigned? sign (GMime.CryptoContext ctx, GMime.Object entity, string userid) throws GLib.Error;
		public GMime.SignatureList? verify (GMime.VerifyFlags flags) throws GLib.Error;
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_object_get_type ()")]
	public abstract class Object : GLib.Object {
		public weak string content_id;
		public weak GMime.ContentType content_type;
		public weak GMime.ContentDisposition disposition;
		public weak GMime.HeaderList headers;
		[CCode (has_construct_function = false)]
		protected Object ();
		public void append_header (string header, string value, string charset);
		public virtual void encode (GMime.EncodingConstraint constraint);
		public unowned GMime.ContentDisposition get_content_disposition ();
		public unowned string get_content_disposition_parameter (string name);
		public unowned string get_content_id ();
		public unowned GMime.ContentType get_content_type ();
		public unowned string? get_content_type_parameter (string name);
		public unowned string get_disposition ();
		public unowned string get_header (string header);
		public unowned GMime.HeaderList get_header_list ();
		public virtual string get_headers (GMime.FormatOptions? options);
		[NoWrapper]
		public virtual void header_added (GMime.Header header);
		[NoWrapper]
		public virtual void header_changed (GMime.Header header);
		[NoWrapper]
		public virtual void header_removed (GMime.Header header);
		[NoWrapper]
		public virtual void headers_cleared ();
		[CCode (cname = "g_mime_object_new")]
		public static GMime.Object new_for_type (GMime.ParserOptions? options, GMime.ContentType content_type);
		[CCode (cname = "g_mime_object_new_type")]
		public static GMime.Object new_for_type_str (GMime.ParserOptions? options, string type, string subtype);
		public void prepend_header (string header, string value, string charset);
		public static void register_type (string type, string subtype, GLib.Type object_type);
		public bool remove_header (string header);
		public void set_content_disposition (GMime.ContentDisposition disposition);
		public void set_content_disposition_parameter (string name, string value);
		public void set_content_id (string content_id);
		public virtual void set_content_type (GMime.ContentType content_type);
		public void set_content_type_parameter (string name, string value);
		public void set_disposition (string disposition);
		public void set_header (string header, string value, string charset);
		public string to_string (GMime.FormatOptions? options);
		public static void type_registry_init ();
		public static void type_registry_shutdown ();
		public ssize_t write_to_stream (GMime.FormatOptions? options, GMime.Stream stream);
		[CCode (vfunc_name = "write_to_stream")]
		[NoWrapper]
		public virtual ssize_t write_to_stream_vfunc (GMime.FormatOptions options, bool content_only, GMime.Stream stream);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_param_get_type ()")]
	public class Param : GLib.Object {
		public weak string charset;
		public weak string lang;
		public GMime.ParamEncodingMethod method;
		public weak string name;
		public weak string value;
		[CCode (has_construct_function = false)]
		protected Param ();
		public unowned string get_charset ();
		public GMime.ParamEncodingMethod get_encoding_method ();
		public unowned string get_lang ();
		public unowned string get_name ();
		public unowned string get_value ();
		public void set_charset (string charset);
		public void set_encoding_method (GMime.ParamEncodingMethod method);
		public void set_lang (string lang);
		public void set_value (string value);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_param_list_get_type ()")]
	public class ParamList : GLib.Object {
		[CCode (has_construct_function = false)]
		public ParamList ();
		public void clear ();
		public void encode (GMime.FormatOptions options, bool fold, GLib.StringBuilder str);
		public unowned GMime.Param get_parameter (string name);
		public unowned GMime.Param get_parameter_at (int index);
		public int length ();
		public static GMime.ParamList parse (GMime.ParserOptions options, string str);
		public bool remove (string name);
		public bool remove_at (int index);
		public void set_parameter (string name, string value);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_parser_get_type ()")]
	public class Parser : GLib.Object {
		[CCode (has_construct_function = false)]
		public Parser ();
		public GMime.Message? construct_message (GMime.ParserOptions? options);
		public GMime.Object? construct_part (GMime.ParserOptions? options);
		public bool eos ();
		public GMime.Format get_format ();
		public int64 get_headers_begin ();
		public int64 get_headers_end ();
		public string? get_mbox_marker ();
		public int64 get_mbox_marker_offset ();
		public bool get_persist_stream ();
		public bool get_respect_content_length ();
		public void init_with_stream (GMime.Stream stream);
		public void set_format (GMime.Format format);
		public void set_persist_stream (bool persist);
		public void set_respect_content_length (bool respect_content_length);
		public int64 tell ();
		[CCode (has_construct_function = false)]
		public Parser.with_stream (GMime.Stream stream);
	}
	[CCode (cheader_filename = "gmime/gmime.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "g_mime_parser_options_get_type ()")]
	[Compact]
	public class ParserOptions {
		[CCode (has_construct_function = false)]
		public ParserOptions ();
		public GMime.ParserOptions clone ();
		public void free ();
		public GMime.RfcComplianceMode get_address_compliance_mode ();
		public bool get_allow_addresses_without_domain ();
		public static GMime.ParserOptions get_default ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_fallback_charsets ();
		public GMime.RfcComplianceMode get_parameter_compliance_mode ();
		public GMime.RfcComplianceMode get_rfc2047_compliance_mode ();
		public void set_address_compliance_mode (GMime.RfcComplianceMode mode);
		public void set_allow_addresses_without_domain (bool allow);
		public void set_fallback_charsets (string charsets);
		public void set_parameter_compliance_mode (GMime.RfcComplianceMode mode);
		public void set_rfc2047_compliance_mode (GMime.RfcComplianceMode mode);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_part_get_type ()")]
	public class Part : GMime.Object {
		public weak GMime.DataWrapper content;
		public weak string content_description;
		public weak string content_location;
		public weak string content_md5;
		public GMime.ContentEncoding encoding;
		public GMime.OpenPGPData openpgp;
		[CCode (has_construct_function = false)]
		public Part ();
		public GMime.ContentEncoding get_best_content_encoding (GMime.EncodingConstraint constraint);
		public unowned GMime.DataWrapper get_content ();
		public unowned string get_content_description ();
		public GMime.ContentEncoding get_content_encoding ();
		public unowned string get_content_id ();
		public unowned string get_content_location ();
		public unowned string get_content_md5 ();
		public unowned string get_filename ();
		public GMime.OpenPGPData get_openpgp_data ();
		public bool is_attachment ();
		public GMime.DecryptResult? openpgp_decrypt (GMime.DecryptFlags flags, string? session_key) throws GLib.Error;
		public bool openpgp_encrypt (bool sign, string? userid, GMime.EncryptFlags flags, GLib.GenericArray<string> recipients) throws GLib.Error;
		public bool openpgp_sign (string userid) throws GLib.Error;
		public GMime.SignatureList? openpgp_verify (GMime.VerifyFlags flags) throws GLib.Error;
		public virtual void set_content (GMime.DataWrapper content);
		public void set_content_description (string description);
		public void set_content_encoding (GMime.ContentEncoding encoding);
		public void set_content_id (string content_id);
		public void set_content_location (string content_location);
		public void set_content_md5 (string content_md5);
		public void set_filename (string filename);
		public void set_openpgp_data (GMime.OpenPGPData data);
		public bool verify_content_md5 ();
		[CCode (has_construct_function = false)]
		public Part.with_type (string type, string subtype);
	}
	[CCode (cheader_filename = "gmime/gmime.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "g_mime_part_iter_get_type ()")]
	[Compact]
	public class PartIter {
		[CCode (has_construct_function = false)]
		public PartIter (GMime.Object toplevel);
		public GMime.PartIter clone ();
		public void free ();
		public unowned GMime.Object get_current ();
		public unowned GMime.Object get_parent ();
		public string get_path ();
		public unowned GMime.Object get_toplevel ();
		public bool is_valid ();
		public bool jump_to (string path);
		public bool next ();
		public bool prev ();
		public bool remove ();
		public bool replace (GMime.Object replacement);
		public void reset ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_pkcs7_context_get_type ()")]
	public class Pkcs7Context : GMime.CryptoContext {
		[CCode (has_construct_function = false, type = "GMimeCryptoContext*")]
		public Pkcs7Context ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "g_mime_references_get_type ()")]
	[Compact]
	public class References {
		public weak GLib.GenericArray<void*> array;
		[CCode (has_construct_function = false)]
		public References ();
		public void append (string msgid);
		public void clear ();
		public GMime.References copy ();
		public void free ();
		public unowned string get_message_id (int index);
		public int length ();
		public static GMime.References parse (GMime.ParserOptions? options, string text);
		public void set_message_id (int index, string msgid);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_signature_get_type ()")]
	public class Signature : GLib.Object {
		public weak GMime.Certificate cert;
		public long created;
		public long expires;
		public GMime.SignatureStatus status;
		[CCode (has_construct_function = false)]
		public Signature ();
		public unowned GMime.Certificate get_certificate ();
		public long get_created ();
		public int64 get_created64 ();
		public long get_expires ();
		public int64 get_expires64 ();
		public GMime.SignatureStatus get_status ();
		public void set_certificate (GMime.Certificate cert);
		public void set_created (long created);
		public void set_expires (long expires);
		public void set_status (GMime.SignatureStatus status);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_signature_list_get_type ()")]
	public class SignatureList : GLib.Object {
		[CCode (has_construct_function = false)]
		public SignatureList ();
		public int add (GMime.Signature sig);
		public void clear ();
		public bool contains (GMime.Signature sig);
		public unowned GMime.Signature get_signature (int index);
		public int index_of (GMime.Signature sig);
		public void insert (int index, GMime.Signature sig);
		public int length ();
		public bool remove (GMime.Signature sig);
		public bool remove_at (int index);
		public void set_signature (int index, GMime.Signature sig);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_get_type ()")]
	public abstract class Stream : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Stream ();
		public ssize_t buffer_gets (string buf, size_t max);
		public void buffer_readln (GLib.ByteArray buffer);
		public virtual int close ();
		public void @construct (int64 start, int64 end);
		public virtual bool eos ();
		public virtual int flush ();
		public virtual int64 length ();
		public virtual ssize_t read ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buf);
		public virtual int reset ();
		public virtual int64 seek (int64 offset, GMime.SeekWhence whence);
		public void set_bounds (int64 start, int64 end);
		public virtual GMime.Stream substream (int64 start, int64 end);
		public virtual int64 tell ();
		public virtual ssize_t write (string buf, size_t len);
		public ssize_t write_string (string str);
		public int64 write_to_stream (GMime.Stream dest);
		public int64 writev (GMime.StreamIOVector vector, size_t count);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_buffer_get_type ()")]
	public class StreamBuffer : GMime.Stream {
		public weak string bufend;
		public weak string buffer;
		public size_t buflen;
		public weak string bufptr;
		public GMime.StreamBufferMode mode;
		public weak GMime.Stream source;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamBuffer (GMime.Stream source, GMime.StreamBufferMode mode);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_cat_get_type ()")]
	public class StreamCat : GMime.Stream {
		public void* current;
		public void* sources;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamCat ();
		public int add_source (GMime.Stream source);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_file_get_type ()")]
	public class StreamFile : GMime.Stream {
		public void* fp;
		public bool owner;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamFile (void* fp);
		public bool get_owner ();
		public static GMime.Stream open (string path, string mode) throws GLib.Error;
		public void set_owner (bool owner);
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamFile.with_bounds (void* fp, int64 start, int64 end);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_filter_get_type ()")]
	public class StreamFilter : GMime.Stream {
		public bool owner;
		public weak GMime.Stream source;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamFilter (GMime.Stream stream);
		public int add (GMime.Filter filter);
		public bool get_owner ();
		public void remove (int id);
		public void set_owner (bool owner);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_fs_get_type ()")]
	public class StreamFs : GMime.Stream {
		public bool eos;
		public int fd;
		public bool owner;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamFs (int fd);
		public bool get_owner ();
		public static GMime.Stream open (string path, int flags, int mode) throws GLib.Error;
		public void set_owner (bool owner);
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamFs.with_bounds (int fd, int64 start, int64 end);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_gio_get_type ()")]
	public class StreamGIO : GMime.Stream {
		public bool eos;
		public weak GLib.File file;
		public weak GLib.InputStream istream;
		public weak GLib.OutputStream ostream;
		public bool owner;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamGIO (GLib.File file);
		public bool get_owner ();
		public void set_owner (bool owner);
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamGIO.with_bounds (GLib.File file, int64 start, int64 end);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_mem_get_type ()")]
	public class StreamMem : GMime.Stream {
		public weak GLib.ByteArray buffer;
		public bool owner;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamMem ();
		public unowned GLib.ByteArray get_byte_array ();
		public bool get_owner ();
		public void set_byte_array (GLib.ByteArray array);
		public void set_owner (bool owner);
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamMem.with_buffer ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buffer);
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamMem.with_byte_array (GLib.ByteArray array);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_mmap_get_type ()")]
	public class StreamMmap : GMime.Stream {
		public bool eos;
		public int fd;
		public weak string map;
		public size_t maplen;
		public bool owner;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamMmap (int fd, int prot, int flags);
		[Version (since = "3.2")]
		public bool get_owner ();
		[Version (since = "3.2")]
		public void set_owner (bool owner);
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamMmap.with_bounds (int fd, int prot, int flags, int64 start, int64 end);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_null_get_type ()")]
	public class StreamNull : GMime.Stream {
		public bool count_newlines;
		public size_t newlines;
		public size_t written;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamNull ();
		public bool get_count_newlines ();
		public void set_count_newlines (bool count);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_stream_pipe_get_type ()")]
	public class StreamPipe : GMime.Stream {
		public bool eos;
		public int fd;
		public bool owner;
		[CCode (has_construct_function = false, type = "GMimeStream*")]
		public StreamPipe (int fd);
		public bool get_owner ();
		public void set_owner (bool owner);
	}
	[CCode (cheader_filename = "gmime/gmime.h", type_id = "g_mime_text_part_get_type ()")]
	public class TextPart : GMime.Part {
		[CCode (has_construct_function = false)]
		public TextPart ();
		public unowned string get_charset ();
		public string get_text ();
		public void set_charset (string charset);
		public void set_text (string text);
		[CCode (has_construct_function = false)]
		public TextPart.with_subtype (string subtype);
	}
	[CCode (cheader_filename = "gmime/gmime.h", has_type_id = false)]
	public struct Charset {
		public uint mask;
		public uint level;
		public static unowned string? best (string inbuf, size_t inlen);
		public unowned string? best_name ();
		public bool can_encode (string charset, string text, size_t len);
		public static unowned string canon_name (string charset);
		public static unowned string iconv_name (string charset);
		public void init ();
		public static unowned string iso_to_windows (string isocharset);
		public static unowned string? language (string charset);
		public static unowned string locale_name ();
		public static void map_init ();
		public static void map_shutdown ();
		public static unowned string name (string charset);
		public void step (string inbuf, size_t inlen);
	}
	[CCode (cheader_filename = "gmime/gmime.h", has_type_id = false)]
	public struct Encoding {
		public GMime.ContentEncoding encoding;
		[CCode (array_length = false)]
		public weak uint8 uubuf[60];
		public bool encode;
		public uint32 save;
		public int state;
		public static size_t base64_decode_step (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 save);
		public static size_t base64_encode_close (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 save);
		public static size_t base64_encode_step (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 save);
		public size_t flush (string inbuf, size_t inlen, string outbuf);
		public void init_decode (GMime.ContentEncoding encoding);
		public void init_encode (GMime.ContentEncoding encoding);
		public size_t outlen (size_t inlen);
		public static size_t quoted_decode_step (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 save);
		public static size_t quoted_encode_close (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 save);
		public static size_t quoted_encode_step (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 save);
		public void reset ();
		public size_t step (string inbuf, size_t inlen, string outbuf);
		public static size_t uudecode_step (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 save);
		public static size_t uuencode_close (uint8 inbuf, size_t inlen, uint8 outbuf, uint8 uubuf, int state, uint32 save);
		public static size_t uuencode_step (uint8 inbuf, size_t inlen, uint8 outbuf, uint8 uubuf, int state, uint32 save);
	}
	[CCode (cheader_filename = "gmime/gmime.h", has_type_id = false)]
	[Version (since = "3.2")]
	public struct OpenPGPMarker {
		public weak string marker;
		public size_t len;
		public GMime.OpenPGPState before;
		public GMime.OpenPGPState after;
		public bool is_end_marker;
	}
	[CCode (cheader_filename = "gmime/gmime.h", has_type_id = false)]
	public struct StreamIOVector {
		public void* data;
		public size_t len;
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_ADDRESS_TYPE_", has_type_id = false)]
	public enum AddressType {
		SENDER,
		FROM,
		REPLY_TO,
		TO,
		CC,
		BCC
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_AUTOCRYPT_PREFER_ENCRYPT_", has_type_id = false)]
	public enum AutocryptPreferEncrypt {
		NONE,
		MUTUAL
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_CIPHER_ALGO_", has_type_id = false)]
	public enum CipherAlgo {
		DEFAULT,
		IDEA,
		@3DES,
		CAST5,
		BLOWFISH,
		AES,
		AES192,
		AES256,
		TWOFISH,
		CAMELLIA128,
		CAMELLIA192,
		CAMELLIA256
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_CONTENT_ENCODING_", has_type_id = false)]
	public enum ContentEncoding {
		DEFAULT,
		@7BIT,
		@8BIT,
		BINARY,
		BASE64,
		QUOTEDPRINTABLE,
		UUENCODE;
		public static GMime.ContentEncoding from_string (string str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_DECRYPT_", has_type_id = false)]
	[Flags]
	public enum DecryptFlags {
		NONE,
		EXPORT_SESSION_KEY,
		NO_VERIFY,
		ENABLE_KEYSERVER_LOOKUPS,
		ENABLE_ONLINE_CERTIFICATE_CHECKS
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_DIGEST_ALGO_", has_type_id = false)]
	public enum DigestAlgo {
		DEFAULT,
		MD5,
		SHA1,
		RIPEMD160,
		MD2,
		TIGER192,
		HAVAL5160,
		SHA256,
		SHA384,
		SHA512,
		SHA224,
		MD4,
		CRC32,
		CRC32_RFC1510,
		CRC32_RFC2440
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_ENCODING_CONSTRAINT_", has_type_id = false)]
	public enum EncodingConstraint {
		@7BIT,
		@8BIT,
		BINARY
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_ENCRYPT_", has_type_id = false)]
	public enum EncryptFlags {
		NONE,
		ALWAYS_TRUST,
		NO_COMPRESS,
		SYMMETRIC,
		THROW_KEYIDS
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_FILTER_BEST_", has_type_id = false)]
	[Flags]
	public enum FilterBestFlags {
		CHARSET,
		ENCODING
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_FILTER_FROM_MODE_", has_type_id = false)]
	public enum FilterFromMode {
		DEFAULT,
		ESCAPE,
		ARMOR
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_FILTER_GZIP_MODE_", has_type_id = false)]
	public enum FilterGZipMode {
		ZIP,
		UNZIP
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_FORMAT_", has_type_id = false)]
	public enum Format {
		MESSAGE,
		MBOX,
		MMDF
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_NEWLINE_FORMAT_", has_type_id = false)]
	public enum NewLineFormat {
		UNIX,
		DOS
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_OPENPGP_DATA_", has_type_id = false)]
	public enum OpenPGPData {
		NONE,
		ENCRYPTED,
		SIGNED,
		PUBLIC_KEY,
		PRIVATE_KEY
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_OPENPGP_", has_type_id = false)]
	[Flags]
	[Version (since = "3.2")]
	public enum OpenPGPState {
		NONE,
		BEGIN_PGP_MESSAGE,
		END_PGP_MESSAGE,
		BEGIN_PGP_SIGNED_MESSAGE,
		BEGIN_PGP_SIGNATURE,
		END_PGP_SIGNATURE,
		BEGIN_PGP_PUBLIC_KEY_BLOCK,
		END_PGP_PUBLIC_KEY_BLOCK,
		BEGIN_PGP_PRIVATE_KEY_BLOCK,
		END_PGP_PRIVATE_KEY_BLOCK
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_PARAM_ENCODING_METHOD_", has_type_id = false)]
	public enum ParamEncodingMethod {
		DEFAULT,
		RFC2231,
		RFC2047
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_", has_type_id = false)]
	public enum ParserWarning {
		WARN_DUPLICATED_HEADER,
		WARN_DUPLICATED_PARAMETER,
		WARN_UNENCODED_8BIT_HEADER,
		WARN_INVALID_CONTENT_TYPE,
		WARN_INVALID_RFC2047_HEADER_VALUE,
		WARN_MALFORMED_MULTIPART,
		WARN_TRUNCATED_MESSAGE,
		WARN_MALFORMED_MESSAGE,
		CRIT_INVALID_HEADER_NAME,
		CRIT_CONFLICTING_HEADER,
		CRIT_CONFLICTING_PARAMETER,
		CRIT_MULTIPART_WITHOUT_BOUNDARY,
		WARN_INVALID_PARAMETER,
		WARN_INVALID_ADDRESS_LIST,
		CRIT_NESTING_OVERFLOW
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_PUBKEY_ALGO_", has_type_id = false)]
	public enum PubKeyAlgo {
		DEFAULT,
		RSA,
		RSA_E,
		RSA_S,
		ELG_E,
		DSA,
		ECC,
		ELG,
		ECDSA,
		ECDH,
		EDDSA
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_RFC_COMPLIANCE_", has_type_id = false)]
	public enum RfcComplianceMode {
		LOOSE,
		STRICT
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_SECURE_MIME_TYPE_", has_type_id = false)]
	public enum SecureMimeType {
		COMPRESSED_DATA,
		ENVELOPED_DATA,
		SIGNED_DATA,
		CERTS_ONLY,
		UNKNOWN
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_STREAM_SEEK_", has_type_id = false)]
	public enum SeekWhence {
		SET,
		CUR,
		END
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_SIGNATURE_STATUS_", has_type_id = false)]
	public enum SignatureStatus {
		VALID,
		GREEN,
		RED,
		KEY_REVOKED,
		KEY_EXPIRED,
		SIG_EXPIRED,
		KEY_MISSING,
		CRL_MISSING,
		CRL_TOO_OLD,
		BAD_POLICY,
		SYS_ERROR,
		TOFU_CONFLICT
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_STREAM_BUFFER_BLOCK_", has_type_id = false)]
	public enum StreamBufferMode {
		READ,
		WRITE
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_TRUST_", has_type_id = false)]
	public enum Trust {
		UNKNOWN,
		UNDEFINED,
		NEVER,
		MARGINAL,
		FULL,
		ULTIMATE
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_VALIDITY_", has_type_id = false)]
	public enum Validity {
		UNKNOWN,
		UNDEFINED,
		NEVER,
		MARGINAL,
		FULL,
		ULTIMATE
	}
	[CCode (cheader_filename = "gmime/gmime.h", cprefix = "GMIME_VERIFY_", has_type_id = false)]
	[Flags]
	public enum VerifyFlags {
		NONE,
		ENABLE_KEYSERVER_LOOKUPS,
		ENABLE_ONLINE_CERTIFICATE_CHECKS
	}
	[CCode (cheader_filename = "gmime/gmime.h", has_target = false)]
	public delegate string HeaderRawValueFormatter (GMime.Header header, GMime.FormatOptions options, string value, string charset);
	[CCode (cheader_filename = "gmime/gmime.h", instance_pos = 2.9)]
	public delegate void ObjectForeachFunc (GMime.Object parent, GMime.Object part);
	[CCode (cheader_filename = "gmime/gmime.h", instance_pos = 4.9)]
	public delegate void ParserHeaderRegexFunc (GMime.Parser parser, string header, string value, int64 offset);
	[CCode (cheader_filename = "gmime/gmime.h", instance_pos = 3.9)]
	public delegate void ParserWarningFunc (int64 offset, GMime.ParserWarning errcode, string item);
	[CCode (cheader_filename = "gmime/gmime.h", has_target = false)]
	public delegate bool PasswordRequestFunc (GMime.CryptoContext ctx, string user_id, string prompt, bool reprompt, GMime.Stream response) throws GLib.Error;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_BINARY_AGE")]
	public const int BINARY_AGE;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_DISPOSITION_ATTACHMENT")]
	public const string DISPOSITION_ATTACHMENT;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_DISPOSITION_INLINE")]
	public const string DISPOSITION_INLINE;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_ENRICHED_IS_RICHTEXT")]
	public const int FILTER_ENRICHED_IS_RICHTEXT;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_BLOCKQUOTE_CITATION")]
	public const int FILTER_HTML_BLOCKQUOTE_CITATION;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_CITE")]
	public const int FILTER_HTML_CITE;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_CONVERT_ADDRESSES")]
	public const int FILTER_HTML_CONVERT_ADDRESSES;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_CONVERT_NL")]
	public const int FILTER_HTML_CONVERT_NL;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_CONVERT_SPACES")]
	public const int FILTER_HTML_CONVERT_SPACES;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_CONVERT_URLS")]
	public const int FILTER_HTML_CONVERT_URLS;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_ESCAPE_8BIT")]
	public const int FILTER_HTML_ESCAPE_8BIT;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_MARK_CITATION")]
	public const int FILTER_HTML_MARK_CITATION;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_FILTER_HTML_PRE")]
	public const int FILTER_HTML_PRE;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_INTERFACE_AGE")]
	public const int INTERFACE_AGE;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_SIGNATURE_STATUS_ERROR_MASK")]
	public const int SIGNATURE_STATUS_ERROR_MASK;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_UUDECODE_STATE_BEGIN")]
	public const int UUDECODE_STATE_BEGIN;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_UUDECODE_STATE_END")]
	public const int UUDECODE_STATE_END;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_UUDECODE_STATE_INIT")]
	public const int UUDECODE_STATE_INIT;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_UUDECODE_STATE_MASK")]
	public const int UUDECODE_STATE_MASK;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YDECODE_STATE_BEGIN")]
	public const int YDECODE_STATE_BEGIN;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YDECODE_STATE_DECODE")]
	public const int YDECODE_STATE_DECODE;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YDECODE_STATE_END")]
	public const int YDECODE_STATE_END;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YDECODE_STATE_EOLN")]
	public const int YDECODE_STATE_EOLN;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YDECODE_STATE_ESCAPE")]
	public const int YDECODE_STATE_ESCAPE;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YDECODE_STATE_INIT")]
	public const int YDECODE_STATE_INIT;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YDECODE_STATE_PART")]
	public const int YDECODE_STATE_PART;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YENCODE_CRC_INIT")]
	public const int YENCODE_CRC_INIT;
	[CCode (cheader_filename = "gmime/gmime.h", cname = "GMIME_YENCODE_STATE_INIT")]
	public const int YENCODE_STATE_INIT;
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static bool check_version (uint major, uint minor, uint micro);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string iconv_locale_to_utf8 (string str);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string iconv_locale_to_utf8_length (string str, size_t n);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string iconv_utf8_to_locale (string str);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string iconv_utf8_to_locale_length (string str, size_t n);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static void init ();
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static unowned string locale_charset ();
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static unowned string? locale_language ();
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static void shutdown ();
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static GMime.ContentEncoding utils_best_encoding ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] text);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_decode_8bit (GMime.ParserOptions? options, [CCode (array_length_cname = "len", array_length_pos = 2.1, array_length_type = "gsize")] uint8[] text);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_decode_message_id (string message_id);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_generate_message_id (string fqdn);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static GLib.DateTime? utils_header_decode_date (string str);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_header_decode_phrase (GMime.ParserOptions? options, string phrase);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_header_decode_text (GMime.ParserOptions? options, string text);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_header_encode_phrase (GMime.FormatOptions? options, string phrase, string? charset);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_header_encode_text (GMime.FormatOptions? options, string text, string? charset);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_header_format_date (GLib.DateTime date);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_header_unfold (string value);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_quote_string (string str);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_structured_header_fold (GMime.ParserOptions? options, GMime.FormatOptions? format, string header);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static bool utils_text_is_8bit ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] text);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static void utils_unquote_string (string str);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static string utils_unstructured_header_fold (GMime.ParserOptions? options, GMime.FormatOptions? format, string header);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static size_t ydecode_step (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 pcrc, uint32 crc);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static size_t yencode_close (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 pcrc, uint32 crc);
	[CCode (cheader_filename = "gmime/gmime.h")]
	public static size_t yencode_step (uint8 inbuf, size_t inlen, uint8 outbuf, int state, uint32 pcrc, uint32 crc);
}
