/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.tasks.properties.DefaultInputPropertySpec;
import org.gradle.api.internal.tasks.properties.InputParameterUtils;
import org.gradle.api.internal.tasks.properties.InputPropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;

public class GetInputPropertiesVisitor
extends PropertyVisitor.Adapter {
    private final String beanName;
    private List<InputPropertySpec> inputProperties = new ArrayList<InputPropertySpec>();

    public GetInputPropertiesVisitor(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
        DefaultInputPropertySpec spec = new DefaultInputPropertySpec(propertyName, value);
        this.inputProperties.add(spec);
    }

    public Supplier<Map<String, Object>> getPropertyValuesSupplier() {
        return () -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (InputPropertySpec inputProperty : this.inputProperties) {
                String propertyName = inputProperty.getPropertyName();
                try {
                    Object value = InputParameterUtils.prepareInputParameterValue(inputProperty.getValue());
                    result.put(propertyName, value);
                }
                catch (Exception ex) {
                    throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, this.beanName), (Throwable)ex);
                }
            }
            return result;
        };
    }
}

