/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.IDexNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeGen {
    private static final Logger LOG = LoggerFactory.getLogger(TypeGen.class);

    private TypeGen() {
    }

    public static String signature(ArgType type) {
        PrimitiveType stype = type.getPrimitiveType();
        if (stype == PrimitiveType.OBJECT) {
            return Utils.makeQualifiedObjectName(type.getObject());
        }
        if (stype == PrimitiveType.ARRAY) {
            return '[' + TypeGen.signature(type.getArrayElement());
        }
        return stype.getShortName();
    }

    public static String literalToString(LiteralArg arg, IDexNode dexNode, boolean fallback) {
        return TypeGen.literalToString(arg.getLiteral(), arg.getType(), dexNode.root().getStringUtils(), fallback, arg.contains(AFlag.EXPLICIT_PRIMITIVE_TYPE));
    }

    public static String literalToString(long lit, ArgType type, IDexNode dexNode, boolean fallback) {
        return TypeGen.literalToString(lit, type, dexNode.root().getStringUtils(), fallback, false);
    }

    public static String literalToString(long lit, ArgType type, StringUtils stringUtils, boolean fallback, boolean cast) {
        if (type == null || !type.isTypeKnown()) {
            String n = Long.toString(lit);
            if (fallback && Math.abs(lit) > 100L) {
                StringBuilder sb = new StringBuilder();
                sb.append(n).append("(0x").append(Long.toHexString(lit));
                if (type == null || type.contains(PrimitiveType.FLOAT)) {
                    sb.append(", float:").append(Float.intBitsToFloat((int)lit));
                }
                if (type == null || type.contains(PrimitiveType.DOUBLE)) {
                    sb.append(", double:").append(Double.longBitsToDouble(lit));
                }
                sb.append(')');
                return sb.toString();
            }
            return n;
        }
        switch (type.getPrimitiveType()) {
            case BOOLEAN: {
                return lit == 0L ? "false" : "true";
            }
            case CHAR: {
                char ch = (char)lit;
                if (!NameMapper.isPrintableChar(ch)) {
                    return Integer.toString(ch);
                }
                return stringUtils.unescapeChar(ch);
            }
            case BYTE: {
                return TypeGen.formatByte(lit, cast);
            }
            case SHORT: {
                return TypeGen.formatShort(lit, cast);
            }
            case INT: {
                return TypeGen.formatInteger(lit, cast);
            }
            case LONG: {
                return TypeGen.formatLong(lit, cast);
            }
            case FLOAT: {
                return TypeGen.formatFloat(Float.intBitsToFloat((int)lit));
            }
            case DOUBLE: {
                return TypeGen.formatDouble(Double.longBitsToDouble(lit));
            }
            case OBJECT: 
            case ARRAY: {
                if (lit != 0L) {
                    LOG.warn("Wrong object literal: {} for type: {}", (Object)lit, (Object)type);
                    return Long.toString(lit);
                }
                return "null";
            }
        }
        throw new JadxRuntimeException("Unknown type in literalToString: " + type);
    }

    public static String formatShort(long l, boolean cast) {
        if (l == 32767L) {
            return "Short.MAX_VALUE";
        }
        if (l == -32768L) {
            return "Short.MIN_VALUE";
        }
        String str = Long.toString(l);
        return cast ? "(short) " + str : str;
    }

    public static String formatByte(long l, boolean cast) {
        if (l == 127L) {
            return "Byte.MAX_VALUE";
        }
        if (l == -128L) {
            return "Byte.MIN_VALUE";
        }
        String str = Long.toString(l);
        return cast ? "(byte) " + str : str;
    }

    public static String formatInteger(long l, boolean cast) {
        if (l == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (l == Integer.MIN_VALUE) {
            return "Integer.MIN_VALUE";
        }
        String str = Long.toString(l);
        return cast ? "(int) " + str : str;
    }

    public static String formatLong(long l, boolean cast) {
        if (l == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (l == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        String str = Long.toString(l);
        if (cast || Math.abs(l) >= Integer.MAX_VALUE) {
            return str + 'L';
        }
        return str;
    }

    public static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "Double.NaN";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "Double.NEGATIVE_INFINITY";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Double.POSITIVE_INFINITY";
        }
        if (d == Double.MIN_VALUE) {
            return "Double.MIN_VALUE";
        }
        if (d == Double.MAX_VALUE) {
            return "Double.MAX_VALUE";
        }
        if (d == Double.MIN_NORMAL) {
            return "Double.MIN_NORMAL";
        }
        return Double.toString(d) + 'd';
    }

    public static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "Float.NaN";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "Float.NEGATIVE_INFINITY";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Float.POSITIVE_INFINITY";
        }
        if (f == Float.MIN_VALUE) {
            return "Float.MIN_VALUE";
        }
        if (f == Float.MAX_VALUE) {
            return "Float.MAX_VALUE";
        }
        if (f == Float.MIN_NORMAL) {
            return "Float.MIN_NORMAL";
        }
        return Float.toString(f) + 'f';
    }
}

