/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.shrink;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.shrink.ArgsInfo;
import jadx.core.dex.visitors.shrink.WrapInfo;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnList;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

@JadxVisitor(name="CodeShrinkVisitor", desc="Inline variables for make code smaller", runAfter={ModVisitor.class})
public class CodeShrinkVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) {
        CodeShrinkVisitor.shrinkMethod(mth);
    }

    public static void shrinkMethod(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            CodeShrinkVisitor.shrinkBlock(mth, block);
            CodeShrinkVisitor.simplifyMoveInsns(block);
        }
    }

    private static void shrinkBlock(MethodNode mth, BlockNode block) {
        if (block.getInstructions().isEmpty()) {
            return;
        }
        InsnList insnList = new InsnList(block.getInstructions());
        int insnCount = insnList.size();
        ArrayList<ArgsInfo> argsList = new ArrayList<ArgsInfo>(insnCount);
        for (int i = 0; i < insnCount; ++i) {
            argsList.add(new ArgsInfo(insnList.get(i), argsList, i));
        }
        ArrayList<WrapInfo> wrapList = new ArrayList<WrapInfo>();
        for (ArgsInfo argsInfo : argsList) {
            List<RegisterArg> args = argsInfo.getArgs();
            if (args.isEmpty()) continue;
            ListIterator<RegisterArg> it = args.listIterator(args.size());
            while (it.hasPrevious()) {
                RegisterArg arg = it.previous();
                CodeShrinkVisitor.checkInline(mth, block, insnList, wrapList, argsInfo, arg);
            }
        }
        if (!wrapList.isEmpty()) {
            for (WrapInfo wrapInfo : wrapList) {
                CodeShrinkVisitor.inline(mth, wrapInfo.getArg(), wrapInfo.getInsn(), block);
            }
        }
    }

    private static void checkInline(MethodNode mth, BlockNode block, InsnList insnList, List<WrapInfo> wrapList, ArgsInfo argsInfo, RegisterArg arg) {
        InsnNode parentInsn;
        SSAVar sVar = arg.getSVar();
        if (sVar == null || sVar.getAssign().contains(AFlag.DONT_INLINE)) {
            return;
        }
        InsnNode assignInsn = sVar.getAssign().getParentInsn();
        if (assignInsn == null || assignInsn.contains(AFlag.DONT_INLINE) || assignInsn.contains(AFlag.WRAPPED)) {
            return;
        }
        boolean assignInline = assignInsn.contains(AFlag.FORCE_ASSIGN_INLINE);
        if (!assignInline && sVar.getVariableUseCount() != 1) {
            return;
        }
        List<RegisterArg> useList = sVar.getUseList();
        if (!useList.isEmpty() && (parentInsn = useList.get(0).getParentInsn()) != null && parentInsn.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        int assignPos = insnList.getIndex(assignInsn);
        if (assignPos != -1) {
            if (assignInline) {
                return;
            }
            WrapInfo wrapInfo = argsInfo.checkInline(assignPos, arg);
            if (wrapInfo != null) {
                wrapList.add(wrapInfo);
            }
        } else {
            BlockNode assignBlock = BlockUtils.getBlockByInsn(mth, assignInsn);
            if (assignBlock != null && assignInsn != arg.getParentInsn() && CodeShrinkVisitor.canMoveBetweenBlocks(assignInsn, assignBlock, block, argsInfo.getInsn())) {
                if (assignInline) {
                    CodeShrinkVisitor.assignInline(mth, arg, assignInsn, assignBlock);
                } else {
                    CodeShrinkVisitor.inline(mth, arg, assignInsn, assignBlock);
                }
            }
        }
    }

    private static void assignInline(MethodNode mth, RegisterArg arg, InsnNode assignInsn, BlockNode assignBlock) {
        RegisterArg useArg = arg.getSVar().getUseList().get(0);
        InsnNode useInsn = useArg.getParentInsn();
        if (useInsn == null || useInsn.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        InsnArg replaceArg = InsnArg.wrapArg(assignInsn.copy());
        useInsn.replaceArg(useArg, replaceArg);
        assignInsn.add(AFlag.REMOVE);
        assignInsn.add(AFlag.DONT_GENERATE);
        InsnRemover.remove(mth, assignBlock, assignInsn);
    }

    private static boolean inline(MethodNode mth, RegisterArg arg, InsnNode insn, BlockNode block) {
        boolean replaced;
        InsnNode parentInsn = arg.getParentInsn();
        if (parentInsn != null && parentInsn.getType() == InsnType.RETURN) {
            parentInsn.setSourceLine(insn.getSourceLine());
        }
        boolean bl = replaced = arg.wrapInstruction(mth, insn) != null;
        if (replaced) {
            InsnList.remove(block, insn);
        }
        return replaced;
    }

    private static boolean canMoveBetweenBlocks(InsnNode assignInsn, BlockNode assignBlock, BlockNode useBlock, InsnNode useInsn) {
        if (!BlockUtils.isPathExists(assignBlock, useBlock)) {
            return false;
        }
        List<RegisterArg> argsList = ArgsInfo.getArgs(assignInsn);
        BitSet args = new BitSet();
        for (RegisterArg registerArg : argsList) {
            args.set(registerArg.getRegNum());
        }
        boolean startCheck = false;
        for (InsnNode insn : assignBlock.getInstructions()) {
            if (startCheck && (!insn.canReorder() || ArgsInfo.usedArgAssign(insn, args))) {
                return false;
            }
            if (insn != assignInsn) continue;
            startCheck = true;
        }
        Set<BlockNode> set = BlockUtils.getAllPathsBlocks(assignBlock, useBlock);
        set.remove(assignBlock);
        set.remove(useBlock);
        for (BlockNode block : set) {
            if (block.contains(AFlag.DONT_GENERATE)) {
                if (!BlockUtils.checkLastInsnType(block, InsnType.MONITOR_EXIT)) continue;
                return false;
            }
            for (InsnNode insn : block.getInstructions()) {
                if (insn.canReorder() && !ArgsInfo.usedArgAssign(insn, args)) continue;
                return false;
            }
        }
        for (InsnNode insn : useBlock.getInstructions()) {
            if (insn == useInsn) {
                return true;
            }
            if (insn.canReorder() && !ArgsInfo.usedArgAssign(insn, args)) continue;
            return false;
        }
        throw new JadxRuntimeException("Can't process instruction move : " + assignBlock);
    }

    private static void simplifyMoveInsns(BlockNode block) {
        List<InsnNode> insns = block.getInstructions();
        int size = insns.size();
        for (int i = 0; i < size; ++i) {
            InsnArg arg;
            InsnNode insn = insns.get(i);
            if (insn.getType() != InsnType.MOVE || !(arg = insn.getArg(0)).isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            wrapInsn.setResult(insn.getResult());
            wrapInsn.copyAttributesFrom(insn);
            wrapInsn.setOffset(insn.getOffset());
            wrapInsn.remove(AFlag.WRAPPED);
            block.getInstructions().set(i, wrapInsn);
        }
    }
}

