"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_specs_1 = require("./get_specs");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
var annotation_utils_1 = require("../../annotations/annotation_utils");
var compute_series_geometries_1 = require("./compute_series_geometries");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
exports.computeAnnotationDimensionsSelector = re_reselect_1.default([
    get_specs_1.getAnnotationSpecsSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    compute_series_geometries_1.computeSeriesGeometriesSelector,
    get_specs_1.getAxisSpecsSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
    get_specs_1.getAxisSpecsSelector,
], function (annotationSpecs, chartDimensions, settingsSpec, seriesGeometries, axesSpecs, totalBarsInCluster, isHistogramMode) {
    var _a = seriesGeometries.scales, yScales = _a.yScales, xScale = _a.xScale;
    return annotation_utils_1.computeAnnotationDimensions(annotationSpecs, chartDimensions.chartDimensions, settingsSpec.rotation, yScales, xScale, axesSpecs, totalBarsInCluster, isHistogramMode);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_annotations.js.map