"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndexPatternCache = createIndexPatternCache;

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function createIndexPatternCache() {
  var vals = {};
  var cache = {
    get: function get(id) {
      return vals[id];
    },
    set: function set(id, prom) {
      vals[id] = prom;
      return prom;
    },
    clear: function clear(id) {
      delete vals[id];
    },
    clearAll: function clearAll() {
      for (var _id in vals) {
        if (vals.hasOwnProperty(_id)) {
          delete vals[_id];
        }
      }
    }
  };
  return cache;
}