/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LayoutProcessState;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DefaultDocumentContext;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.style.resolver.DefaultStyleResolver;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractLayoutProcess
implements LayoutProcess {
    private InputFeed inputFeed;
    private DocumentContext documentContext;
    private OutputProcessor outputProcessor;
    private StyleResolver styleResolver;

    protected AbstractLayoutProcess(OutputProcessor outputProcessor) {
        if (outputProcessor == null) {
            throw new NullPointerException();
        }
        this.outputProcessor = outputProcessor;
        this.documentContext = new DefaultDocumentContext();
        this.styleResolver = new DefaultStyleResolver();
    }

    @Override
    public OutputProcessorMetaData getOutputMetaData() {
        return this.outputProcessor.getMetaData();
    }

    @Override
    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    @Override
    public InputFeed getInputFeed() {
        if (this.inputFeed == null) {
            this.inputFeed = this.getOutputProcessor().createInputFeed(this);
        }
        return this.inputFeed;
    }

    protected abstract InputFeed createInputFeed();

    @Override
    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.documentContext.getResourceManager();
    }

    @Override
    public void pageBreakEncountered(CSSValue cSSValue, PseudoPage[] pseudoPageArray) throws NormalizationException {
        this.getInputFeed().handlePageBreakEncountered(cSSValue, pseudoPageArray);
    }

    @Override
    public boolean isPagebreakEncountered() {
        return this.getInputFeed().isPagebreakEncountered();
    }

    @Override
    public Normalizer getNormalizer() {
        return this.getInputFeed().getCurrentNormalizer();
    }

    @Override
    public StyleResolver getStyleResolver() {
        return this.styleResolver;
    }

    protected static abstract class AbstractLayoutProcessState
    implements LayoutProcessState {
        private State inputFeedState;
        private DocumentContext documentContext;
        private State styleResolver;

        protected AbstractLayoutProcessState(AbstractLayoutProcess abstractLayoutProcess) throws StateException {
            if (abstractLayoutProcess.styleResolver != null) {
                this.styleResolver = abstractLayoutProcess.styleResolver.saveState();
            }
            this.documentContext = abstractLayoutProcess.documentContext;
            if (abstractLayoutProcess.inputFeed != null) {
                this.inputFeedState = abstractLayoutProcess.inputFeed.saveState();
            }
        }

        protected AbstractLayoutProcess restore(OutputProcessor outputProcessor, AbstractLayoutProcess abstractLayoutProcess) throws StateException {
            abstractLayoutProcess.documentContext = this.documentContext;
            if (this.styleResolver != null) {
                abstractLayoutProcess.styleResolver = (StyleResolver)this.styleResolver.restore(abstractLayoutProcess);
            }
            if (this.inputFeedState != null) {
                abstractLayoutProcess.inputFeed = (InputFeed)this.inputFeedState.restore(abstractLayoutProcess);
            }
            return abstractLayoutProcess;
        }
    }
}

