/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.codecs;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.logstash.ObjectMappers;
import org.logstash.StringInterpolation;

@LogstashPlugin(name="java_line")
public class Line
implements Codec {
    public static final String DEFAULT_DELIMITER = System.lineSeparator();
    private static final PluginConfigSpec<String> CHARSET_CONFIG = PluginConfigSpec.stringSetting("charset", "UTF-8");
    private static final PluginConfigSpec<String> DELIMITER_CONFIG = PluginConfigSpec.stringSetting("delimiter", DEFAULT_DELIMITER);
    private static final PluginConfigSpec<String> FORMAT_CONFIG = PluginConfigSpec.stringSetting("format");
    private Context context;
    static final String MESSAGE_FIELD = "message";
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final String delimiter;
    private final Charset charset;
    private String format = null;
    private String id;
    private final CharBuffer charBuffer = ByteBuffer.allocateDirect(65536).asCharBuffer();
    private final CharsetDecoder decoder;
    private String remainder = "";

    public Line(Configuration configuration, Context context) {
        this(context, configuration.get(DELIMITER_CONFIG), configuration.get(CHARSET_CONFIG), configuration.get(FORMAT_CONFIG));
    }

    private Line(Context context, String delimiter, String charsetName, String format) {
        this.context = context;
        this.id = UUID.randomUUID().toString();
        this.delimiter = delimiter;
        this.charset = Charset.forName(charsetName);
        this.format = format;
        this.decoder = this.charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.IGNORE);
    }

    @Override
    public void decode(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        int bufferPosition = buffer.position();
        CoderResult result = this.decoder.decode(buffer, this.charBuffer, false);
        this.charBuffer.flip();
        String s = (this.remainder == null ? "" : this.remainder) + this.charBuffer.toString();
        this.charBuffer.clear();
        if (s.endsWith(this.delimiter)) {
            s = s.substring(0, s.length() - this.delimiter.length());
        } else {
            int lastIndex = s.lastIndexOf(this.delimiter);
            if (lastIndex == -1) {
                buffer.position(bufferPosition);
                s = "";
            } else {
                this.remainder = s.substring(lastIndex + this.delimiter.length(), s.length());
                s = s.substring(0, lastIndex);
            }
        }
        if (s.length() > 0) {
            String[] lines = s.split(this.delimiter, 0);
            for (int k = 0; k < lines.length; ++k) {
                eventConsumer.accept(this.simpleMap(lines[k]));
            }
        }
    }

    @Override
    public void flush(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        if (this.remainder.length() > 0 || buffer.position() != buffer.limit()) {
            try {
                String remainder = this.remainder + this.charset.newDecoder().decode(buffer).toString();
                String[] lines = remainder.split(this.delimiter, 0);
                for (int k = 0; k < lines.length; ++k) {
                    eventConsumer.accept(this.simpleMap(lines[k]));
                }
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void encode(Event event, OutputStream output) throws IOException {
        String outputString = (this.format == null ? ObjectMappers.JSON_MAPPER.writeValueAsString(event.getData()) : StringInterpolation.evaluate(event, this.format)) + this.delimiter;
        output.write(outputString.getBytes(this.charset));
    }

    private Map<String, Object> simpleMap(String message) {
        this.map.put(MESSAGE_FIELD, message);
        return this.map;
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return Arrays.asList(CHARSET_CONFIG, DELIMITER_CONFIG, FORMAT_CONFIG);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Codec cloneCodec() {
        return new Line(this.context, this.delimiter, this.charset.name(), this.format);
    }
}

