/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import nokogiri.HtmlDocument;
import nokogiri.XmlAttr;
import nokogiri.XmlAttributeDecl;
import nokogiri.XmlDocument;
import nokogiri.XmlDocumentFragment;
import nokogiri.XmlElement;
import nokogiri.XmlElementDecl;
import nokogiri.XmlEntityDecl;
import nokogiri.XmlNamespace;
import nokogiri.XmlNodeSet;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.HtmlDomParserContext;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceCache;
import nokogiri.internals.SaveContextVisitor;
import nokogiri.internals.XmlDomParserContext;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@JRubyClass(name={"Nokogiri::XML::Node"})
public class XmlNode
extends RubyObject {
    protected static final String TEXT_WRAPPER_NAME = "nokogiri_text_wrapper";
    protected Node node;
    protected IRubyObject content = null;
    protected IRubyObject doc = null;
    protected IRubyObject name = null;
    protected static final int IDENTICAL_ELEMENTS = 0;
    protected static final int IN_DIFFERENT_DOCUMENTS = 1;
    protected static final int SECOND_PRECEDES_FIRST = 2;
    protected static final int FIRST_PRECEDES_SECOND = 4;
    protected static final int SECOND_CONTAINS_FIRST = 8;
    protected static final int FIRST_CONTAINS_SECOND = 16;

    protected static XmlNode asXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof XmlNode)) {
            Ruby ruby = threadContext.getRuntime();
            throw ruby.newTypeError(iRubyObject == null ? ruby.getNil() : iRubyObject, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Node"));
        }
        return (XmlNode)iRubyObject;
    }

    protected static XmlNode asXmlNodeOrNull(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject == null || iRubyObject.isNil()) {
            return null;
        }
        return XmlNode.asXmlNode(threadContext, iRubyObject);
    }

    public static void coalesceTextNodes(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        XmlNode xmlNode2 = XmlNode.asXmlNode(threadContext, iRubyObject2);
        Node node = xmlNode.node;
        Node node2 = xmlNode2.node;
        node.setNodeValue(node.getNodeValue() + node2.getNodeValue());
        xmlNode.content = null;
        xmlNode2.assimilateXmlNode(threadContext, (IRubyObject)xmlNode);
    }

    protected static void coalesceTextNodes(ThreadContext threadContext, IRubyObject iRubyObject, AdoptScheme adoptScheme) {
        boolean bl;
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        XmlNode xmlNode2 = XmlNode.asXmlNodeOrNull(threadContext, xmlNode.previous_sibling(threadContext));
        XmlNode xmlNode3 = XmlNode.asXmlNodeOrNull(threadContext, xmlNode.next_sibling(threadContext));
        Node node = xmlNode2 == null ? null : xmlNode2.node;
        Node node2 = xmlNode.node;
        Node node3 = xmlNode3 == null ? null : xmlNode3.node;
        Node node4 = node2.getParentNode();
        boolean bl2 = adoptScheme == AdoptScheme.NEXT_SIBLING || adoptScheme == AdoptScheme.CHILD || adoptScheme == AdoptScheme.REPLACEMENT;
        boolean bl3 = bl = adoptScheme == AdoptScheme.PREV_SIBLING || adoptScheme == AdoptScheme.REPLACEMENT;
        if (bl && node3 != null && node3.getNodeType() == 3) {
            xmlNode.setContent(node2.getNodeValue() + node3.getNodeValue());
            node4.removeChild(node3);
            xmlNode3.assimilateXmlNode(threadContext, (IRubyObject)xmlNode);
        }
        if (bl2 && node != null && node.getNodeType() == 3) {
            xmlNode2.setContent(node.getNodeValue() + node2.getNodeValue());
            node4.removeChild(node2);
            xmlNode.assimilateXmlNode(threadContext, (IRubyObject)xmlNode2);
        }
    }

    public XmlNode(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public XmlNode(Ruby ruby, RubyClass rubyClass, Node node) {
        super(ruby, rubyClass);
        this.setNode(ruby.getCurrentContext(), node);
    }

    protected void decorate(ThreadContext threadContext) {
        if (this.node != null) {
            this.resetCache();
            if (this.node.getNodeType() != 9) {
                this.doc = this.document(threadContext.runtime);
                if (this.doc != null && !this.doc.isNil()) {
                    Helpers.invoke((ThreadContext)threadContext, (IRubyObject)this.doc, (String)"decorate", (IRubyObject)this);
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void resetCache() {
        this.node.setUserData("NOKOGIRI_CACHED_NODE", (Object)this, null);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = threadContext.getRuntime();
        RubyClass rubyClass = (RubyClass)iRubyObject;
        if ("Nokogiri::XML::Node".equals(rubyClass.getName())) {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Element");
        }
        XmlNode xmlNode = (XmlNode)rubyClass.allocate();
        xmlNode.init(threadContext, iRubyObjectArray);
        xmlNode.callInit(iRubyObjectArray, block);
        assert (xmlNode.node != null);
        if (block.isGiven()) {
            block.call(threadContext, (IRubyObject)xmlNode);
        }
        return xmlNode;
    }

    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 2) {
            throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
        }
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        Document document = XmlNode.asXmlNode(threadContext, iRubyObject2).getOwnerDocument();
        if (document == null) {
            throw this.getRuntime().newArgumentError("node must have owner document");
        }
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        String string2 = NokogiriHelpers.getPrefix(string);
        String string3 = null;
        if (document.getDocumentElement() != null) {
            string3 = document.getDocumentElement().lookupNamespaceURI(string2);
        }
        Element element = document.createElementNS(string3, string);
        this.setNode(threadContext, element);
    }

    protected void assimilateXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        this.node = xmlNode.node;
        this.content = null;
    }

    public void normalize() {
        this.node.normalize();
    }

    public Node getNode() {
        return this.node;
    }

    public static Node getNodeFromXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        return XmlNode.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject).node;
    }

    protected String indentString(IRubyObject iRubyObject, String string) {
        String[] stringArray = string.split("\n");
        if (stringArray.length <= 1) {
            return string;
        }
        String[] stringArray2 = new String[stringArray.length];
        boolean bl = false;
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        stringArray2[0] = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (string3.length() == 0) continue;
            if (string3.startsWith("</")) {
                bl = true;
                stringBuilder.setLength(Math.max(0, stringBuilder.length() - n));
            }
            stringArray2[i] = stringBuilder.toString() + string3;
            if (!string3.endsWith("/>") && !bl) {
                stringBuilder.append(string2);
            }
            bl = false;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuilder2.append(stringArray2[i]).append('\n');
        }
        return stringBuilder2.toString();
    }

    public boolean isComment() {
        return false;
    }

    public boolean isElement() {
        return this.node instanceof Element;
    }

    public boolean isProcessingInstruction() {
        return false;
    }

    protected IRubyObject getAttribute(ThreadContext threadContext, String string) {
        return this.getAttribute(threadContext.getRuntime(), string);
    }

    protected IRubyObject getAttribute(Ruby ruby, String string) {
        String string2 = this.getAttribute(string);
        return NokogiriHelpers.nonEmptyStringOrNil(ruby, string2);
    }

    protected String getAttribute(String string) {
        if (this.node.getNodeType() != 1) {
            return null;
        }
        String string2 = ((Element)this.node).getAttribute(string);
        return string2.length() == 0 ? null : string2;
    }

    public void relink_namespace(ThreadContext threadContext) {
        Object object;
        if (!(this.node instanceof Element)) {
            return;
        }
        Element element = (Element)this.node;
        element.getOwnerDocument().setStrictErrorChecking(false);
        String string = element.getPrefix();
        String string2 = element.lookupNamespaceURI(string);
        this.node = NokogiriHelpers.renameNode(element, string2, element.getNodeName());
        if (string2 == null || string2 == "") {
            return;
        }
        String string3 = element.getParentNode().lookupPrefix(string2);
        String string4 = element.getParentNode().lookupNamespaceURI(string);
        boolean bl = element.getParentNode().isDefaultNamespace(string2);
        if (element.getParentNode().getNodeType() == 9) {
            element.setAttribute(string == null ? "xmlns" : "xmlns:" + string, string2);
        } else if (string == null) {
            if (!bl) {
                element.setAttribute("xmlns", string2);
            }
        } else if (string3 != string || string4 != string2) {
            element.setAttribute("xmlns:" + string, string2);
        }
        if (element.hasAttributes()) {
            object = element.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Attr attr = (Attr)object.item(i);
                String string5 = attr.getPrefix();
                if (string5 == null) {
                    string5 = NokogiriHelpers.getPrefix(attr.getNodeName());
                }
                String string6 = attr.getNodeName();
                String string7 = "xml".equals(string5) ? "http://www.w3.org/XML/1998/namespace" : ("xmlns".equals(string5) || string6.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : attr.lookupNamespaceURI(string5));
                if (string7 == element.getNamespaceURI()) {
                    string7 = null;
                }
                if (string7 != null && !"".equals(string7) && !"http://www.w3.org/XML/1998/namespace".equals(string7)) {
                    XmlNamespace.createFromAttr(threadContext.getRuntime(), attr);
                }
                NokogiriHelpers.renameNode(attr, string7, string6);
            }
        }
        if (this.node.hasChildNodes()) {
            object = (XmlNodeSet)this.children(threadContext);
            ((XmlNodeSet)object).relink_namespace(threadContext);
        }
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter(this.node);
        XmlNodeSet xmlNodeSet = (XmlNodeSet)this.children(threadContext);
        if (xmlNodeSet.length() > 0) {
            RubyArray rubyArray = (RubyArray)xmlNodeSet.to_a(threadContext);
            for (int i = 0; i < rubyArray.getLength(); ++i) {
                RubyObject rubyObject;
                Object object = rubyArray.get(i);
                if (object instanceof XmlNode) {
                    rubyObject = (XmlNode)((Object)object);
                    rubyObject.accept(threadContext, saveContextVisitor);
                    continue;
                }
                if (!(object instanceof XmlNamespace)) continue;
                rubyObject = (XmlNamespace)((Object)object);
                rubyObject.accept(threadContext, saveContextVisitor);
            }
        }
        saveContextVisitor.leave(this.node);
    }

    public void setName(IRubyObject iRubyObject) {
        this.name = iRubyObject;
    }

    public void setDocument(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.doc = iRubyObject;
        XmlNode.setDocumentAndDecorate(threadContext, this, iRubyObject);
    }

    static void setDocumentAndDecorate(ThreadContext threadContext, RubyObject rubyObject, IRubyObject iRubyObject) {
        rubyObject.setInstanceVariable("@document", iRubyObject);
        if (iRubyObject != null) {
            Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"decorate", (IRubyObject)rubyObject);
        }
    }

    public void setNode(ThreadContext threadContext, Node node) {
        this.node = node;
        this.decorate(threadContext);
        if (this instanceof XmlAttr) {
            ((XmlAttr)this).setNamespaceIfNecessary(threadContext.getRuntime());
        }
    }

    public void updateNodeNamespaceIfNecessary(ThreadContext threadContext, XmlNamespace xmlNamespace) {
        boolean bl;
        String string = this.node.getPrefix();
        String string2 = NokogiriHelpers.rubyStringToString(xmlNamespace.href(threadContext));
        boolean bl2 = bl = string == null && xmlNamespace.prefix(threadContext).isNil() || string != null && !xmlNamespace.prefix(threadContext).isNil() && string.equals(NokogiriHelpers.rubyStringToString(xmlNamespace.prefix(threadContext)));
        if (bl) {
            this.node = NokogiriHelpers.renameNode(this.node, string2, this.node.getNodeName());
        }
    }

    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name != null) {
            return this.name;
        }
        String string = null;
        if (this.node != null) {
            string = this.node.getNodeName();
            string = NokogiriHelpers.getLocalPart(string);
        }
        if (string == null) {
            string = "";
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        this.name = NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), string);
        return this.name;
    }

    @JRubyMethod(name={"add_namespace_definition", "add_namespace"})
    public IRubyObject add_namespace_definition(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Object object;
        Node node;
        String string;
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        if (iRubyObject2.isNil()) {
            string = this.findNamespaceHref(threadContext, NokogiriHelpers.rubyStringToString(iRubyObject));
            if (string == null) {
                return threadContext.nil;
            }
            iRubyObject2 = threadContext.getRuntime().newString(string);
        } else {
            string = NokogiriHelpers.rubyStringToString(iRubyObject2);
        }
        NokogiriNamespaceCache nokogiriNamespaceCache = NokogiriHelpers.getNamespaceCacheFormNode(this.node);
        XmlNamespace xmlNamespace = nokogiriNamespaceCache.get(string2, string);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        if (this.node.getNodeType() == 1) {
            node = this.node;
            object = (Element)this.node;
            String string3 = iRubyObject.isNil() ? "xmlns" : "xmlns:" + string2;
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string);
        } else {
            node = this.node.getNodeType() == 2 ? ((Attr)this.node).getOwnerElement() : this.node.getParentNode();
        }
        object = XmlNamespace.createFromPrefixAndHref(node, iRubyObject, iRubyObject2);
        if (this.node != node) {
            this.node = NokogiriHelpers.renameNode(this.node, ((XmlNamespace)((Object)object)).getHref(), ((XmlNamespace)((Object)object)).getPrefix() + ":" + this.node.getLocalName());
        }
        this.updateNodeNamespaceIfNecessary(threadContext, (XmlNamespace)((Object)object));
        return object;
    }

    @JRubyMethod(name={"attribute", "attr"})
    public IRubyObject attribute(ThreadContext threadContext, IRubyObject iRubyObject) {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        Node node = namedNodeMap.getNamedItem(NokogiriHelpers.rubyStringToString(iRubyObject));
        if (node == null) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
    }

    @JRubyMethod
    public IRubyObject attribute_nodes(ThreadContext threadContext) {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        Ruby ruby = threadContext.getRuntime();
        if (namedNodeMap == null) {
            return ruby.newEmptyArray();
        }
        RubyArray rubyArray = ruby.newArray();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (!(this.doc instanceof HtmlDocument) && NokogiriHelpers.isNamespace(namedNodeMap.item(i))) continue;
            rubyArray.append(NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), namedNodeMap.item(i)));
        }
        return rubyArray;
    }

    @JRubyMethod
    public IRubyObject attribute_with_ns(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        String string2 = iRubyObject2.isNil() ? null : NokogiriHelpers.rubyStringToString(iRubyObject2);
        Node node = this.node.getAttributes().getNamedItemNS(string2, string);
        if (node == null) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
    }

    @JRubyMethod(name={"blank?"})
    public IRubyObject blank_p(ThreadContext threadContext) {
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            String string = this.node.getTextContent();
            return threadContext.runtime.newBoolean(string == null || NokogiriHelpers.isBlank(string));
        }
        return threadContext.runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject child(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getFirstChild());
    }

    @JRubyMethod
    public IRubyObject children(ThreadContext threadContext) {
        XmlNodeSet xmlNodeSet = XmlNodeSet.newEmptyNodeSet(threadContext);
        NodeList nodeList = this.node.getChildNodes();
        if (nodeList.getLength() > 0) {
            xmlNodeSet.setNodeList(nodeList);
        } else {
            XmlNode.setDocumentAndDecorate(threadContext, xmlNodeSet, this.doc);
        }
        return xmlNodeSet;
    }

    @JRubyMethod
    public IRubyObject first_element_child(ThreadContext threadContext) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.addElements(this.node, arrayList, true);
        if (arrayList.size() == 0) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), (Node)arrayList.get(0));
    }

    @JRubyMethod
    public IRubyObject last_element_child(ThreadContext threadContext) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.addElements(this.node, arrayList, false);
        if (arrayList.size() == 0) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), (Node)arrayList.get(arrayList.size() - 1));
    }

    @JRubyMethod(name={"element_children", "elements"})
    public IRubyObject element_children(ThreadContext threadContext) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.addElements(this.node, arrayList, false);
        IRubyObject[] iRubyObjectArray = NokogiriHelpers.nodeArrayToArray(threadContext.runtime, arrayList.toArray(new Node[0]));
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, iRubyObjectArray);
        return xmlNodeSet;
    }

    private void addElements(Node node, List<Node> list, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            list.add(node2);
            if (!bl) continue;
            return;
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject compare(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof XmlNode)) {
            return threadContext.getRuntime().newFixnum(-2);
        }
        Node node = XmlNode.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject).node;
        if (this.node.getNodeType() == 9 || node.getNodeType() == 9) {
            return threadContext.getRuntime().newFixnum(-1);
        }
        try {
            short s = this.node.compareDocumentPosition(node);
            if ((s & 4) == 4) {
                return threadContext.getRuntime().newFixnum(-1);
            }
            if ((s & 2) == 2) {
                return threadContext.getRuntime().newFixnum(1);
            }
            if (s == 0) {
                return threadContext.getRuntime().newFixnum(0);
            }
            return threadContext.getRuntime().newFixnum(-2);
        }
        catch (Exception exception) {
            return threadContext.getRuntime().newFixnum(-2);
        }
    }

    @JRubyMethod(required=2, visibility=Visibility.PRIVATE)
    public IRubyObject in_context(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray rubyArray;
        Object object;
        ByteArrayInputStream byteArrayInputStream;
        XmlDomParserContext xmlDomParserContext;
        RubyClass rubyClass;
        IRubyObject iRubyObject3 = this.document(threadContext);
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject3 == null || !(iRubyObject3 instanceof XmlDocument)) {
            return ruby.getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)iRubyObject3;
        if (xmlDocument instanceof HtmlDocument) {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::HTML::Document");
            xmlDomParserContext = new HtmlDomParserContext(ruby, iRubyObject2);
            ((HtmlDomParserContext)xmlDomParserContext).enableDocumentFragment();
            byteArrayInputStream = new ByteArrayInputStream(NokogiriHelpers.rubyStringToString(iRubyObject).getBytes());
        } else {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document");
            xmlDomParserContext = new XmlDomParserContext(ruby, iRubyObject2);
            object = NokogiriHelpers.rubyStringToString(iRubyObject);
            byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
        }
        xmlDomParserContext.setInputSource(byteArrayInputStream);
        if (xmlDocument instanceof HtmlDocument && xmlDocument.getEncoding() != null && !xmlDocument.getEncoding().isNil()) {
            object = (HtmlDomParserContext)xmlDomParserContext;
            ((HtmlDomParserContext)((Object)object)).setEncoding(xmlDocument.getEncoding().asJavaString());
        }
        object = xmlDomParserContext.parse(threadContext, (IRubyObject)rubyClass, ruby.getNil());
        RubyArray rubyArray2 = this.getErrorArray(xmlDocument);
        if (this.isErrorIncreased(rubyArray2, rubyArray = this.getErrorArray((XmlDocument)((Object)object)))) {
            for (int i = 0; i < rubyArray.getLength(); ++i) {
                rubyArray2.add((Object)rubyArray.entry(i));
            }
            xmlDocument.setInstanceVariable("@errors", (IRubyObject)rubyArray2);
            XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, new IRubyObject[0]);
            return xmlNodeSet;
        }
        Node node = ((XmlDocument)((Object)object)).node.getFirstChild().getNodeType() == 10 ? ((XmlDocument)((Object)object)).node.getFirstChild().getNextSibling() : ((XmlDocument)((Object)object)).node.getFirstChild();
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.getCachedNodeOrCreate(ruby, node)};
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, iRubyObjectArray);
        return xmlNodeSet;
    }

    private RubyArray getErrorArray(XmlDocument xmlDocument) {
        IRubyObject iRubyObject = xmlDocument.getInstanceVariable("@errors");
        if (iRubyObject != null && iRubyObject instanceof RubyArray) {
            return (RubyArray)iRubyObject;
        }
        return RubyArray.newArray((Ruby)xmlDocument.getRuntime());
    }

    private boolean isErrorIncreased(RubyArray rubyArray, RubyArray rubyArray2) {
        int n = ((RubyArray)rubyArray2.op_diff((IRubyObject)rubyArray)).size();
        return n > 0;
    }

    @JRubyMethod(name={"content", "text", "inner_text"})
    public IRubyObject content(ThreadContext threadContext) {
        return NokogiriHelpers.stringOrNil(threadContext.getRuntime(), this.getContentImpl());
    }

    public CharSequence getContentImpl() {
        CharSequence charSequence;
        if (!(this.node.hasChildNodes() || this.node.getNodeValue() != null || this.node.getNodeType() != 3 && this.node.getNodeType() != 4)) {
            return null;
        }
        if (this instanceof XmlDocument) {
            Element element = ((Document)this.node).getDocumentElement();
            if (element == null) {
                charSequence = "";
            } else {
                Element element2 = ((Document)this.node).getDocumentElement();
                charSequence = this.getTextContentRecursively(new StringBuilder(), element2);
            }
        } else {
            charSequence = this.getTextContentRecursively(new StringBuilder(), this.node);
        }
        return charSequence;
    }

    private StringBuilder getTextContentRecursively(StringBuilder stringBuilder, Node node) {
        CharSequence charSequence = node.getNodeValue();
        if (charSequence != null && NokogiriHelpers.shouldDecode(node)) {
            charSequence = NokogiriHelpers.decodeJavaString(charSequence);
        }
        if (charSequence != null) {
            stringBuilder.append(charSequence);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!this.hasTextContent(node2)) continue;
            this.getTextContentRecursively(stringBuilder, node2);
        }
        return stringBuilder;
    }

    private boolean hasTextContent(Node node) {
        return node.getNodeType() != 8 && node.getNodeType() != 7;
    }

    @JRubyMethod
    public final IRubyObject document(ThreadContext threadContext) {
        return this.document(threadContext.runtime);
    }

    IRubyObject document(Ruby ruby) {
        if (this.doc == null) {
            this.doc = (XmlDocument)((Object)this.node.getOwnerDocument().getUserData("NOKOGIRI_CACHED_NODE"));
        }
        if (this.doc == null) {
            this.doc = NokogiriHelpers.getCachedNodeOrCreate(ruby, this.node.getOwnerDocument());
            this.node.getOwnerDocument().setUserData("NOKOGIRI_CACHED_NODE", this.doc, null);
        }
        return this.doc;
    }

    public IRubyObject dup() {
        return this.dup_implementation(this.getMetaClass().getClassRuntime(), true);
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext threadContext) {
        return this.dup_implementation(threadContext, true);
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext threadContext, IRubyObject iRubyObject) {
        boolean bl = iRubyObject instanceof RubyInteger && RubyFixnum.fix2int((IRubyObject)iRubyObject) != 0;
        return this.dup_implementation(threadContext, bl);
    }

    protected final IRubyObject dup_implementation(ThreadContext threadContext, boolean bl) {
        return this.dup_implementation(threadContext.getRuntime(), bl);
    }

    protected IRubyObject dup_implementation(Ruby ruby, boolean bl) {
        Node node;
        XmlNode xmlNode;
        try {
            xmlNode = (XmlNode)((Object)this.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw ruby.newRuntimeError(cloneNotSupportedException.toString());
        }
        xmlNode.node = node = this.node.cloneNode(bl);
        return xmlNode;
    }

    public static RubyString encode_special_chars(ThreadContext threadContext, IRubyObject iRubyObject) {
        CharSequence charSequence = NokogiriHelpers.encodeJavaString(NokogiriHelpers.rubyStringToString(iRubyObject));
        return RubyString.newString((Ruby)threadContext.getRuntime(), (CharSequence)charSequence);
    }

    @JRubyMethod(name={"encode_special_chars"})
    public IRubyObject i_encode_special_chars(ThreadContext threadContext, IRubyObject iRubyObject) {
        return XmlNode.encode_special_chars(threadContext, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject get(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.node instanceof Element) {
            String string;
            Element element;
            if (iRubyObject == null || iRubyObject.isNil()) {
                threadContext.getRuntime().getNil();
            }
            if (!(element = (Element)this.node).hasAttribute(string = NokogiriHelpers.rubyStringToString(iRubyObject))) {
                return threadContext.getRuntime().getNil();
            }
            String string2 = element.getAttribute(string);
            return NokogiriHelpers.stringOrNil(threadContext.getRuntime(), string2);
        }
        return threadContext.getRuntime().getNil();
    }

    protected Document getOwnerDocument() {
        if (this.node.getNodeType() == 9) {
            return (Document)this.node;
        }
        return this.node.getOwnerDocument();
    }

    @JRubyMethod
    public IRubyObject internal_subset(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject = xmlDocument.getInternalSubset(threadContext);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject create_internal_subset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4 = this.internal_subset(threadContext);
        if (!iRubyObject4.isNil()) {
            throw threadContext.getRuntime().newRuntimeError("Document already has internal subset");
        }
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject5 = xmlDocument.createInternalSubset(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        return iRubyObject5;
    }

    @JRubyMethod
    public IRubyObject external_subset(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject = xmlDocument.getExternalSubset(threadContext);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject create_external_subset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4 = this.external_subset(threadContext);
        if (!iRubyObject4.isNil()) {
            throw threadContext.getRuntime().newRuntimeError("Document already has external subset");
        }
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject5 = xmlDocument.createExternalSubset(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        return iRubyObject5;
    }

    @JRubyMethod(name={"key?", "has_attribute?"})
    public IRubyObject key_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            String string = NokogiriHelpers.rubyStringToString(iRubyObject);
            if (element.hasAttribute(string)) {
                return threadContext.getRuntime().getTrue();
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                if (!string.equals(node.getLocalName())) continue;
                return threadContext.getRuntime().getTrue();
            }
            return threadContext.getRuntime().getFalse();
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject namespace(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        if (this.doc instanceof HtmlDocument) {
            return ruby.getNil();
        }
        NokogiriNamespaceCache nokogiriNamespaceCache = NokogiriHelpers.getNamespaceCacheFormNode(this.node);
        String string = this.node.getNamespaceURI();
        if (string == null || string == "") {
            return ruby.getNil();
        }
        String string2 = this.node.getPrefix();
        XmlNamespace xmlNamespace = nokogiriNamespaceCache.get(string2 == null ? "" : string2, string);
        if (xmlNamespace == null || xmlNamespace.isEmpty()) {
            xmlNamespace = new XmlNamespace(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Namespace"));
            IRubyObject iRubyObject = NokogiriHelpers.stringOrNil(ruby, string2);
            IRubyObject iRubyObject2 = NokogiriHelpers.stringOrNil(ruby, string);
            xmlNamespace.init(null, iRubyObject, iRubyObject2, this.doc);
        }
        return xmlNamespace;
    }

    @JRubyMethod
    public IRubyObject namespace_definitions(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        if (this.doc == null) {
            return rubyArray;
        }
        if (this.doc instanceof HtmlDocument) {
            return rubyArray;
        }
        List<XmlNamespace> list = ((XmlDocument)this.doc).getNamespaceCache().get(this.node);
        for (XmlNamespace xmlNamespace : list) {
            rubyArray.append((IRubyObject)xmlNamespace);
        }
        return rubyArray;
    }

    @JRubyMethod
    public IRubyObject namespace_scopes(ThreadContext threadContext) {
        RubyArray rubyArray = threadContext.getRuntime().newArray();
        if (this.doc == null) {
            return rubyArray;
        }
        if (this.doc instanceof HtmlDocument) {
            return rubyArray;
        }
        Node node = this.node.getNodeType() == 1 ? this.node : (this.node.getNodeType() == 2 ? ((Attr)this.node).getOwnerElement() : this.findPreviousElement(this.node));
        if (node == null) {
            return rubyArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        NokogiriNamespaceCache nokogiriNamespaceCache = NokogiriHelpers.getNamespaceCacheFormNode(node);
        Node node2 = node;
        while (node2 != null) {
            List<XmlNamespace> list = nokogiriNamespaceCache.get(node2);
            for (XmlNamespace xmlNamespace : list) {
                if (arrayList.contains(xmlNamespace.getPrefix())) continue;
                rubyArray.append((IRubyObject)xmlNamespace);
                arrayList.add(xmlNamespace.getPrefix());
            }
            node2 = this.findPreviousElement(node2);
        }
        return rubyArray;
    }

    private Node findPreviousElement(Node node) {
        Node node2;
        Node node3 = node2 = node.getPreviousSibling() == null ? node.getParentNode() : node.getPreviousSibling();
        if (node2 == null || node2.getNodeType() == 9) {
            return null;
        }
        if (node2.getNodeType() == 1) {
            return node2;
        }
        return this.findPreviousElement(node2);
    }

    @JRubyMethod(name={"namespaced_key?"})
    public IRubyObject namespaced_key_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.attribute_with_ns(threadContext, iRubyObject, iRubyObject2).isNil() ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
    }

    protected void setContent(IRubyObject iRubyObject) {
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        this.node.setTextContent(string);
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            return;
        }
        if (this.node.getFirstChild() != null) {
            this.node.getFirstChild().setUserData("NOKOGIRI_ENCODED_STRING", true, null);
        }
    }

    private void setContent(String string) {
        this.node.setTextContent(string);
        this.content = null;
    }

    @JRubyMethod(name={"native_content="})
    public IRubyObject native_content_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.setContent(iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject lang(ThreadContext threadContext) {
        XmlNode xmlNode = this;
        while (!xmlNode.isNil()) {
            XmlNode xmlNode2 = XmlNode.asXmlNode(threadContext, (IRubyObject)xmlNode);
            IRubyObject iRubyObject = xmlNode2.getAttribute(threadContext.getRuntime(), "xml:lang");
            if (!iRubyObject.isNil()) {
                return iRubyObject;
            }
            xmlNode = xmlNode2.parent(threadContext);
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"lang="})
    public IRubyObject set_lang(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.setAttribute(threadContext, "xml:lang", NokogiriHelpers.rubyStringToString(iRubyObject));
        return threadContext.nil;
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public IRubyObject native_write_to(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyString rubyString;
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        String string = iRubyObject2.isNil() ? null : NokogiriHelpers.rubyStringToString(iRubyObject2);
        SaveContextVisitor saveContextVisitor = new SaveContextVisitor(RubyFixnum.fix2int((IRubyObject)iRubyObject4), NokogiriHelpers.rubyStringToString(iRubyObject3), string, this.isHtmlDoc(threadContext), this.isFragment(), 0);
        this.accept(threadContext, saveContextVisitor);
        if (NokogiriHelpers.isUTF8(string)) {
            rubyString = NokogiriHelpers.convertString(threadContext.getRuntime(), saveContextVisitor.getInternalBuffer());
        } else {
            ByteBuffer byteBuffer = NokogiriHelpers.convertEncoding(Charset.forName(string), saveContextVisitor.getInternalBuffer());
            ByteList byteList = new ByteList(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
            rubyString = RubyString.newString((Ruby)threadContext.getRuntime(), (ByteList)byteList);
        }
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"write", (IRubyObject)rubyString);
        return iRubyObject;
    }

    private boolean isHtmlDoc(ThreadContext threadContext) {
        return this.document(threadContext).getMetaClass().isKindOfModule((RubyModule)NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::HTML::Document"));
    }

    private boolean isFragment() {
        if (this.node instanceof DocumentFragment) {
            return true;
        }
        return this.node.getParentNode() != null && this.node.getParentNode() instanceof DocumentFragment;
    }

    @JRubyMethod(name={"next_sibling", "next"})
    public IRubyObject next_sibling(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getNextSibling());
    }

    @JRubyMethod(name={"previous_sibling", "previous"})
    public IRubyObject previous_sibling(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getPreviousSibling());
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject new_from_str(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDocument xmlDocument = (XmlDocument)XmlDocument.read_memory(threadContext, iRubyObjectArray);
        return xmlDocument.root(threadContext);
    }

    @JRubyMethod(name={"node_name", "name"})
    public IRubyObject node_name(ThreadContext threadContext) {
        return this.getNodeName(threadContext);
    }

    @JRubyMethod(name={"node_name=", "name="})
    public IRubyObject node_name_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        this.node = NokogiriHelpers.renameNode(this.node, null, string);
        this.setName(iRubyObject);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (this.node instanceof Element) {
            this.setAttribute(threadContext, NokogiriHelpers.rubyStringToString(iRubyObject), NokogiriHelpers.rubyStringToString(iRubyObject2));
            return this;
        }
        return iRubyObject2;
    }

    private void setAttribute(ThreadContext threadContext, String string, String string2) {
        Element element = (Element)this.node;
        String string3 = null;
        int n = string.indexOf(":");
        if (n > 0) {
            String string4 = string.substring(0, n);
            string3 = string4.equals("xml") ? "http://www.w3.org/XML/1998/namespace" : (string4.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : this.node.lookupNamespaceURI(string4));
        }
        if (string3 != null) {
            element.setAttributeNS(string3, string, string2);
        } else {
            element.setAttribute(string, string2);
        }
        NokogiriHelpers.clearXpathContext(this.node);
    }

    private String findNamespaceHref(ThreadContext threadContext, String string) {
        for (XmlNode xmlNode = this; xmlNode != this.document(threadContext); xmlNode = (XmlNode)xmlNode.parent(threadContext)) {
            RubyArray rubyArray = (RubyArray)xmlNode.namespace_scopes(threadContext);
            for (XmlNamespace xmlNamespace : rubyArray) {
                if (!xmlNamespace.getPrefix().equals(string)) continue;
                return xmlNamespace.getHref();
            }
            if (xmlNode.parent(threadContext).isNil()) break;
        }
        return null;
    }

    @JRubyMethod
    public IRubyObject parent(ThreadContext threadContext) {
        if (this.node.getOwnerDocument() != null && this.node.getOwnerDocument().getDocumentElement() == this.node) {
            return this.document(threadContext);
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getParentNode());
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext threadContext) {
        return RubyString.newString((Ruby)threadContext.getRuntime(), (String)NokogiriHelpers.getNodeCompletePath(this.node));
    }

    @JRubyMethod
    public IRubyObject pointer_id(ThreadContext threadContext) {
        return RubyFixnum.newFixnum((Ruby)threadContext.getRuntime(), (long)this.node.hashCode());
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject set_namespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            if (this.doc != null) {
                Node node = this.node;
                String string = node.getPrefix();
                String string2 = node.getNamespaceURI();
                ((XmlDocument)this.doc).getNamespaceCache().remove(string == null ? "" : string, string2);
                this.node = NokogiriHelpers.renameNode(node, null, NokogiriHelpers.getLocalPart(node.getNodeName()));
            }
        } else {
            XmlNamespace xmlNamespace = (XmlNamespace)iRubyObject;
            String string = NokogiriHelpers.rubyStringToString(xmlNamespace.prefix(threadContext));
            String string3 = NokogiriHelpers.rubyStringToString(xmlNamespace.href(threadContext));
            String string4 = NokogiriHelpers.newQName(string, this.node);
            this.node = NokogiriHelpers.renameNode(this.node, string3, string4);
        }
        NokogiriHelpers.clearXpathContext(this.getNode());
        return this;
    }

    @JRubyMethod(name={"unlink", "remove"})
    public IRubyObject unlink(ThreadContext threadContext) {
        Node node = this.node.getParentNode();
        if (node != null) {
            node.removeChild(this.node);
            NokogiriHelpers.clearXpathContext(node);
        }
        return this;
    }

    @JRubyMethod(name={"node_type", "type"})
    public IRubyObject node_type(ThreadContext threadContext) {
        String string;
        switch (this.node.getNodeType()) {
            case 1: {
                if (this instanceof XmlElementDecl) {
                    string = "ELEMENT_DECL";
                    break;
                }
                if (this instanceof XmlAttributeDecl) {
                    string = "ATTRIBUTE_DECL";
                    break;
                }
                if (this instanceof XmlEntityDecl) {
                    string = "ENTITY_DECL";
                    break;
                }
                string = "ELEMENT_NODE";
                break;
            }
            case 2: {
                string = "ATTRIBUTE_NODE";
                break;
            }
            case 3: {
                string = "TEXT_NODE";
                break;
            }
            case 4: {
                string = "CDATA_SECTION_NODE";
                break;
            }
            case 5: {
                string = "ENTITY_REF_NODE";
                break;
            }
            case 6: {
                string = "ENTITY_NODE";
                break;
            }
            case 7: {
                string = "PI_NODE";
                break;
            }
            case 8: {
                string = "COMMENT_NODE";
                break;
            }
            case 9: {
                if (this instanceof HtmlDocument) {
                    string = "HTML_DOCUMENT_NODE";
                    break;
                }
                string = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                string = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 11: {
                string = "DOCUMENT_FRAG_NODE";
                break;
            }
            case 12: {
                string = "NOTATION_NODE";
                break;
            }
            default: {
                return threadContext.getRuntime().newFixnum(0);
            }
        }
        return NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::Node").getConstant(string);
    }

    @JRubyMethod
    public IRubyObject line(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        int[] nArray = new int[1];
        this.count(document, nArray);
        return RubyFixnum.newFixnum((Ruby)threadContext.getRuntime(), (long)(nArray[0] + 1));
    }

    private boolean count(Node node, int[] nArray) {
        if (node == this.node) {
            return true;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof Text && ((Text)node2).getData().contains("\n")) {
                nArray[0] = nArray[0] + 1;
            }
            if (!this.count(node2, nArray)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod
    public IRubyObject next_element(ThreadContext threadContext) {
        Node node = this.node.getNextSibling();
        Ruby ruby = threadContext.getRuntime();
        if (node == null) {
            return ruby.getNil();
        }
        if (node instanceof Element) {
            return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
        }
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            return ruby.getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node2);
    }

    @JRubyMethod
    public IRubyObject previous_element(ThreadContext threadContext) {
        Node node = this.node.getPreviousSibling();
        Ruby ruby = threadContext.getRuntime();
        if (node == null) {
            return ruby.getNil();
        }
        if (node instanceof Element) {
            return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
        }
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            return ruby.getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node2);
    }

    protected IRubyObject adoptAs(ThreadContext threadContext, AdoptScheme adoptScheme, IRubyObject iRubyObject) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        if (this.doc != null) {
            xmlNode.setDocument(threadContext, this.doc);
        }
        XmlNode xmlNode2 = xmlNode;
        Node node = this.node;
        Node node2 = xmlNode.node;
        try {
            Node node3;
            Document document = node2.getOwnerDocument();
            Document document2 = node.getOwnerDocument();
            if (document2 == null && node instanceof Document) {
                document2 = (Document)node;
            }
            NokogiriHelpers.clearXpathContext(document);
            NokogiriHelpers.clearXpathContext(document2);
            if (document2 != null && document2 != node2.getOwnerDocument()) {
                node3 = document2.adoptNode(node2);
                this.fixUserData(document, node3);
                if (node3 == null) {
                    throw threadContext.getRuntime().newRuntimeError("Failed to take ownership of node");
                }
                node2 = node3;
            }
            node3 = node.getParentNode();
            switch (adoptScheme) {
                case CHILD: {
                    Node[] nodeArray = this.adoptAsChild(threadContext, node, node2);
                    if (nodeArray.length == 1 && node2 == nodeArray[0]) break;
                    xmlNode2 = NokogiriHelpers.nodeArrayToRubyArray(threadContext.getRuntime(), nodeArray);
                    break;
                }
                case PREV_SIBLING: {
                    this.adoptAsPrevSibling(threadContext, node3, node, node2);
                    break;
                }
                case NEXT_SIBLING: {
                    this.adoptAsNextSibling(threadContext, node3, node, node2);
                    break;
                }
                case REPLACEMENT: {
                    this.adoptAsReplacement(threadContext, node3, node, node2);
                }
            }
        }
        catch (Exception exception) {
            throw threadContext.getRuntime().newRuntimeError(exception.toString());
        }
        if (node2.getNodeType() == 3) {
            XmlNode.coalesceTextNodes(threadContext, (IRubyObject)xmlNode, adoptScheme);
        }
        if (this instanceof XmlDocument) {
            ((XmlDocument)this).resetNamespaceCache(threadContext);
        }
        xmlNode.relink_namespace(threadContext);
        return xmlNode2;
    }

    private void fixUserData(Document document, Node node) {
        String string = "NOKOGIRI_ENCODED_STRING";
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)document;
            node2.setUserData(string, coreDocumentImpl.getUserData(node2, string), null);
            this.fixUserData(document, node2);
        }
    }

    protected Node[] adoptAsChild(ThreadContext threadContext, Node node, Node nodeArray) {
        Node[] nodeArray2;
        if (node.getNodeType() == 9 && nodeArray.getNodeType() == 3) {
            nodeArray2 = (Node[])node.getFirstChild();
            if (nodeArray2 == null || !nodeArray2.getNodeName().equals(TEXT_WRAPPER_NAME)) {
                nodeArray2 = ((Document)node).createElement(TEXT_WRAPPER_NAME);
                this.adoptAsChild(threadContext, node, (Node)nodeArray2);
            }
            nodeArray2.appendChild((Node)nodeArray);
            nodeArray = nodeArray2;
        } else {
            this.addNamespaceURIIfNeeded((Node)nodeArray);
            node.appendChild((Node)nodeArray);
        }
        nodeArray2 = new Node[]{nodeArray};
        return nodeArray2;
    }

    private void addNamespaceURIIfNeeded(Node node) {
        if (this instanceof XmlDocumentFragment && ((XmlDocumentFragment)this).getFragmentContext() != null) {
            XmlElement xmlElement = ((XmlDocumentFragment)this).getFragmentContext();
            String string = xmlElement.node.getNamespaceURI();
            if (string != null && string.length() > 0) {
                NokogiriHelpers.renameNode(node, string, node.getNodeName());
            }
        }
    }

    protected void adoptAsPrevSibling(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            if (node3.getParentNode() != null) {
                node3.getParentNode().removeChild(node3);
            }
            return;
        }
        node.insertBefore(node3, node2);
    }

    protected void adoptAsNextSibling(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            if (node3.getParentNode() != null) {
                node3.getParentNode().removeChild(node3);
            }
            return;
        }
        Node node4 = node2.getNextSibling();
        if (node4 != null) {
            node.insertBefore(node3, node4);
        } else {
            node.appendChild(node3);
        }
    }

    protected void adoptAsReplacement(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            return;
        }
        try {
            node.replaceChild(node3, node2);
        }
        catch (Exception exception) {
            String string = "could not replace child: ";
            throw threadContext.getRuntime().newRuntimeError(string + exception.toString());
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_child_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.CHILD, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject replace_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.REPLACEMENT, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_previous_sibling_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.PREV_SIBLING, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_next_sibling_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.NEXT_SIBLING, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject process_xincludes(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlDocument xmlDocument = (XmlDocument)this.document(threadContext);
        RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
        while (rubyArray.getLength() > 0) {
            XmlSyntaxError xmlSyntaxError = (XmlSyntaxError)rubyArray.shift(threadContext);
            if (!xmlSyntaxError.toString().contains("Include operation failed")) continue;
            throw new RaiseException((RubyException)xmlSyntaxError);
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject clear_xpath_context(ThreadContext threadContext) {
        NokogiriHelpers.clearXpathContext(this.getNode());
        return threadContext.nil;
    }

    protected static enum AdoptScheme {
        CHILD,
        PREV_SIBLING,
        NEXT_SIBLING,
        REPLACEMENT;

    }
}

