/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import liquibase.exception.ServiceNotFoundException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.osgi.OSGiPackageScanClassResolver;
import liquibase.osgi.OSGiResourceAccessor;
import liquibase.osgi.OSGiUtil;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.LiquibaseService;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.PrioritizedService;
import liquibase.servicelocator.WebSpherePackageScanClassResolver;
import liquibase.util.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ServiceLocator {
    private static ServiceLocator instance;
    private ResourceAccessor resourceAccessor;
    private Map<Class, List<Class>> classesBySuperclass;
    private List<String> packagesToScan;
    private PackageScanClassResolver classResolver;

    protected ServiceLocator() {
        this.classResolver = this.defaultClassLoader();
        this.setResourceAccessor(new ClassLoaderResourceAccessor());
    }

    protected ServiceLocator(ResourceAccessor accessor) {
        this.classResolver = this.defaultClassLoader();
        this.setResourceAccessor(accessor);
    }

    protected ServiceLocator(PackageScanClassResolver classResolver) {
        this.classResolver = classResolver;
        this.setResourceAccessor(new ClassLoaderResourceAccessor());
    }

    protected ServiceLocator(PackageScanClassResolver classResolver, ResourceAccessor accessor) {
        this.classResolver = classResolver;
        this.setResourceAccessor(accessor);
    }

    public static ServiceLocator getInstance() {
        return instance;
    }

    public static synchronized void setInstance(ServiceLocator newInstance) {
        instance = newInstance;
    }

    public static synchronized void reset() {
        instance = new ServiceLocator();
    }

    protected PackageScanClassResolver defaultClassLoader() {
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            LogService.getLog(this.getClass()).debug(LogType.LOG, "Using WebSphere Specific Class Resolver");
            return new WebSpherePackageScanClassResolver("liquibase/parser/core/xml/dbchangelog-2.0.xsd");
        }
        return new DefaultPackageScanClassResolver();
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
        this.classesBySuperclass = new HashMap<Class, List<Class>>();
        this.classResolver.setClassLoaders(new HashSet<ClassLoader>(Arrays.asList(resourceAccessor.toClassLoader())));
        if (this.packagesToScan == null) {
            this.packagesToScan = new ArrayList<String>();
            String packagesToScanSystemProp = System.getProperty("liquibase.scan.packages");
            if (packagesToScanSystemProp != null && (packagesToScanSystemProp = StringUtils.trimToNull(packagesToScanSystemProp)) != null) {
                for (String value : packagesToScanSystemProp.split(",")) {
                    this.addPackageToScan(value);
                }
            } else {
                try {
                    Set<InputStream> manifests = resourceAccessor.getResourcesAsStream("META-INF/MANIFEST.MF");
                    if (manifests != null) {
                        for (InputStream is : manifests) {
                            Manifest manifest = new Manifest(is);
                            String attributes = StringUtils.trimToNull(manifest.getMainAttributes().getValue("Liquibase-Package"));
                            if (attributes != null) {
                                for (String value : attributes.split(",")) {
                                    this.addPackageToScan(value.toString());
                                }
                            }
                            is.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UnexpectedLiquibaseException(e);
                }
                if (this.packagesToScan.isEmpty()) {
                    this.addPackageToScan("liquibase.change");
                    this.addPackageToScan("liquibase.changelog");
                    this.addPackageToScan("liquibase.database");
                    this.addPackageToScan("liquibase.parser");
                    this.addPackageToScan("liquibase.precondition");
                    this.addPackageToScan("liquibase.datatype");
                    this.addPackageToScan("liquibase.serializer");
                    this.addPackageToScan("liquibase.sqlgenerator");
                    this.addPackageToScan("liquibase.executor");
                    this.addPackageToScan("liquibase.snapshot");
                    this.addPackageToScan("liquibase.logging");
                    this.addPackageToScan("liquibase.diff");
                    this.addPackageToScan("liquibase.structure");
                    this.addPackageToScan("liquibase.structurecompare");
                    this.addPackageToScan("liquibase.lockservice");
                    this.addPackageToScan("liquibase.sdk.database");
                    this.addPackageToScan("liquibase.ext");
                }
            }
        }
    }

    public void addPackageToScan(String packageName) {
        this.packagesToScan.add(packageName);
    }

    public List<String> getPackages() {
        return this.packagesToScan;
    }

    public Class findClass(Class requiredInterface) throws ServiceNotFoundException {
        Class<T>[] classes = this.findClasses(requiredInterface);
        if (PrioritizedService.class.isAssignableFrom(requiredInterface)) {
            Object returnObject = null;
            for (Class clazz : classes) {
                PrioritizedService newInstance;
                try {
                    newInstance = (PrioritizedService)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new UnexpectedLiquibaseException(e);
                }
                if (returnObject != null && newInstance.getPriority() <= returnObject.getPriority()) continue;
                returnObject = newInstance;
            }
            if (returnObject == null) {
                throw new ServiceNotFoundException("Could not find implementation of " + requiredInterface.getName());
            }
            return returnObject.getClass();
        }
        if (classes.length != 1) {
            throw new ServiceNotFoundException("Could not find unique implementation of " + requiredInterface.getName() + ".  Found " + classes.length + " implementations");
        }
        return classes[0];
    }

    public <T> Class<? extends T>[] findClasses(Class<T> requiredInterface) throws ServiceNotFoundException {
        LogService.getLog(this.getClass()).debug(LogType.LOG, "ServiceLocator.findClasses for " + requiredInterface.getName());
        try {
            Class.forName(requiredInterface.getName());
            if (!this.classesBySuperclass.containsKey(requiredInterface)) {
                this.classesBySuperclass.put(requiredInterface, this.findClassesImpl(requiredInterface));
            }
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
        List<Class> classes = this.classesBySuperclass.get(requiredInterface);
        HashSet<Class> uniqueClasses = new HashSet<Class>(classes);
        return uniqueClasses.toArray(new Class[uniqueClasses.size()]);
    }

    public Object newInstance(Class requiredInterface) throws ServiceNotFoundException {
        try {
            return this.findClass(requiredInterface).newInstance();
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
    }

    private List<Class> findClassesImpl(Class requiredInterface) throws Exception {
        LogService.getLog(this.getClass()).debug(LogType.LOG, "ServiceLocator finding classes matching interface " + requiredInterface.getName());
        ArrayList<Class> classes = new ArrayList<Class>();
        this.classResolver.addClassLoader(this.resourceAccessor.toClassLoader());
        for (Class<?> clazz : this.classResolver.findImplementations(requiredInterface, this.packagesToScan.toArray(new String[this.packagesToScan.size()]))) {
            if (clazz.getAnnotation(LiquibaseService.class) != null && clazz.getAnnotation(LiquibaseService.class).skip() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || clazz.isAnonymousClass() || clazz.isSynthetic() || !Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                clazz.getConstructor(new Class[0]);
                LogService.getLog(this.getClass()).debug(LogType.LOG, clazz.getName() + " matches " + requiredInterface.getName());
                classes.add(clazz);
            }
            catch (NoSuchMethodException e) {
                LogService.getLog(this.getClass()).info(LogType.LOG, "Can not use " + clazz + " as a Liquibase service because it does not have a " + "no-argument constructor");
            }
            catch (NoClassDefFoundError e) {
                String message = "Can not use " + clazz + " as a Liquibase service because " + e.getMessage().replace("/", ".") + " is not in the classpath";
                if (e.getMessage().startsWith("org/yaml/snakeyaml")) {
                    LogService.getLog(this.getClass()).info(LogType.LOG, message);
                    continue;
                }
                LogService.getLog(this.getClass()).warning(LogType.LOG, message);
            }
        }
        return classes;
    }

    static {
        try {
            Class<?> scanner = Class.forName("Liquibase.ServiceLocator.ClrServiceLocator, Liquibase");
            instance = (ServiceLocator)scanner.newInstance();
        }
        catch (Exception e) {
            try {
                if (OSGiUtil.isLiquibaseLoadedAsOSGiBundle()) {
                    Bundle liquibaseBundle = FrameworkUtil.getBundle(ServiceLocator.class);
                    instance = new ServiceLocator(new OSGiPackageScanClassResolver(liquibaseBundle), new OSGiResourceAccessor(liquibaseBundle));
                } else {
                    instance = new ServiceLocator();
                }
            }
            catch (Throwable e1) {
                LogService.getLog(ServiceLocator.class).severe(LogType.LOG, "Cannot build ServiceLocator", e1);
            }
        }
    }
}

