/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.compliance.HardwareRule;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.compliance.SoftwareRule;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DynamicDeviceGroup;
import onl.netfishers.netshot.device.StaticDeviceGroup;
import onl.netfishers.netshot.diagnostic.Diagnostic;
import onl.netfishers.netshot.work.tasks.CheckGroupComplianceTask;
import onl.netfishers.netshot.work.tasks.CheckGroupSoftwareTask;
import onl.netfishers.netshot.work.tasks.RunDeviceGroupScriptTask;
import onl.netfishers.netshot.work.tasks.TakeGroupSnapshotTask;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DynamicDeviceGroup.class, name="DynamicDeviceGroup"), @JsonSubTypes.Type(value=StaticDeviceGroup.class, name="StaticDeviceGroup")})
public abstract class DeviceGroup {
    protected Set<Policy> appliedPolicies = new HashSet<Policy>();
    protected Set<SoftwareRule> appliedSoftwareRules = new HashSet<SoftwareRule>();
    protected Set<HardwareRule> appliedHardwareRules = new HashSet<HardwareRule>();
    protected Set<Device> cachedDevices = new HashSet<Device>();
    protected Date changeDate;
    private int version;
    protected List<CheckGroupComplianceTask> checkComplianceTasks = new ArrayList<CheckGroupComplianceTask>();
    protected List<CheckGroupSoftwareTask> checkSoftwareComplianceTasks = new ArrayList<CheckGroupSoftwareTask>();
    protected List<RunDeviceGroupScriptTask> runDeviceGroupScriptTasks = new ArrayList<RunDeviceGroupScriptTask>();
    protected List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    protected long id;
    protected String name;
    protected String folder = "";
    protected boolean hiddenFromReports = false;
    protected List<TakeGroupSnapshotTask> snapshotTasks = new ArrayList<TakeGroupSnapshotTask>();

    protected DeviceGroup() {
    }

    public DeviceGroup(String name) {
        this.name = name;
    }

    public void deleteCachedDevice(Device device) {
        this.cachedDevices.remove(device);
    }

    @OneToMany(mappedBy="targetGroup")
    public Set<Policy> getAppliedPolicies() {
        return this.appliedPolicies;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="targetGroup")
    public Set<SoftwareRule> getAppliedSoftwareRules() {
        return this.appliedSoftwareRules;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="targetGroup")
    public Set<HardwareRule> getAppliedHardwareRules() {
        return this.appliedHardwareRules;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    public Set<Device> getCachedDevices() {
        return this.cachedDevices;
    }

    @XmlElement
    public Date getChangeDate() {
        return this.changeDate;
    }

    @Version
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="deviceGroup")
    public List<CheckGroupComplianceTask> getCheckComplianceTasks() {
        return this.checkComplianceTasks;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="deviceGroup")
    public List<CheckGroupSoftwareTask> getCheckSoftwareComplianceTasks() {
        return this.checkSoftwareComplianceTasks;
    }

    public void setCheckSoftwareComplianceTasks(List<CheckGroupSoftwareTask> checkSoftwareComplianceTasks) {
        this.checkSoftwareComplianceTasks = checkSoftwareComplianceTasks;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="deviceGroup")
    public List<RunDeviceGroupScriptTask> getRunDeviceGroupScriptTasks() {
        return this.runDeviceGroupScriptTasks;
    }

    public void setRunDeviceGroupScriptTasks(List<RunDeviceGroupScriptTask> runDeviceGroupScriptTasks) {
        this.runDeviceGroupScriptTasks = runDeviceGroupScriptTasks;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="targetGroup")
    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(List<Diagnostic> diagnostics) {
        this.diagnostics = diagnostics;
    }

    @Id
    @GeneratedValue
    @XmlAttribute
    public long getId() {
        return this.id;
    }

    @NaturalId(mutable=true)
    @XmlElement
    public String getName() {
        return this.name;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="deviceGroup")
    public List<TakeGroupSnapshotTask> getSnapshotTasks() {
        return this.snapshotTasks;
    }

    public abstract void refreshCache(Session var1) throws Exception;

    public void setAppliedPolicies(Set<Policy> appliedPolicies) {
        this.appliedPolicies = appliedPolicies;
    }

    public void setAppliedSoftwareRules(Set<SoftwareRule> appliedSoftwareRules) {
        this.appliedSoftwareRules = appliedSoftwareRules;
    }

    public void setAppliedHardwareRules(Set<HardwareRule> appliedHardwareRules) {
        this.appliedHardwareRules = appliedHardwareRules;
    }

    public void setCachedDevices(Set<Device> cachedDevices) {
        this.cachedDevices = cachedDevices;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public void setCheckComplianceTasks(List<CheckGroupComplianceTask> checkComplianceTasks) {
        this.checkComplianceTasks = checkComplianceTasks;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSnapshotTasks(List<TakeGroupSnapshotTask> snapshotTasks) {
        this.snapshotTasks = snapshotTasks;
    }

    public void updateCachedDevices(Collection<Device> devices) {
        this.cachedDevices.addAll(devices);
        this.cachedDevices.retainAll(devices);
    }

    @XmlElement
    @Column(length=1000)
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    @XmlElement
    public boolean isHiddenFromReports() {
        return this.hiddenFromReports;
    }

    public void setHiddenFromReports(boolean hideInReports) {
        this.hiddenFromReports = hideInReports;
    }
}

