/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.Finder;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class DynamicDeviceGroup
extends DeviceGroup {
    private static Logger logger = LoggerFactory.getLogger(DeviceGroup.class);
    private String driver = null;
    private String query = "[Name] IS \"Example\"";

    protected DynamicDeviceGroup() {
    }

    public DynamicDeviceGroup(String name, String driver, String query) {
        super(name);
        this.driver = driver;
        this.query = query;
    }

    @XmlElement
    public String getDriver() {
        return this.driver;
    }

    @Transient
    public DeviceDriver getDeviceDriver() {
        return DeviceDriver.getDriverByName(this.driver);
    }

    @Column(length=1000)
    @XmlElement
    public String getQuery() {
        return this.query;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Transient
    public boolean validateQuery() {
        try {
            Finder finder = this.getFinder();
            this.query = finder.getFormattedQuery();
        }
        catch (Finder.Expression.FinderParseException e) {
            return false;
        }
        return true;
    }

    @Transient
    private Finder getFinder() throws Finder.Expression.FinderParseException {
        return new Finder(this.query, this.getDeviceDriver());
    }

    @Override
    public void refreshCache(Session session) throws Finder.Expression.FinderParseException, HibernateException {
        Finder finder = this.getFinder();
        Query query = session.createQuery("select d" + finder.getHql());
        finder.setVariables(query);
        List devices = query.list();
        this.updateCachedDevices(devices);
        this.query = finder.getFormattedQuery();
    }

    public void refreshCache(Session session, Device device) throws Finder.Expression.FinderParseException, HibernateException {
        logger.debug("Refreshing cache of group {} for device {}.", (Object)this.getId(), (Object)device.getId());
        long id = device.getId();
        if (this.query.isEmpty()) {
            if (this.getDeviceDriver() == null || this.getDeviceDriver().getName().equals(device.getDriver())) {
                this.cachedDevices.add(device);
            } else {
                this.cachedDevices.remove(device);
            }
        } else {
            String deviceQuery = String.format("[DEVICE] IS %d AND (%s)", id, this.query);
            logger.trace("Finder query: '{}'.", (Object)deviceQuery);
            Finder finder = new Finder(deviceQuery, this.getDeviceDriver());
            Query query = session.createQuery("select d.id" + finder.getHql());
            finder.setVariables(query);
            if (query.uniqueResult() == null) {
                this.cachedDevices.remove(device);
            } else {
                this.cachedDevices.add(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void refreshAllGroups(Device device) {
        logger.debug("Refreshing all groups for device {}.", (Object)device.getId());
        try (Session session = Database.getSession();){
            session.beginTransaction();
            List groups = session.createCriteria(DynamicDeviceGroup.class).list();
            for (DynamicDeviceGroup group : groups) {
                try {
                    group.refreshCache(session, device);
                    session.update(group);
                }
                catch (Finder.Expression.FinderParseException e) {
                    logger.error("Parse error while updating the group {}.", (Object)group.getId(), (Object)e);
                }
            }
            session.getTransaction().commit();
        }
    }
}

