/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.enumerable.AggregateLambdaFactory;
import org.apache.calcite.adapter.enumerable.SourceSorter;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;

public class OrderedAggregateLambdaFactory<TSource, TKey, TSortKey, TOrigAccumulate, TResult>
implements AggregateLambdaFactory<TSource, TOrigAccumulate, LazySource<TSource>, TResult, TKey> {
    private final Function0<TOrigAccumulate> accumulatorInitializer;
    private final List<SourceSorter<TOrigAccumulate, TSource, TSortKey>> sourceSorters;

    public OrderedAggregateLambdaFactory(Function0<TOrigAccumulate> accumulatorInitializer, List<SourceSorter<TOrigAccumulate, TSource, TSortKey>> sourceSorters) {
        this.accumulatorInitializer = accumulatorInitializer;
        this.sourceSorters = sourceSorters;
    }

    @Override
    public Function0<LazySource<TSource>> accumulatorInitializer() {
        return LazySource::new;
    }

    @Override
    public Function2<LazySource<TSource>, TSource, LazySource<TSource>> accumulatorAdder() {
        return (lazySource, source) -> {
            ((LazySource)lazySource).add(source);
            return lazySource;
        };
    }

    @Override
    public Function1<LazySource<TSource>, TResult> singleGroupResultSelector(Function1<TOrigAccumulate, TResult> resultSelector) {
        return lazySource -> {
            Object accumulator = this.accumulatorInitializer.apply();
            for (SourceSorter<TOrigAccumulate, TSource, TSortKey> acc : this.sourceSorters) {
                acc.sortAndAccumulate((Iterable<TSource>)lazySource, (TOrigAccumulate)accumulator);
            }
            return resultSelector.apply(accumulator);
        };
    }

    @Override
    public Function2<TKey, LazySource<TSource>, TResult> resultSelector(Function2<TKey, TOrigAccumulate, TResult> resultSelector) {
        return (groupByKey, lazySource) -> {
            Object accumulator = this.accumulatorInitializer.apply();
            for (SourceSorter<TOrigAccumulate, TSource, TSortKey> acc : this.sourceSorters) {
                acc.sortAndAccumulate((Iterable<TSource>)lazySource, (TOrigAccumulate)accumulator);
            }
            return resultSelector.apply(groupByKey, accumulator);
        };
    }

    public static class LazySource<TSource>
    implements Iterable<TSource> {
        private final List<TSource> list = new ArrayList<TSource>();

        private void add(TSource source) {
            this.list.add(source);
        }

        @Override
        public Iterator<TSource> iterator() {
            return this.list.iterator();
        }
    }
}

