/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.EdgeTree;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.index.PointValues;

final class Line2D
implements Component2D {
    private final double minY;
    private final double maxY;
    private final double minX;
    private final double maxX;
    private final EdgeTree tree;

    private Line2D(Line line) {
        this.minY = line.minLat;
        this.maxY = line.maxLat;
        this.minX = line.minLon;
        this.maxX = line.maxLon;
        this.tree = EdgeTree.createTree(line.getLons(), line.getLats());
    }

    private Line2D(XYLine line) {
        this.minY = line.minY;
        this.maxY = line.maxY;
        this.minX = line.minX;
        this.maxX = line.maxX;
        this.tree = EdgeTree.createTree(XYEncodingUtils.floatArrayToDoubleArray(line.getX()), XYEncodingUtils.floatArrayToDoubleArray(line.getY()));
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        if (Component2D.containsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY)) {
            return this.tree.isPointOnLine(x, y);
        }
        return false;
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public PointValues.Relation relateTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (ax == bx && bx == cx && ay == by && by == cy) {
            if (this.tree.isPointOnLine(ax, ay)) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
        } else {
            if (ax == cx && ay == cy) {
                if (this.tree.crossesLine(minX, maxX, minY, maxY, ax, ay, bx, by, true)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (ax == bx && ay == by) {
                if (this.tree.crossesLine(minX, maxX, minY, maxY, bx, by, cx, cy, true)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (bx == cx && by == cy) {
                if (this.tree.crossesLine(minX, maxX, minY, maxY, cx, cy, ax, ay, true)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, ax, ay, bx, by, cx, cy) || this.tree.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, true)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, boolean ab, double bx, double by, boolean bc, double cx, double cy, boolean ca) {
        if (ax == bx && ay == by || ax == cx && ay == cy || bx == cx && by == cy) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.tree.crossesLine(minX, maxX, minY, maxY, ax, ay, bx, by, true)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, bx, by, cx, cy, true)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, cx, cy, ax, ay, true)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, ax, ay, bx, by, cx, cy)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    static Component2D create(Line line) {
        return new Line2D(line);
    }

    static Component2D create(XYLine line) {
        return new Line2D(line);
    }
}

