/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.LuceneTestCase;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class TestRuleIgnoreTestSuites
implements TestRule {
    public static final String PROPERTY_RUN_NESTED = "tests.runnested";

    public Statement apply(final Statement s, final Description d) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (NestedTestSuite.class.isAssignableFrom(d.getTestClass())) {
                    LuceneTestCase.assumeTrue("Nested suite class ignored (started as stand-alone).", TestRuleIgnoreTestSuites.isRunningNested());
                }
                s.evaluate();
            }
        };
    }

    public static boolean isRunningNested() {
        return Boolean.getBoolean(PROPERTY_RUN_NESTED);
    }

    public static interface NestedTestSuite {
    }
}

