/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.protocol.Gt06ProtocolDecoder;

public class TopinProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS = 16;
    public static final int MSG_GPS_OFFLINE = 17;
    public static final int MSG_STATUS = 19;
    public static final int MSG_WIFI_OFFLINE = 23;
    public static final int MSG_WIFI = 105;

    public TopinProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int length, int type, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(30840);
            response.writeByte(length);
            response.writeByte(type);
            response.writeBytes(content);
            response.writeByte(13);
            response.writeByte(10);
            content.release();
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        int length = buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        if (type == 1) {
            String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            ByteBuf content = Unpooled.buffer();
            content.writeByte(deviceSession != null ? 1 : 68);
            this.sendResponse(channel, length, type, content);
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (type == 16 || type == 17) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            ByteBuf time = buf.slice(buf.readerIndex(), 6);
            Gt06ProtocolDecoder.decodeGps(position, buf, false, TimeZone.getTimeZone("UTC"));
            ByteBuf content = Unpooled.buffer();
            content.writeBytes(time);
            this.sendResponse(channel, length, type, content);
            return position;
        }
        if (type == 19) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            short battery = buf.readUnsignedByte();
            short firmware = buf.readUnsignedByte();
            short timezone = buf.readUnsignedByte();
            short interval = buf.readUnsignedByte();
            short signal = 0;
            if (length >= 7) {
                signal = buf.readUnsignedByte();
                position.set("rssi", Integer.valueOf(signal));
            }
            position.set("batteryLevel", Integer.valueOf(battery));
            position.set("versionFw", Integer.valueOf(firmware));
            ByteBuf content = Unpooled.buffer();
            content.writeByte((int)battery);
            content.writeByte((int)firmware);
            content.writeByte((int)timezone);
            content.writeByte((int)interval);
            if (length >= 7) {
                content.writeByte((int)signal);
            }
            this.sendResponse(channel, length, type, content);
            return position;
        }
        if (type == 105 || type == 23) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            ByteBuf time = buf.readSlice(6);
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(time, 2)).setMonth(BcdUtil.readInteger(time, 2)).setDay(BcdUtil.readInteger(time, 2)).setHour(BcdUtil.readInteger(time, 2)).setMinute(BcdUtil.readInteger(time, 2)).setSecond(BcdUtil.readInteger(time, 2));
            time.resetReaderIndex();
            this.getLastLocation(position, dateBuilder.getDate());
            Network network = new Network();
            for (int i = 0; i < length; ++i) {
                String mac = String.format("%02x:%02x:%02x:%02x:%02x:%02x", buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                network.addWifiAccessPoint(WifiAccessPoint.from(mac, buf.readUnsignedByte()));
            }
            int cellCount = buf.readUnsignedByte();
            int mcc = buf.readUnsignedShort();
            short mnc = buf.readUnsignedByte();
            for (int i = 0; i < cellCount; ++i) {
                network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
            }
            position.setNetwork(network);
            ByteBuf content = Unpooled.buffer();
            content.writeBytes(time);
            this.sendResponse(channel, length, type, content);
            return position;
        }
        return null;
    }
}

