/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.RuntimeEnvironment;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.SkippedChangeSetVisitor;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.LoggerContext;
import liquibase.util.StringUtils;

public class ChangeLogIterator {
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;
    private Set<String> seenChangeSets = new HashSet<String>();

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter ... changeSetFilters) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public ChangeLogIterator(List<RanChangeSet> changeSetList, DatabaseChangeLog changeLog, ChangeSetFilter ... changeSetFilters) {
        final ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        for (RanChangeSet ranChangeSet : changeSetList) {
            ChangeSet changeSet = changeLog.getChangeSet(ranChangeSet);
            if (changeSet == null) continue;
            if (changeLog.ignoreClasspathPrefix()) {
                changeSet.setFilePath(ranChangeSet.getChangeLog());
            }
            changeSets.add(changeSet);
        }
        this.databaseChangeLog = new DatabaseChangeLog(){

            @Override
            public List<ChangeSet> getChangeSets() {
                return changeSets;
            }

            @Override
            public String toString() {
                return "";
            }
        };
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ChangeSetVisitor visitor, RuntimeEnvironment env) throws LiquibaseException {
        Logger log = LogService.getLog(this.getClass());
        this.databaseChangeLog.setRuntimeEnvironment(env);
        try (LoggerContext ignored = LogService.pushContext("databaseChangeLog", this.databaseChangeLog);){
            ArrayList<ChangeSet> changeSetList = new ArrayList<ChangeSet>(this.databaseChangeLog.getChangeSets());
            if (visitor.getDirection().equals((Object)ChangeSetVisitor.Direction.REVERSE)) {
                Collections.reverse(changeSetList);
            }
            for (ChangeSet changeSet : changeSetList) {
                boolean shouldVisit = true;
                HashSet<ChangeSetFilterResult> reasonsAccepted = new HashSet<ChangeSetFilterResult>();
                HashSet<ChangeSetFilterResult> reasonsDenied = new HashSet<ChangeSetFilterResult>();
                if (this.changeSetFilters != null) {
                    for (ChangeSetFilter filter : this.changeSetFilters) {
                        ChangeSetFilterResult acceptsResult = filter.accepts(changeSet);
                        if (acceptsResult.isAccepted()) {
                            reasonsAccepted.add(acceptsResult);
                            continue;
                        }
                        shouldVisit = false;
                        reasonsDenied.add(acceptsResult);
                        break;
                    }
                }
                LoggerContext ignored2 = LogService.pushContext("changeSet", changeSet);
                Throwable throwable = null;
                try {
                    if (shouldVisit && !this.alreadySaw(changeSet)) {
                        visitor.visit(changeSet, this.databaseChangeLog, env.getTargetDatabase(), reasonsAccepted);
                        this.markSeen(changeSet);
                        continue;
                    }
                    if (!(visitor instanceof SkippedChangeSetVisitor)) continue;
                    ((SkippedChangeSetVisitor)((Object)visitor)).skipped(changeSet, this.databaseChangeLog, env.getTargetDatabase(), reasonsDenied);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored2 == null) continue;
                    if (throwable != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored2.close();
                }
            }
        }
        finally {
            this.databaseChangeLog.setRuntimeEnvironment(null);
        }
    }

    protected void markSeen(ChangeSet changeSet) {
        if (changeSet.key == null) {
            changeSet.key = this.createKey(changeSet);
        }
        this.seenChangeSets.add(changeSet.key);
    }

    protected String createKey(ChangeSet changeSet) {
        Labels labels = changeSet.getLabels();
        ContextExpression contexts = changeSet.getContexts();
        return changeSet.toString(true) + ":" + (labels == null ? null : labels.toString()) + ":" + (contexts == null ? null : contexts.toString()) + ":" + StringUtils.join(changeSet.getDbmsSet(), ",");
    }

    protected boolean alreadySaw(ChangeSet changeSet) {
        if (changeSet.key == null) {
            changeSet.key = this.createKey(changeSet);
        }
        return this.seenChangeSets.contains(changeSet.key);
    }

    public List<ChangeSetFilter> getChangeSetFilters() {
        return Collections.unmodifiableList(this.changeSetFilters);
    }
}

