/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoPooledConnection;
import virtuoso.jdbc4.VirtuosoXAResource;

public class VirtuosoXAConnection
implements XAConnection {
    private VirtuosoPooledConnection pconn;
    private VirtuosoXAResource resource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtuosoXAConnection(VirtuosoPooledConnection virtuosoPooledConnection, String string, int n) throws SQLException {
        this.pconn = virtuosoPooledConnection;
        this.pconn.getVirtuosoConnection().xa_connection = this;
        this.resource = new VirtuosoXAResource(this.pconn, string, n);
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("new VirtuosoXAConnection (connection=" + virtuosoPooledConnection.hashCode() + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.getVirtuosoXAResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtuosoXAResource getVirtuosoXAResource() throws VirtuosoException {
        if (this.pconn.isClosed()) {
            throw new VirtuosoException("Connection is closed.", -1);
        }
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXAConnection.getVirtuosoXAResource () ret " + this.resource.hashCode() + " :" + this.hashCode());
                VirtuosoFuture.rpc_log.flush();
            }
        }
        return this.resource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.pconn.isClosed()) {
            throw new VirtuosoException("Connection is closed.", -1);
        }
        ConnectionWrapper connectionWrapper = (ConnectionWrapper)this.pconn.getConnection();
        connectionWrapper.setXAResource(this.resource);
        return connectionWrapper;
    }

    @Override
    public void close() throws SQLException {
        this.pconn.close();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.pconn.addConnectionEventListener(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.pconn.removeConnectionEventListener(connectionEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
    }
}

