/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public final class QueryResultKey
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(QueryResultKey.class);
    private static final long BASE_SF_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SortField.class);
    final Query query;
    final Sort sort;
    final SortField[] sfields;
    final List<Query> filters;
    final int nc_flags;
    private final int hc;
    private final long ramBytesUsed;
    private static SortField[] defaultSort = new SortField[0];

    public QueryResultKey(Query query, List<Query> filters, Sort sort, int nc_flags) {
        this.query = query;
        this.sort = sort;
        this.filters = filters;
        this.nc_flags = nc_flags;
        int h = query.hashCode();
        if (filters != null) {
            for (Query filt : filters) {
                h += filt.hashCode();
            }
        }
        this.sfields = this.sort != null ? this.sort.getSort() : defaultSort;
        long ramSfields = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        for (SortField sf : this.sfields) {
            h = h * 29 + sf.hashCode();
            ramSfields += BASE_SF_RAM_BYTES_USED + RamUsageEstimator.sizeOfObject((Object)sf.getField());
        }
        this.hc = h;
        this.ramBytesUsed = BASE_RAM_BYTES_USED + ramSfields + RamUsageEstimator.sizeOfObject((Object)query, (long)1024L) + RamUsageEstimator.sizeOfObject(filters, (long)1024L);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResultKey)) {
            return false;
        }
        QueryResultKey other = (QueryResultKey)o;
        if (this.hc != other.hc) {
            return false;
        }
        if (this.sfields.length != other.sfields.length) {
            return false;
        }
        if (!this.query.equals((Object)other.query)) {
            return false;
        }
        if (!QueryResultKey.unorderedCompare(this.filters, other.filters)) {
            return false;
        }
        for (int i = 0; i < this.sfields.length; ++i) {
            SortField sf1 = this.sfields[i];
            SortField sf2 = other.sfields[i];
            if (sf1.equals((Object)sf2)) continue;
            return false;
        }
        return true;
    }

    private static boolean unorderedCompare(List<Query> fqList1, List<Query> fqList2) {
        if (fqList1 == fqList2) {
            return true;
        }
        if (fqList1 == null || fqList2 == null) {
            return false;
        }
        int sz = fqList1.size();
        if (sz != fqList2.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (fqList1.get(i).equals((Object)fqList2.get(i))) continue;
            return QueryResultKey.unorderedCompare(fqList1, fqList2, i);
        }
        return true;
    }

    private static boolean unorderedCompare(List<Query> fqList1, List<Query> fqList2, int start) {
        assert (null != fqList1);
        assert (null != fqList2);
        int sz = fqList1.size();
        assert (fqList2.size() == sz);
        ArrayList<Query> set2 = new ArrayList<Query>(fqList2.subList(start, sz));
        for (int i = start; i < sz; ++i) {
            Query q1 = fqList1.get(i);
            if (set2.remove(q1)) continue;
            return false;
        }
        return set2.isEmpty();
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

