/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexDeletionPolicyWrapper
extends IndexDeletionPolicy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final IndexDeletionPolicy deletionPolicy;
    private final SolrSnapshotMetaDataManager snapshotMgr;
    private volatile Map<Long, IndexCommit> knownCommits = new ConcurrentHashMap<Long, IndexCommit>();
    private volatile IndexCommit latestCommit;
    private final Map<Long, Long> reserves = new ConcurrentHashMap<Long, Long>();
    private final Map<Long, AtomicInteger> savedCommits = new ConcurrentHashMap<Long, AtomicInteger>();

    public IndexDeletionPolicyWrapper(IndexDeletionPolicy deletionPolicy, SolrSnapshotMetaDataManager snapshotMgr) {
        this.deletionPolicy = deletionPolicy;
        this.snapshotMgr = snapshotMgr;
    }

    public IndexCommit getLatestCommit() {
        return this.latestCommit;
    }

    public synchronized IndexCommit getAndSaveLatestCommit() {
        IndexCommit commit = this.getLatestCommit();
        if (null != commit) {
            this.saveCommitPoint(commit.getGeneration());
        }
        return commit;
    }

    public synchronized IndexCommit getAndSaveCommitPoint(Long generation) {
        if (null == generation) {
            throw new NullPointerException("generation to get and save must not be null");
        }
        IndexCommit commit = this.knownCommits.get(generation);
        if (null != commit && commit.isDeleted() || null == commit && null != this.latestCommit && generation < this.latestCommit.getGeneration()) {
            throw new IllegalStateException("Specified index generation is too old to be saved: " + generation);
        }
        AtomicInteger refCount = this.savedCommits.computeIfAbsent(generation, s -> new AtomicInteger());
        int currentCount = refCount.incrementAndGet();
        log.debug("Saving generation={}, refCount={}", (Object)generation, (Object)currentCount);
        return commit;
    }

    public IndexDeletionPolicy getWrappedDeletionPolicy() {
        return this.deletionPolicy;
    }

    public void setReserveDuration(Long indexGen, long reserveTime) {
        long reserveAsNanoTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(reserveTime, TimeUnit.MILLISECONDS);
        this.reserves.merge(indexGen, reserveAsNanoTime, BinaryOperator.maxBy(Comparator.naturalOrder()));
    }

    private void cleanReserves() {
        long currentNanoTime = System.nanoTime();
        this.reserves.entrySet().removeIf(e -> (Long)e.getValue() < currentNanoTime);
    }

    private List<IndexCommitWrapper> wrap(List<? extends IndexCommit> list) {
        ArrayList<IndexCommitWrapper> result = new ArrayList<IndexCommitWrapper>();
        for (IndexCommit indexCommit : list) {
            result.add(new IndexCommitWrapper(indexCommit));
        }
        return result;
    }

    public synchronized void saveCommitPoint(Long generation) {
        this.getAndSaveCommitPoint(generation);
    }

    public synchronized void releaseCommitPoint(IndexCommit commit) {
        if (null != commit) {
            this.releaseCommitPoint(commit.getGeneration());
        }
    }

    public synchronized void releaseCommitPoint(Long generation) {
        if (null == generation) {
            return;
        }
        AtomicInteger refCount = this.savedCommits.get(generation);
        if (null != refCount) {
            int currentCount = refCount.decrementAndGet();
            log.debug("Released generation={}, refCount={}", (Object)generation, (Object)currentCount);
            if (currentCount <= 0) {
                this.savedCommits.remove(generation);
            }
        }
    }

    public void onInit(List<? extends IndexCommit> list) throws IOException {
        List<IndexCommitWrapper> wrapperList = this.wrap(list);
        this.updateLatestCommit(wrapperList);
        this.deletionPolicy.onInit(wrapperList);
        this.updateKnownCommitPoints(wrapperList);
        this.cleanReserves();
    }

    public void onCommit(List<? extends IndexCommit> list) throws IOException {
        List<IndexCommitWrapper> wrapperList = this.wrap(list);
        this.updateLatestCommit(wrapperList);
        this.deletionPolicy.onCommit(wrapperList);
        this.updateKnownCommitPoints(wrapperList);
        this.cleanReserves();
    }

    @Deprecated
    public IndexCommit getCommitPoint(Long gen) {
        return this.knownCommits.get(gen);
    }

    public Map<Long, IndexCommit> getCommits() {
        return Collections.unmodifiableMap(this.knownCommits);
    }

    private synchronized void updateLatestCommit(List<IndexCommitWrapper> list) {
        assert (null != list);
        if (list.isEmpty()) {
            return;
        }
        IndexCommitWrapper newLast = list.get(list.size() - 1);
        assert (!newLast.isDeleted()) : "Code flaw: Last commit already deleted, call this method before delegating onCommit/onInit";
        this.latestCommit = newLast.delegate;
    }

    private synchronized void updateKnownCommitPoints(List<IndexCommitWrapper> list) {
        assert (null != list);
        assert (list.isEmpty() || null != this.latestCommit) : "Code flaw: How is latestCommit not set yet?";
        assert (null == this.latestCommit || !this.latestCommit.isDeleted()) : "Code flaw: How did the latestCommit get set but deleted?";
        assert (list.isEmpty() || this.latestCommit == list.get((int)(list.size() - 1)).delegate) : "Code flaw, updateLatestCommit() should have already been called";
        ConcurrentHashMap<Long, IndexCommit> map = new ConcurrentHashMap<Long, IndexCommit>();
        for (IndexCommitWrapper wrapper : list) {
            if (wrapper.isDeleted()) continue;
            map.put(wrapper.delegate.getGeneration(), wrapper.delegate);
        }
        this.knownCommits = map;
    }

    public static long getCommitTimestamp(IndexCommit commit) throws IOException {
        Map commitData = commit.getUserData();
        String commitTime = (String)commitData.get("commitTimeMSec");
        if (commitTime != null) {
            return Long.parseLong(commitTime);
        }
        return 0L;
    }

    private class IndexCommitWrapper
    extends IndexCommit {
        final IndexCommit delegate;

        IndexCommitWrapper(IndexCommit delegate) {
            this.delegate = delegate;
        }

        public String getSegmentsFileName() {
            return this.delegate.getSegmentsFileName();
        }

        public Collection getFileNames() throws IOException {
            return this.delegate.getFileNames();
        }

        public Directory getDirectory() {
            return this.delegate.getDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Long gen = this.delegate.getGeneration();
            IndexDeletionPolicyWrapper indexDeletionPolicyWrapper = IndexDeletionPolicyWrapper.this;
            synchronized (indexDeletionPolicyWrapper) {
                if (System.nanoTime() < IndexDeletionPolicyWrapper.this.reserves.getOrDefault(gen, 0L) || IndexDeletionPolicyWrapper.this.savedCommits.containsKey(gen) || IndexDeletionPolicyWrapper.this.snapshotMgr.isSnapshotted(gen) || null != IndexDeletionPolicyWrapper.this.latestCommit && gen.longValue() == IndexDeletionPolicyWrapper.this.latestCommit.getGeneration()) {
                    return;
                }
                log.debug("Deleting generation={}", (Object)gen);
                this.delegate.delete();
            }
        }

        public int getSegmentCount() {
            return this.delegate.getSegmentCount();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public long getGeneration() {
            return this.delegate.getGeneration();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDeleted() {
            IndexDeletionPolicyWrapper indexDeletionPolicyWrapper = IndexDeletionPolicyWrapper.this;
            synchronized (indexDeletionPolicyWrapper) {
                return this.delegate.isDeleted();
            }
        }

        public Map getUserData() throws IOException {
            return this.delegate.getUserData();
        }
    }
}

