/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.routing.AffinityReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.stats.InstrumentedHttpListenerFactory;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized,
SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_SCHEME = "http";
    private ExecutorService commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory("httpShardExecutor"), false);
    protected volatile Http2SolrClient defaultClient;
    protected InstrumentedHttpListenerFactory httpListenerFactory;
    private LBHttp2SolrClient loadbalancer;
    int corePoolSize = 0;
    int maximumPoolSize = Integer.MAX_VALUE;
    int keepAliveTime = 5;
    int queueSize = -1;
    int permittedLoadBalancerRequestsMinimumAbsolute = 0;
    float permittedLoadBalancerRequestsMaximumFraction = 1.0f;
    boolean accessPolicy = false;
    private WhitelistHostChecker whitelistHostChecker = null;
    private String scheme = null;
    private InstrumentedHttpListenerFactory.NameStrategy metricNameStrategy;
    protected final Random r = new Random();
    private RequestReplicaListTransformerGenerator requestReplicaListTransformerGenerator = new RequestReplicaListTransformerGenerator();
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE = "loadBalancerRequestsMinimumAbsolute";
    static final String LOAD_BALANCER_REQUESTS_MAX_FRACTION = "loadBalancerRequestsMaximumFraction";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";
    public static final String INIT_SHARDS_WHITELIST = "shardsWhitelist";
    static final String INIT_SOLR_DISABLE_SHARDS_WHITELIST = "solr.disable.shardsWhitelist";
    static final String SET_SOLR_DISABLE_SHARDS_WHITELIST_CLUE = " set -Dsolr.disable.shardsWhitelist=true to disable shards whitelist checks";

    @Override
    public ShardHandler getShardHandler() {
        return this.getShardHandler(this.defaultClient);
    }

    public ShardHandler getShardHandler(Http2SolrClient httpClient) {
        return new HttpShardHandler(this, httpClient);
    }

    @Deprecated
    public ShardHandler getShardHandler(final HttpClient httpClient) {
        return new HttpShardHandler(this, null){

            @Override
            protected NamedList<Object> request(String url, SolrRequest req) throws IOException, SolrServerException {
                try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(url).withHttpClient(httpClient)).build();){
                    NamedList namedList = client.request(req);
                    return namedList;
                }
            }
        };
    }

    public WhitelistHostChecker getWhitelistHostChecker() {
        return this.whitelistHostChecker;
    }

    @Deprecated
    static boolean doGetDisableShardsWhitelist() {
        return HttpShardHandlerFactory.getDisableShardsWhitelist();
    }

    private static boolean getDisableShardsWhitelist() {
        return Boolean.getBoolean(INIT_SOLR_DISABLE_SHARDS_WHITELIST);
    }

    private static NamedList<?> getNamedList(Object val) {
        if (val instanceof NamedList) {
            return (NamedList)val;
        }
        throw new IllegalArgumentException("Invalid config for replicaRouting; expected NamedList, but got " + val);
    }

    private static String checkDefaultReplicaListTransformer(NamedList<?> c, String setTo, String extantDefaultRouting) {
        if (!Boolean.TRUE.equals(c.getBooleanArg("default"))) {
            return null;
        }
        if (extantDefaultRouting == null) {
            return setTo;
        }
        throw new IllegalArgumentException("more than one routing scheme marked as default");
    }

    private void initReplicaListTransformers(NamedList routingConfig) {
        String defaultRouting = null;
        AffinityReplicaListTransformerFactory stableRltFactory = null;
        if (routingConfig != null && routingConfig.size() > 0) {
            Iterator iter = routingConfig.iterator();
            do {
                String key;
                Map.Entry e = (Map.Entry)iter.next();
                switch (key = (String)e.getKey()) {
                    case "random": {
                        defaultRouting = HttpShardHandlerFactory.checkDefaultReplicaListTransformer(HttpShardHandlerFactory.getNamedList(e.getValue()), key, defaultRouting);
                        break;
                    }
                    case "stable": {
                        NamedList<?> c = HttpShardHandlerFactory.getNamedList(e.getValue());
                        defaultRouting = HttpShardHandlerFactory.checkDefaultReplicaListTransformer(c, key, defaultRouting);
                        stableRltFactory = new AffinityReplicaListTransformerFactory(c);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid replica routing spec name: " + key);
                    }
                }
            } while (iter.hasNext());
        }
        if (stableRltFactory == null) {
            stableRltFactory = new AffinityReplicaListTransformerFactory();
        }
        Object defaultRltFactory = "stable".equals(defaultRouting) ? stableRltFactory : RequestReplicaListTransformerGenerator.RANDOM_RLTF;
        this.requestReplicaListTransformerGenerator = new RequestReplicaListTransformerGenerator((ReplicaListTransformerFactory)defaultRltFactory, (ReplicaListTransformerFactory)stableRltFactory);
    }

    @Override
    public void init(PluginInfo info) {
        StringBuilder sb = new StringBuilder();
        NamedList args = info.initArgs;
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, null, sb);
        if (StringUtils.endsWith((CharSequence)this.scheme, (CharSequence)"://")) {
            this.scheme = StringUtils.removeEnd((String)this.scheme, (String)"://");
        }
        String strategy = this.getParameter(args, "metricNameStrategy", "queryLessURLAndMethod", sb);
        this.metricNameStrategy = InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.get(strategy);
        if (this.metricNameStrategy == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + strategy + " found. Must be one of: " + InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, this.corePoolSize, sb);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, this.maximumPoolSize, sb);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, this.keepAliveTime, sb);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, this.queueSize, sb);
        this.permittedLoadBalancerRequestsMinimumAbsolute = this.getParameter(args, LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE, this.permittedLoadBalancerRequestsMinimumAbsolute, sb);
        this.permittedLoadBalancerRequestsMaximumFraction = this.getParameter(args, LOAD_BALANCER_REQUESTS_MAX_FRACTION, Float.valueOf(this.permittedLoadBalancerRequestsMaximumFraction), sb).floatValue();
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, this.accessPolicy, sb);
        this.whitelistHostChecker = new WhitelistHostChecker(args == null ? null : (String)args.get(INIT_SHARDS_WHITELIST), !HttpShardHandlerFactory.getDisableShardsWhitelist());
        log.info("Host whitelist initialized: {}", (Object)this.whitelistHostChecker);
        String v = System.getProperty("tests.shardhandler.randomSeed");
        if (v != null) {
            this.r.setSeed(Long.parseLong(v));
        }
        AbstractQueue blockingQueue = this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy);
        this.commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, blockingQueue, (ThreadFactory)new DefaultSolrThreadFactory("httpShardExecutor"));
        this.httpListenerFactory = new InstrumentedHttpListenerFactory(this.metricNameStrategy);
        int connectionTimeout = this.getParameter(args, "connTimeout", 60000, sb);
        int maxConnectionsPerHost = this.getParameter(args, "maxConnectionsPerHost", 100000, sb);
        int soTimeout = this.getParameter(args, "socketTimeout", 600000, sb);
        this.defaultClient = new Http2SolrClient.Builder().connectionTimeout(connectionTimeout).idleTimeout(soTimeout).maxConnectionsPerHost(maxConnectionsPerHost).build();
        this.defaultClient.addListenerFactory((HttpListenerFactory)this.httpListenerFactory);
        this.loadbalancer = new LBHttp2SolrClient(this.defaultClient, new String[0]);
        this.initReplicaListTransformers(this.getParameter(args, "replicaRouting", null, sb));
        log.debug("created with {}", (Object)sb);
    }

    @Override
    public void setSecurityBuilder(HttpClientBuilderPlugin clientBuilderPlugin) {
        clientBuilderPlugin.setup(this.defaultClient);
    }

    protected <T> T getParameter(NamedList initArgs, String configKey, T defaultValue, StringBuilder sb) {
        Object toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            T t = toReturn = temp != null ? temp : defaultValue;
        }
        if (sb != null && toReturn != null) {
            sb.append(configKey).append(" : ").append(toReturn).append(",");
        }
        return toReturn;
    }

    @Override
    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.commExecutor);
        }
        finally {
            try {
                if (this.loadbalancer != null) {
                    this.loadbalancer.close();
                }
            }
            finally {
                if (this.defaultClient != null) {
                    IOUtils.closeQuietly((Closeable)this.defaultClient);
                }
            }
        }
    }

    public LBSolrClient.Rsp makeLoadBalancedRequest(QueryRequest req, List<String> urls) throws SolrServerException, IOException {
        return this.loadbalancer.request(this.newLBHttpSolrClientReq(req, urls));
    }

    protected LBSolrClient.Req newLBHttpSolrClientReq(QueryRequest req, List<String> urls) {
        int numServersToTry = (int)Math.floor((float)urls.size() * this.permittedLoadBalancerRequestsMaximumFraction);
        if (numServersToTry < this.permittedLoadBalancerRequestsMinimumAbsolute) {
            numServersToTry = this.permittedLoadBalancerRequestsMinimumAbsolute;
        }
        return new LBSolrClient.Req((SolrRequest)req, urls, Integer.valueOf(numServersToTry));
    }

    public List<String> buildURLList(String shard) {
        List urls = StrUtils.splitSmart((String)shard, (String)"|", (boolean)true);
        for (int i = 0; i < urls.size(); ++i) {
            urls.set(i, this.buildUrl((String)urls.get(i)));
        }
        return urls;
    }

    protected ReplicaListTransformer getReplicaListTransformer(SolrQueryRequest req) {
        ZkController zkController;
        SolrParams params = req.getParams();
        SolrCore core = req.getCore();
        ZkController zkController2 = zkController = core == null ? null : core.getCoreContainer().getZkController();
        if (zkController != null) {
            return this.requestReplicaListTransformerGenerator.getReplicaListTransformer(params, zkController.getZkStateReader().getClusterProperties().getOrDefault("defaultShardPreferences", "").toString(), zkController.getNodeName(), zkController.getBaseUrl(), zkController.getSysPropsCacher());
        }
        return this.requestReplicaListTransformerGenerator.getReplicaListTransformer(params);
    }

    public CompletionService<ShardResponse> newCompletionService() {
        return new ExecutorCompletionService<ShardResponse>(this.commExecutor);
    }

    private String buildUrl(String url) {
        if (!URLUtil.hasScheme((String)url)) {
            return (String)StringUtils.defaultIfEmpty((CharSequence)this.scheme, (CharSequence)DEFAULT_SCHEME) + "://" + url;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.scheme)) {
            return this.scheme + "://" + URLUtil.removeScheme((String)url);
        }
        return url;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String tag, String scope) {
        String expandedScope = SolrMetricManager.mkName(scope, SolrInfoBean.Category.QUERY.name());
        this.httpListenerFactory.initializeMetrics(manager, registry, tag, expandedScope);
        this.commExecutor = MetricUtils.instrumentedExecutorService(this.commExecutor, null, manager.registry(registry), SolrMetricManager.mkName("httpShardExecutor", expandedScope, "threadPool"));
    }

    public static class WhitelistHostChecker {
        private final Set<String> whitelistHosts;
        private final boolean whitelistHostCheckingEnabled;

        public WhitelistHostChecker(String whitelistStr, boolean enabled) {
            this.whitelistHosts = WhitelistHostChecker.implGetShardsWhitelist(whitelistStr);
            this.whitelistHostCheckingEnabled = enabled;
        }

        static final Set<String> implGetShardsWhitelist(String shardsWhitelist) {
            if (shardsWhitelist != null && !shardsWhitelist.isEmpty()) {
                return StrUtils.splitSmart((String)shardsWhitelist, (char)',').stream().map(String::trim).map(hostUrl -> {
                    URL url;
                    try {
                        url = !hostUrl.startsWith("http://") && !hostUrl.startsWith("https://") ? new URL("http://" + hostUrl) : new URL((String)hostUrl);
                    }
                    catch (MalformedURLException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid URL syntax in \"shardsWhitelist\": " + shardsWhitelist, (Throwable)e);
                    }
                    if (url.getHost() == null || url.getPort() < 0) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid URL syntax in \"shardsWhitelist\": " + shardsWhitelist);
                    }
                    return url.getHost() + ":" + url.getPort();
                }).collect(Collectors.toSet());
            }
            return null;
        }

        protected void checkWhitelist(String shardsParamValue, List<String> shardUrls) {
            this.checkWhitelist(null, shardsParamValue, shardUrls);
        }

        protected void checkWhitelist(ClusterState clusterState, String shardsParamValue, List<String> shardUrls) {
            if (!this.whitelistHostCheckingEnabled) {
                return;
            }
            Set<Object> localWhitelistHosts = this.whitelistHosts == null && clusterState != null ? this.generateWhitelistFromLiveNodes(clusterState) : (this.whitelistHosts != null ? this.whitelistHosts : Collections.emptySet());
            shardUrls.stream().map(String::trim).forEach(shardUrl -> {
                URL url;
                try {
                    url = !shardUrl.startsWith("http://") && !shardUrl.startsWith("https://") ? new URL("http://" + shardUrl) : new URL((String)shardUrl);
                }
                catch (MalformedURLException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid URL syntax in \"shards\" parameter: " + shardsParamValue, (Throwable)e);
                }
                if (url.getHost() == null || url.getPort() < 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid URL syntax in \"shards\" parameter: " + shardsParamValue);
                }
                if (!localWhitelistHosts.contains(url.getHost() + ":" + url.getPort())) {
                    log.warn("The 'shards' parameter value '" + shardsParamValue + "' contained value(s) not on the shards whitelist (" + localWhitelistHosts + "), shardUrl:" + shardUrl);
                    throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "The 'shards' parameter value '" + shardsParamValue + "' contained value(s) not on the shards whitelist. shardUrl:" + shardUrl + "." + HttpShardHandlerFactory.SET_SOLR_DISABLE_SHARDS_WHITELIST_CLUE);
                }
            });
        }

        Set<String> generateWhitelistFromLiveNodes(ClusterState clusterState) {
            return clusterState.getLiveNodes().stream().map(liveNode -> liveNode.substring(0, liveNode.indexOf(95))).collect(Collectors.toSet());
        }

        public boolean hasExplicitWhitelist() {
            return this.whitelistHosts != null;
        }

        public boolean isWhitelistHostCheckingEnabled() {
            return this.whitelistHostCheckingEnabled;
        }

        @VisibleForTesting
        Set<String> getWhitelistHosts() {
            return this.whitelistHosts;
        }

        public String toString() {
            return "WhitelistHostChecker [whitelistHosts=" + this.whitelistHosts + ", whitelistHostCheckingEnabled=" + this.whitelistHostCheckingEnabled + "]";
        }
    }
}

