/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.events.QuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.RemoteEvent;
import com.carrotsearch.ant.tasks.junit4.events.Serializer$1;
import com.carrotsearch.ant.tasks.junit4.events.Serializer$2;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;

public class Serializer
implements Closeable {
    private final Object lock = new Object();
    private Writer writer;
    private JsonWriter jsonWriter;
    private final ArrayDeque events = new ArrayDeque();
    private volatile Throwable doForcedShutdown;
    private Thread forceCloseDaemon;
    private AtomicBoolean forceCloseDaemonQuit = new AtomicBoolean();
    private final AtomicBoolean isFlushing = new AtomicBoolean();

    public Serializer(OutputStream outputStream) {
        this.writer = new OutputStreamWriter(outputStream, Charsets.UTF_8);
        this.jsonWriter = new JsonWriter(this.writer);
        this.jsonWriter.setIndent(" ");
        this.jsonWriter.setLenient(true);
        this.forceCloseDaemon = new Serializer$1(this, "JUnit4-serializer-daemon");
        this.forceCloseDaemon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer serialize(RemoteEvent remoteEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer == null) {
                throw new IOException("Serializer already closed.");
            }
            this.events.addLast(remoteEvent);
            if (this.events.size() > 1) {
                return this;
            }
            this.flushQueue();
            return this;
        }
    }

    private void flushQueue() {
        if (!Thread.holdsLock(this.lock)) {
            throw new IllegalStateException("Must be holding a lock on flushing.");
        }
        if (this.isFlushing.getAndSet(true)) {
            return;
        }
        try {
            while (!this.events.isEmpty()) {
                if (this.writer == null) {
                    throw new IOException("Serializer already closed, with " + this.events.size() + " events on queue.");
                }
                RemoteEvent remoteEvent = (RemoteEvent)this.events.removeFirst();
                try {
                    AccessController.doPrivileged(new Serializer$2(this, remoteEvent));
                }
                catch (Throwable throwable) {
                    this.doForcedShutdown = throwable;
                    break;
                }
            }
        }
        finally {
            this.isFlushing.set(false);
        }
        if (this.doForcedShutdown != null) {
            while (true) {
                try {
                    while (true) {
                        this.forceCloseDaemon.join();
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.flushQueue();
                this.writer.flush();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.serialize(new QuitEvent());
                this.flushQueue();
                this.writer.close();
                this.writer = null;
            }
            this.forceCloseDaemonQuit.set(true);
        }
        try {
            this.forceCloseDaemon.interrupt();
            this.forceCloseDaemon.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ AtomicBoolean access$000(Serializer serializer) {
        return serializer.forceCloseDaemonQuit;
    }

    static /* synthetic */ Throwable access$100(Serializer serializer) {
        return serializer.doForcedShutdown;
    }

    static /* synthetic */ JsonWriter access$200(Serializer serializer) {
        return serializer.jsonWriter;
    }

    static /* synthetic */ Writer access$300(Serializer serializer) {
        return serializer.writer;
    }
}

