/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import liquibase.configuration.AbstractConfigurationContainer;

public class GlobalConfiguration
extends AbstractConfigurationContainer {
    public static final String SHOULD_RUN = "shouldRun";
    public static final String DATABASECHANGELOG_TABLE_NAME = "databaseChangeLogTableName";
    public static final String DATABASECHANGELOGLOCK_TABLE_NAME = "databaseChangeLogLockTableName";
    public static final String LIQUIBASE_TABLESPACE_NAME = "tablespaceName";
    public static final String LIQUIBASE_CATALOG_NAME = "catalogName";
    public static final String LIQUIBASE_SCHEMA_NAME = "schemaName";
    public static final String OUTPUT_LINE_SEPARATOR = "outputLineSeparator";
    public static final String OUTPUT_ENCODING = "outputFileEncoding";
    public static final String CHANGELOGLOCK_WAIT_TIME = "changeLogLockWaitTimeInMinutes";
    public static final String CHANGELOGLOCK_POLL_RATE = "changeLogLockPollRate";
    public static final String CONVERT_DATA_TYPES = "convertDataTypes";
    public static final String GENERATE_CHANGESET_CREATED_VALUES = "generateChangeSetCreatedValues";
    public static final String AUTO_REORG = "autoReorg";
    public static final String DIFF_COLUMN_ORDER = "diffColumnOrder";
    public static final String ALWAYS_OVERRIDE_STORED_LOGIC_SCHEMA = "alwaysOverrideStoredLogicSchema";
    public static final String GENERATED_CHANGESET_IDS_INCLUDE_DESCRIPTION = "generatedChangeSetIdsContainsDescription";
    public static final String INCLUDE_CATALOG_IN_SPECIFICATION = "includeCatalogInSpecification";

    public GlobalConfiguration() {
        super("liquibase");
        this.getContainer().addProperty(SHOULD_RUN, Boolean.class).setDescription("Should Liquibase commands execute").setDefaultValue(true).addAlias("should.run");
        this.getContainer().addProperty(DATABASECHANGELOG_TABLE_NAME, String.class).setDescription("Name of table to use for tracking change history").setDefaultValue("DATABASECHANGELOG");
        this.getContainer().addProperty(DATABASECHANGELOGLOCK_TABLE_NAME, String.class).setDescription("Name of table to use for tracking concurrent Liquibase usage").setDefaultValue("DATABASECHANGELOGLOCK");
        this.getContainer().addProperty(CHANGELOGLOCK_WAIT_TIME, Long.class).setDescription("Number of minutes to wait for the changelog lock to be available before giving up").setDefaultValue(5);
        this.getContainer().addProperty(CHANGELOGLOCK_POLL_RATE, Long.class).setDescription("Number of seconds wait between checks to the changelog lock when it is locked").setDefaultValue(10);
        this.getContainer().addProperty(LIQUIBASE_TABLESPACE_NAME, String.class).setDescription("Tablespace to use for Liquibase objects");
        this.getContainer().addProperty(LIQUIBASE_CATALOG_NAME, String.class).setDescription("Catalog to use for Liquibase objects");
        this.getContainer().addProperty(LIQUIBASE_SCHEMA_NAME, String.class).setDescription("Schema to use for Liquibase objects");
        this.getContainer().addProperty(OUTPUT_LINE_SEPARATOR, String.class).setDescription("Line separator for output. Defaults to OS default").setDefaultValue(System.getProperty("line.separator"));
        this.getContainer().addProperty(OUTPUT_ENCODING, String.class).setDescription("Encoding to output text in. Defaults to file.encoding system property or UTF-8").setDefaultValue("UTF-8").addAlias("file.encoding");
        this.getContainer().addProperty(CONVERT_DATA_TYPES, Boolean.class).setDescription("Should Liquibase convert to/from STANDARD data types. Applies to both snapshot and update commands.").setDefaultValue(true);
        this.getContainer().addProperty(GENERATE_CHANGESET_CREATED_VALUES, Boolean.class).setDescription("Should Liquibase include a 'created' attribute in diff/generateChangeLog changeSets with the current datetime").setDefaultValue(false);
        this.getContainer().addProperty(AUTO_REORG, Boolean.class).setDescription("Should Liquibase automatically include REORG TABLE commands when needed?").setDefaultValue(true);
        this.getContainer().addProperty(DIFF_COLUMN_ORDER, Boolean.class).setDescription("Should Liquibase compare column order in diff operation?").setDefaultValue(true);
        this.getContainer().addProperty(ALWAYS_OVERRIDE_STORED_LOGIC_SCHEMA, Boolean.class).setDescription("When generating SQL for createProcedure, should the procedure schema be forced to the default schema if no schemaName attribute is set?").setDefaultValue(false);
        this.getContainer().addProperty(GENERATED_CHANGESET_IDS_INCLUDE_DESCRIPTION, Boolean.class).setDescription("Should Liquibase include the change description in the id when generating changeSets?").setDefaultValue(false);
        this.getContainer().addProperty(INCLUDE_CATALOG_IN_SPECIFICATION, Boolean.class).setDescription("Should Liquibase include the catalog name when determining equality?").setDefaultValue(false);
    }

    public boolean getShouldRun() {
        return this.getContainer().getValue(SHOULD_RUN, Boolean.class);
    }

    public GlobalConfiguration setShouldRun(boolean shouldRun) {
        this.getContainer().setValue(SHOULD_RUN, shouldRun);
        return this;
    }

    public String getDatabaseChangeLogTableName() {
        return this.getContainer().getValue(DATABASECHANGELOG_TABLE_NAME, String.class);
    }

    public GlobalConfiguration setDatabaseChangeLogTableName(String name) {
        this.getContainer().setValue(DATABASECHANGELOG_TABLE_NAME, name);
        return this;
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.getContainer().getValue(DATABASECHANGELOGLOCK_TABLE_NAME, String.class);
    }

    public GlobalConfiguration setDatabaseChangeLogLockTableName(String name) {
        this.getContainer().setValue(DATABASECHANGELOGLOCK_TABLE_NAME, name);
        return this;
    }

    public Long getDatabaseChangeLogLockWaitTime() {
        return this.getContainer().getValue(CHANGELOGLOCK_WAIT_TIME, Long.class);
    }

    public GlobalConfiguration setDatabaseChangeLogLockWaitTime(Long minutes) {
        this.getContainer().setValue(CHANGELOGLOCK_WAIT_TIME, minutes);
        return this;
    }

    public Long getDatabaseChangeLogLockPollRate() {
        return this.getContainer().getValue(CHANGELOGLOCK_POLL_RATE, Long.class);
    }

    public GlobalConfiguration setDatabaseChangeLogLockPollRate(Long seconds) {
        this.getContainer().setValue(CHANGELOGLOCK_POLL_RATE, seconds);
        return this;
    }

    public String getLiquibaseTablespaceName() {
        return this.getContainer().getValue(LIQUIBASE_TABLESPACE_NAME, String.class);
    }

    public GlobalConfiguration setLiquibaseTablespaceName(String name) {
        this.getContainer().setValue(LIQUIBASE_TABLESPACE_NAME, name);
        return this;
    }

    public String getLiquibaseCatalogName() {
        return this.getContainer().getValue(LIQUIBASE_CATALOG_NAME, String.class);
    }

    public GlobalConfiguration setLiquibaseCatalogName(String name) {
        this.getContainer().setValue(LIQUIBASE_CATALOG_NAME, name);
        return this;
    }

    public String getLiquibaseSchemaName() {
        return this.getContainer().getValue(LIQUIBASE_SCHEMA_NAME, String.class);
    }

    public GlobalConfiguration setLiquibaseSchemaName(String name) {
        this.getContainer().setValue(LIQUIBASE_SCHEMA_NAME, name);
        return this;
    }

    public String getOutputLineSeparator() {
        return this.getContainer().getValue(OUTPUT_LINE_SEPARATOR, String.class);
    }

    public GlobalConfiguration setOutputLineSeparator(String name) {
        this.getContainer().setValue(OUTPUT_LINE_SEPARATOR, name);
        return this;
    }

    public String getOutputEncoding() {
        return this.getContainer().getValue(OUTPUT_ENCODING, String.class);
    }

    public GlobalConfiguration setOutputEncoding(String name) {
        this.getContainer().setValue(OUTPUT_ENCODING, name);
        return this;
    }

    public Boolean getDiffColumnOrder() {
        return this.getContainer().getValue(DIFF_COLUMN_ORDER, Boolean.class);
    }

    public GlobalConfiguration setDiffColumnOrder(boolean diff) {
        this.getContainer().setValue(DIFF_COLUMN_ORDER, diff);
        return this;
    }

    public Boolean getAlwaysOverrideStoredLogicSchema() {
        return this.getContainer().getValue(ALWAYS_OVERRIDE_STORED_LOGIC_SCHEMA, Boolean.class);
    }

    public GlobalConfiguration setAlwaysOverrideStoredLogicSchema(boolean override) {
        this.getContainer().setValue(ALWAYS_OVERRIDE_STORED_LOGIC_SCHEMA, override);
        return this;
    }

    public Boolean getGeneratedChangeSetIdsContainDescription() {
        return this.getContainer().getValue(GENERATED_CHANGESET_IDS_INCLUDE_DESCRIPTION, Boolean.class);
    }

    public GlobalConfiguration setGeneratedChangeSetIdsContainDescription(boolean containDescription) {
        this.getContainer().setValue(GENERATED_CHANGESET_IDS_INCLUDE_DESCRIPTION, containDescription);
        return this;
    }
}

