"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var __1 = require("../..");
var tooltip_1 = require("../../../components/tooltip");
var get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
var partition_1 = require("../renderer/canvas/partition");
var highlighter_hover_1 = require("../renderer/dom/highlighter_hover");
var highlighter_legend_1 = require("../renderer/dom/highlighter_legend");
var compute_legend_1 = require("./selectors/compute_legend");
var get_legend_items_labels_1 = require("./selectors/get_legend_items_labels");
var is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
var on_element_click_caller_1 = require("./selectors/on_element_click_caller");
var on_element_out_caller_1 = require("./selectors/on_element_out_caller");
var on_element_over_caller_1 = require("./selectors/on_element_over_caller");
var pie_spec_1 = require("./selectors/pie_spec");
var tooltip_2 = require("./selectors/tooltip");
var EMPTY_MAP = new Map();
var PartitionState = (function () {
    function PartitionState() {
        this.chartType = __1.ChartTypes.Partition;
        this.onElementClickCaller = on_element_click_caller_1.createOnElementClickCaller();
        this.onElementOverCaller = on_element_over_caller_1.createOnElementOverCaller();
        this.onElementOutCaller = on_element_out_caller_1.createOnElementOutCaller();
    }
    PartitionState.prototype.isInitialized = function (globalState) {
        return pie_spec_1.getPieSpec(globalState) !== null ? get_internal_is_intialized_1.InitStatus.Initialized : get_internal_is_intialized_1.InitStatus.SpecNotInitialized;
    };
    PartitionState.prototype.isBrushAvailable = function () {
        return false;
    };
    PartitionState.prototype.isBrushing = function () {
        return false;
    };
    PartitionState.prototype.isChartEmpty = function () {
        return false;
    };
    PartitionState.prototype.getLegendItemsLabels = function (globalState) {
        return get_legend_items_labels_1.getLegendItemsLabels(globalState);
    };
    PartitionState.prototype.getLegendItems = function (globalState) {
        return compute_legend_1.computeLegendSelector(globalState);
    };
    PartitionState.prototype.getLegendExtraValues = function () {
        return EMPTY_MAP;
    };
    PartitionState.prototype.chartRenderer = function (containerRef, forwardStageRef) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(tooltip_1.Tooltip, { getChartContainerRef: containerRef }),
            react_1.default.createElement(partition_1.Partition, { forwardStageRef: forwardStageRef }),
            react_1.default.createElement(highlighter_hover_1.HighlighterFromHover, null),
            react_1.default.createElement(highlighter_legend_1.HighlighterFromLegend, null)));
    };
    PartitionState.prototype.getPointerCursor = function () {
        return 'default';
    };
    PartitionState.prototype.isTooltipVisible = function (globalState) {
        return { visible: is_tooltip_visible_1.isTooltipVisibleSelector(globalState), isExternal: false };
    };
    PartitionState.prototype.getTooltipInfo = function (globalState) {
        return tooltip_2.getTooltipInfoSelector(globalState);
    };
    PartitionState.prototype.getTooltipAnchor = function (state) {
        var position = state.interactions.pointer.current.position;
        return {
            isRotated: false,
            x1: position.x,
            y1: position.y,
        };
    };
    PartitionState.prototype.eventCallbacks = function (globalState) {
        this.onElementOverCaller(globalState);
        this.onElementOutCaller(globalState);
        this.onElementClickCaller(globalState);
    };
    return PartitionState;
}());
exports.PartitionState = PartitionState;
//# sourceMappingURL=chart_state.js.map