"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = require("../state/utils/common");
exports.DEFAULT_SNAP_POSITION_BAND = 1;
function getSnapPosition(value, scale, totalBarsInCluster) {
    if (totalBarsInCluster === void 0) { totalBarsInCluster = 1; }
    var position = scale.scale(value);
    if (position === null) {
        return;
    }
    if (scale.bandwidth > 0) {
        var band = scale.bandwidth / (1 - scale.barsPadding);
        var halfPadding = (band - scale.bandwidth) / 2;
        return {
            position: position - halfPadding * totalBarsInCluster,
            band: band * totalBarsInCluster,
        };
    }
    return {
        position: position,
        band: exports.DEFAULT_SNAP_POSITION_BAND,
    };
}
exports.getSnapPosition = getSnapPosition;
function getCursorLinePosition(chartRotation, chartDimensions, projectedPointerPosition) {
    var x = projectedPointerPosition.x, y = projectedPointerPosition.y;
    if (x < 0 || y < 0) {
        return void 0;
    }
    var left = chartDimensions.left, top = chartDimensions.top, width = chartDimensions.width, height = chartDimensions.height;
    var isHorizontalRotated = common_1.isHorizontalRotation(chartRotation);
    if (isHorizontalRotated) {
        var crosshairTop = projectedPointerPosition.y + top;
        return {
            left: left,
            width: width,
            top: crosshairTop,
            height: 0,
        };
    }
    var crosshairLeft = projectedPointerPosition.x + left;
    return {
        top: top,
        left: crosshairLeft,
        width: 0,
        height: height,
    };
}
exports.getCursorLinePosition = getCursorLinePosition;
function getCursorBandPosition(chartRotation, chartDimensions, cursorPosition, invertedValue, snapEnabled, xScale, totalBarsInCluster) {
    var top = chartDimensions.top, left = chartDimensions.left, width = chartDimensions.width, height = chartDimensions.height;
    var x = cursorPosition.x, y = cursorPosition.y;
    var isHorizontalRotated = common_1.isHorizontalRotation(chartRotation);
    var chartWidth = isHorizontalRotated ? width : height;
    var chartHeight = isHorizontalRotated ? height : width;
    if (x > chartWidth || y > chartHeight || x < 0 || y < 0 || !invertedValue.withinBandwidth) {
        return {
            top: -1,
            left: -1,
            width: 0,
            height: 0,
            visible: false,
        };
    }
    var snappedPosition = getSnapPosition(invertedValue.value, xScale, totalBarsInCluster);
    if (!snappedPosition) {
        return {
            top: -1,
            left: -1,
            width: 0,
            height: 0,
            visible: false,
        };
    }
    var position = snappedPosition.position, band = snappedPosition.band;
    var bandOffset = xScale.bandwidth > 0 ? band : 0;
    if (isHorizontalRotated) {
        var adjustedLeft = snapEnabled ? position : cursorPosition.x;
        var leftPosition = chartRotation === 0 ? left + adjustedLeft : left + width - adjustedLeft - bandOffset;
        var adjustedWidth = band;
        if (band > 1 && leftPosition + band > left + width) {
            adjustedWidth = left + width - leftPosition;
        }
        else if (band > 1 && leftPosition < left) {
            adjustedWidth = band - (left - leftPosition);
            leftPosition = left;
        }
        return {
            top: top,
            left: leftPosition,
            width: adjustedWidth,
            height: height,
            visible: true,
        };
    }
    var adjustedTop = snapEnabled ? position : cursorPosition.x;
    var topPosition = chartRotation === 90 ? top + adjustedTop : height + top - adjustedTop - bandOffset;
    var adjustedHeight = band;
    if (band > 1 && topPosition + band > top + height) {
        adjustedHeight = band - (topPosition + band - (top + height));
    }
    else if (band > 1 && topPosition < top) {
        adjustedHeight = band - (top - topPosition);
        topPosition = top;
    }
    return {
        top: topPosition,
        left: left,
        width: width,
        height: adjustedHeight,
        visible: true,
    };
}
exports.getCursorBandPosition = getCursorBandPosition;
function getTooltipAnchorPosition(chartDimensions, chartRotation, cursorBandPosition, cursorPosition, isSingleValueXScale) {
    var isRotated = common_1.isVerticalRotation(chartRotation);
    var hPosition = getHorizontalTooltipPosition(cursorPosition.x, cursorBandPosition, chartDimensions, isRotated, isSingleValueXScale);
    var vPosition = getVerticalTooltipPosition(cursorPosition.y, cursorBandPosition, chartDimensions, isRotated, isSingleValueXScale);
    return __assign(__assign({ isRotated: isRotated }, vPosition), hPosition);
}
exports.getTooltipAnchorPosition = getTooltipAnchorPosition;
function getHorizontalTooltipPosition(cursorXPosition, cursorBandPosition, chartDimensions, isRotated, isSingleValueXScale) {
    if (!isRotated) {
        return {
            x0: cursorBandPosition.left,
            x1: cursorBandPosition.left + (isSingleValueXScale ? 0 : cursorBandPosition.width),
        };
    }
    return {
        x1: chartDimensions.left + cursorXPosition,
    };
}
function getVerticalTooltipPosition(cursorYPosition, cursorBandPosition, chartDimensions, isRotated, isSingleValueXScale) {
    if (!isRotated) {
        return {
            y0: cursorYPosition + chartDimensions.top,
            y1: cursorYPosition + chartDimensions.top,
        };
    }
    return {
        y0: cursorBandPosition.top,
        y1: (isSingleValueXScale ? 0 : cursorBandPosition.height) + cursorBandPosition.top,
    };
}
//# sourceMappingURL=crosshair_utils.js.map