"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../../../scales/constants");
var accessor_1 = require("../../../utils/accessor");
var logger_1 = require("../../../utils/logger");
var y_domain_1 = require("../domains/y_domain");
var nonstacked_series_utils_1 = require("./nonstacked_series_utils");
var specs_1 = require("./specs");
var stacked_series_utils_1 = require("./stacked_series_utils");
exports.SERIES_DELIMITER = ' - ';
function getSeriesIndex(series, target) {
    if (!series) {
        return -1;
    }
    return series.findIndex(function (_a) {
        var key = _a.key;
        return target.key === key;
    });
}
exports.getSeriesIndex = getSeriesIndex;
function splitSeries(_a) {
    var specId = _a.id, data = _a.data, xAccessor = _a.xAccessor, yAccessors = _a.yAccessors, y0Accessors = _a.y0Accessors, markSizeAccessor = _a.markSizeAccessor, _b = _a.splitSeriesAccessors, splitSeriesAccessors = _b === void 0 ? [] : _b;
    var isMultipleY = yAccessors && yAccessors.length > 1;
    var series = new Map();
    var colorsValues = new Set();
    var xValues = new Set();
    var nonNumericValues = [];
    data.forEach(function (datum) {
        var splitAccessors = getSplitAccessors(datum, splitSeriesAccessors);
        if (splitSeriesAccessors.length > 0 && splitAccessors.size < 1) {
            return;
        }
        if (isMultipleY) {
            yAccessors.forEach(function (accessor, index) {
                var cleanedDatum = cleanDatum(datum, xAccessor, accessor, nonNumericValues, y0Accessors && y0Accessors[index], markSizeAccessor);
                if (cleanedDatum !== null && cleanedDatum.x !== null && cleanedDatum.x !== undefined) {
                    xValues.add(cleanedDatum.x);
                    var seriesKey = updateSeriesMap(series, splitAccessors, accessor, cleanedDatum, specId);
                    colorsValues.add(seriesKey);
                }
            });
        }
        else {
            var cleanedDatum = cleanDatum(datum, xAccessor, yAccessors[0], nonNumericValues, y0Accessors && y0Accessors[0], markSizeAccessor);
            if (cleanedDatum !== null && cleanedDatum.x !== null && cleanedDatum.x !== undefined) {
                xValues.add(cleanedDatum.x);
                var seriesKey = updateSeriesMap(series, splitAccessors, yAccessors[0], cleanedDatum, specId);
                colorsValues.add(seriesKey);
            }
        }
    });
    if (nonNumericValues.length > 0) {
        logger_1.Logger.warn("Found non-numeric y value" + (nonNumericValues.length > 1 ? 's' : '') + " in dataset for spec \"" + specId + "\"", "(" + nonNumericValues.map(function (v) { return JSON.stringify(v); }).join(', ') + ")");
    }
    return {
        rawDataSeries: __spread(series.values()),
        colorsValues: colorsValues,
        xValues: xValues,
    };
}
exports.splitSeries = splitSeries;
function getSeriesKey(_a) {
    var specId = _a.specId, yAccessor = _a.yAccessor, splitAccessors = _a.splitAccessors;
    var joinedAccessors = __spread(splitAccessors.entries()).sort(function (_a, _b) {
        var _c = __read(_a, 1), a = _c[0];
        var _d = __read(_b, 1), b = _d[0];
        return (a > b ? 1 : -1);
    })
        .map(function (_a) {
        var _b = __read(_a, 2), key = _b[0], value = _b[1];
        return key + "-" + value;
    })
        .join('|');
    return "spec{" + specId + "}yAccessor{" + yAccessor + "}splitAccessors{" + joinedAccessors + "}";
}
exports.getSeriesKey = getSeriesKey;
function updateSeriesMap(seriesMap, splitAccessors, accessor, datum, specId) {
    var seriesKeys = __spread(splitAccessors.values(), [accessor]);
    var seriesKey = getSeriesKey({
        specId: specId,
        yAccessor: accessor,
        splitAccessors: splitAccessors,
    });
    var series = seriesMap.get(seriesKey);
    if (series) {
        series.data.push(datum);
    }
    else {
        seriesMap.set(seriesKey, {
            specId: specId,
            yAccessor: accessor,
            splitAccessors: splitAccessors,
            data: [datum],
            key: seriesKey,
            seriesKeys: seriesKeys,
        });
    }
    return seriesKey;
}
function getSplitAccessors(datum, accessors) {
    if (accessors === void 0) { accessors = []; }
    var splitAccessors = new Map();
    if (typeof datum === 'object' && datum !== null) {
        accessors.forEach(function (accessor) {
            var value = datum[accessor];
            if (typeof value === 'string' || typeof value === 'number') {
                splitAccessors.set(accessor, value);
            }
        });
    }
    return splitAccessors;
}
function cleanDatum(datum, xAccessor, yAccessor, nonNumericValues, y0Accessor, markSizeAccessor) {
    if (typeof datum !== 'object' || datum === null) {
        return null;
    }
    var x = accessor_1.getAccessorValue(datum, xAccessor);
    if (typeof x !== 'string' && typeof x !== 'number') {
        return null;
    }
    var mark = markSizeAccessor === undefined ? null : accessor_1.getAccessorValue(datum, markSizeAccessor);
    var y1 = castToNumber(datum[yAccessor], nonNumericValues);
    var cleanedDatum = { x: x, y1: y1, datum: datum, y0: null, mark: mark };
    if (y0Accessor) {
        cleanedDatum.y0 = castToNumber(datum[y0Accessor], nonNumericValues);
    }
    return cleanedDatum;
}
exports.cleanDatum = cleanDatum;
function castToNumber(value, nonNumericValues) {
    if (value === null || value === undefined) {
        return null;
    }
    var num = Number(value);
    if (isNaN(num)) {
        nonNumericValues.push(value);
        return null;
    }
    return num;
}
function getFormattedDataseries(specs, dataSeries, xValues, xScaleType, seriesSpecs) {
    var specsByGroupIds = y_domain_1.splitSpecsByGroupId(specs);
    var specsByGroupIdsEntries = __spread(specsByGroupIds.entries());
    var stackedFormattedDataSeries = [];
    var nonStackedFormattedDataSeries = [];
    specsByGroupIdsEntries.forEach(function (_a) {
        var _b = __read(_a, 2), groupId = _b[0], groupSpecs = _b[1];
        var isPercentageStack = groupSpecs.isPercentageStack;
        var stackedDataSeries = getRawDataSeries(groupSpecs.stacked, dataSeries);
        var stackedDataSeriesValues = stacked_series_utils_1.formatStackedDataSeriesValues(stackedDataSeries.rawDataSeries, false, isPercentageStack, xValues, xScaleType);
        stackedFormattedDataSeries.push({
            groupId: groupId,
            counts: stackedDataSeries.counts,
            dataSeries: stackedDataSeriesValues,
        });
        var nonStackedDataSeries = getRawDataSeries(groupSpecs.nonStacked, dataSeries);
        nonStackedFormattedDataSeries.push({
            groupId: groupId,
            counts: nonStackedDataSeries.counts,
            dataSeries: nonstacked_series_utils_1.formatNonStackedDataSeriesValues(nonStackedDataSeries.rawDataSeries, false, seriesSpecs, xScaleType),
        });
    });
    return {
        stacked: stackedFormattedDataSeries.filter(function (ds) { return ds.dataSeries.length > 0; }),
        nonStacked: nonStackedFormattedDataSeries.filter(function (ds) { return ds.dataSeries.length > 0; }),
    };
}
exports.getFormattedDataseries = getFormattedDataseries;
function getRawDataSeries(seriesSpecs, dataSeries) {
    var rawDataSeries = [];
    var counts = {
        barSeries: 0,
        lineSeries: 0,
        areaSeries: 0,
    };
    var seriesSpecsCount = seriesSpecs.length;
    var i = 0;
    for (; i < seriesSpecsCount; i++) {
        var spec = seriesSpecs[i];
        var id = spec.id, seriesType = spec.seriesType;
        var ds = dataSeries.get(id);
        switch (seriesType) {
            case specs_1.SeriesTypes.Bar:
                counts.barSeries += ds ? ds.length : 0;
                break;
            case specs_1.SeriesTypes.Line:
                counts.lineSeries += ds ? ds.length : 0;
                break;
            case specs_1.SeriesTypes.Area:
            default:
                counts.areaSeries += ds ? ds.length : 0;
                break;
        }
        if (ds) {
            rawDataSeries.push.apply(rawDataSeries, __spread(ds));
        }
    }
    return {
        rawDataSeries: rawDataSeries,
        counts: counts,
    };
}
function getSplittedSeries(seriesSpecs, deselectedDataSeries) {
    var e_1, _a;
    if (deselectedDataSeries === void 0) { deselectedDataSeries = []; }
    var splittedSeries = new Map();
    var seriesCollection = new Map();
    var xValues = new Set();
    var isNumberArray = true;
    var isOrdinalScale = false;
    var _loop_1 = function (spec) {
        var e_2, _a;
        var dataSeries = splitSeries(spec);
        var currentRawDataSeries = dataSeries.rawDataSeries;
        if (spec.xScaleType === constants_1.ScaleType.Ordinal) {
            isOrdinalScale = true;
        }
        if (deselectedDataSeries.length > 0) {
            currentRawDataSeries = dataSeries.rawDataSeries.filter(function (_a) {
                var key = _a.key;
                return !deselectedDataSeries.some(function (_a) {
                    var deselectedKey = _a.key;
                    return key === deselectedKey;
                });
            });
        }
        splittedSeries.set(spec.id, currentRawDataSeries);
        var banded = spec.y0Accessors && spec.y0Accessors.length > 0;
        dataSeries.rawDataSeries.forEach(function (series) {
            var data = series.data, seriesIdentifier = __rest(series, ["data"]);
            seriesCollection.set(series.key, {
                banded: banded,
                specSortIndex: spec.sortIndex,
                seriesIdentifier: seriesIdentifier,
            });
        });
        try {
            for (var _b = (e_2 = void 0, __values(dataSeries.xValues)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var xValue = _c.value;
                if (isNumberArray && typeof xValue !== 'number') {
                    isNumberArray = false;
                }
                xValues.add(xValue);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    try {
        for (var seriesSpecs_1 = __values(seriesSpecs), seriesSpecs_1_1 = seriesSpecs_1.next(); !seriesSpecs_1_1.done; seriesSpecs_1_1 = seriesSpecs_1.next()) {
            var spec = seriesSpecs_1_1.value;
            _loop_1(spec);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (seriesSpecs_1_1 && !seriesSpecs_1_1.done && (_a = seriesSpecs_1.return)) _a.call(seriesSpecs_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return {
        splittedSeries: splittedSeries,
        seriesCollection: seriesCollection,
        xValues: (isOrdinalScale || !isNumberArray) ? xValues : new Set(__spread(xValues).sort()),
        fallbackScale: (!isOrdinalScale && !isNumberArray) ? constants_1.ScaleType.Ordinal : undefined,
    };
}
exports.getSplittedSeries = getSplittedSeries;
function getSeriesNameFromOptions(options, _a, delimiter) {
    var yAccessor = _a.yAccessor, splitAccessors = _a.splitAccessors;
    if (!options.names) {
        return null;
    }
    return (options.names
        .slice()
        .sort(function (_a, _b) {
        var _c = _a.sortIndex, a = _c === void 0 ? Infinity : _c;
        var _d = _b.sortIndex, b = _d === void 0 ? Infinity : _d;
        return a - b;
    })
        .map(function (_a) {
        var accessor = _a.accessor, value = _a.value, name = _a.name;
        var _b;
        var accessorValue = (_b = splitAccessors.get(accessor), (_b !== null && _b !== void 0 ? _b : null));
        if (accessorValue === value) {
            return (name !== null && name !== void 0 ? name : value);
        }
        if (yAccessor === accessor) {
            return (name !== null && name !== void 0 ? name : accessor);
        }
        return null;
    })
        .filter(function (d) { return Boolean(d) || d === 0; })
        .join(delimiter) || null);
}
function getSeriesName(seriesIdentifier, hasSingleSeries, isTooltip, spec) {
    var _a;
    var delimiter = exports.SERIES_DELIMITER;
    if (spec && spec.name && typeof spec.name !== 'string') {
        var customLabel = null;
        if (typeof spec.name === 'function') {
            customLabel = spec.name(seriesIdentifier, isTooltip);
        }
        else {
            delimiter = (_a = spec.name.delimiter, (_a !== null && _a !== void 0 ? _a : delimiter));
            customLabel = getSeriesNameFromOptions(spec.name, seriesIdentifier, delimiter);
        }
        if (customLabel !== null) {
            return customLabel.toString();
        }
    }
    var name = '';
    var nameKeys = spec && spec.yAccessors.length > 1 ? seriesIdentifier.seriesKeys : seriesIdentifier.seriesKeys.slice(0, -1);
    if (hasSingleSeries || nameKeys.length === 0 || nameKeys[0] == null) {
        if (!spec) {
            return '';
        }
        if (spec.splitSeriesAccessors && nameKeys.length > 0 && nameKeys[0] != null) {
            name = nameKeys.join(delimiter);
        }
        else {
            name = typeof spec.name === 'string' ? spec.name : "" + spec.id;
        }
    }
    else {
        name = nameKeys.join(delimiter);
    }
    return name;
}
exports.getSeriesName = getSeriesName;
function getSortIndex(_a, total) {
    var specSortIndex = _a.specSortIndex;
    return specSortIndex != null ? specSortIndex : total;
}
function getSortedDataSeriesColorsValuesMap(seriesCollection) {
    var seriesColorsArray = __spread(seriesCollection);
    seriesColorsArray.sort(function (_a, _b) {
        var _c = __read(_a, 2), specA = _c[1];
        var _d = __read(_b, 2), specB = _d[1];
        return getSortIndex(specA, seriesCollection.size) - getSortIndex(specB, seriesCollection.size);
    });
    return new Map(__spread(seriesColorsArray));
}
exports.getSortedDataSeriesColorsValuesMap = getSortedDataSeriesColorsValuesMap;
function getHighestOverride(key, customColors, overrides) {
    var color = overrides.temporary[key];
    if (color) {
        return color;
    }
    color = customColors.get(key);
    if (color) {
        return color;
    }
    return overrides.persisted[key];
}
function getSeriesColors(seriesCollection, chartColors, customColors, overrides) {
    var seriesColorMap = new Map();
    var counter = 0;
    seriesCollection.forEach(function (_, seriesKey) {
        var colorOverride = getHighestOverride(seriesKey, customColors, overrides);
        var color = colorOverride || chartColors.vizColors[counter % chartColors.vizColors.length];
        seriesColorMap.set(seriesKey, color);
        counter++;
    });
    return seriesColorMap;
}
exports.getSeriesColors = getSeriesColors;
//# sourceMappingURL=series.js.map