/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import { keysOf } from '../common';
import classNames from 'classnames';
var typeToClassNameMap = {
  regular: 'euiCommentEvent--regular',
  update: 'euiCommentEvent--update'
};
export var TYPES = keysOf(typeToClassNameMap);
export var EuiCommentEvent = function EuiCommentEvent(_ref) {
  var children = _ref.children,
      className = _ref.className,
      username = _ref.username,
      timestamp = _ref.timestamp,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'regular' : _ref$type,
      event = _ref.event,
      actions = _ref.actions;
  var classes = classNames('euiCommentEvent', typeToClassNameMap[type], className);
  var isFigure = type === 'regular' || type === 'update' && typeof children !== 'undefined';
  var Element = isFigure ? 'figure' : 'div';
  var HeaderElement = isFigure ? 'figcaption' : 'div';
  return React.createElement(Element, {
    className: classes
  }, React.createElement(HeaderElement, {
    className: "euiCommentEvent__header"
  }, React.createElement("div", {
    className: "euiCommentEvent__headerData"
  }, React.createElement("div", {
    className: "euiCommentEvent__headerUsername"
  }, username), React.createElement("div", {
    className: "euiCommentEvent__headerEvent"
  }, event), timestamp ? React.createElement("div", {
    className: "euiCommentEvent__headerTimestamp"
  }, React.createElement("time", null, timestamp)) : undefined), actions ? React.createElement("div", {
    className: "euiCommentEvent__headerActions"
  }, actions) : undefined), children ? React.createElement("div", {
    className: "euiCommentEvent__body"
  }, children) : undefined);
};
EuiCommentEvent.propTypes = {
  /**
     * Author of the comment. Display a small icon or avatar with it if needed.
     */
  username: PropTypes.node.isRequired,

  /**
     * Time of occurrence of the event. Its format is set on the consumer's side
     */
  timestamp: PropTypes.node,

  /**
     * Describes the event that took place
     */
  event: PropTypes.node,

  /**
     * Custom actions that the user can perform from the comment's header
     */
  actions: PropTypes.node,

  /**
     * Use "update" when the comment is primarily showing info about actions that the user or the system has performed (e.g. "user1 edited a case").
     */
  type: PropTypes.oneOf(["regular", "update"]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};
EuiCommentEvent.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiCommentEvent",
  "props": {
    "type": {
      "defaultValue": {
        "value": "'regular'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"regular\"",
          "computed": false
        }, {
          "value": "\"update\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Use \"update\" when the comment is primarily showing info about actions that the user or the system has performed (e.g. \"user1 edited a case\")."
    },
    "username": {
      "type": {
        "name": "node"
      },
      "required": true,
      "description": "Author of the comment. Display a small icon or avatar with it if needed."
    },
    "timestamp": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Time of occurrence of the event. Its format is set on the consumer's side"
    },
    "event": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Describes the event that took place"
    },
    "actions": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Custom actions that the user can perform from the comment's header"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};