"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHeader = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _header_section = require("./header_section");

var _header_breadcrumbs = require("./header_breadcrumbs");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function createHeaderSection(sections, border) {
  return sections.map(function (section, index) {
    return _react.default.createElement(_header_section.EuiHeaderSectionItem, {
      key: index,
      border: border
    }, section);
  });
}

// Start a counter to manage the total number of fixed headers that need the body class
var euiHeaderFixedCounter = 0;

var EuiHeader = function EuiHeader(_ref) {
  var children = _ref.children,
      className = _ref.className,
      sections = _ref.sections,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'static' : _ref$position,
      _ref$theme = _ref.theme,
      theme = _ref$theme === void 0 ? 'default' : _ref$theme,
      rest = _objectWithoutProperties(_ref, ["children", "className", "sections", "position", "theme"]);

  var classes = (0, _classnames.default)('euiHeader', "euiHeader--".concat(theme), "euiHeader--".concat(position), className);
  (0, _react.useEffect)(function () {
    if (position === 'fixed') {
      // Increment fixed header counter for each fixed header
      euiHeaderFixedCounter++;
      document.body.classList.add('euiBody--headerIsFixed');
      return function () {
        // Both decrement the fixed counter AND then check if there are none
        if (--euiHeaderFixedCounter === 0) {
          // If there are none, THEN remove class
          document.body.classList.remove('euiBody--headerIsFixed');
        }
      };
    }
  }, [position]);
  var contents;

  if (sections) {
    if (children) {
      // In case both children and sections are passed, warn in the console that the children will be disregarded
      console.warn('EuiHeader cannot accept both `children` and `sections`. It will disregard the `children`.');
    }

    contents = sections.map(function (section, index) {
      var content = [];

      if (section.items) {
        // Items get wrapped in EuiHeaderSection and each item in a EuiHeaderSectionItem
        content.push(_react.default.createElement(_header_section.EuiHeaderSection, {
          key: "items-".concat(index)
        }, createHeaderSection(section.items, section.borders)));
      }

      if (section.breadcrumbs) {
        content.push( // Breadcrumbs are separate and cannot be contained in a EuiHeaderSection
        // in order for truncation to work
        _react.default.createElement(_header_breadcrumbs.EuiHeaderBreadcrumbs, _extends({
          key: "breadcrumbs-".concat(index),
          breadcrumbs: section.breadcrumbs
        }, section.breadcrumbProps)));
      }

      return content;
    });
  } else {
    contents = children;
  }

  return _react.default.createElement("div", _extends({
    className: classes
  }, rest), contents);
};

exports.EuiHeader = EuiHeader;
EuiHeader.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * An array of objects to wrap in a #EuiHeaderSection.
       * Each section is spaced using `space-between`.
       * See #EuiHeaderSectionsProp for object details.
       * This prop disregards the prop `children` if both are passed.
       */
  sections: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * An arry of items that will be wrapped in a #EuiHeaderSectionItem
       */
    items: _propTypes.default.arrayOf(_propTypes.default.node.isRequired),

    /**
       * Apply the passed border side to each #EuiHeaderSectionItem
       */
    borders: _propTypes.default.oneOf(["left", "right", "none"]),

    /**
       * Breadcrumbs in the header cannot be wrapped in a #EuiHeaderSection in order for truncation to work.
       * Simply pass the array of EuiBreadcrumb objects
       */
    breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,

      /**
         * Visible label of the breadcrumb
         */
      text: _propTypes.default.node.isRequired,
      href: _propTypes.default.string,
      onClick: _propTypes.default.func,

      /**
         * Force a max-width on the breadcrumb text
         */
      truncate: _propTypes.default.bool
    }).isRequired),

    /**
       * Other props to pass to #EuiHeaderBreadcrumbs
       */
    breadcrumbProps: _propTypes.default.any
  }).isRequired),

  /**
       * Helper that positions the header against the window body and
       * adds the correct amount of top padding to the window when in `fixed` mode
       */
  position: _propTypes.default.oneOf(["static", "fixed"]),

  /**
       * The `default` will inherit its coloring from the light or dark theme.
       * Or, force the header into pseudo `dark` theme for all themes.
       */
  theme: _propTypes.default.oneOf(["default", "dark"])
};
EuiHeader.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiHeader",
  "props": {
    "position": {
      "defaultValue": {
        "value": "'static'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"static\"",
          "computed": false
        }, {
          "value": "\"fixed\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Helper that positions the header against the window body and\nadds the correct amount of top padding to the window when in `fixed` mode"
    },
    "theme": {
      "defaultValue": {
        "value": "'default'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"default\"",
          "computed": false
        }, {
          "value": "\"dark\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "The `default` will inherit its coloring from the light or dark theme.\nOr, force the header into pseudo `dark` theme for all themes."
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "sections": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "items": {
              "name": "arrayOf",
              "value": {
                "name": "node"
              },
              "description": "An arry of items that will be wrapped in a #EuiHeaderSectionItem",
              "required": false
            },
            "borders": {
              "name": "enum",
              "value": [{
                "value": "\"left\"",
                "computed": false
              }, {
                "value": "\"right\"",
                "computed": false
              }, {
                "value": "\"none\"",
                "computed": false
              }],
              "description": "Apply the passed border side to each #EuiHeaderSectionItem",
              "required": false
            },
            "breadcrumbs": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "text": {
                    "name": "node",
                    "description": "Visible label of the breadcrumb",
                    "required": true
                  },
                  "href": {
                    "name": "string",
                    "required": false
                  },
                  "onClick": {
                    "name": "func",
                    "required": false
                  },
                  "truncate": {
                    "name": "bool",
                    "description": "Force a max-width on the breadcrumb text",
                    "required": false
                  }
                }
              },
              "description": "Breadcrumbs in the header cannot be wrapped in a #EuiHeaderSection in order for truncation to work.\nSimply pass the array of EuiBreadcrumb objects",
              "required": false
            },
            "breadcrumbProps": {
              "name": "any",
              "description": "Other props to pass to #EuiHeaderBreadcrumbs",
              "required": false
            }
          }
        }
      },
      "required": false,
      "description": "An array of objects to wrap in a #EuiHeaderSection.\nEach section is spaced using `space-between`.\nSee #EuiHeaderSectionsProp for object details.\nThis prop disregards the prop `children` if both are passed."
    }
  }
};