"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuggestInput = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _form = require("../form");

var _tool_tip = require("../tool_tip");

var _icon = require("../icon");

var _popover = require("../popover");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var statusMap = {
  unsaved: {
    icon: 'dot',
    color: 'accent',
    tooltip: 'Changes have not been saved.'
  },
  saved: {
    icon: 'checkInCircleFilled',
    color: 'secondary',
    tooltip: 'Saved.'
  },
  unchanged: {
    icon: '',
    color: 'secondary'
  },
  loading: {}
};

var EuiSuggestInput = function EuiSuggestInput(props) {
  var _useState = (0, _react.useState)(''),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isPopoverOpen = _useState4[0],
      setIsPopoverOpen = _useState4[1];

  var className = props.className,
      _props$status = props.status,
      status = _props$status === void 0 ? 'unchanged' : _props$status,
      append = props.append,
      tooltipContent = props.tooltipContent,
      suggestions = props.suggestions,
      sendValue = props.sendValue,
      rest = _objectWithoutProperties(props, ["className", "status", "append", "tooltipContent", "suggestions", "sendValue"]);

  var onFieldChange = function onFieldChange(e) {
    setValue(e.target.value);
    setIsPopoverOpen(e.target.value !== '' ? true : false);
    if (sendValue) sendValue(e.target.value);
  };

  var closePopover = function closePopover() {
    setIsPopoverOpen(false);
  };

  var icon = '';
  var color = '';

  if (statusMap[status]) {
    icon = statusMap[status].icon || '';
    color = statusMap[status].color || '';
  }

  var classes = (0, _classnames.default)('euiSuggestInput', className); // EuiFieldText's append accepts an array of elements so start by creating an empty array

  var appendArray = [];

  var statusElement = (status === 'saved' || status === 'unsaved') && _react.default.createElement(_tool_tip.EuiToolTip, {
    position: "left",
    content: tooltipContent || statusMap[status].tooltip
  }, _react.default.createElement(_icon.EuiIcon, {
    className: "euiSuggestInput__statusIcon",
    color: color,
    type: icon
  })); // Push the status element to the array if it is not undefined


  if (statusElement) appendArray.push(statusElement); // Check to see if consumer passed an append item and if so, add it to the array

  if (append) appendArray.push(append);

  var customInput = _react.default.createElement(_form.EuiFieldText, _extends({
    value: value,
    fullWidth: true,
    append: appendArray,
    isLoading: status === 'loading' ? true : false,
    onChange: onFieldChange
  }, rest));

  return _react.default.createElement("div", {
    className: classes
  }, _react.default.createElement(_popover.EuiInputPopover, {
    input: customInput,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    fullWidth: true,
    closePopover: closePopover
  }, _react.default.createElement("div", null, suggestions)));
};

exports.EuiSuggestInput = EuiSuggestInput;
EuiSuggestInput.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  tooltipContent: _propTypes.default.string,

  /**
     * Status of the current query 'unsaved', 'saved', 'unchanged' or 'loading'.
     */
  status: _propTypes.default.oneOf(["unsaved", "saved", "unchanged", "loading"]),

  /**
     * Element to be appended to the input bar.
     */
  append: _propTypes.default.any,

  /**
     * List of suggestions to display using 'suggestItem'.
     */
  suggestions: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Takes 'iconType' for EuiIcon and 'color'. 'color' can be tint1 through tint9.
       */
    type: _propTypes.default.shape({
      iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,
      color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf(["tint0", "tint1", "tint2", "tint3", "tint4", "tint5", "tint6", "tint7", "tint8", "tint9", "tint10"]).isRequired]).isRequired
    }).isRequired,

    /**
       * Label or primary text.
       */
    label: _propTypes.default.string.isRequired,

    /**
       * Description or secondary text (optional).
       */
    description: _propTypes.default.string,

    /**
       * Label display is 'fixed' by default. Label will increase its width beyond 50% if needed with 'expand'.
       */
    labelDisplay: _propTypes.default.oneOf(["fixed", "expand"]),
    onClick: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.oneOf([undefined])])
  }).isRequired).isRequired]).isRequired,
  sendValue: _propTypes.default.func
};
EuiSuggestInput.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiSuggestInput",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "tooltipContent": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "status": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"unsaved\"",
          "computed": false
        }, {
          "value": "\"saved\"",
          "computed": false
        }, {
          "value": "\"unchanged\"",
          "computed": false
        }, {
          "value": "\"loading\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Status of the current query 'unsaved', 'saved', 'unchanged' or 'loading'."
    },
    "append": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Element to be appended to the input bar."
    },
    "suggestions": {
      "type": {
        "name": "union",
        "value": [{
          "name": "arrayOf",
          "value": {
            "name": "any"
          }
        }, {
          "name": "arrayOf",
          "value": {
            "name": "shape",
            "value": {
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              },
              "type": {
                "name": "shape",
                "value": {
                  "iconType": {
                    "name": "union",
                    "value": [{
                      "name": "enum",
                      "value": [{
                        "value": "\"accessibility\"",
                        "computed": false
                      }, {
                        "value": "\"addDataApp\"",
                        "computed": false
                      }, {
                        "value": "\"advancedSettingsApp\"",
                        "computed": false
                      }, {
                        "value": "\"aggregate\"",
                        "computed": false
                      }, {
                        "value": "\"alert\"",
                        "computed": false
                      }, {
                        "value": "\"annotation\"",
                        "computed": false
                      }, {
                        "value": "\"apmApp\"",
                        "computed": false
                      }, {
                        "value": "\"apmTrace\"",
                        "computed": false
                      }, {
                        "value": "\"apps\"",
                        "computed": false
                      }, {
                        "value": "\"arrowDown\"",
                        "computed": false
                      }, {
                        "value": "\"arrowLeft\"",
                        "computed": false
                      }, {
                        "value": "\"arrowRight\"",
                        "computed": false
                      }, {
                        "value": "\"arrowUp\"",
                        "computed": false
                      }, {
                        "value": "\"asterisk\"",
                        "computed": false
                      }, {
                        "value": "\"auditbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"beaker\"",
                        "computed": false
                      }, {
                        "value": "\"bell\"",
                        "computed": false
                      }, {
                        "value": "\"bellSlash\"",
                        "computed": false
                      }, {
                        "value": "\"bolt\"",
                        "computed": false
                      }, {
                        "value": "\"boxesHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"boxesVertical\"",
                        "computed": false
                      }, {
                        "value": "\"branch\"",
                        "computed": false
                      }, {
                        "value": "\"broom\"",
                        "computed": false
                      }, {
                        "value": "\"brush\"",
                        "computed": false
                      }, {
                        "value": "\"bug\"",
                        "computed": false
                      }, {
                        "value": "\"bullseye\"",
                        "computed": false
                      }, {
                        "value": "\"calendar\"",
                        "computed": false
                      }, {
                        "value": "\"canvasApp\"",
                        "computed": false
                      }, {
                        "value": "\"codeApp\"",
                        "computed": false
                      }, {
                        "value": "\"check\"",
                        "computed": false
                      }, {
                        "value": "\"checkInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"cheer\"",
                        "computed": false
                      }, {
                        "value": "\"clock\"",
                        "computed": false
                      }, {
                        "value": "\"cloudDrizzle\"",
                        "computed": false
                      }, {
                        "value": "\"cloudStormy\"",
                        "computed": false
                      }, {
                        "value": "\"cloudSunny\"",
                        "computed": false
                      }, {
                        "value": "\"compute\"",
                        "computed": false
                      }, {
                        "value": "\"console\"",
                        "computed": false
                      }, {
                        "value": "\"consoleApp\"",
                        "computed": false
                      }, {
                        "value": "\"controlsHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"controlsVertical\"",
                        "computed": false
                      }, {
                        "value": "\"copy\"",
                        "computed": false
                      }, {
                        "value": "\"copyClipboard\"",
                        "computed": false
                      }, {
                        "value": "\"createAdvancedJob\"",
                        "computed": false
                      }, {
                        "value": "\"createMultiMetricJob\"",
                        "computed": false
                      }, {
                        "value": "\"createPopulationJob\"",
                        "computed": false
                      }, {
                        "value": "\"createSingleMetricJob\"",
                        "computed": false
                      }, {
                        "value": "\"cross\"",
                        "computed": false
                      }, {
                        "value": "\"crossClusterReplicationApp\"",
                        "computed": false
                      }, {
                        "value": "\"crosshairs\"",
                        "computed": false
                      }, {
                        "value": "\"crossInACircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"currency\"",
                        "computed": false
                      }, {
                        "value": "\"cut\"",
                        "computed": false
                      }, {
                        "value": "\"dashboardApp\"",
                        "computed": false
                      }, {
                        "value": "\"database\"",
                        "computed": false
                      }, {
                        "value": "\"dataVisualizer\"",
                        "computed": false
                      }, {
                        "value": "\"devToolsApp\"",
                        "computed": false
                      }, {
                        "value": "\"discoverApp\"",
                        "computed": false
                      }, {
                        "value": "\"document\"",
                        "computed": false
                      }, {
                        "value": "\"documentEdit\"",
                        "computed": false
                      }, {
                        "value": "\"documents\"",
                        "computed": false
                      }, {
                        "value": "\"dot\"",
                        "computed": false
                      }, {
                        "value": "\"download\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignCenter\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorBold\"",
                        "computed": false
                      }, {
                        "value": "\"editorCodeBlock\"",
                        "computed": false
                      }, {
                        "value": "\"editorComment\"",
                        "computed": false
                      }, {
                        "value": "\"editorDistributeHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"editorDistributeVertical\"",
                        "computed": false
                      }, {
                        "value": "\"editorHeading\"",
                        "computed": false
                      }, {
                        "value": "\"editorItalic\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignBottom\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignCenter\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignMiddle\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignTop\"",
                        "computed": false
                      }, {
                        "value": "\"editorLink\"",
                        "computed": false
                      }, {
                        "value": "\"editorOrderedList\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionBottomLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionBottomRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionTopLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionTopRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorRedo\"",
                        "computed": false
                      }, {
                        "value": "\"editorStrike\"",
                        "computed": false
                      }, {
                        "value": "\"editorTable\"",
                        "computed": false
                      }, {
                        "value": "\"editorUnderline\"",
                        "computed": false
                      }, {
                        "value": "\"editorUndo\"",
                        "computed": false
                      }, {
                        "value": "\"editorUnorderedList\"",
                        "computed": false
                      }, {
                        "value": "\"email\"",
                        "computed": false
                      }, {
                        "value": "\"empty\"",
                        "computed": false
                      }, {
                        "value": "\"emsApp\"",
                        "computed": false
                      }, {
                        "value": "\"exit\"",
                        "computed": false
                      }, {
                        "value": "\"expand\"",
                        "computed": false
                      }, {
                        "value": "\"expandMini\"",
                        "computed": false
                      }, {
                        "value": "\"exportAction\"",
                        "computed": false
                      }, {
                        "value": "\"eye\"",
                        "computed": false
                      }, {
                        "value": "\"eyeClosed\"",
                        "computed": false
                      }, {
                        "value": "\"faceHappy\"",
                        "computed": false
                      }, {
                        "value": "\"faceNeutral\"",
                        "computed": false
                      }, {
                        "value": "\"faceSad\"",
                        "computed": false
                      }, {
                        "value": "\"filebeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"filter\"",
                        "computed": false
                      }, {
                        "value": "\"flag\"",
                        "computed": false
                      }, {
                        "value": "\"folderCheck\"",
                        "computed": false
                      }, {
                        "value": "\"folderClosed\"",
                        "computed": false
                      }, {
                        "value": "\"folderExclamation\"",
                        "computed": false
                      }, {
                        "value": "\"folderOpen\"",
                        "computed": false
                      }, {
                        "value": "\"fullScreen\"",
                        "computed": false
                      }, {
                        "value": "\"gear\"",
                        "computed": false
                      }, {
                        "value": "\"gisApp\"",
                        "computed": false
                      }, {
                        "value": "\"glasses\"",
                        "computed": false
                      }, {
                        "value": "\"globe\"",
                        "computed": false
                      }, {
                        "value": "\"grab\"",
                        "computed": false
                      }, {
                        "value": "\"grabHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"graphApp\"",
                        "computed": false
                      }, {
                        "value": "\"grid\"",
                        "computed": false
                      }, {
                        "value": "\"grokApp\"",
                        "computed": false
                      }, {
                        "value": "\"heart\"",
                        "computed": false
                      }, {
                        "value": "\"heartbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"heatmap\"",
                        "computed": false
                      }, {
                        "value": "\"help\"",
                        "computed": false
                      }, {
                        "value": "\"home\"",
                        "computed": false
                      }, {
                        "value": "\"iInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"image\"",
                        "computed": false
                      }, {
                        "value": "\"importAction\"",
                        "computed": false
                      }, {
                        "value": "\"indexClose\"",
                        "computed": false
                      }, {
                        "value": "\"indexEdit\"",
                        "computed": false
                      }, {
                        "value": "\"indexFlush\"",
                        "computed": false
                      }, {
                        "value": "\"indexManagementApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexMapping\"",
                        "computed": false
                      }, {
                        "value": "\"indexOpen\"",
                        "computed": false
                      }, {
                        "value": "\"indexPatternApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexRollupApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexSettings\"",
                        "computed": false
                      }, {
                        "value": "\"inputOutput\"",
                        "computed": false
                      }, {
                        "value": "\"inspect\"",
                        "computed": false
                      }, {
                        "value": "\"invert\"",
                        "computed": false
                      }, {
                        "value": "\"ip\"",
                        "computed": false
                      }, {
                        "value": "\"keyboardShortcut\"",
                        "computed": false
                      }, {
                        "value": "\"kqlField\"",
                        "computed": false
                      }, {
                        "value": "\"kqlFunction\"",
                        "computed": false
                      }, {
                        "value": "\"kqlOperand\"",
                        "computed": false
                      }, {
                        "value": "\"kqlSelector\"",
                        "computed": false
                      }, {
                        "value": "\"kqlValue\"",
                        "computed": false
                      }, {
                        "value": "\"lensApp\"",
                        "computed": false
                      }, {
                        "value": "\"link\"",
                        "computed": false
                      }, {
                        "value": "\"list\"",
                        "computed": false
                      }, {
                        "value": "\"listAdd\"",
                        "computed": false
                      }, {
                        "value": "\"lock\"",
                        "computed": false
                      }, {
                        "value": "\"lockOpen\"",
                        "computed": false
                      }, {
                        "value": "\"logsApp\"",
                        "computed": false
                      }, {
                        "value": "\"logoAerospike\"",
                        "computed": false
                      }, {
                        "value": "\"logoApache\"",
                        "computed": false
                      }, {
                        "value": "\"logoAPM\"",
                        "computed": false
                      }, {
                        "value": "\"logoAppSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoAWS\"",
                        "computed": false
                      }, {
                        "value": "\"logoAWSMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoAzure\"",
                        "computed": false
                      }, {
                        "value": "\"logoAzureMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoBeats\"",
                        "computed": false
                      }, {
                        "value": "\"logoBusinessAnalytics\"",
                        "computed": false
                      }, {
                        "value": "\"logoCeph\"",
                        "computed": false
                      }, {
                        "value": "\"logoCloud\"",
                        "computed": false
                      }, {
                        "value": "\"logoCloudEnterprise\"",
                        "computed": false
                      }, {
                        "value": "\"logoCode\"",
                        "computed": false
                      }, {
                        "value": "\"logoCodesandbox\"",
                        "computed": false
                      }, {
                        "value": "\"logoCouchbase\"",
                        "computed": false
                      }, {
                        "value": "\"logoDocker\"",
                        "computed": false
                      }, {
                        "value": "\"logoDropwizard\"",
                        "computed": false
                      }, {
                        "value": "\"logoElastic\"",
                        "computed": false
                      }, {
                        "value": "\"logoElasticsearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoElasticStack\"",
                        "computed": false
                      }, {
                        "value": "\"logoEnterpriseSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoEtcd\"",
                        "computed": false
                      }, {
                        "value": "\"logoGCP\"",
                        "computed": false
                      }, {
                        "value": "\"logoGCPMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoGithub\"",
                        "computed": false
                      }, {
                        "value": "\"logoGmail\"",
                        "computed": false
                      }, {
                        "value": "\"logoGolang\"",
                        "computed": false
                      }, {
                        "value": "\"logoGoogleG\"",
                        "computed": false
                      }, {
                        "value": "\"logoHAproxy\"",
                        "computed": false
                      }, {
                        "value": "\"logoIBM\"",
                        "computed": false
                      }, {
                        "value": "\"logoIBMMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoKafka\"",
                        "computed": false
                      }, {
                        "value": "\"logoKibana\"",
                        "computed": false
                      }, {
                        "value": "\"logoKubernetes\"",
                        "computed": false
                      }, {
                        "value": "\"logoLogging\"",
                        "computed": false
                      }, {
                        "value": "\"logoLogstash\"",
                        "computed": false
                      }, {
                        "value": "\"logoMaps\"",
                        "computed": false
                      }, {
                        "value": "\"logoMemcached\"",
                        "computed": false
                      }, {
                        "value": "\"logoMetrics\"",
                        "computed": false
                      }, {
                        "value": "\"logoMongodb\"",
                        "computed": false
                      }, {
                        "value": "\"logoMySQL\"",
                        "computed": false
                      }, {
                        "value": "\"logoNginx\"",
                        "computed": false
                      }, {
                        "value": "\"logoObservability\"",
                        "computed": false
                      }, {
                        "value": "\"logoOsquery\"",
                        "computed": false
                      }, {
                        "value": "\"logoPhp\"",
                        "computed": false
                      }, {
                        "value": "\"logoPostgres\"",
                        "computed": false
                      }, {
                        "value": "\"logoPrometheus\"",
                        "computed": false
                      }, {
                        "value": "\"logoRabbitmq\"",
                        "computed": false
                      }, {
                        "value": "\"logoRedis\"",
                        "computed": false
                      }, {
                        "value": "\"logoSecurity\"",
                        "computed": false
                      }, {
                        "value": "\"logoSiteSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoSketch\"",
                        "computed": false
                      }, {
                        "value": "\"logoSlack\"",
                        "computed": false
                      }, {
                        "value": "\"logoUptime\"",
                        "computed": false
                      }, {
                        "value": "\"logoWebhook\"",
                        "computed": false
                      }, {
                        "value": "\"logoWindows\"",
                        "computed": false
                      }, {
                        "value": "\"logoWorkplaceSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logstashFilter\"",
                        "computed": false
                      }, {
                        "value": "\"logstashIf\"",
                        "computed": false
                      }, {
                        "value": "\"logstashInput\"",
                        "computed": false
                      }, {
                        "value": "\"logstashOutput\"",
                        "computed": false
                      }, {
                        "value": "\"logstashQueue\"",
                        "computed": false
                      }, {
                        "value": "\"machineLearningApp\"",
                        "computed": false
                      }, {
                        "value": "\"magnet\"",
                        "computed": false
                      }, {
                        "value": "\"magnifyWithMinus\"",
                        "computed": false
                      }, {
                        "value": "\"magnifyWithPlus\"",
                        "computed": false
                      }, {
                        "value": "\"managementApp\"",
                        "computed": false
                      }, {
                        "value": "\"mapMarker\"",
                        "computed": false
                      }, {
                        "value": "\"memory\"",
                        "computed": false
                      }, {
                        "value": "\"menu\"",
                        "computed": false
                      }, {
                        "value": "\"menuLeft\"",
                        "computed": false
                      }, {
                        "value": "\"menuRight\"",
                        "computed": false
                      }, {
                        "value": "\"merge\"",
                        "computed": false
                      }, {
                        "value": "\"metricbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"metricsApp\"",
                        "computed": false
                      }, {
                        "value": "\"minimize\"",
                        "computed": false
                      }, {
                        "value": "\"minusInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"minusInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"monitoringApp\"",
                        "computed": false
                      }, {
                        "value": "\"moon\"",
                        "computed": false
                      }, {
                        "value": "\"nested\"",
                        "computed": false
                      }, {
                        "value": "\"node\"",
                        "computed": false
                      }, {
                        "value": "\"notebookApp\"",
                        "computed": false
                      }, {
                        "value": "\"number\"",
                        "computed": false
                      }, {
                        "value": "\"offline\"",
                        "computed": false
                      }, {
                        "value": "\"online\"",
                        "computed": false
                      }, {
                        "value": "\"package\"",
                        "computed": false
                      }, {
                        "value": "\"packetbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"pageSelect\"",
                        "computed": false
                      }, {
                        "value": "\"pagesSelect\"",
                        "computed": false
                      }, {
                        "value": "\"partial\"",
                        "computed": false
                      }, {
                        "value": "\"paperClip\"",
                        "computed": false
                      }, {
                        "value": "\"pause\"",
                        "computed": false
                      }, {
                        "value": "\"pencil\"",
                        "computed": false
                      }, {
                        "value": "\"pin\"",
                        "computed": false
                      }, {
                        "value": "\"pinFilled\"",
                        "computed": false
                      }, {
                        "value": "\"pipelineApp\"",
                        "computed": false
                      }, {
                        "value": "\"play\"",
                        "computed": false
                      }, {
                        "value": "\"plusInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"plusInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"popout\"",
                        "computed": false
                      }, {
                        "value": "\"push\"",
                        "computed": false
                      }, {
                        "value": "\"questionInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"quote\"",
                        "computed": false
                      }, {
                        "value": "\"recentlyViewedApp\"",
                        "computed": false
                      }, {
                        "value": "\"refresh\"",
                        "computed": false
                      }, {
                        "value": "\"reporter\"",
                        "computed": false
                      }, {
                        "value": "\"reportingApp\"",
                        "computed": false
                      }, {
                        "value": "\"save\"",
                        "computed": false
                      }, {
                        "value": "\"savedObjectsApp\"",
                        "computed": false
                      }, {
                        "value": "\"scale\"",
                        "computed": false
                      }, {
                        "value": "\"search\"",
                        "computed": false
                      }, {
                        "value": "\"searchProfilerApp\"",
                        "computed": false
                      }, {
                        "value": "\"securityAnalyticsApp\"",
                        "computed": false
                      }, {
                        "value": "\"securityApp\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignal\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignalDetected\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignalResolved\"",
                        "computed": false
                      }, {
                        "value": "\"shard\"",
                        "computed": false
                      }, {
                        "value": "\"share\"",
                        "computed": false
                      }, {
                        "value": "\"snowflake\"",
                        "computed": false
                      }, {
                        "value": "\"sortable\"",
                        "computed": false
                      }, {
                        "value": "\"sortDown\"",
                        "computed": false
                      }, {
                        "value": "\"sortLeft\"",
                        "computed": false
                      }, {
                        "value": "\"sortRight\"",
                        "computed": false
                      }, {
                        "value": "\"sortUp\"",
                        "computed": false
                      }, {
                        "value": "\"spacesApp\"",
                        "computed": false
                      }, {
                        "value": "\"sqlApp\"",
                        "computed": false
                      }, {
                        "value": "\"starEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starEmptySpace\"",
                        "computed": false
                      }, {
                        "value": "\"starFilled\"",
                        "computed": false
                      }, {
                        "value": "\"starFilledSpace\"",
                        "computed": false
                      }, {
                        "value": "\"starMinusEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starMinusFilled\"",
                        "computed": false
                      }, {
                        "value": "\"starPlusEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starPlusFilled\"",
                        "computed": false
                      }, {
                        "value": "\"stats\"",
                        "computed": false
                      }, {
                        "value": "\"stop\"",
                        "computed": false
                      }, {
                        "value": "\"stopFilled\"",
                        "computed": false
                      }, {
                        "value": "\"stopSlash\"",
                        "computed": false
                      }, {
                        "value": "\"storage\"",
                        "computed": false
                      }, {
                        "value": "\"string\"",
                        "computed": false
                      }, {
                        "value": "\"submodule\"",
                        "computed": false
                      }, {
                        "value": "\"swatchInput\"",
                        "computed": false
                      }, {
                        "value": "\"symlink\"",
                        "computed": false
                      }, {
                        "value": "\"tableOfContents\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityExpanded\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityCompact\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityNormal\"",
                        "computed": false
                      }, {
                        "value": "\"tag\"",
                        "computed": false
                      }, {
                        "value": "\"tear\"",
                        "computed": false
                      }, {
                        "value": "\"temperature\"",
                        "computed": false
                      }, {
                        "value": "\"timeline\"",
                        "computed": false
                      }, {
                        "value": "\"timelionApp\"",
                        "computed": false
                      }, {
                        "value": "\"training\"",
                        "computed": false
                      }, {
                        "value": "\"trash\"",
                        "computed": false
                      }, {
                        "value": "\"upgradeAssistantApp\"",
                        "computed": false
                      }, {
                        "value": "\"uptimeApp\"",
                        "computed": false
                      }, {
                        "value": "\"user\"",
                        "computed": false
                      }, {
                        "value": "\"users\"",
                        "computed": false
                      }, {
                        "value": "\"usersRolesApp\"",
                        "computed": false
                      }, {
                        "value": "\"vector\"",
                        "computed": false
                      }, {
                        "value": "\"videoPlayer\"",
                        "computed": false
                      }, {
                        "value": "\"visArea\"",
                        "computed": false
                      }, {
                        "value": "\"visAreaStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visBarHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"visBarHorizontalStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visBarVertical\"",
                        "computed": false
                      }, {
                        "value": "\"visBarVerticalStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visGauge\"",
                        "computed": false
                      }, {
                        "value": "\"visGoal\"",
                        "computed": false
                      }, {
                        "value": "\"visLine\"",
                        "computed": false
                      }, {
                        "value": "\"visMapCoordinate\"",
                        "computed": false
                      }, {
                        "value": "\"visMapRegion\"",
                        "computed": false
                      }, {
                        "value": "\"visMetric\"",
                        "computed": false
                      }, {
                        "value": "\"visPie\"",
                        "computed": false
                      }, {
                        "value": "\"visTable\"",
                        "computed": false
                      }, {
                        "value": "\"visTagCloud\"",
                        "computed": false
                      }, {
                        "value": "\"visText\"",
                        "computed": false
                      }, {
                        "value": "\"visTimelion\"",
                        "computed": false
                      }, {
                        "value": "\"visualizeApp\"",
                        "computed": false
                      }, {
                        "value": "\"visVega\"",
                        "computed": false
                      }, {
                        "value": "\"visVisualBuilder\"",
                        "computed": false
                      }, {
                        "value": "\"watchesApp\"",
                        "computed": false
                      }, {
                        "value": "\"wrench\"",
                        "computed": false
                      }, {
                        "value": "\"tokenClass\"",
                        "computed": false
                      }, {
                        "value": "\"tokenProperty\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEnum\"",
                        "computed": false
                      }, {
                        "value": "\"tokenVariable\"",
                        "computed": false
                      }, {
                        "value": "\"tokenMethod\"",
                        "computed": false
                      }, {
                        "value": "\"tokenAnnotation\"",
                        "computed": false
                      }, {
                        "value": "\"tokenException\"",
                        "computed": false
                      }, {
                        "value": "\"tokenInterface\"",
                        "computed": false
                      }, {
                        "value": "\"tokenParameter\"",
                        "computed": false
                      }, {
                        "value": "\"tokenField\"",
                        "computed": false
                      }, {
                        "value": "\"tokenElement\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFunction\"",
                        "computed": false
                      }, {
                        "value": "\"tokenBoolean\"",
                        "computed": false
                      }, {
                        "value": "\"tokenString\"",
                        "computed": false
                      }, {
                        "value": "\"tokenArray\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNumber\"",
                        "computed": false
                      }, {
                        "value": "\"tokenConstant\"",
                        "computed": false
                      }, {
                        "value": "\"tokenObject\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEvent\"",
                        "computed": false
                      }, {
                        "value": "\"tokenKey\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNull\"",
                        "computed": false
                      }, {
                        "value": "\"tokenStruct\"",
                        "computed": false
                      }, {
                        "value": "\"tokenPackage\"",
                        "computed": false
                      }, {
                        "value": "\"tokenOperator\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEnumMember\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRepo\"",
                        "computed": false
                      }, {
                        "value": "\"tokenSymbol\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFile\"",
                        "computed": false
                      }, {
                        "value": "\"tokenModule\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNamespace\"",
                        "computed": false
                      }, {
                        "value": "\"tokenDate\"",
                        "computed": false
                      }, {
                        "value": "\"tokenIP\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNested\"",
                        "computed": false
                      }, {
                        "value": "\"tokenAlias\"",
                        "computed": false
                      }, {
                        "value": "\"tokenShape\"",
                        "computed": false
                      }, {
                        "value": "\"tokenGeo\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRange\"",
                        "computed": false
                      }, {
                        "value": "\"tokenBinary\"",
                        "computed": false
                      }, {
                        "value": "\"tokenJoin\"",
                        "computed": false
                      }, {
                        "value": "\"tokenPercolator\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFlattened\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRankFeature\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRankFeatures\"",
                        "computed": false
                      }, {
                        "value": "\"tokenKeyword\"",
                        "computed": false
                      }, {
                        "value": "\"tokenCompletionSuggester\"",
                        "computed": false
                      }, {
                        "value": "\"tokenDenseVector\"",
                        "computed": false
                      }, {
                        "value": "\"tokenText\"",
                        "computed": false
                      }, {
                        "value": "\"tokenTokenCount\"",
                        "computed": false
                      }, {
                        "value": "\"tokenSearchType\"",
                        "computed": false
                      }, {
                        "value": "\"tokenHistogram\"",
                        "computed": false
                      }]
                    }, {
                      "name": "string"
                    }, {
                      "name": "elementType"
                    }],
                    "required": true
                  },
                  "color": {
                    "name": "union",
                    "value": [{
                      "name": "string"
                    }, {
                      "name": "enum",
                      "value": [{
                        "value": "\"tint0\"",
                        "computed": false
                      }, {
                        "value": "\"tint1\"",
                        "computed": false
                      }, {
                        "value": "\"tint2\"",
                        "computed": false
                      }, {
                        "value": "\"tint3\"",
                        "computed": false
                      }, {
                        "value": "\"tint4\"",
                        "computed": false
                      }, {
                        "value": "\"tint5\"",
                        "computed": false
                      }, {
                        "value": "\"tint6\"",
                        "computed": false
                      }, {
                        "value": "\"tint7\"",
                        "computed": false
                      }, {
                        "value": "\"tint8\"",
                        "computed": false
                      }, {
                        "value": "\"tint9\"",
                        "computed": false
                      }, {
                        "value": "\"tint10\"",
                        "computed": false
                      }]
                    }],
                    "required": true
                  }
                },
                "description": "Takes 'iconType' for EuiIcon and 'color'. 'color' can be tint1 through tint9.",
                "required": true
              },
              "label": {
                "name": "string",
                "description": "Label or primary text.",
                "required": true
              },
              "description": {
                "name": "string",
                "description": "Description or secondary text (optional).",
                "required": false
              },
              "labelDisplay": {
                "name": "enum",
                "value": [{
                  "value": "\"fixed\"",
                  "computed": false
                }, {
                  "value": "\"expand\"",
                  "computed": false
                }],
                "description": "Label display is 'fixed' by default. Label will increase its width beyond 50% if needed with 'expand'.",
                "required": false
              },
              "onClick": {
                "name": "union",
                "value": [{
                  "name": "func"
                }, {
                  "name": "enum",
                  "value": [{
                    "value": "undefined",
                    "computed": true
                  }]
                }],
                "required": false
              }
            }
          }
        }]
      },
      "required": true,
      "description": "List of suggestions to display using 'suggestItem'."
    },
    "sendValue": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    }
  }
};