"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormFieldset = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _form_legend = require("./form_legend");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiFormFieldset = function EuiFormFieldset(_ref) {
  var children = _ref.children,
      className = _ref.className,
      legend = _ref.legend,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "legend"]);

  var legendDisplay = !!legend && _react.default.createElement(_form_legend.EuiFormLegend, legend);

  return _react.default.createElement("fieldset", (0, _extends2.default)({
    className: className
  }, rest), legendDisplay, children);
};

exports.EuiFormFieldset = EuiFormFieldset;
EuiFormFieldset.propTypes = {
  /**
     * Adds an EuiFormLegend element as the first child
     */
  legend: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    children: _propTypes.default.node.isRequired,

    /**
         * For a hidden legend that is still visible to the screen reader, set to 'hidden'
         */
    display: _propTypes.default.oneOf(["hidden", "visible"]),
    compressed: _propTypes.default.bool
  }),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
EuiFormFieldset.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiFormFieldset",
  "props": {
    "legend": {
      "type": {
        "name": "shape",
        "value": {
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "children": {
            "name": "node",
            "required": true
          },
          "display": {
            "name": "enum",
            "value": [{
              "value": "\"hidden\"",
              "computed": false
            }, {
              "value": "\"visible\"",
              "computed": false
            }],
            "description": "For a hidden legend that is still visible to the screen reader, set to 'hidden'",
            "required": false
          },
          "compressed": {
            "name": "bool",
            "required": false
          }
        }
      },
      "required": false,
      "description": "Adds an EuiFormLegend element as the first child"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};