"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPinnableListGroup = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../../i18n");

var _list_group = require("../list_group");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var pinExtraAction = {
  color: 'primary',
  iconType: 'pinFilled',
  iconSize: 's',
  className: 'euiPinnableListGroup__itemExtraAction'
};
var pinnedExtraAction = {
  color: 'primary',
  iconType: 'pinFilled',
  iconSize: 's',
  className: 'euiPinnableListGroup__itemExtraAction euiPinnableListGroup__itemExtraAction-pinned',
  alwaysShow: true
};

var EuiPinnableListGroup = function EuiPinnableListGroup(_ref) {
  var className = _ref.className,
      listItems = _ref.listItems,
      pinTitle = _ref.pinTitle,
      unpinTitle = _ref.unpinTitle,
      onPinClick = _ref.onPinClick,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "listItems", "pinTitle", "unpinTitle", "onPinClick"]);
  var classes = (0, _classnames.default)('euiPinnableListGroup', className); // Alter listItems object with extra props

  var getNewListItems = function getNewListItems(pinExtraActionLabel, pinnedExtraActionLabel) {
    return listItems.map(function (item) {
      var pinned = item.pinned,
          _item$pinnable = item.pinnable,
          pinnable = _item$pinnable === void 0 ? true : _item$pinnable,
          itemProps = (0, _objectWithoutProperties2.default)(item, ["pinned", "pinnable"]); // Make some declarations of props for the nav implementation

      itemProps.className = (0, _classnames.default)('euiPinnableListGroup__item', item.className); // Add the pinning action unless the item has it's own extra action

      if (onPinClick && !itemProps.extraAction && pinnable) {
        // Different displays for pinned vs unpinned
        if (pinned) {
          itemProps.extraAction = _objectSpread({}, pinnedExtraAction, {
            title: unpinTitle ? unpinTitle(item) : pinnedExtraActionLabel,
            'aria-label': unpinTitle ? unpinTitle(item) : pinnedExtraActionLabel
          });
        } else {
          itemProps.extraAction = _objectSpread({}, pinExtraAction, {
            title: pinTitle ? pinTitle(item) : pinExtraActionLabel,
            'aria-label': pinTitle ? pinTitle(item) : pinExtraActionLabel
          });
        } // Return the item on click


        itemProps.extraAction.onClick = function () {
          return onPinClick(item);
        };
      }

      return itemProps;
    });
  };

  return _react.default.createElement(_i18n.EuiI18n, {
    tokens: ['euiPinnableListGroup.pinExtraActionLabel', 'euiPinnableListGroup.pinnedExtraActionLabel'],
    defaults: ['Pin item', 'Unpin item']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
        pinExtraActionLabel = _ref3[0],
        pinnedExtraActionLabel = _ref3[1];

    var newListItems = getNewListItems(pinExtraActionLabel, pinnedExtraActionLabel);
    return _react.default.createElement(_list_group.EuiListGroup, (0, _extends2.default)({
      className: classes,
      listItems: newListItems
    }, rest));
  });
};

exports.EuiPinnableListGroup = EuiPinnableListGroup;
EuiPinnableListGroup.propTypes = {
  /**
       * Items to display in this group. See #EuiListGroupItem
       */

  /**
     * Extends `EuiListGroupItemProps`, at the very least, expecting a `label`.
     * See #EuiPinnableListGroupItem
     */
  listItems: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
         * Size of the label text
         */
    size: _propTypes.default.oneOf(["xs", "s", "m", "l"]),

    /**
         * By default the item will inherit the color of its wrapper (button/link/span),
         * otherwise pass one of the acceptable options
         */
    color: _propTypes.default.oneOf(["inherit", "primary", "text", "subdued", "ghost"]),

    /**
         * Content to be displayed in the list item
         */
    label: _propTypes.default.node.isRequired,

    /**
         * Apply styles indicating an item is active
         */
    isActive: _propTypes.default.bool,

    /**
         * Apply styles indicating an item is disabled
         */
    isDisabled: _propTypes.default.bool,

    /**
         * Make the list item label a link.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    href: _propTypes.default.string,
    target: _propTypes.default.string,
    rel: _propTypes.default.string,

    /**
         * Adds `EuiIcon` of `EuiIcon.type`
         */
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

    /**
         * Custom node to pass as the icon. Cannot be used in conjunction
         * with `iconType`.
         */
    icon: _propTypes.default.element,

    /**
         * Display tooltip on list item
         */
    showToolTip: _propTypes.default.bool,

    /**
         * Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;
         * pass `alwaysShow` if you don't want the default behavior of only showing on hover
         */
    extraAction: _propTypes.default.shape({
      onClick: _propTypes.default.func,
      iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
      color: _propTypes.default.oneOf(["danger", "disabled", "ghost", "primary", "subdued", "success", "text", "warning"]),
      "aria-label": _propTypes.default.string,
      "aria-labelledby": _propTypes.default.string,
      isDisabled: _propTypes.default.bool,
      size: _propTypes.default.oneOf(["s", "m"]),
      iconSize: _propTypes.default.oneOf(["original", "s", "m", "l", "xl", "xxl"]),
      className: _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      buttonRef: _propTypes.default.any,
      alwaysShow: _propTypes.default.bool
    }),

    /**
         * Make the list item label a button.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    onClick: _propTypes.default.func,

    /**
         * Allow link text to wrap
         */
    wrapText: _propTypes.default.bool,

    /**
         * Pass-through ref reference specifically for targeting
         * instances where the item content is rendered as a `button`
         */
    buttonRef: _propTypes.default.any,

    /**
       * Saves the pinned status and changes the visibility of the pin icon
       */
    pinned: _propTypes.default.bool,

    /**
       * Passing `onPinClick` to the full EuiPinnableListGroup, will make every item pinnable.
       * Set this property to `false` to turn off individual item pinnability
       */
    pinnable: _propTypes.default.bool
  }).isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
         * Size of the label text
         */
    size: _propTypes.default.oneOf(["xs", "s", "m", "l"]),

    /**
         * By default the item will inherit the color of its wrapper (button/link/span),
         * otherwise pass one of the acceptable options
         */
    color: _propTypes.default.oneOf(["inherit", "primary", "text", "subdued", "ghost"]),

    /**
         * Content to be displayed in the list item
         */
    label: _propTypes.default.node.isRequired,

    /**
         * Apply styles indicating an item is active
         */
    isActive: _propTypes.default.bool,

    /**
         * Apply styles indicating an item is disabled
         */
    isDisabled: _propTypes.default.bool,

    /**
         * Make the list item label a link.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    href: _propTypes.default.string,
    target: _propTypes.default.string,
    rel: _propTypes.default.string,

    /**
         * Adds `EuiIcon` of `EuiIcon.type`
         */
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

    /**
         * Custom node to pass as the icon. Cannot be used in conjunction
         * with `iconType`.
         */
    icon: _propTypes.default.element,

    /**
         * Display tooltip on list item
         */
    showToolTip: _propTypes.default.bool,

    /**
         * Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;
         * pass `alwaysShow` if you don't want the default behavior of only showing on hover
         */
    extraAction: _propTypes.default.shape({
      onClick: _propTypes.default.func,
      iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
      color: _propTypes.default.oneOf(["danger", "disabled", "ghost", "primary", "subdued", "success", "text", "warning"]),
      "aria-label": _propTypes.default.string,
      "aria-labelledby": _propTypes.default.string,
      isDisabled: _propTypes.default.bool,
      size: _propTypes.default.oneOf(["s", "m"]),
      iconSize: _propTypes.default.oneOf(["original", "s", "m", "l", "xl", "xxl"]),
      className: _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      buttonRef: _propTypes.default.any,
      alwaysShow: _propTypes.default.bool
    }),

    /**
         * Make the list item label a button.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    onClick: _propTypes.default.func,

    /**
         * Allow link text to wrap
         */
    wrapText: _propTypes.default.bool,

    /**
         * Pass-through ref reference specifically for targeting
         * instances where the item content is rendered as a `button`
         */
    buttonRef: _propTypes.default.any
  }).isRequired)]),

  /**
     * Shows the pin icon and calls this function on click.
     * Returns `item: EuiPinnableListGroupItemProps`
     */
  onPinClick: _propTypes.default.func.isRequired,

  /**
     * The pin icon needs a title/aria-label for accessibility.
     * It is a function that passes the item back and must return a string `(item) => string`.
     * Default is `"Pin item"`
     */
  pinTitle: _propTypes.default.func,

  /**
     * The unpin icon needs a title/aria-label for accessibility.
     * It is a function that passes the item back and must return a string `(item) => string`.
     * Default is `"Unpin item"`
     */
  unpinTitle: _propTypes.default.func,
  className: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
  "aria-label": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
  "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),

  /**
       * Add a border to the list container
       */
  bordered: _propTypes.default.bool,

  /**
       * Remove container padding, stretching list items to the edges
       */
  flush: _propTypes.default.bool,

  /**
       * Spacing between list items
       */
  gutterSize: _propTypes.default.oneOf(["none", "s", "m"]),

  /**
       * Change the colors of all `listItems` at once
       */
  color: _propTypes.default.oneOf(["inherit", "primary", "text", "subdued", "ghost"]),

  /**
       * Change the size of all `listItems` at once
       */
  size: _propTypes.default.oneOf(["xs", "s", "m", "l"]),

  /**
       * Sets the max-width of the page,
       * set to `true` to use the default size,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
  maxWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
       * Display tooltips on all list items
       */
  showToolTips: _propTypes.default.bool,

  /**
       * Allow link text to wrap vs truncated
       */
  wrapText: _propTypes.default.bool,
  ariaLabelledby: _propTypes.default.string
};
EuiPinnableListGroup.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiPinnableListGroup",
  "props": {
    "listItems": {
      "type": {
        "name": "union",
        "value": [{
          "name": "arrayOf",
          "value": {
            "name": "shape",
            "value": {
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              },
              "size": {
                "name": "enum",
                "value": [{
                  "value": "\"xs\"",
                  "computed": false
                }, {
                  "value": "\"s\"",
                  "computed": false
                }, {
                  "value": "\"m\"",
                  "computed": false
                }, {
                  "value": "\"l\"",
                  "computed": false
                }],
                "description": "Size of the label text",
                "required": false
              },
              "color": {
                "name": "enum",
                "value": [{
                  "value": "\"inherit\"",
                  "computed": false
                }, {
                  "value": "\"primary\"",
                  "computed": false
                }, {
                  "value": "\"text\"",
                  "computed": false
                }, {
                  "value": "\"subdued\"",
                  "computed": false
                }, {
                  "value": "\"ghost\"",
                  "computed": false
                }],
                "description": "By default the item will inherit the color of its wrapper (button/link/span),\notherwise pass one of the acceptable options",
                "required": false
              },
              "label": {
                "name": "node",
                "description": "Content to be displayed in the list item",
                "required": true
              },
              "isActive": {
                "name": "bool",
                "description": "Apply styles indicating an item is active",
                "required": false
              },
              "isDisabled": {
                "name": "bool",
                "description": "Apply styles indicating an item is disabled",
                "required": false
              },
              "href": {
                "name": "string",
                "description": "Make the list item label a link.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems.",
                "required": false
              },
              "target": {
                "name": "string",
                "required": false
              },
              "rel": {
                "name": "string",
                "required": false
              },
              "iconType": {
                "name": "union",
                "value": [{
                  "name": "enum",
                  "value": [{
                    "value": "\"accessibility\"",
                    "computed": false
                  }, {
                    "value": "\"addDataApp\"",
                    "computed": false
                  }, {
                    "value": "\"advancedSettingsApp\"",
                    "computed": false
                  }, {
                    "value": "\"aggregate\"",
                    "computed": false
                  }, {
                    "value": "\"alert\"",
                    "computed": false
                  }, {
                    "value": "\"annotation\"",
                    "computed": false
                  }, {
                    "value": "\"apmApp\"",
                    "computed": false
                  }, {
                    "value": "\"apmTrace\"",
                    "computed": false
                  }, {
                    "value": "\"apps\"",
                    "computed": false
                  }, {
                    "value": "\"arrowDown\"",
                    "computed": false
                  }, {
                    "value": "\"arrowLeft\"",
                    "computed": false
                  }, {
                    "value": "\"arrowRight\"",
                    "computed": false
                  }, {
                    "value": "\"arrowUp\"",
                    "computed": false
                  }, {
                    "value": "\"asterisk\"",
                    "computed": false
                  }, {
                    "value": "\"auditbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"beaker\"",
                    "computed": false
                  }, {
                    "value": "\"bell\"",
                    "computed": false
                  }, {
                    "value": "\"bellSlash\"",
                    "computed": false
                  }, {
                    "value": "\"bolt\"",
                    "computed": false
                  }, {
                    "value": "\"boxesHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"boxesVertical\"",
                    "computed": false
                  }, {
                    "value": "\"branch\"",
                    "computed": false
                  }, {
                    "value": "\"broom\"",
                    "computed": false
                  }, {
                    "value": "\"brush\"",
                    "computed": false
                  }, {
                    "value": "\"bug\"",
                    "computed": false
                  }, {
                    "value": "\"bullseye\"",
                    "computed": false
                  }, {
                    "value": "\"calendar\"",
                    "computed": false
                  }, {
                    "value": "\"canvasApp\"",
                    "computed": false
                  }, {
                    "value": "\"codeApp\"",
                    "computed": false
                  }, {
                    "value": "\"check\"",
                    "computed": false
                  }, {
                    "value": "\"checkInCircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"cheer\"",
                    "computed": false
                  }, {
                    "value": "\"clock\"",
                    "computed": false
                  }, {
                    "value": "\"cloudDrizzle\"",
                    "computed": false
                  }, {
                    "value": "\"cloudStormy\"",
                    "computed": false
                  }, {
                    "value": "\"cloudSunny\"",
                    "computed": false
                  }, {
                    "value": "\"compute\"",
                    "computed": false
                  }, {
                    "value": "\"console\"",
                    "computed": false
                  }, {
                    "value": "\"consoleApp\"",
                    "computed": false
                  }, {
                    "value": "\"controlsHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"controlsVertical\"",
                    "computed": false
                  }, {
                    "value": "\"copy\"",
                    "computed": false
                  }, {
                    "value": "\"copyClipboard\"",
                    "computed": false
                  }, {
                    "value": "\"createAdvancedJob\"",
                    "computed": false
                  }, {
                    "value": "\"createMultiMetricJob\"",
                    "computed": false
                  }, {
                    "value": "\"createPopulationJob\"",
                    "computed": false
                  }, {
                    "value": "\"createSingleMetricJob\"",
                    "computed": false
                  }, {
                    "value": "\"cross\"",
                    "computed": false
                  }, {
                    "value": "\"crossClusterReplicationApp\"",
                    "computed": false
                  }, {
                    "value": "\"crosshairs\"",
                    "computed": false
                  }, {
                    "value": "\"crossInACircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"currency\"",
                    "computed": false
                  }, {
                    "value": "\"cut\"",
                    "computed": false
                  }, {
                    "value": "\"dashboardApp\"",
                    "computed": false
                  }, {
                    "value": "\"database\"",
                    "computed": false
                  }, {
                    "value": "\"dataVisualizer\"",
                    "computed": false
                  }, {
                    "value": "\"devToolsApp\"",
                    "computed": false
                  }, {
                    "value": "\"discoverApp\"",
                    "computed": false
                  }, {
                    "value": "\"document\"",
                    "computed": false
                  }, {
                    "value": "\"documentEdit\"",
                    "computed": false
                  }, {
                    "value": "\"documents\"",
                    "computed": false
                  }, {
                    "value": "\"dot\"",
                    "computed": false
                  }, {
                    "value": "\"download\"",
                    "computed": false
                  }, {
                    "value": "\"editorAlignCenter\"",
                    "computed": false
                  }, {
                    "value": "\"editorAlignLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorAlignRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorBold\"",
                    "computed": false
                  }, {
                    "value": "\"editorCodeBlock\"",
                    "computed": false
                  }, {
                    "value": "\"editorComment\"",
                    "computed": false
                  }, {
                    "value": "\"editorDistributeHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"editorDistributeVertical\"",
                    "computed": false
                  }, {
                    "value": "\"editorHeading\"",
                    "computed": false
                  }, {
                    "value": "\"editorItalic\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignBottom\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignCenter\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignMiddle\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignTop\"",
                    "computed": false
                  }, {
                    "value": "\"editorLink\"",
                    "computed": false
                  }, {
                    "value": "\"editorOrderedList\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionBottomLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionBottomRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionTopLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionTopRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorRedo\"",
                    "computed": false
                  }, {
                    "value": "\"editorStrike\"",
                    "computed": false
                  }, {
                    "value": "\"editorTable\"",
                    "computed": false
                  }, {
                    "value": "\"editorUnderline\"",
                    "computed": false
                  }, {
                    "value": "\"editorUndo\"",
                    "computed": false
                  }, {
                    "value": "\"editorUnorderedList\"",
                    "computed": false
                  }, {
                    "value": "\"email\"",
                    "computed": false
                  }, {
                    "value": "\"empty\"",
                    "computed": false
                  }, {
                    "value": "\"emsApp\"",
                    "computed": false
                  }, {
                    "value": "\"exit\"",
                    "computed": false
                  }, {
                    "value": "\"expand\"",
                    "computed": false
                  }, {
                    "value": "\"expandMini\"",
                    "computed": false
                  }, {
                    "value": "\"exportAction\"",
                    "computed": false
                  }, {
                    "value": "\"eye\"",
                    "computed": false
                  }, {
                    "value": "\"eyeClosed\"",
                    "computed": false
                  }, {
                    "value": "\"faceHappy\"",
                    "computed": false
                  }, {
                    "value": "\"faceNeutral\"",
                    "computed": false
                  }, {
                    "value": "\"faceSad\"",
                    "computed": false
                  }, {
                    "value": "\"filebeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"filter\"",
                    "computed": false
                  }, {
                    "value": "\"flag\"",
                    "computed": false
                  }, {
                    "value": "\"folderCheck\"",
                    "computed": false
                  }, {
                    "value": "\"folderClosed\"",
                    "computed": false
                  }, {
                    "value": "\"folderExclamation\"",
                    "computed": false
                  }, {
                    "value": "\"folderOpen\"",
                    "computed": false
                  }, {
                    "value": "\"fullScreen\"",
                    "computed": false
                  }, {
                    "value": "\"gear\"",
                    "computed": false
                  }, {
                    "value": "\"gisApp\"",
                    "computed": false
                  }, {
                    "value": "\"glasses\"",
                    "computed": false
                  }, {
                    "value": "\"globe\"",
                    "computed": false
                  }, {
                    "value": "\"grab\"",
                    "computed": false
                  }, {
                    "value": "\"grabHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"graphApp\"",
                    "computed": false
                  }, {
                    "value": "\"grid\"",
                    "computed": false
                  }, {
                    "value": "\"grokApp\"",
                    "computed": false
                  }, {
                    "value": "\"heart\"",
                    "computed": false
                  }, {
                    "value": "\"heartbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"heatmap\"",
                    "computed": false
                  }, {
                    "value": "\"help\"",
                    "computed": false
                  }, {
                    "value": "\"home\"",
                    "computed": false
                  }, {
                    "value": "\"iInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"image\"",
                    "computed": false
                  }, {
                    "value": "\"importAction\"",
                    "computed": false
                  }, {
                    "value": "\"indexClose\"",
                    "computed": false
                  }, {
                    "value": "\"indexEdit\"",
                    "computed": false
                  }, {
                    "value": "\"indexFlush\"",
                    "computed": false
                  }, {
                    "value": "\"indexManagementApp\"",
                    "computed": false
                  }, {
                    "value": "\"indexMapping\"",
                    "computed": false
                  }, {
                    "value": "\"indexOpen\"",
                    "computed": false
                  }, {
                    "value": "\"indexPatternApp\"",
                    "computed": false
                  }, {
                    "value": "\"indexRollupApp\"",
                    "computed": false
                  }, {
                    "value": "\"indexSettings\"",
                    "computed": false
                  }, {
                    "value": "\"inputOutput\"",
                    "computed": false
                  }, {
                    "value": "\"inspect\"",
                    "computed": false
                  }, {
                    "value": "\"invert\"",
                    "computed": false
                  }, {
                    "value": "\"ip\"",
                    "computed": false
                  }, {
                    "value": "\"keyboardShortcut\"",
                    "computed": false
                  }, {
                    "value": "\"kqlField\"",
                    "computed": false
                  }, {
                    "value": "\"kqlFunction\"",
                    "computed": false
                  }, {
                    "value": "\"kqlOperand\"",
                    "computed": false
                  }, {
                    "value": "\"kqlSelector\"",
                    "computed": false
                  }, {
                    "value": "\"kqlValue\"",
                    "computed": false
                  }, {
                    "value": "\"lensApp\"",
                    "computed": false
                  }, {
                    "value": "\"link\"",
                    "computed": false
                  }, {
                    "value": "\"list\"",
                    "computed": false
                  }, {
                    "value": "\"listAdd\"",
                    "computed": false
                  }, {
                    "value": "\"lock\"",
                    "computed": false
                  }, {
                    "value": "\"lockOpen\"",
                    "computed": false
                  }, {
                    "value": "\"logsApp\"",
                    "computed": false
                  }, {
                    "value": "\"logoAerospike\"",
                    "computed": false
                  }, {
                    "value": "\"logoApache\"",
                    "computed": false
                  }, {
                    "value": "\"logoAPM\"",
                    "computed": false
                  }, {
                    "value": "\"logoAppSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoAWS\"",
                    "computed": false
                  }, {
                    "value": "\"logoAWSMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoAzure\"",
                    "computed": false
                  }, {
                    "value": "\"logoAzureMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoBeats\"",
                    "computed": false
                  }, {
                    "value": "\"logoBusinessAnalytics\"",
                    "computed": false
                  }, {
                    "value": "\"logoCeph\"",
                    "computed": false
                  }, {
                    "value": "\"logoCloud\"",
                    "computed": false
                  }, {
                    "value": "\"logoCloudEnterprise\"",
                    "computed": false
                  }, {
                    "value": "\"logoCode\"",
                    "computed": false
                  }, {
                    "value": "\"logoCodesandbox\"",
                    "computed": false
                  }, {
                    "value": "\"logoCouchbase\"",
                    "computed": false
                  }, {
                    "value": "\"logoDocker\"",
                    "computed": false
                  }, {
                    "value": "\"logoDropwizard\"",
                    "computed": false
                  }, {
                    "value": "\"logoElastic\"",
                    "computed": false
                  }, {
                    "value": "\"logoElasticsearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoElasticStack\"",
                    "computed": false
                  }, {
                    "value": "\"logoEnterpriseSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoEtcd\"",
                    "computed": false
                  }, {
                    "value": "\"logoGCP\"",
                    "computed": false
                  }, {
                    "value": "\"logoGCPMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoGithub\"",
                    "computed": false
                  }, {
                    "value": "\"logoGmail\"",
                    "computed": false
                  }, {
                    "value": "\"logoGolang\"",
                    "computed": false
                  }, {
                    "value": "\"logoGoogleG\"",
                    "computed": false
                  }, {
                    "value": "\"logoHAproxy\"",
                    "computed": false
                  }, {
                    "value": "\"logoIBM\"",
                    "computed": false
                  }, {
                    "value": "\"logoIBMMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoKafka\"",
                    "computed": false
                  }, {
                    "value": "\"logoKibana\"",
                    "computed": false
                  }, {
                    "value": "\"logoKubernetes\"",
                    "computed": false
                  }, {
                    "value": "\"logoLogging\"",
                    "computed": false
                  }, {
                    "value": "\"logoLogstash\"",
                    "computed": false
                  }, {
                    "value": "\"logoMaps\"",
                    "computed": false
                  }, {
                    "value": "\"logoMemcached\"",
                    "computed": false
                  }, {
                    "value": "\"logoMetrics\"",
                    "computed": false
                  }, {
                    "value": "\"logoMongodb\"",
                    "computed": false
                  }, {
                    "value": "\"logoMySQL\"",
                    "computed": false
                  }, {
                    "value": "\"logoNginx\"",
                    "computed": false
                  }, {
                    "value": "\"logoObservability\"",
                    "computed": false
                  }, {
                    "value": "\"logoOsquery\"",
                    "computed": false
                  }, {
                    "value": "\"logoPhp\"",
                    "computed": false
                  }, {
                    "value": "\"logoPostgres\"",
                    "computed": false
                  }, {
                    "value": "\"logoPrometheus\"",
                    "computed": false
                  }, {
                    "value": "\"logoRabbitmq\"",
                    "computed": false
                  }, {
                    "value": "\"logoRedis\"",
                    "computed": false
                  }, {
                    "value": "\"logoSecurity\"",
                    "computed": false
                  }, {
                    "value": "\"logoSiteSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoSketch\"",
                    "computed": false
                  }, {
                    "value": "\"logoSlack\"",
                    "computed": false
                  }, {
                    "value": "\"logoUptime\"",
                    "computed": false
                  }, {
                    "value": "\"logoWebhook\"",
                    "computed": false
                  }, {
                    "value": "\"logoWindows\"",
                    "computed": false
                  }, {
                    "value": "\"logoWorkplaceSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logstashFilter\"",
                    "computed": false
                  }, {
                    "value": "\"logstashIf\"",
                    "computed": false
                  }, {
                    "value": "\"logstashInput\"",
                    "computed": false
                  }, {
                    "value": "\"logstashOutput\"",
                    "computed": false
                  }, {
                    "value": "\"logstashQueue\"",
                    "computed": false
                  }, {
                    "value": "\"machineLearningApp\"",
                    "computed": false
                  }, {
                    "value": "\"magnet\"",
                    "computed": false
                  }, {
                    "value": "\"magnifyWithMinus\"",
                    "computed": false
                  }, {
                    "value": "\"magnifyWithPlus\"",
                    "computed": false
                  }, {
                    "value": "\"managementApp\"",
                    "computed": false
                  }, {
                    "value": "\"mapMarker\"",
                    "computed": false
                  }, {
                    "value": "\"memory\"",
                    "computed": false
                  }, {
                    "value": "\"menu\"",
                    "computed": false
                  }, {
                    "value": "\"menuLeft\"",
                    "computed": false
                  }, {
                    "value": "\"menuRight\"",
                    "computed": false
                  }, {
                    "value": "\"merge\"",
                    "computed": false
                  }, {
                    "value": "\"metricbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"metricsApp\"",
                    "computed": false
                  }, {
                    "value": "\"minimize\"",
                    "computed": false
                  }, {
                    "value": "\"minusInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"minusInCircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"monitoringApp\"",
                    "computed": false
                  }, {
                    "value": "\"moon\"",
                    "computed": false
                  }, {
                    "value": "\"nested\"",
                    "computed": false
                  }, {
                    "value": "\"node\"",
                    "computed": false
                  }, {
                    "value": "\"notebookApp\"",
                    "computed": false
                  }, {
                    "value": "\"number\"",
                    "computed": false
                  }, {
                    "value": "\"offline\"",
                    "computed": false
                  }, {
                    "value": "\"online\"",
                    "computed": false
                  }, {
                    "value": "\"package\"",
                    "computed": false
                  }, {
                    "value": "\"packetbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"pageSelect\"",
                    "computed": false
                  }, {
                    "value": "\"pagesSelect\"",
                    "computed": false
                  }, {
                    "value": "\"partial\"",
                    "computed": false
                  }, {
                    "value": "\"paperClip\"",
                    "computed": false
                  }, {
                    "value": "\"pause\"",
                    "computed": false
                  }, {
                    "value": "\"pencil\"",
                    "computed": false
                  }, {
                    "value": "\"pin\"",
                    "computed": false
                  }, {
                    "value": "\"pinFilled\"",
                    "computed": false
                  }, {
                    "value": "\"pipelineApp\"",
                    "computed": false
                  }, {
                    "value": "\"play\"",
                    "computed": false
                  }, {
                    "value": "\"plusInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"plusInCircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"popout\"",
                    "computed": false
                  }, {
                    "value": "\"push\"",
                    "computed": false
                  }, {
                    "value": "\"questionInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"quote\"",
                    "computed": false
                  }, {
                    "value": "\"recentlyViewedApp\"",
                    "computed": false
                  }, {
                    "value": "\"refresh\"",
                    "computed": false
                  }, {
                    "value": "\"reporter\"",
                    "computed": false
                  }, {
                    "value": "\"reportingApp\"",
                    "computed": false
                  }, {
                    "value": "\"save\"",
                    "computed": false
                  }, {
                    "value": "\"savedObjectsApp\"",
                    "computed": false
                  }, {
                    "value": "\"scale\"",
                    "computed": false
                  }, {
                    "value": "\"search\"",
                    "computed": false
                  }, {
                    "value": "\"searchProfilerApp\"",
                    "computed": false
                  }, {
                    "value": "\"securityAnalyticsApp\"",
                    "computed": false
                  }, {
                    "value": "\"securityApp\"",
                    "computed": false
                  }, {
                    "value": "\"securitySignal\"",
                    "computed": false
                  }, {
                    "value": "\"securitySignalDetected\"",
                    "computed": false
                  }, {
                    "value": "\"securitySignalResolved\"",
                    "computed": false
                  }, {
                    "value": "\"shard\"",
                    "computed": false
                  }, {
                    "value": "\"share\"",
                    "computed": false
                  }, {
                    "value": "\"snowflake\"",
                    "computed": false
                  }, {
                    "value": "\"sortable\"",
                    "computed": false
                  }, {
                    "value": "\"sortDown\"",
                    "computed": false
                  }, {
                    "value": "\"sortLeft\"",
                    "computed": false
                  }, {
                    "value": "\"sortRight\"",
                    "computed": false
                  }, {
                    "value": "\"sortUp\"",
                    "computed": false
                  }, {
                    "value": "\"spacesApp\"",
                    "computed": false
                  }, {
                    "value": "\"sqlApp\"",
                    "computed": false
                  }, {
                    "value": "\"starEmpty\"",
                    "computed": false
                  }, {
                    "value": "\"starEmptySpace\"",
                    "computed": false
                  }, {
                    "value": "\"starFilled\"",
                    "computed": false
                  }, {
                    "value": "\"starFilledSpace\"",
                    "computed": false
                  }, {
                    "value": "\"starMinusEmpty\"",
                    "computed": false
                  }, {
                    "value": "\"starMinusFilled\"",
                    "computed": false
                  }, {
                    "value": "\"starPlusEmpty\"",
                    "computed": false
                  }, {
                    "value": "\"starPlusFilled\"",
                    "computed": false
                  }, {
                    "value": "\"stats\"",
                    "computed": false
                  }, {
                    "value": "\"stop\"",
                    "computed": false
                  }, {
                    "value": "\"stopFilled\"",
                    "computed": false
                  }, {
                    "value": "\"stopSlash\"",
                    "computed": false
                  }, {
                    "value": "\"storage\"",
                    "computed": false
                  }, {
                    "value": "\"string\"",
                    "computed": false
                  }, {
                    "value": "\"submodule\"",
                    "computed": false
                  }, {
                    "value": "\"swatchInput\"",
                    "computed": false
                  }, {
                    "value": "\"symlink\"",
                    "computed": false
                  }, {
                    "value": "\"tableOfContents\"",
                    "computed": false
                  }, {
                    "value": "\"tableDensityExpanded\"",
                    "computed": false
                  }, {
                    "value": "\"tableDensityCompact\"",
                    "computed": false
                  }, {
                    "value": "\"tableDensityNormal\"",
                    "computed": false
                  }, {
                    "value": "\"tag\"",
                    "computed": false
                  }, {
                    "value": "\"tear\"",
                    "computed": false
                  }, {
                    "value": "\"temperature\"",
                    "computed": false
                  }, {
                    "value": "\"timeline\"",
                    "computed": false
                  }, {
                    "value": "\"timelionApp\"",
                    "computed": false
                  }, {
                    "value": "\"training\"",
                    "computed": false
                  }, {
                    "value": "\"trash\"",
                    "computed": false
                  }, {
                    "value": "\"upgradeAssistantApp\"",
                    "computed": false
                  }, {
                    "value": "\"uptimeApp\"",
                    "computed": false
                  }, {
                    "value": "\"user\"",
                    "computed": false
                  }, {
                    "value": "\"users\"",
                    "computed": false
                  }, {
                    "value": "\"usersRolesApp\"",
                    "computed": false
                  }, {
                    "value": "\"vector\"",
                    "computed": false
                  }, {
                    "value": "\"videoPlayer\"",
                    "computed": false
                  }, {
                    "value": "\"visArea\"",
                    "computed": false
                  }, {
                    "value": "\"visAreaStacked\"",
                    "computed": false
                  }, {
                    "value": "\"visBarHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"visBarHorizontalStacked\"",
                    "computed": false
                  }, {
                    "value": "\"visBarVertical\"",
                    "computed": false
                  }, {
                    "value": "\"visBarVerticalStacked\"",
                    "computed": false
                  }, {
                    "value": "\"visGauge\"",
                    "computed": false
                  }, {
                    "value": "\"visGoal\"",
                    "computed": false
                  }, {
                    "value": "\"visLine\"",
                    "computed": false
                  }, {
                    "value": "\"visMapCoordinate\"",
                    "computed": false
                  }, {
                    "value": "\"visMapRegion\"",
                    "computed": false
                  }, {
                    "value": "\"visMetric\"",
                    "computed": false
                  }, {
                    "value": "\"visPie\"",
                    "computed": false
                  }, {
                    "value": "\"visTable\"",
                    "computed": false
                  }, {
                    "value": "\"visTagCloud\"",
                    "computed": false
                  }, {
                    "value": "\"visText\"",
                    "computed": false
                  }, {
                    "value": "\"visTimelion\"",
                    "computed": false
                  }, {
                    "value": "\"visualizeApp\"",
                    "computed": false
                  }, {
                    "value": "\"visVega\"",
                    "computed": false
                  }, {
                    "value": "\"visVisualBuilder\"",
                    "computed": false
                  }, {
                    "value": "\"watchesApp\"",
                    "computed": false
                  }, {
                    "value": "\"wrench\"",
                    "computed": false
                  }, {
                    "value": "\"tokenClass\"",
                    "computed": false
                  }, {
                    "value": "\"tokenProperty\"",
                    "computed": false
                  }, {
                    "value": "\"tokenEnum\"",
                    "computed": false
                  }, {
                    "value": "\"tokenVariable\"",
                    "computed": false
                  }, {
                    "value": "\"tokenMethod\"",
                    "computed": false
                  }, {
                    "value": "\"tokenAnnotation\"",
                    "computed": false
                  }, {
                    "value": "\"tokenException\"",
                    "computed": false
                  }, {
                    "value": "\"tokenInterface\"",
                    "computed": false
                  }, {
                    "value": "\"tokenParameter\"",
                    "computed": false
                  }, {
                    "value": "\"tokenField\"",
                    "computed": false
                  }, {
                    "value": "\"tokenElement\"",
                    "computed": false
                  }, {
                    "value": "\"tokenFunction\"",
                    "computed": false
                  }, {
                    "value": "\"tokenBoolean\"",
                    "computed": false
                  }, {
                    "value": "\"tokenString\"",
                    "computed": false
                  }, {
                    "value": "\"tokenArray\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNumber\"",
                    "computed": false
                  }, {
                    "value": "\"tokenConstant\"",
                    "computed": false
                  }, {
                    "value": "\"tokenObject\"",
                    "computed": false
                  }, {
                    "value": "\"tokenEvent\"",
                    "computed": false
                  }, {
                    "value": "\"tokenKey\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNull\"",
                    "computed": false
                  }, {
                    "value": "\"tokenStruct\"",
                    "computed": false
                  }, {
                    "value": "\"tokenPackage\"",
                    "computed": false
                  }, {
                    "value": "\"tokenOperator\"",
                    "computed": false
                  }, {
                    "value": "\"tokenEnumMember\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRepo\"",
                    "computed": false
                  }, {
                    "value": "\"tokenSymbol\"",
                    "computed": false
                  }, {
                    "value": "\"tokenFile\"",
                    "computed": false
                  }, {
                    "value": "\"tokenModule\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNamespace\"",
                    "computed": false
                  }, {
                    "value": "\"tokenDate\"",
                    "computed": false
                  }, {
                    "value": "\"tokenIP\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNested\"",
                    "computed": false
                  }, {
                    "value": "\"tokenAlias\"",
                    "computed": false
                  }, {
                    "value": "\"tokenShape\"",
                    "computed": false
                  }, {
                    "value": "\"tokenGeo\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRange\"",
                    "computed": false
                  }, {
                    "value": "\"tokenBinary\"",
                    "computed": false
                  }, {
                    "value": "\"tokenJoin\"",
                    "computed": false
                  }, {
                    "value": "\"tokenPercolator\"",
                    "computed": false
                  }, {
                    "value": "\"tokenFlattened\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRankFeature\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRankFeatures\"",
                    "computed": false
                  }, {
                    "value": "\"tokenKeyword\"",
                    "computed": false
                  }, {
                    "value": "\"tokenCompletionSuggester\"",
                    "computed": false
                  }, {
                    "value": "\"tokenDenseVector\"",
                    "computed": false
                  }, {
                    "value": "\"tokenText\"",
                    "computed": false
                  }, {
                    "value": "\"tokenTokenCount\"",
                    "computed": false
                  }, {
                    "value": "\"tokenSearchType\"",
                    "computed": false
                  }, {
                    "value": "\"tokenHistogram\"",
                    "computed": false
                  }]
                }, {
                  "name": "string"
                }, {
                  "name": "elementType"
                }],
                "description": "Adds `EuiIcon` of `EuiIcon.type`",
                "required": false
              },
              "icon": {
                "name": "element",
                "description": "Custom node to pass as the icon. Cannot be used in conjunction\nwith `iconType`.",
                "required": false
              },
              "showToolTip": {
                "name": "bool",
                "description": "Display tooltip on list item",
                "required": false
              },
              "extraAction": {
                "name": "shape",
                "value": {
                  "onClick": {
                    "name": "func",
                    "required": false
                  },
                  "iconType": {
                    "name": "union",
                    "value": [{
                      "name": "enum",
                      "value": [{
                        "value": "\"accessibility\"",
                        "computed": false
                      }, {
                        "value": "\"addDataApp\"",
                        "computed": false
                      }, {
                        "value": "\"advancedSettingsApp\"",
                        "computed": false
                      }, {
                        "value": "\"aggregate\"",
                        "computed": false
                      }, {
                        "value": "\"alert\"",
                        "computed": false
                      }, {
                        "value": "\"annotation\"",
                        "computed": false
                      }, {
                        "value": "\"apmApp\"",
                        "computed": false
                      }, {
                        "value": "\"apmTrace\"",
                        "computed": false
                      }, {
                        "value": "\"apps\"",
                        "computed": false
                      }, {
                        "value": "\"arrowDown\"",
                        "computed": false
                      }, {
                        "value": "\"arrowLeft\"",
                        "computed": false
                      }, {
                        "value": "\"arrowRight\"",
                        "computed": false
                      }, {
                        "value": "\"arrowUp\"",
                        "computed": false
                      }, {
                        "value": "\"asterisk\"",
                        "computed": false
                      }, {
                        "value": "\"auditbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"beaker\"",
                        "computed": false
                      }, {
                        "value": "\"bell\"",
                        "computed": false
                      }, {
                        "value": "\"bellSlash\"",
                        "computed": false
                      }, {
                        "value": "\"bolt\"",
                        "computed": false
                      }, {
                        "value": "\"boxesHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"boxesVertical\"",
                        "computed": false
                      }, {
                        "value": "\"branch\"",
                        "computed": false
                      }, {
                        "value": "\"broom\"",
                        "computed": false
                      }, {
                        "value": "\"brush\"",
                        "computed": false
                      }, {
                        "value": "\"bug\"",
                        "computed": false
                      }, {
                        "value": "\"bullseye\"",
                        "computed": false
                      }, {
                        "value": "\"calendar\"",
                        "computed": false
                      }, {
                        "value": "\"canvasApp\"",
                        "computed": false
                      }, {
                        "value": "\"codeApp\"",
                        "computed": false
                      }, {
                        "value": "\"check\"",
                        "computed": false
                      }, {
                        "value": "\"checkInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"cheer\"",
                        "computed": false
                      }, {
                        "value": "\"clock\"",
                        "computed": false
                      }, {
                        "value": "\"cloudDrizzle\"",
                        "computed": false
                      }, {
                        "value": "\"cloudStormy\"",
                        "computed": false
                      }, {
                        "value": "\"cloudSunny\"",
                        "computed": false
                      }, {
                        "value": "\"compute\"",
                        "computed": false
                      }, {
                        "value": "\"console\"",
                        "computed": false
                      }, {
                        "value": "\"consoleApp\"",
                        "computed": false
                      }, {
                        "value": "\"controlsHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"controlsVertical\"",
                        "computed": false
                      }, {
                        "value": "\"copy\"",
                        "computed": false
                      }, {
                        "value": "\"copyClipboard\"",
                        "computed": false
                      }, {
                        "value": "\"createAdvancedJob\"",
                        "computed": false
                      }, {
                        "value": "\"createMultiMetricJob\"",
                        "computed": false
                      }, {
                        "value": "\"createPopulationJob\"",
                        "computed": false
                      }, {
                        "value": "\"createSingleMetricJob\"",
                        "computed": false
                      }, {
                        "value": "\"cross\"",
                        "computed": false
                      }, {
                        "value": "\"crossClusterReplicationApp\"",
                        "computed": false
                      }, {
                        "value": "\"crosshairs\"",
                        "computed": false
                      }, {
                        "value": "\"crossInACircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"currency\"",
                        "computed": false
                      }, {
                        "value": "\"cut\"",
                        "computed": false
                      }, {
                        "value": "\"dashboardApp\"",
                        "computed": false
                      }, {
                        "value": "\"database\"",
                        "computed": false
                      }, {
                        "value": "\"dataVisualizer\"",
                        "computed": false
                      }, {
                        "value": "\"devToolsApp\"",
                        "computed": false
                      }, {
                        "value": "\"discoverApp\"",
                        "computed": false
                      }, {
                        "value": "\"document\"",
                        "computed": false
                      }, {
                        "value": "\"documentEdit\"",
                        "computed": false
                      }, {
                        "value": "\"documents\"",
                        "computed": false
                      }, {
                        "value": "\"dot\"",
                        "computed": false
                      }, {
                        "value": "\"download\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignCenter\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorBold\"",
                        "computed": false
                      }, {
                        "value": "\"editorCodeBlock\"",
                        "computed": false
                      }, {
                        "value": "\"editorComment\"",
                        "computed": false
                      }, {
                        "value": "\"editorDistributeHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"editorDistributeVertical\"",
                        "computed": false
                      }, {
                        "value": "\"editorHeading\"",
                        "computed": false
                      }, {
                        "value": "\"editorItalic\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignBottom\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignCenter\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignMiddle\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignTop\"",
                        "computed": false
                      }, {
                        "value": "\"editorLink\"",
                        "computed": false
                      }, {
                        "value": "\"editorOrderedList\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionBottomLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionBottomRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionTopLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionTopRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorRedo\"",
                        "computed": false
                      }, {
                        "value": "\"editorStrike\"",
                        "computed": false
                      }, {
                        "value": "\"editorTable\"",
                        "computed": false
                      }, {
                        "value": "\"editorUnderline\"",
                        "computed": false
                      }, {
                        "value": "\"editorUndo\"",
                        "computed": false
                      }, {
                        "value": "\"editorUnorderedList\"",
                        "computed": false
                      }, {
                        "value": "\"email\"",
                        "computed": false
                      }, {
                        "value": "\"empty\"",
                        "computed": false
                      }, {
                        "value": "\"emsApp\"",
                        "computed": false
                      }, {
                        "value": "\"exit\"",
                        "computed": false
                      }, {
                        "value": "\"expand\"",
                        "computed": false
                      }, {
                        "value": "\"expandMini\"",
                        "computed": false
                      }, {
                        "value": "\"exportAction\"",
                        "computed": false
                      }, {
                        "value": "\"eye\"",
                        "computed": false
                      }, {
                        "value": "\"eyeClosed\"",
                        "computed": false
                      }, {
                        "value": "\"faceHappy\"",
                        "computed": false
                      }, {
                        "value": "\"faceNeutral\"",
                        "computed": false
                      }, {
                        "value": "\"faceSad\"",
                        "computed": false
                      }, {
                        "value": "\"filebeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"filter\"",
                        "computed": false
                      }, {
                        "value": "\"flag\"",
                        "computed": false
                      }, {
                        "value": "\"folderCheck\"",
                        "computed": false
                      }, {
                        "value": "\"folderClosed\"",
                        "computed": false
                      }, {
                        "value": "\"folderExclamation\"",
                        "computed": false
                      }, {
                        "value": "\"folderOpen\"",
                        "computed": false
                      }, {
                        "value": "\"fullScreen\"",
                        "computed": false
                      }, {
                        "value": "\"gear\"",
                        "computed": false
                      }, {
                        "value": "\"gisApp\"",
                        "computed": false
                      }, {
                        "value": "\"glasses\"",
                        "computed": false
                      }, {
                        "value": "\"globe\"",
                        "computed": false
                      }, {
                        "value": "\"grab\"",
                        "computed": false
                      }, {
                        "value": "\"grabHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"graphApp\"",
                        "computed": false
                      }, {
                        "value": "\"grid\"",
                        "computed": false
                      }, {
                        "value": "\"grokApp\"",
                        "computed": false
                      }, {
                        "value": "\"heart\"",
                        "computed": false
                      }, {
                        "value": "\"heartbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"heatmap\"",
                        "computed": false
                      }, {
                        "value": "\"help\"",
                        "computed": false
                      }, {
                        "value": "\"home\"",
                        "computed": false
                      }, {
                        "value": "\"iInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"image\"",
                        "computed": false
                      }, {
                        "value": "\"importAction\"",
                        "computed": false
                      }, {
                        "value": "\"indexClose\"",
                        "computed": false
                      }, {
                        "value": "\"indexEdit\"",
                        "computed": false
                      }, {
                        "value": "\"indexFlush\"",
                        "computed": false
                      }, {
                        "value": "\"indexManagementApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexMapping\"",
                        "computed": false
                      }, {
                        "value": "\"indexOpen\"",
                        "computed": false
                      }, {
                        "value": "\"indexPatternApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexRollupApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexSettings\"",
                        "computed": false
                      }, {
                        "value": "\"inputOutput\"",
                        "computed": false
                      }, {
                        "value": "\"inspect\"",
                        "computed": false
                      }, {
                        "value": "\"invert\"",
                        "computed": false
                      }, {
                        "value": "\"ip\"",
                        "computed": false
                      }, {
                        "value": "\"keyboardShortcut\"",
                        "computed": false
                      }, {
                        "value": "\"kqlField\"",
                        "computed": false
                      }, {
                        "value": "\"kqlFunction\"",
                        "computed": false
                      }, {
                        "value": "\"kqlOperand\"",
                        "computed": false
                      }, {
                        "value": "\"kqlSelector\"",
                        "computed": false
                      }, {
                        "value": "\"kqlValue\"",
                        "computed": false
                      }, {
                        "value": "\"lensApp\"",
                        "computed": false
                      }, {
                        "value": "\"link\"",
                        "computed": false
                      }, {
                        "value": "\"list\"",
                        "computed": false
                      }, {
                        "value": "\"listAdd\"",
                        "computed": false
                      }, {
                        "value": "\"lock\"",
                        "computed": false
                      }, {
                        "value": "\"lockOpen\"",
                        "computed": false
                      }, {
                        "value": "\"logsApp\"",
                        "computed": false
                      }, {
                        "value": "\"logoAerospike\"",
                        "computed": false
                      }, {
                        "value": "\"logoApache\"",
                        "computed": false
                      }, {
                        "value": "\"logoAPM\"",
                        "computed": false
                      }, {
                        "value": "\"logoAppSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoAWS\"",
                        "computed": false
                      }, {
                        "value": "\"logoAWSMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoAzure\"",
                        "computed": false
                      }, {
                        "value": "\"logoAzureMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoBeats\"",
                        "computed": false
                      }, {
                        "value": "\"logoBusinessAnalytics\"",
                        "computed": false
                      }, {
                        "value": "\"logoCeph\"",
                        "computed": false
                      }, {
                        "value": "\"logoCloud\"",
                        "computed": false
                      }, {
                        "value": "\"logoCloudEnterprise\"",
                        "computed": false
                      }, {
                        "value": "\"logoCode\"",
                        "computed": false
                      }, {
                        "value": "\"logoCodesandbox\"",
                        "computed": false
                      }, {
                        "value": "\"logoCouchbase\"",
                        "computed": false
                      }, {
                        "value": "\"logoDocker\"",
                        "computed": false
                      }, {
                        "value": "\"logoDropwizard\"",
                        "computed": false
                      }, {
                        "value": "\"logoElastic\"",
                        "computed": false
                      }, {
                        "value": "\"logoElasticsearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoElasticStack\"",
                        "computed": false
                      }, {
                        "value": "\"logoEnterpriseSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoEtcd\"",
                        "computed": false
                      }, {
                        "value": "\"logoGCP\"",
                        "computed": false
                      }, {
                        "value": "\"logoGCPMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoGithub\"",
                        "computed": false
                      }, {
                        "value": "\"logoGmail\"",
                        "computed": false
                      }, {
                        "value": "\"logoGolang\"",
                        "computed": false
                      }, {
                        "value": "\"logoGoogleG\"",
                        "computed": false
                      }, {
                        "value": "\"logoHAproxy\"",
                        "computed": false
                      }, {
                        "value": "\"logoIBM\"",
                        "computed": false
                      }, {
                        "value": "\"logoIBMMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoKafka\"",
                        "computed": false
                      }, {
                        "value": "\"logoKibana\"",
                        "computed": false
                      }, {
                        "value": "\"logoKubernetes\"",
                        "computed": false
                      }, {
                        "value": "\"logoLogging\"",
                        "computed": false
                      }, {
                        "value": "\"logoLogstash\"",
                        "computed": false
                      }, {
                        "value": "\"logoMaps\"",
                        "computed": false
                      }, {
                        "value": "\"logoMemcached\"",
                        "computed": false
                      }, {
                        "value": "\"logoMetrics\"",
                        "computed": false
                      }, {
                        "value": "\"logoMongodb\"",
                        "computed": false
                      }, {
                        "value": "\"logoMySQL\"",
                        "computed": false
                      }, {
                        "value": "\"logoNginx\"",
                        "computed": false
                      }, {
                        "value": "\"logoObservability\"",
                        "computed": false
                      }, {
                        "value": "\"logoOsquery\"",
                        "computed": false
                      }, {
                        "value": "\"logoPhp\"",
                        "computed": false
                      }, {
                        "value": "\"logoPostgres\"",
                        "computed": false
                      }, {
                        "value": "\"logoPrometheus\"",
                        "computed": false
                      }, {
                        "value": "\"logoRabbitmq\"",
                        "computed": false
                      }, {
                        "value": "\"logoRedis\"",
                        "computed": false
                      }, {
                        "value": "\"logoSecurity\"",
                        "computed": false
                      }, {
                        "value": "\"logoSiteSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoSketch\"",
                        "computed": false
                      }, {
                        "value": "\"logoSlack\"",
                        "computed": false
                      }, {
                        "value": "\"logoUptime\"",
                        "computed": false
                      }, {
                        "value": "\"logoWebhook\"",
                        "computed": false
                      }, {
                        "value": "\"logoWindows\"",
                        "computed": false
                      }, {
                        "value": "\"logoWorkplaceSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logstashFilter\"",
                        "computed": false
                      }, {
                        "value": "\"logstashIf\"",
                        "computed": false
                      }, {
                        "value": "\"logstashInput\"",
                        "computed": false
                      }, {
                        "value": "\"logstashOutput\"",
                        "computed": false
                      }, {
                        "value": "\"logstashQueue\"",
                        "computed": false
                      }, {
                        "value": "\"machineLearningApp\"",
                        "computed": false
                      }, {
                        "value": "\"magnet\"",
                        "computed": false
                      }, {
                        "value": "\"magnifyWithMinus\"",
                        "computed": false
                      }, {
                        "value": "\"magnifyWithPlus\"",
                        "computed": false
                      }, {
                        "value": "\"managementApp\"",
                        "computed": false
                      }, {
                        "value": "\"mapMarker\"",
                        "computed": false
                      }, {
                        "value": "\"memory\"",
                        "computed": false
                      }, {
                        "value": "\"menu\"",
                        "computed": false
                      }, {
                        "value": "\"menuLeft\"",
                        "computed": false
                      }, {
                        "value": "\"menuRight\"",
                        "computed": false
                      }, {
                        "value": "\"merge\"",
                        "computed": false
                      }, {
                        "value": "\"metricbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"metricsApp\"",
                        "computed": false
                      }, {
                        "value": "\"minimize\"",
                        "computed": false
                      }, {
                        "value": "\"minusInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"minusInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"monitoringApp\"",
                        "computed": false
                      }, {
                        "value": "\"moon\"",
                        "computed": false
                      }, {
                        "value": "\"nested\"",
                        "computed": false
                      }, {
                        "value": "\"node\"",
                        "computed": false
                      }, {
                        "value": "\"notebookApp\"",
                        "computed": false
                      }, {
                        "value": "\"number\"",
                        "computed": false
                      }, {
                        "value": "\"offline\"",
                        "computed": false
                      }, {
                        "value": "\"online\"",
                        "computed": false
                      }, {
                        "value": "\"package\"",
                        "computed": false
                      }, {
                        "value": "\"packetbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"pageSelect\"",
                        "computed": false
                      }, {
                        "value": "\"pagesSelect\"",
                        "computed": false
                      }, {
                        "value": "\"partial\"",
                        "computed": false
                      }, {
                        "value": "\"paperClip\"",
                        "computed": false
                      }, {
                        "value": "\"pause\"",
                        "computed": false
                      }, {
                        "value": "\"pencil\"",
                        "computed": false
                      }, {
                        "value": "\"pin\"",
                        "computed": false
                      }, {
                        "value": "\"pinFilled\"",
                        "computed": false
                      }, {
                        "value": "\"pipelineApp\"",
                        "computed": false
                      }, {
                        "value": "\"play\"",
                        "computed": false
                      }, {
                        "value": "\"plusInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"plusInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"popout\"",
                        "computed": false
                      }, {
                        "value": "\"push\"",
                        "computed": false
                      }, {
                        "value": "\"questionInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"quote\"",
                        "computed": false
                      }, {
                        "value": "\"recentlyViewedApp\"",
                        "computed": false
                      }, {
                        "value": "\"refresh\"",
                        "computed": false
                      }, {
                        "value": "\"reporter\"",
                        "computed": false
                      }, {
                        "value": "\"reportingApp\"",
                        "computed": false
                      }, {
                        "value": "\"save\"",
                        "computed": false
                      }, {
                        "value": "\"savedObjectsApp\"",
                        "computed": false
                      }, {
                        "value": "\"scale\"",
                        "computed": false
                      }, {
                        "value": "\"search\"",
                        "computed": false
                      }, {
                        "value": "\"searchProfilerApp\"",
                        "computed": false
                      }, {
                        "value": "\"securityAnalyticsApp\"",
                        "computed": false
                      }, {
                        "value": "\"securityApp\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignal\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignalDetected\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignalResolved\"",
                        "computed": false
                      }, {
                        "value": "\"shard\"",
                        "computed": false
                      }, {
                        "value": "\"share\"",
                        "computed": false
                      }, {
                        "value": "\"snowflake\"",
                        "computed": false
                      }, {
                        "value": "\"sortable\"",
                        "computed": false
                      }, {
                        "value": "\"sortDown\"",
                        "computed": false
                      }, {
                        "value": "\"sortLeft\"",
                        "computed": false
                      }, {
                        "value": "\"sortRight\"",
                        "computed": false
                      }, {
                        "value": "\"sortUp\"",
                        "computed": false
                      }, {
                        "value": "\"spacesApp\"",
                        "computed": false
                      }, {
                        "value": "\"sqlApp\"",
                        "computed": false
                      }, {
                        "value": "\"starEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starEmptySpace\"",
                        "computed": false
                      }, {
                        "value": "\"starFilled\"",
                        "computed": false
                      }, {
                        "value": "\"starFilledSpace\"",
                        "computed": false
                      }, {
                        "value": "\"starMinusEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starMinusFilled\"",
                        "computed": false
                      }, {
                        "value": "\"starPlusEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starPlusFilled\"",
                        "computed": false
                      }, {
                        "value": "\"stats\"",
                        "computed": false
                      }, {
                        "value": "\"stop\"",
                        "computed": false
                      }, {
                        "value": "\"stopFilled\"",
                        "computed": false
                      }, {
                        "value": "\"stopSlash\"",
                        "computed": false
                      }, {
                        "value": "\"storage\"",
                        "computed": false
                      }, {
                        "value": "\"string\"",
                        "computed": false
                      }, {
                        "value": "\"submodule\"",
                        "computed": false
                      }, {
                        "value": "\"swatchInput\"",
                        "computed": false
                      }, {
                        "value": "\"symlink\"",
                        "computed": false
                      }, {
                        "value": "\"tableOfContents\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityExpanded\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityCompact\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityNormal\"",
                        "computed": false
                      }, {
                        "value": "\"tag\"",
                        "computed": false
                      }, {
                        "value": "\"tear\"",
                        "computed": false
                      }, {
                        "value": "\"temperature\"",
                        "computed": false
                      }, {
                        "value": "\"timeline\"",
                        "computed": false
                      }, {
                        "value": "\"timelionApp\"",
                        "computed": false
                      }, {
                        "value": "\"training\"",
                        "computed": false
                      }, {
                        "value": "\"trash\"",
                        "computed": false
                      }, {
                        "value": "\"upgradeAssistantApp\"",
                        "computed": false
                      }, {
                        "value": "\"uptimeApp\"",
                        "computed": false
                      }, {
                        "value": "\"user\"",
                        "computed": false
                      }, {
                        "value": "\"users\"",
                        "computed": false
                      }, {
                        "value": "\"usersRolesApp\"",
                        "computed": false
                      }, {
                        "value": "\"vector\"",
                        "computed": false
                      }, {
                        "value": "\"videoPlayer\"",
                        "computed": false
                      }, {
                        "value": "\"visArea\"",
                        "computed": false
                      }, {
                        "value": "\"visAreaStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visBarHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"visBarHorizontalStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visBarVertical\"",
                        "computed": false
                      }, {
                        "value": "\"visBarVerticalStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visGauge\"",
                        "computed": false
                      }, {
                        "value": "\"visGoal\"",
                        "computed": false
                      }, {
                        "value": "\"visLine\"",
                        "computed": false
                      }, {
                        "value": "\"visMapCoordinate\"",
                        "computed": false
                      }, {
                        "value": "\"visMapRegion\"",
                        "computed": false
                      }, {
                        "value": "\"visMetric\"",
                        "computed": false
                      }, {
                        "value": "\"visPie\"",
                        "computed": false
                      }, {
                        "value": "\"visTable\"",
                        "computed": false
                      }, {
                        "value": "\"visTagCloud\"",
                        "computed": false
                      }, {
                        "value": "\"visText\"",
                        "computed": false
                      }, {
                        "value": "\"visTimelion\"",
                        "computed": false
                      }, {
                        "value": "\"visualizeApp\"",
                        "computed": false
                      }, {
                        "value": "\"visVega\"",
                        "computed": false
                      }, {
                        "value": "\"visVisualBuilder\"",
                        "computed": false
                      }, {
                        "value": "\"watchesApp\"",
                        "computed": false
                      }, {
                        "value": "\"wrench\"",
                        "computed": false
                      }, {
                        "value": "\"tokenClass\"",
                        "computed": false
                      }, {
                        "value": "\"tokenProperty\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEnum\"",
                        "computed": false
                      }, {
                        "value": "\"tokenVariable\"",
                        "computed": false
                      }, {
                        "value": "\"tokenMethod\"",
                        "computed": false
                      }, {
                        "value": "\"tokenAnnotation\"",
                        "computed": false
                      }, {
                        "value": "\"tokenException\"",
                        "computed": false
                      }, {
                        "value": "\"tokenInterface\"",
                        "computed": false
                      }, {
                        "value": "\"tokenParameter\"",
                        "computed": false
                      }, {
                        "value": "\"tokenField\"",
                        "computed": false
                      }, {
                        "value": "\"tokenElement\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFunction\"",
                        "computed": false
                      }, {
                        "value": "\"tokenBoolean\"",
                        "computed": false
                      }, {
                        "value": "\"tokenString\"",
                        "computed": false
                      }, {
                        "value": "\"tokenArray\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNumber\"",
                        "computed": false
                      }, {
                        "value": "\"tokenConstant\"",
                        "computed": false
                      }, {
                        "value": "\"tokenObject\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEvent\"",
                        "computed": false
                      }, {
                        "value": "\"tokenKey\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNull\"",
                        "computed": false
                      }, {
                        "value": "\"tokenStruct\"",
                        "computed": false
                      }, {
                        "value": "\"tokenPackage\"",
                        "computed": false
                      }, {
                        "value": "\"tokenOperator\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEnumMember\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRepo\"",
                        "computed": false
                      }, {
                        "value": "\"tokenSymbol\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFile\"",
                        "computed": false
                      }, {
                        "value": "\"tokenModule\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNamespace\"",
                        "computed": false
                      }, {
                        "value": "\"tokenDate\"",
                        "computed": false
                      }, {
                        "value": "\"tokenIP\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNested\"",
                        "computed": false
                      }, {
                        "value": "\"tokenAlias\"",
                        "computed": false
                      }, {
                        "value": "\"tokenShape\"",
                        "computed": false
                      }, {
                        "value": "\"tokenGeo\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRange\"",
                        "computed": false
                      }, {
                        "value": "\"tokenBinary\"",
                        "computed": false
                      }, {
                        "value": "\"tokenJoin\"",
                        "computed": false
                      }, {
                        "value": "\"tokenPercolator\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFlattened\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRankFeature\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRankFeatures\"",
                        "computed": false
                      }, {
                        "value": "\"tokenKeyword\"",
                        "computed": false
                      }, {
                        "value": "\"tokenCompletionSuggester\"",
                        "computed": false
                      }, {
                        "value": "\"tokenDenseVector\"",
                        "computed": false
                      }, {
                        "value": "\"tokenText\"",
                        "computed": false
                      }, {
                        "value": "\"tokenTokenCount\"",
                        "computed": false
                      }, {
                        "value": "\"tokenSearchType\"",
                        "computed": false
                      }, {
                        "value": "\"tokenHistogram\"",
                        "computed": false
                      }]
                    }, {
                      "name": "string"
                    }, {
                      "name": "elementType"
                    }],
                    "required": false
                  },
                  "color": {
                    "name": "enum",
                    "value": [{
                      "value": "\"danger\"",
                      "computed": false
                    }, {
                      "value": "\"disabled\"",
                      "computed": false
                    }, {
                      "value": "\"ghost\"",
                      "computed": false
                    }, {
                      "value": "\"primary\"",
                      "computed": false
                    }, {
                      "value": "\"subdued\"",
                      "computed": false
                    }, {
                      "value": "\"success\"",
                      "computed": false
                    }, {
                      "value": "\"text\"",
                      "computed": false
                    }, {
                      "value": "\"warning\"",
                      "computed": false
                    }],
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "aria-labelledby": {
                    "name": "string",
                    "required": false
                  },
                  "isDisabled": {
                    "name": "bool",
                    "required": false
                  },
                  "size": {
                    "name": "enum",
                    "value": [{
                      "value": "\"s\"",
                      "computed": false
                    }, {
                      "value": "\"m\"",
                      "computed": false
                    }],
                    "required": false
                  },
                  "iconSize": {
                    "name": "enum",
                    "value": [{
                      "value": "\"original\"",
                      "computed": false
                    }, {
                      "value": "\"s\"",
                      "computed": false
                    }, {
                      "value": "\"m\"",
                      "computed": false
                    }, {
                      "value": "\"l\"",
                      "computed": false
                    }, {
                      "value": "\"xl\"",
                      "computed": false
                    }, {
                      "value": "\"xxl\"",
                      "computed": false
                    }],
                    "required": false
                  },
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "buttonRef": {
                    "name": "any",
                    "required": false
                  },
                  "alwaysShow": {
                    "name": "bool",
                    "required": false
                  }
                },
                "description": "Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;\npass `alwaysShow` if you don't want the default behavior of only showing on hover",
                "required": false
              },
              "onClick": {
                "name": "func",
                "description": "Make the list item label a button.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems.",
                "required": false
              },
              "wrapText": {
                "name": "bool",
                "description": "Allow link text to wrap",
                "required": false
              },
              "buttonRef": {
                "name": "any",
                "description": "Pass-through ref reference specifically for targeting\ninstances where the item content is rendered as a `button`",
                "required": false
              },
              "pinned": {
                "name": "bool",
                "description": "Saves the pinned status and changes the visibility of the pin icon",
                "required": false
              },
              "pinnable": {
                "name": "bool",
                "description": "Passing `onPinClick` to the full EuiPinnableListGroup, will make every item pinnable.\nSet this property to `false` to turn off individual item pinnability",
                "required": false
              }
            }
          }
        }, {
          "name": "arrayOf",
          "value": {
            "name": "shape",
            "value": {
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              },
              "size": {
                "name": "enum",
                "value": [{
                  "value": "\"xs\"",
                  "computed": false
                }, {
                  "value": "\"s\"",
                  "computed": false
                }, {
                  "value": "\"m\"",
                  "computed": false
                }, {
                  "value": "\"l\"",
                  "computed": false
                }],
                "description": "Size of the label text",
                "required": false
              },
              "color": {
                "name": "enum",
                "value": [{
                  "value": "\"inherit\"",
                  "computed": false
                }, {
                  "value": "\"primary\"",
                  "computed": false
                }, {
                  "value": "\"text\"",
                  "computed": false
                }, {
                  "value": "\"subdued\"",
                  "computed": false
                }, {
                  "value": "\"ghost\"",
                  "computed": false
                }],
                "description": "By default the item will inherit the color of its wrapper (button/link/span),\notherwise pass one of the acceptable options",
                "required": false
              },
              "label": {
                "name": "node",
                "description": "Content to be displayed in the list item",
                "required": true
              },
              "isActive": {
                "name": "bool",
                "description": "Apply styles indicating an item is active",
                "required": false
              },
              "isDisabled": {
                "name": "bool",
                "description": "Apply styles indicating an item is disabled",
                "required": false
              },
              "href": {
                "name": "string",
                "description": "Make the list item label a link.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems.",
                "required": false
              },
              "target": {
                "name": "string",
                "required": false
              },
              "rel": {
                "name": "string",
                "required": false
              },
              "iconType": {
                "name": "union",
                "value": [{
                  "name": "enum",
                  "value": [{
                    "value": "\"accessibility\"",
                    "computed": false
                  }, {
                    "value": "\"addDataApp\"",
                    "computed": false
                  }, {
                    "value": "\"advancedSettingsApp\"",
                    "computed": false
                  }, {
                    "value": "\"aggregate\"",
                    "computed": false
                  }, {
                    "value": "\"alert\"",
                    "computed": false
                  }, {
                    "value": "\"annotation\"",
                    "computed": false
                  }, {
                    "value": "\"apmApp\"",
                    "computed": false
                  }, {
                    "value": "\"apmTrace\"",
                    "computed": false
                  }, {
                    "value": "\"apps\"",
                    "computed": false
                  }, {
                    "value": "\"arrowDown\"",
                    "computed": false
                  }, {
                    "value": "\"arrowLeft\"",
                    "computed": false
                  }, {
                    "value": "\"arrowRight\"",
                    "computed": false
                  }, {
                    "value": "\"arrowUp\"",
                    "computed": false
                  }, {
                    "value": "\"asterisk\"",
                    "computed": false
                  }, {
                    "value": "\"auditbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"beaker\"",
                    "computed": false
                  }, {
                    "value": "\"bell\"",
                    "computed": false
                  }, {
                    "value": "\"bellSlash\"",
                    "computed": false
                  }, {
                    "value": "\"bolt\"",
                    "computed": false
                  }, {
                    "value": "\"boxesHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"boxesVertical\"",
                    "computed": false
                  }, {
                    "value": "\"branch\"",
                    "computed": false
                  }, {
                    "value": "\"broom\"",
                    "computed": false
                  }, {
                    "value": "\"brush\"",
                    "computed": false
                  }, {
                    "value": "\"bug\"",
                    "computed": false
                  }, {
                    "value": "\"bullseye\"",
                    "computed": false
                  }, {
                    "value": "\"calendar\"",
                    "computed": false
                  }, {
                    "value": "\"canvasApp\"",
                    "computed": false
                  }, {
                    "value": "\"codeApp\"",
                    "computed": false
                  }, {
                    "value": "\"check\"",
                    "computed": false
                  }, {
                    "value": "\"checkInCircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"cheer\"",
                    "computed": false
                  }, {
                    "value": "\"clock\"",
                    "computed": false
                  }, {
                    "value": "\"cloudDrizzle\"",
                    "computed": false
                  }, {
                    "value": "\"cloudStormy\"",
                    "computed": false
                  }, {
                    "value": "\"cloudSunny\"",
                    "computed": false
                  }, {
                    "value": "\"compute\"",
                    "computed": false
                  }, {
                    "value": "\"console\"",
                    "computed": false
                  }, {
                    "value": "\"consoleApp\"",
                    "computed": false
                  }, {
                    "value": "\"controlsHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"controlsVertical\"",
                    "computed": false
                  }, {
                    "value": "\"copy\"",
                    "computed": false
                  }, {
                    "value": "\"copyClipboard\"",
                    "computed": false
                  }, {
                    "value": "\"createAdvancedJob\"",
                    "computed": false
                  }, {
                    "value": "\"createMultiMetricJob\"",
                    "computed": false
                  }, {
                    "value": "\"createPopulationJob\"",
                    "computed": false
                  }, {
                    "value": "\"createSingleMetricJob\"",
                    "computed": false
                  }, {
                    "value": "\"cross\"",
                    "computed": false
                  }, {
                    "value": "\"crossClusterReplicationApp\"",
                    "computed": false
                  }, {
                    "value": "\"crosshairs\"",
                    "computed": false
                  }, {
                    "value": "\"crossInACircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"currency\"",
                    "computed": false
                  }, {
                    "value": "\"cut\"",
                    "computed": false
                  }, {
                    "value": "\"dashboardApp\"",
                    "computed": false
                  }, {
                    "value": "\"database\"",
                    "computed": false
                  }, {
                    "value": "\"dataVisualizer\"",
                    "computed": false
                  }, {
                    "value": "\"devToolsApp\"",
                    "computed": false
                  }, {
                    "value": "\"discoverApp\"",
                    "computed": false
                  }, {
                    "value": "\"document\"",
                    "computed": false
                  }, {
                    "value": "\"documentEdit\"",
                    "computed": false
                  }, {
                    "value": "\"documents\"",
                    "computed": false
                  }, {
                    "value": "\"dot\"",
                    "computed": false
                  }, {
                    "value": "\"download\"",
                    "computed": false
                  }, {
                    "value": "\"editorAlignCenter\"",
                    "computed": false
                  }, {
                    "value": "\"editorAlignLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorAlignRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorBold\"",
                    "computed": false
                  }, {
                    "value": "\"editorCodeBlock\"",
                    "computed": false
                  }, {
                    "value": "\"editorComment\"",
                    "computed": false
                  }, {
                    "value": "\"editorDistributeHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"editorDistributeVertical\"",
                    "computed": false
                  }, {
                    "value": "\"editorHeading\"",
                    "computed": false
                  }, {
                    "value": "\"editorItalic\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignBottom\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignCenter\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignMiddle\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorItemAlignTop\"",
                    "computed": false
                  }, {
                    "value": "\"editorLink\"",
                    "computed": false
                  }, {
                    "value": "\"editorOrderedList\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionBottomLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionBottomRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionTopLeft\"",
                    "computed": false
                  }, {
                    "value": "\"editorPositionTopRight\"",
                    "computed": false
                  }, {
                    "value": "\"editorRedo\"",
                    "computed": false
                  }, {
                    "value": "\"editorStrike\"",
                    "computed": false
                  }, {
                    "value": "\"editorTable\"",
                    "computed": false
                  }, {
                    "value": "\"editorUnderline\"",
                    "computed": false
                  }, {
                    "value": "\"editorUndo\"",
                    "computed": false
                  }, {
                    "value": "\"editorUnorderedList\"",
                    "computed": false
                  }, {
                    "value": "\"email\"",
                    "computed": false
                  }, {
                    "value": "\"empty\"",
                    "computed": false
                  }, {
                    "value": "\"emsApp\"",
                    "computed": false
                  }, {
                    "value": "\"exit\"",
                    "computed": false
                  }, {
                    "value": "\"expand\"",
                    "computed": false
                  }, {
                    "value": "\"expandMini\"",
                    "computed": false
                  }, {
                    "value": "\"exportAction\"",
                    "computed": false
                  }, {
                    "value": "\"eye\"",
                    "computed": false
                  }, {
                    "value": "\"eyeClosed\"",
                    "computed": false
                  }, {
                    "value": "\"faceHappy\"",
                    "computed": false
                  }, {
                    "value": "\"faceNeutral\"",
                    "computed": false
                  }, {
                    "value": "\"faceSad\"",
                    "computed": false
                  }, {
                    "value": "\"filebeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"filter\"",
                    "computed": false
                  }, {
                    "value": "\"flag\"",
                    "computed": false
                  }, {
                    "value": "\"folderCheck\"",
                    "computed": false
                  }, {
                    "value": "\"folderClosed\"",
                    "computed": false
                  }, {
                    "value": "\"folderExclamation\"",
                    "computed": false
                  }, {
                    "value": "\"folderOpen\"",
                    "computed": false
                  }, {
                    "value": "\"fullScreen\"",
                    "computed": false
                  }, {
                    "value": "\"gear\"",
                    "computed": false
                  }, {
                    "value": "\"gisApp\"",
                    "computed": false
                  }, {
                    "value": "\"glasses\"",
                    "computed": false
                  }, {
                    "value": "\"globe\"",
                    "computed": false
                  }, {
                    "value": "\"grab\"",
                    "computed": false
                  }, {
                    "value": "\"grabHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"graphApp\"",
                    "computed": false
                  }, {
                    "value": "\"grid\"",
                    "computed": false
                  }, {
                    "value": "\"grokApp\"",
                    "computed": false
                  }, {
                    "value": "\"heart\"",
                    "computed": false
                  }, {
                    "value": "\"heartbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"heatmap\"",
                    "computed": false
                  }, {
                    "value": "\"help\"",
                    "computed": false
                  }, {
                    "value": "\"home\"",
                    "computed": false
                  }, {
                    "value": "\"iInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"image\"",
                    "computed": false
                  }, {
                    "value": "\"importAction\"",
                    "computed": false
                  }, {
                    "value": "\"indexClose\"",
                    "computed": false
                  }, {
                    "value": "\"indexEdit\"",
                    "computed": false
                  }, {
                    "value": "\"indexFlush\"",
                    "computed": false
                  }, {
                    "value": "\"indexManagementApp\"",
                    "computed": false
                  }, {
                    "value": "\"indexMapping\"",
                    "computed": false
                  }, {
                    "value": "\"indexOpen\"",
                    "computed": false
                  }, {
                    "value": "\"indexPatternApp\"",
                    "computed": false
                  }, {
                    "value": "\"indexRollupApp\"",
                    "computed": false
                  }, {
                    "value": "\"indexSettings\"",
                    "computed": false
                  }, {
                    "value": "\"inputOutput\"",
                    "computed": false
                  }, {
                    "value": "\"inspect\"",
                    "computed": false
                  }, {
                    "value": "\"invert\"",
                    "computed": false
                  }, {
                    "value": "\"ip\"",
                    "computed": false
                  }, {
                    "value": "\"keyboardShortcut\"",
                    "computed": false
                  }, {
                    "value": "\"kqlField\"",
                    "computed": false
                  }, {
                    "value": "\"kqlFunction\"",
                    "computed": false
                  }, {
                    "value": "\"kqlOperand\"",
                    "computed": false
                  }, {
                    "value": "\"kqlSelector\"",
                    "computed": false
                  }, {
                    "value": "\"kqlValue\"",
                    "computed": false
                  }, {
                    "value": "\"lensApp\"",
                    "computed": false
                  }, {
                    "value": "\"link\"",
                    "computed": false
                  }, {
                    "value": "\"list\"",
                    "computed": false
                  }, {
                    "value": "\"listAdd\"",
                    "computed": false
                  }, {
                    "value": "\"lock\"",
                    "computed": false
                  }, {
                    "value": "\"lockOpen\"",
                    "computed": false
                  }, {
                    "value": "\"logsApp\"",
                    "computed": false
                  }, {
                    "value": "\"logoAerospike\"",
                    "computed": false
                  }, {
                    "value": "\"logoApache\"",
                    "computed": false
                  }, {
                    "value": "\"logoAPM\"",
                    "computed": false
                  }, {
                    "value": "\"logoAppSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoAWS\"",
                    "computed": false
                  }, {
                    "value": "\"logoAWSMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoAzure\"",
                    "computed": false
                  }, {
                    "value": "\"logoAzureMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoBeats\"",
                    "computed": false
                  }, {
                    "value": "\"logoBusinessAnalytics\"",
                    "computed": false
                  }, {
                    "value": "\"logoCeph\"",
                    "computed": false
                  }, {
                    "value": "\"logoCloud\"",
                    "computed": false
                  }, {
                    "value": "\"logoCloudEnterprise\"",
                    "computed": false
                  }, {
                    "value": "\"logoCode\"",
                    "computed": false
                  }, {
                    "value": "\"logoCodesandbox\"",
                    "computed": false
                  }, {
                    "value": "\"logoCouchbase\"",
                    "computed": false
                  }, {
                    "value": "\"logoDocker\"",
                    "computed": false
                  }, {
                    "value": "\"logoDropwizard\"",
                    "computed": false
                  }, {
                    "value": "\"logoElastic\"",
                    "computed": false
                  }, {
                    "value": "\"logoElasticsearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoElasticStack\"",
                    "computed": false
                  }, {
                    "value": "\"logoEnterpriseSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoEtcd\"",
                    "computed": false
                  }, {
                    "value": "\"logoGCP\"",
                    "computed": false
                  }, {
                    "value": "\"logoGCPMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoGithub\"",
                    "computed": false
                  }, {
                    "value": "\"logoGmail\"",
                    "computed": false
                  }, {
                    "value": "\"logoGolang\"",
                    "computed": false
                  }, {
                    "value": "\"logoGoogleG\"",
                    "computed": false
                  }, {
                    "value": "\"logoHAproxy\"",
                    "computed": false
                  }, {
                    "value": "\"logoIBM\"",
                    "computed": false
                  }, {
                    "value": "\"logoIBMMono\"",
                    "computed": false
                  }, {
                    "value": "\"logoKafka\"",
                    "computed": false
                  }, {
                    "value": "\"logoKibana\"",
                    "computed": false
                  }, {
                    "value": "\"logoKubernetes\"",
                    "computed": false
                  }, {
                    "value": "\"logoLogging\"",
                    "computed": false
                  }, {
                    "value": "\"logoLogstash\"",
                    "computed": false
                  }, {
                    "value": "\"logoMaps\"",
                    "computed": false
                  }, {
                    "value": "\"logoMemcached\"",
                    "computed": false
                  }, {
                    "value": "\"logoMetrics\"",
                    "computed": false
                  }, {
                    "value": "\"logoMongodb\"",
                    "computed": false
                  }, {
                    "value": "\"logoMySQL\"",
                    "computed": false
                  }, {
                    "value": "\"logoNginx\"",
                    "computed": false
                  }, {
                    "value": "\"logoObservability\"",
                    "computed": false
                  }, {
                    "value": "\"logoOsquery\"",
                    "computed": false
                  }, {
                    "value": "\"logoPhp\"",
                    "computed": false
                  }, {
                    "value": "\"logoPostgres\"",
                    "computed": false
                  }, {
                    "value": "\"logoPrometheus\"",
                    "computed": false
                  }, {
                    "value": "\"logoRabbitmq\"",
                    "computed": false
                  }, {
                    "value": "\"logoRedis\"",
                    "computed": false
                  }, {
                    "value": "\"logoSecurity\"",
                    "computed": false
                  }, {
                    "value": "\"logoSiteSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logoSketch\"",
                    "computed": false
                  }, {
                    "value": "\"logoSlack\"",
                    "computed": false
                  }, {
                    "value": "\"logoUptime\"",
                    "computed": false
                  }, {
                    "value": "\"logoWebhook\"",
                    "computed": false
                  }, {
                    "value": "\"logoWindows\"",
                    "computed": false
                  }, {
                    "value": "\"logoWorkplaceSearch\"",
                    "computed": false
                  }, {
                    "value": "\"logstashFilter\"",
                    "computed": false
                  }, {
                    "value": "\"logstashIf\"",
                    "computed": false
                  }, {
                    "value": "\"logstashInput\"",
                    "computed": false
                  }, {
                    "value": "\"logstashOutput\"",
                    "computed": false
                  }, {
                    "value": "\"logstashQueue\"",
                    "computed": false
                  }, {
                    "value": "\"machineLearningApp\"",
                    "computed": false
                  }, {
                    "value": "\"magnet\"",
                    "computed": false
                  }, {
                    "value": "\"magnifyWithMinus\"",
                    "computed": false
                  }, {
                    "value": "\"magnifyWithPlus\"",
                    "computed": false
                  }, {
                    "value": "\"managementApp\"",
                    "computed": false
                  }, {
                    "value": "\"mapMarker\"",
                    "computed": false
                  }, {
                    "value": "\"memory\"",
                    "computed": false
                  }, {
                    "value": "\"menu\"",
                    "computed": false
                  }, {
                    "value": "\"menuLeft\"",
                    "computed": false
                  }, {
                    "value": "\"menuRight\"",
                    "computed": false
                  }, {
                    "value": "\"merge\"",
                    "computed": false
                  }, {
                    "value": "\"metricbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"metricsApp\"",
                    "computed": false
                  }, {
                    "value": "\"minimize\"",
                    "computed": false
                  }, {
                    "value": "\"minusInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"minusInCircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"monitoringApp\"",
                    "computed": false
                  }, {
                    "value": "\"moon\"",
                    "computed": false
                  }, {
                    "value": "\"nested\"",
                    "computed": false
                  }, {
                    "value": "\"node\"",
                    "computed": false
                  }, {
                    "value": "\"notebookApp\"",
                    "computed": false
                  }, {
                    "value": "\"number\"",
                    "computed": false
                  }, {
                    "value": "\"offline\"",
                    "computed": false
                  }, {
                    "value": "\"online\"",
                    "computed": false
                  }, {
                    "value": "\"package\"",
                    "computed": false
                  }, {
                    "value": "\"packetbeatApp\"",
                    "computed": false
                  }, {
                    "value": "\"pageSelect\"",
                    "computed": false
                  }, {
                    "value": "\"pagesSelect\"",
                    "computed": false
                  }, {
                    "value": "\"partial\"",
                    "computed": false
                  }, {
                    "value": "\"paperClip\"",
                    "computed": false
                  }, {
                    "value": "\"pause\"",
                    "computed": false
                  }, {
                    "value": "\"pencil\"",
                    "computed": false
                  }, {
                    "value": "\"pin\"",
                    "computed": false
                  }, {
                    "value": "\"pinFilled\"",
                    "computed": false
                  }, {
                    "value": "\"pipelineApp\"",
                    "computed": false
                  }, {
                    "value": "\"play\"",
                    "computed": false
                  }, {
                    "value": "\"plusInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"plusInCircleFilled\"",
                    "computed": false
                  }, {
                    "value": "\"popout\"",
                    "computed": false
                  }, {
                    "value": "\"push\"",
                    "computed": false
                  }, {
                    "value": "\"questionInCircle\"",
                    "computed": false
                  }, {
                    "value": "\"quote\"",
                    "computed": false
                  }, {
                    "value": "\"recentlyViewedApp\"",
                    "computed": false
                  }, {
                    "value": "\"refresh\"",
                    "computed": false
                  }, {
                    "value": "\"reporter\"",
                    "computed": false
                  }, {
                    "value": "\"reportingApp\"",
                    "computed": false
                  }, {
                    "value": "\"save\"",
                    "computed": false
                  }, {
                    "value": "\"savedObjectsApp\"",
                    "computed": false
                  }, {
                    "value": "\"scale\"",
                    "computed": false
                  }, {
                    "value": "\"search\"",
                    "computed": false
                  }, {
                    "value": "\"searchProfilerApp\"",
                    "computed": false
                  }, {
                    "value": "\"securityAnalyticsApp\"",
                    "computed": false
                  }, {
                    "value": "\"securityApp\"",
                    "computed": false
                  }, {
                    "value": "\"securitySignal\"",
                    "computed": false
                  }, {
                    "value": "\"securitySignalDetected\"",
                    "computed": false
                  }, {
                    "value": "\"securitySignalResolved\"",
                    "computed": false
                  }, {
                    "value": "\"shard\"",
                    "computed": false
                  }, {
                    "value": "\"share\"",
                    "computed": false
                  }, {
                    "value": "\"snowflake\"",
                    "computed": false
                  }, {
                    "value": "\"sortable\"",
                    "computed": false
                  }, {
                    "value": "\"sortDown\"",
                    "computed": false
                  }, {
                    "value": "\"sortLeft\"",
                    "computed": false
                  }, {
                    "value": "\"sortRight\"",
                    "computed": false
                  }, {
                    "value": "\"sortUp\"",
                    "computed": false
                  }, {
                    "value": "\"spacesApp\"",
                    "computed": false
                  }, {
                    "value": "\"sqlApp\"",
                    "computed": false
                  }, {
                    "value": "\"starEmpty\"",
                    "computed": false
                  }, {
                    "value": "\"starEmptySpace\"",
                    "computed": false
                  }, {
                    "value": "\"starFilled\"",
                    "computed": false
                  }, {
                    "value": "\"starFilledSpace\"",
                    "computed": false
                  }, {
                    "value": "\"starMinusEmpty\"",
                    "computed": false
                  }, {
                    "value": "\"starMinusFilled\"",
                    "computed": false
                  }, {
                    "value": "\"starPlusEmpty\"",
                    "computed": false
                  }, {
                    "value": "\"starPlusFilled\"",
                    "computed": false
                  }, {
                    "value": "\"stats\"",
                    "computed": false
                  }, {
                    "value": "\"stop\"",
                    "computed": false
                  }, {
                    "value": "\"stopFilled\"",
                    "computed": false
                  }, {
                    "value": "\"stopSlash\"",
                    "computed": false
                  }, {
                    "value": "\"storage\"",
                    "computed": false
                  }, {
                    "value": "\"string\"",
                    "computed": false
                  }, {
                    "value": "\"submodule\"",
                    "computed": false
                  }, {
                    "value": "\"swatchInput\"",
                    "computed": false
                  }, {
                    "value": "\"symlink\"",
                    "computed": false
                  }, {
                    "value": "\"tableOfContents\"",
                    "computed": false
                  }, {
                    "value": "\"tableDensityExpanded\"",
                    "computed": false
                  }, {
                    "value": "\"tableDensityCompact\"",
                    "computed": false
                  }, {
                    "value": "\"tableDensityNormal\"",
                    "computed": false
                  }, {
                    "value": "\"tag\"",
                    "computed": false
                  }, {
                    "value": "\"tear\"",
                    "computed": false
                  }, {
                    "value": "\"temperature\"",
                    "computed": false
                  }, {
                    "value": "\"timeline\"",
                    "computed": false
                  }, {
                    "value": "\"timelionApp\"",
                    "computed": false
                  }, {
                    "value": "\"training\"",
                    "computed": false
                  }, {
                    "value": "\"trash\"",
                    "computed": false
                  }, {
                    "value": "\"upgradeAssistantApp\"",
                    "computed": false
                  }, {
                    "value": "\"uptimeApp\"",
                    "computed": false
                  }, {
                    "value": "\"user\"",
                    "computed": false
                  }, {
                    "value": "\"users\"",
                    "computed": false
                  }, {
                    "value": "\"usersRolesApp\"",
                    "computed": false
                  }, {
                    "value": "\"vector\"",
                    "computed": false
                  }, {
                    "value": "\"videoPlayer\"",
                    "computed": false
                  }, {
                    "value": "\"visArea\"",
                    "computed": false
                  }, {
                    "value": "\"visAreaStacked\"",
                    "computed": false
                  }, {
                    "value": "\"visBarHorizontal\"",
                    "computed": false
                  }, {
                    "value": "\"visBarHorizontalStacked\"",
                    "computed": false
                  }, {
                    "value": "\"visBarVertical\"",
                    "computed": false
                  }, {
                    "value": "\"visBarVerticalStacked\"",
                    "computed": false
                  }, {
                    "value": "\"visGauge\"",
                    "computed": false
                  }, {
                    "value": "\"visGoal\"",
                    "computed": false
                  }, {
                    "value": "\"visLine\"",
                    "computed": false
                  }, {
                    "value": "\"visMapCoordinate\"",
                    "computed": false
                  }, {
                    "value": "\"visMapRegion\"",
                    "computed": false
                  }, {
                    "value": "\"visMetric\"",
                    "computed": false
                  }, {
                    "value": "\"visPie\"",
                    "computed": false
                  }, {
                    "value": "\"visTable\"",
                    "computed": false
                  }, {
                    "value": "\"visTagCloud\"",
                    "computed": false
                  }, {
                    "value": "\"visText\"",
                    "computed": false
                  }, {
                    "value": "\"visTimelion\"",
                    "computed": false
                  }, {
                    "value": "\"visualizeApp\"",
                    "computed": false
                  }, {
                    "value": "\"visVega\"",
                    "computed": false
                  }, {
                    "value": "\"visVisualBuilder\"",
                    "computed": false
                  }, {
                    "value": "\"watchesApp\"",
                    "computed": false
                  }, {
                    "value": "\"wrench\"",
                    "computed": false
                  }, {
                    "value": "\"tokenClass\"",
                    "computed": false
                  }, {
                    "value": "\"tokenProperty\"",
                    "computed": false
                  }, {
                    "value": "\"tokenEnum\"",
                    "computed": false
                  }, {
                    "value": "\"tokenVariable\"",
                    "computed": false
                  }, {
                    "value": "\"tokenMethod\"",
                    "computed": false
                  }, {
                    "value": "\"tokenAnnotation\"",
                    "computed": false
                  }, {
                    "value": "\"tokenException\"",
                    "computed": false
                  }, {
                    "value": "\"tokenInterface\"",
                    "computed": false
                  }, {
                    "value": "\"tokenParameter\"",
                    "computed": false
                  }, {
                    "value": "\"tokenField\"",
                    "computed": false
                  }, {
                    "value": "\"tokenElement\"",
                    "computed": false
                  }, {
                    "value": "\"tokenFunction\"",
                    "computed": false
                  }, {
                    "value": "\"tokenBoolean\"",
                    "computed": false
                  }, {
                    "value": "\"tokenString\"",
                    "computed": false
                  }, {
                    "value": "\"tokenArray\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNumber\"",
                    "computed": false
                  }, {
                    "value": "\"tokenConstant\"",
                    "computed": false
                  }, {
                    "value": "\"tokenObject\"",
                    "computed": false
                  }, {
                    "value": "\"tokenEvent\"",
                    "computed": false
                  }, {
                    "value": "\"tokenKey\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNull\"",
                    "computed": false
                  }, {
                    "value": "\"tokenStruct\"",
                    "computed": false
                  }, {
                    "value": "\"tokenPackage\"",
                    "computed": false
                  }, {
                    "value": "\"tokenOperator\"",
                    "computed": false
                  }, {
                    "value": "\"tokenEnumMember\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRepo\"",
                    "computed": false
                  }, {
                    "value": "\"tokenSymbol\"",
                    "computed": false
                  }, {
                    "value": "\"tokenFile\"",
                    "computed": false
                  }, {
                    "value": "\"tokenModule\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNamespace\"",
                    "computed": false
                  }, {
                    "value": "\"tokenDate\"",
                    "computed": false
                  }, {
                    "value": "\"tokenIP\"",
                    "computed": false
                  }, {
                    "value": "\"tokenNested\"",
                    "computed": false
                  }, {
                    "value": "\"tokenAlias\"",
                    "computed": false
                  }, {
                    "value": "\"tokenShape\"",
                    "computed": false
                  }, {
                    "value": "\"tokenGeo\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRange\"",
                    "computed": false
                  }, {
                    "value": "\"tokenBinary\"",
                    "computed": false
                  }, {
                    "value": "\"tokenJoin\"",
                    "computed": false
                  }, {
                    "value": "\"tokenPercolator\"",
                    "computed": false
                  }, {
                    "value": "\"tokenFlattened\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRankFeature\"",
                    "computed": false
                  }, {
                    "value": "\"tokenRankFeatures\"",
                    "computed": false
                  }, {
                    "value": "\"tokenKeyword\"",
                    "computed": false
                  }, {
                    "value": "\"tokenCompletionSuggester\"",
                    "computed": false
                  }, {
                    "value": "\"tokenDenseVector\"",
                    "computed": false
                  }, {
                    "value": "\"tokenText\"",
                    "computed": false
                  }, {
                    "value": "\"tokenTokenCount\"",
                    "computed": false
                  }, {
                    "value": "\"tokenSearchType\"",
                    "computed": false
                  }, {
                    "value": "\"tokenHistogram\"",
                    "computed": false
                  }]
                }, {
                  "name": "string"
                }, {
                  "name": "elementType"
                }],
                "description": "Adds `EuiIcon` of `EuiIcon.type`",
                "required": false
              },
              "icon": {
                "name": "element",
                "description": "Custom node to pass as the icon. Cannot be used in conjunction\nwith `iconType`.",
                "required": false
              },
              "showToolTip": {
                "name": "bool",
                "description": "Display tooltip on list item",
                "required": false
              },
              "extraAction": {
                "name": "shape",
                "value": {
                  "onClick": {
                    "name": "func",
                    "required": false
                  },
                  "iconType": {
                    "name": "union",
                    "value": [{
                      "name": "enum",
                      "value": [{
                        "value": "\"accessibility\"",
                        "computed": false
                      }, {
                        "value": "\"addDataApp\"",
                        "computed": false
                      }, {
                        "value": "\"advancedSettingsApp\"",
                        "computed": false
                      }, {
                        "value": "\"aggregate\"",
                        "computed": false
                      }, {
                        "value": "\"alert\"",
                        "computed": false
                      }, {
                        "value": "\"annotation\"",
                        "computed": false
                      }, {
                        "value": "\"apmApp\"",
                        "computed": false
                      }, {
                        "value": "\"apmTrace\"",
                        "computed": false
                      }, {
                        "value": "\"apps\"",
                        "computed": false
                      }, {
                        "value": "\"arrowDown\"",
                        "computed": false
                      }, {
                        "value": "\"arrowLeft\"",
                        "computed": false
                      }, {
                        "value": "\"arrowRight\"",
                        "computed": false
                      }, {
                        "value": "\"arrowUp\"",
                        "computed": false
                      }, {
                        "value": "\"asterisk\"",
                        "computed": false
                      }, {
                        "value": "\"auditbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"beaker\"",
                        "computed": false
                      }, {
                        "value": "\"bell\"",
                        "computed": false
                      }, {
                        "value": "\"bellSlash\"",
                        "computed": false
                      }, {
                        "value": "\"bolt\"",
                        "computed": false
                      }, {
                        "value": "\"boxesHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"boxesVertical\"",
                        "computed": false
                      }, {
                        "value": "\"branch\"",
                        "computed": false
                      }, {
                        "value": "\"broom\"",
                        "computed": false
                      }, {
                        "value": "\"brush\"",
                        "computed": false
                      }, {
                        "value": "\"bug\"",
                        "computed": false
                      }, {
                        "value": "\"bullseye\"",
                        "computed": false
                      }, {
                        "value": "\"calendar\"",
                        "computed": false
                      }, {
                        "value": "\"canvasApp\"",
                        "computed": false
                      }, {
                        "value": "\"codeApp\"",
                        "computed": false
                      }, {
                        "value": "\"check\"",
                        "computed": false
                      }, {
                        "value": "\"checkInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"cheer\"",
                        "computed": false
                      }, {
                        "value": "\"clock\"",
                        "computed": false
                      }, {
                        "value": "\"cloudDrizzle\"",
                        "computed": false
                      }, {
                        "value": "\"cloudStormy\"",
                        "computed": false
                      }, {
                        "value": "\"cloudSunny\"",
                        "computed": false
                      }, {
                        "value": "\"compute\"",
                        "computed": false
                      }, {
                        "value": "\"console\"",
                        "computed": false
                      }, {
                        "value": "\"consoleApp\"",
                        "computed": false
                      }, {
                        "value": "\"controlsHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"controlsVertical\"",
                        "computed": false
                      }, {
                        "value": "\"copy\"",
                        "computed": false
                      }, {
                        "value": "\"copyClipboard\"",
                        "computed": false
                      }, {
                        "value": "\"createAdvancedJob\"",
                        "computed": false
                      }, {
                        "value": "\"createMultiMetricJob\"",
                        "computed": false
                      }, {
                        "value": "\"createPopulationJob\"",
                        "computed": false
                      }, {
                        "value": "\"createSingleMetricJob\"",
                        "computed": false
                      }, {
                        "value": "\"cross\"",
                        "computed": false
                      }, {
                        "value": "\"crossClusterReplicationApp\"",
                        "computed": false
                      }, {
                        "value": "\"crosshairs\"",
                        "computed": false
                      }, {
                        "value": "\"crossInACircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"currency\"",
                        "computed": false
                      }, {
                        "value": "\"cut\"",
                        "computed": false
                      }, {
                        "value": "\"dashboardApp\"",
                        "computed": false
                      }, {
                        "value": "\"database\"",
                        "computed": false
                      }, {
                        "value": "\"dataVisualizer\"",
                        "computed": false
                      }, {
                        "value": "\"devToolsApp\"",
                        "computed": false
                      }, {
                        "value": "\"discoverApp\"",
                        "computed": false
                      }, {
                        "value": "\"document\"",
                        "computed": false
                      }, {
                        "value": "\"documentEdit\"",
                        "computed": false
                      }, {
                        "value": "\"documents\"",
                        "computed": false
                      }, {
                        "value": "\"dot\"",
                        "computed": false
                      }, {
                        "value": "\"download\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignCenter\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorAlignRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorBold\"",
                        "computed": false
                      }, {
                        "value": "\"editorCodeBlock\"",
                        "computed": false
                      }, {
                        "value": "\"editorComment\"",
                        "computed": false
                      }, {
                        "value": "\"editorDistributeHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"editorDistributeVertical\"",
                        "computed": false
                      }, {
                        "value": "\"editorHeading\"",
                        "computed": false
                      }, {
                        "value": "\"editorItalic\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignBottom\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignCenter\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignMiddle\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorItemAlignTop\"",
                        "computed": false
                      }, {
                        "value": "\"editorLink\"",
                        "computed": false
                      }, {
                        "value": "\"editorOrderedList\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionBottomLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionBottomRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionTopLeft\"",
                        "computed": false
                      }, {
                        "value": "\"editorPositionTopRight\"",
                        "computed": false
                      }, {
                        "value": "\"editorRedo\"",
                        "computed": false
                      }, {
                        "value": "\"editorStrike\"",
                        "computed": false
                      }, {
                        "value": "\"editorTable\"",
                        "computed": false
                      }, {
                        "value": "\"editorUnderline\"",
                        "computed": false
                      }, {
                        "value": "\"editorUndo\"",
                        "computed": false
                      }, {
                        "value": "\"editorUnorderedList\"",
                        "computed": false
                      }, {
                        "value": "\"email\"",
                        "computed": false
                      }, {
                        "value": "\"empty\"",
                        "computed": false
                      }, {
                        "value": "\"emsApp\"",
                        "computed": false
                      }, {
                        "value": "\"exit\"",
                        "computed": false
                      }, {
                        "value": "\"expand\"",
                        "computed": false
                      }, {
                        "value": "\"expandMini\"",
                        "computed": false
                      }, {
                        "value": "\"exportAction\"",
                        "computed": false
                      }, {
                        "value": "\"eye\"",
                        "computed": false
                      }, {
                        "value": "\"eyeClosed\"",
                        "computed": false
                      }, {
                        "value": "\"faceHappy\"",
                        "computed": false
                      }, {
                        "value": "\"faceNeutral\"",
                        "computed": false
                      }, {
                        "value": "\"faceSad\"",
                        "computed": false
                      }, {
                        "value": "\"filebeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"filter\"",
                        "computed": false
                      }, {
                        "value": "\"flag\"",
                        "computed": false
                      }, {
                        "value": "\"folderCheck\"",
                        "computed": false
                      }, {
                        "value": "\"folderClosed\"",
                        "computed": false
                      }, {
                        "value": "\"folderExclamation\"",
                        "computed": false
                      }, {
                        "value": "\"folderOpen\"",
                        "computed": false
                      }, {
                        "value": "\"fullScreen\"",
                        "computed": false
                      }, {
                        "value": "\"gear\"",
                        "computed": false
                      }, {
                        "value": "\"gisApp\"",
                        "computed": false
                      }, {
                        "value": "\"glasses\"",
                        "computed": false
                      }, {
                        "value": "\"globe\"",
                        "computed": false
                      }, {
                        "value": "\"grab\"",
                        "computed": false
                      }, {
                        "value": "\"grabHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"graphApp\"",
                        "computed": false
                      }, {
                        "value": "\"grid\"",
                        "computed": false
                      }, {
                        "value": "\"grokApp\"",
                        "computed": false
                      }, {
                        "value": "\"heart\"",
                        "computed": false
                      }, {
                        "value": "\"heartbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"heatmap\"",
                        "computed": false
                      }, {
                        "value": "\"help\"",
                        "computed": false
                      }, {
                        "value": "\"home\"",
                        "computed": false
                      }, {
                        "value": "\"iInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"image\"",
                        "computed": false
                      }, {
                        "value": "\"importAction\"",
                        "computed": false
                      }, {
                        "value": "\"indexClose\"",
                        "computed": false
                      }, {
                        "value": "\"indexEdit\"",
                        "computed": false
                      }, {
                        "value": "\"indexFlush\"",
                        "computed": false
                      }, {
                        "value": "\"indexManagementApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexMapping\"",
                        "computed": false
                      }, {
                        "value": "\"indexOpen\"",
                        "computed": false
                      }, {
                        "value": "\"indexPatternApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexRollupApp\"",
                        "computed": false
                      }, {
                        "value": "\"indexSettings\"",
                        "computed": false
                      }, {
                        "value": "\"inputOutput\"",
                        "computed": false
                      }, {
                        "value": "\"inspect\"",
                        "computed": false
                      }, {
                        "value": "\"invert\"",
                        "computed": false
                      }, {
                        "value": "\"ip\"",
                        "computed": false
                      }, {
                        "value": "\"keyboardShortcut\"",
                        "computed": false
                      }, {
                        "value": "\"kqlField\"",
                        "computed": false
                      }, {
                        "value": "\"kqlFunction\"",
                        "computed": false
                      }, {
                        "value": "\"kqlOperand\"",
                        "computed": false
                      }, {
                        "value": "\"kqlSelector\"",
                        "computed": false
                      }, {
                        "value": "\"kqlValue\"",
                        "computed": false
                      }, {
                        "value": "\"lensApp\"",
                        "computed": false
                      }, {
                        "value": "\"link\"",
                        "computed": false
                      }, {
                        "value": "\"list\"",
                        "computed": false
                      }, {
                        "value": "\"listAdd\"",
                        "computed": false
                      }, {
                        "value": "\"lock\"",
                        "computed": false
                      }, {
                        "value": "\"lockOpen\"",
                        "computed": false
                      }, {
                        "value": "\"logsApp\"",
                        "computed": false
                      }, {
                        "value": "\"logoAerospike\"",
                        "computed": false
                      }, {
                        "value": "\"logoApache\"",
                        "computed": false
                      }, {
                        "value": "\"logoAPM\"",
                        "computed": false
                      }, {
                        "value": "\"logoAppSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoAWS\"",
                        "computed": false
                      }, {
                        "value": "\"logoAWSMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoAzure\"",
                        "computed": false
                      }, {
                        "value": "\"logoAzureMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoBeats\"",
                        "computed": false
                      }, {
                        "value": "\"logoBusinessAnalytics\"",
                        "computed": false
                      }, {
                        "value": "\"logoCeph\"",
                        "computed": false
                      }, {
                        "value": "\"logoCloud\"",
                        "computed": false
                      }, {
                        "value": "\"logoCloudEnterprise\"",
                        "computed": false
                      }, {
                        "value": "\"logoCode\"",
                        "computed": false
                      }, {
                        "value": "\"logoCodesandbox\"",
                        "computed": false
                      }, {
                        "value": "\"logoCouchbase\"",
                        "computed": false
                      }, {
                        "value": "\"logoDocker\"",
                        "computed": false
                      }, {
                        "value": "\"logoDropwizard\"",
                        "computed": false
                      }, {
                        "value": "\"logoElastic\"",
                        "computed": false
                      }, {
                        "value": "\"logoElasticsearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoElasticStack\"",
                        "computed": false
                      }, {
                        "value": "\"logoEnterpriseSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoEtcd\"",
                        "computed": false
                      }, {
                        "value": "\"logoGCP\"",
                        "computed": false
                      }, {
                        "value": "\"logoGCPMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoGithub\"",
                        "computed": false
                      }, {
                        "value": "\"logoGmail\"",
                        "computed": false
                      }, {
                        "value": "\"logoGolang\"",
                        "computed": false
                      }, {
                        "value": "\"logoGoogleG\"",
                        "computed": false
                      }, {
                        "value": "\"logoHAproxy\"",
                        "computed": false
                      }, {
                        "value": "\"logoIBM\"",
                        "computed": false
                      }, {
                        "value": "\"logoIBMMono\"",
                        "computed": false
                      }, {
                        "value": "\"logoKafka\"",
                        "computed": false
                      }, {
                        "value": "\"logoKibana\"",
                        "computed": false
                      }, {
                        "value": "\"logoKubernetes\"",
                        "computed": false
                      }, {
                        "value": "\"logoLogging\"",
                        "computed": false
                      }, {
                        "value": "\"logoLogstash\"",
                        "computed": false
                      }, {
                        "value": "\"logoMaps\"",
                        "computed": false
                      }, {
                        "value": "\"logoMemcached\"",
                        "computed": false
                      }, {
                        "value": "\"logoMetrics\"",
                        "computed": false
                      }, {
                        "value": "\"logoMongodb\"",
                        "computed": false
                      }, {
                        "value": "\"logoMySQL\"",
                        "computed": false
                      }, {
                        "value": "\"logoNginx\"",
                        "computed": false
                      }, {
                        "value": "\"logoObservability\"",
                        "computed": false
                      }, {
                        "value": "\"logoOsquery\"",
                        "computed": false
                      }, {
                        "value": "\"logoPhp\"",
                        "computed": false
                      }, {
                        "value": "\"logoPostgres\"",
                        "computed": false
                      }, {
                        "value": "\"logoPrometheus\"",
                        "computed": false
                      }, {
                        "value": "\"logoRabbitmq\"",
                        "computed": false
                      }, {
                        "value": "\"logoRedis\"",
                        "computed": false
                      }, {
                        "value": "\"logoSecurity\"",
                        "computed": false
                      }, {
                        "value": "\"logoSiteSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logoSketch\"",
                        "computed": false
                      }, {
                        "value": "\"logoSlack\"",
                        "computed": false
                      }, {
                        "value": "\"logoUptime\"",
                        "computed": false
                      }, {
                        "value": "\"logoWebhook\"",
                        "computed": false
                      }, {
                        "value": "\"logoWindows\"",
                        "computed": false
                      }, {
                        "value": "\"logoWorkplaceSearch\"",
                        "computed": false
                      }, {
                        "value": "\"logstashFilter\"",
                        "computed": false
                      }, {
                        "value": "\"logstashIf\"",
                        "computed": false
                      }, {
                        "value": "\"logstashInput\"",
                        "computed": false
                      }, {
                        "value": "\"logstashOutput\"",
                        "computed": false
                      }, {
                        "value": "\"logstashQueue\"",
                        "computed": false
                      }, {
                        "value": "\"machineLearningApp\"",
                        "computed": false
                      }, {
                        "value": "\"magnet\"",
                        "computed": false
                      }, {
                        "value": "\"magnifyWithMinus\"",
                        "computed": false
                      }, {
                        "value": "\"magnifyWithPlus\"",
                        "computed": false
                      }, {
                        "value": "\"managementApp\"",
                        "computed": false
                      }, {
                        "value": "\"mapMarker\"",
                        "computed": false
                      }, {
                        "value": "\"memory\"",
                        "computed": false
                      }, {
                        "value": "\"menu\"",
                        "computed": false
                      }, {
                        "value": "\"menuLeft\"",
                        "computed": false
                      }, {
                        "value": "\"menuRight\"",
                        "computed": false
                      }, {
                        "value": "\"merge\"",
                        "computed": false
                      }, {
                        "value": "\"metricbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"metricsApp\"",
                        "computed": false
                      }, {
                        "value": "\"minimize\"",
                        "computed": false
                      }, {
                        "value": "\"minusInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"minusInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"monitoringApp\"",
                        "computed": false
                      }, {
                        "value": "\"moon\"",
                        "computed": false
                      }, {
                        "value": "\"nested\"",
                        "computed": false
                      }, {
                        "value": "\"node\"",
                        "computed": false
                      }, {
                        "value": "\"notebookApp\"",
                        "computed": false
                      }, {
                        "value": "\"number\"",
                        "computed": false
                      }, {
                        "value": "\"offline\"",
                        "computed": false
                      }, {
                        "value": "\"online\"",
                        "computed": false
                      }, {
                        "value": "\"package\"",
                        "computed": false
                      }, {
                        "value": "\"packetbeatApp\"",
                        "computed": false
                      }, {
                        "value": "\"pageSelect\"",
                        "computed": false
                      }, {
                        "value": "\"pagesSelect\"",
                        "computed": false
                      }, {
                        "value": "\"partial\"",
                        "computed": false
                      }, {
                        "value": "\"paperClip\"",
                        "computed": false
                      }, {
                        "value": "\"pause\"",
                        "computed": false
                      }, {
                        "value": "\"pencil\"",
                        "computed": false
                      }, {
                        "value": "\"pin\"",
                        "computed": false
                      }, {
                        "value": "\"pinFilled\"",
                        "computed": false
                      }, {
                        "value": "\"pipelineApp\"",
                        "computed": false
                      }, {
                        "value": "\"play\"",
                        "computed": false
                      }, {
                        "value": "\"plusInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"plusInCircleFilled\"",
                        "computed": false
                      }, {
                        "value": "\"popout\"",
                        "computed": false
                      }, {
                        "value": "\"push\"",
                        "computed": false
                      }, {
                        "value": "\"questionInCircle\"",
                        "computed": false
                      }, {
                        "value": "\"quote\"",
                        "computed": false
                      }, {
                        "value": "\"recentlyViewedApp\"",
                        "computed": false
                      }, {
                        "value": "\"refresh\"",
                        "computed": false
                      }, {
                        "value": "\"reporter\"",
                        "computed": false
                      }, {
                        "value": "\"reportingApp\"",
                        "computed": false
                      }, {
                        "value": "\"save\"",
                        "computed": false
                      }, {
                        "value": "\"savedObjectsApp\"",
                        "computed": false
                      }, {
                        "value": "\"scale\"",
                        "computed": false
                      }, {
                        "value": "\"search\"",
                        "computed": false
                      }, {
                        "value": "\"searchProfilerApp\"",
                        "computed": false
                      }, {
                        "value": "\"securityAnalyticsApp\"",
                        "computed": false
                      }, {
                        "value": "\"securityApp\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignal\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignalDetected\"",
                        "computed": false
                      }, {
                        "value": "\"securitySignalResolved\"",
                        "computed": false
                      }, {
                        "value": "\"shard\"",
                        "computed": false
                      }, {
                        "value": "\"share\"",
                        "computed": false
                      }, {
                        "value": "\"snowflake\"",
                        "computed": false
                      }, {
                        "value": "\"sortable\"",
                        "computed": false
                      }, {
                        "value": "\"sortDown\"",
                        "computed": false
                      }, {
                        "value": "\"sortLeft\"",
                        "computed": false
                      }, {
                        "value": "\"sortRight\"",
                        "computed": false
                      }, {
                        "value": "\"sortUp\"",
                        "computed": false
                      }, {
                        "value": "\"spacesApp\"",
                        "computed": false
                      }, {
                        "value": "\"sqlApp\"",
                        "computed": false
                      }, {
                        "value": "\"starEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starEmptySpace\"",
                        "computed": false
                      }, {
                        "value": "\"starFilled\"",
                        "computed": false
                      }, {
                        "value": "\"starFilledSpace\"",
                        "computed": false
                      }, {
                        "value": "\"starMinusEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starMinusFilled\"",
                        "computed": false
                      }, {
                        "value": "\"starPlusEmpty\"",
                        "computed": false
                      }, {
                        "value": "\"starPlusFilled\"",
                        "computed": false
                      }, {
                        "value": "\"stats\"",
                        "computed": false
                      }, {
                        "value": "\"stop\"",
                        "computed": false
                      }, {
                        "value": "\"stopFilled\"",
                        "computed": false
                      }, {
                        "value": "\"stopSlash\"",
                        "computed": false
                      }, {
                        "value": "\"storage\"",
                        "computed": false
                      }, {
                        "value": "\"string\"",
                        "computed": false
                      }, {
                        "value": "\"submodule\"",
                        "computed": false
                      }, {
                        "value": "\"swatchInput\"",
                        "computed": false
                      }, {
                        "value": "\"symlink\"",
                        "computed": false
                      }, {
                        "value": "\"tableOfContents\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityExpanded\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityCompact\"",
                        "computed": false
                      }, {
                        "value": "\"tableDensityNormal\"",
                        "computed": false
                      }, {
                        "value": "\"tag\"",
                        "computed": false
                      }, {
                        "value": "\"tear\"",
                        "computed": false
                      }, {
                        "value": "\"temperature\"",
                        "computed": false
                      }, {
                        "value": "\"timeline\"",
                        "computed": false
                      }, {
                        "value": "\"timelionApp\"",
                        "computed": false
                      }, {
                        "value": "\"training\"",
                        "computed": false
                      }, {
                        "value": "\"trash\"",
                        "computed": false
                      }, {
                        "value": "\"upgradeAssistantApp\"",
                        "computed": false
                      }, {
                        "value": "\"uptimeApp\"",
                        "computed": false
                      }, {
                        "value": "\"user\"",
                        "computed": false
                      }, {
                        "value": "\"users\"",
                        "computed": false
                      }, {
                        "value": "\"usersRolesApp\"",
                        "computed": false
                      }, {
                        "value": "\"vector\"",
                        "computed": false
                      }, {
                        "value": "\"videoPlayer\"",
                        "computed": false
                      }, {
                        "value": "\"visArea\"",
                        "computed": false
                      }, {
                        "value": "\"visAreaStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visBarHorizontal\"",
                        "computed": false
                      }, {
                        "value": "\"visBarHorizontalStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visBarVertical\"",
                        "computed": false
                      }, {
                        "value": "\"visBarVerticalStacked\"",
                        "computed": false
                      }, {
                        "value": "\"visGauge\"",
                        "computed": false
                      }, {
                        "value": "\"visGoal\"",
                        "computed": false
                      }, {
                        "value": "\"visLine\"",
                        "computed": false
                      }, {
                        "value": "\"visMapCoordinate\"",
                        "computed": false
                      }, {
                        "value": "\"visMapRegion\"",
                        "computed": false
                      }, {
                        "value": "\"visMetric\"",
                        "computed": false
                      }, {
                        "value": "\"visPie\"",
                        "computed": false
                      }, {
                        "value": "\"visTable\"",
                        "computed": false
                      }, {
                        "value": "\"visTagCloud\"",
                        "computed": false
                      }, {
                        "value": "\"visText\"",
                        "computed": false
                      }, {
                        "value": "\"visTimelion\"",
                        "computed": false
                      }, {
                        "value": "\"visualizeApp\"",
                        "computed": false
                      }, {
                        "value": "\"visVega\"",
                        "computed": false
                      }, {
                        "value": "\"visVisualBuilder\"",
                        "computed": false
                      }, {
                        "value": "\"watchesApp\"",
                        "computed": false
                      }, {
                        "value": "\"wrench\"",
                        "computed": false
                      }, {
                        "value": "\"tokenClass\"",
                        "computed": false
                      }, {
                        "value": "\"tokenProperty\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEnum\"",
                        "computed": false
                      }, {
                        "value": "\"tokenVariable\"",
                        "computed": false
                      }, {
                        "value": "\"tokenMethod\"",
                        "computed": false
                      }, {
                        "value": "\"tokenAnnotation\"",
                        "computed": false
                      }, {
                        "value": "\"tokenException\"",
                        "computed": false
                      }, {
                        "value": "\"tokenInterface\"",
                        "computed": false
                      }, {
                        "value": "\"tokenParameter\"",
                        "computed": false
                      }, {
                        "value": "\"tokenField\"",
                        "computed": false
                      }, {
                        "value": "\"tokenElement\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFunction\"",
                        "computed": false
                      }, {
                        "value": "\"tokenBoolean\"",
                        "computed": false
                      }, {
                        "value": "\"tokenString\"",
                        "computed": false
                      }, {
                        "value": "\"tokenArray\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNumber\"",
                        "computed": false
                      }, {
                        "value": "\"tokenConstant\"",
                        "computed": false
                      }, {
                        "value": "\"tokenObject\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEvent\"",
                        "computed": false
                      }, {
                        "value": "\"tokenKey\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNull\"",
                        "computed": false
                      }, {
                        "value": "\"tokenStruct\"",
                        "computed": false
                      }, {
                        "value": "\"tokenPackage\"",
                        "computed": false
                      }, {
                        "value": "\"tokenOperator\"",
                        "computed": false
                      }, {
                        "value": "\"tokenEnumMember\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRepo\"",
                        "computed": false
                      }, {
                        "value": "\"tokenSymbol\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFile\"",
                        "computed": false
                      }, {
                        "value": "\"tokenModule\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNamespace\"",
                        "computed": false
                      }, {
                        "value": "\"tokenDate\"",
                        "computed": false
                      }, {
                        "value": "\"tokenIP\"",
                        "computed": false
                      }, {
                        "value": "\"tokenNested\"",
                        "computed": false
                      }, {
                        "value": "\"tokenAlias\"",
                        "computed": false
                      }, {
                        "value": "\"tokenShape\"",
                        "computed": false
                      }, {
                        "value": "\"tokenGeo\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRange\"",
                        "computed": false
                      }, {
                        "value": "\"tokenBinary\"",
                        "computed": false
                      }, {
                        "value": "\"tokenJoin\"",
                        "computed": false
                      }, {
                        "value": "\"tokenPercolator\"",
                        "computed": false
                      }, {
                        "value": "\"tokenFlattened\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRankFeature\"",
                        "computed": false
                      }, {
                        "value": "\"tokenRankFeatures\"",
                        "computed": false
                      }, {
                        "value": "\"tokenKeyword\"",
                        "computed": false
                      }, {
                        "value": "\"tokenCompletionSuggester\"",
                        "computed": false
                      }, {
                        "value": "\"tokenDenseVector\"",
                        "computed": false
                      }, {
                        "value": "\"tokenText\"",
                        "computed": false
                      }, {
                        "value": "\"tokenTokenCount\"",
                        "computed": false
                      }, {
                        "value": "\"tokenSearchType\"",
                        "computed": false
                      }, {
                        "value": "\"tokenHistogram\"",
                        "computed": false
                      }]
                    }, {
                      "name": "string"
                    }, {
                      "name": "elementType"
                    }],
                    "required": false
                  },
                  "color": {
                    "name": "enum",
                    "value": [{
                      "value": "\"danger\"",
                      "computed": false
                    }, {
                      "value": "\"disabled\"",
                      "computed": false
                    }, {
                      "value": "\"ghost\"",
                      "computed": false
                    }, {
                      "value": "\"primary\"",
                      "computed": false
                    }, {
                      "value": "\"subdued\"",
                      "computed": false
                    }, {
                      "value": "\"success\"",
                      "computed": false
                    }, {
                      "value": "\"text\"",
                      "computed": false
                    }, {
                      "value": "\"warning\"",
                      "computed": false
                    }],
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "aria-labelledby": {
                    "name": "string",
                    "required": false
                  },
                  "isDisabled": {
                    "name": "bool",
                    "required": false
                  },
                  "size": {
                    "name": "enum",
                    "value": [{
                      "value": "\"s\"",
                      "computed": false
                    }, {
                      "value": "\"m\"",
                      "computed": false
                    }],
                    "required": false
                  },
                  "iconSize": {
                    "name": "enum",
                    "value": [{
                      "value": "\"original\"",
                      "computed": false
                    }, {
                      "value": "\"s\"",
                      "computed": false
                    }, {
                      "value": "\"m\"",
                      "computed": false
                    }, {
                      "value": "\"l\"",
                      "computed": false
                    }, {
                      "value": "\"xl\"",
                      "computed": false
                    }, {
                      "value": "\"xxl\"",
                      "computed": false
                    }],
                    "required": false
                  },
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "buttonRef": {
                    "name": "any",
                    "required": false
                  },
                  "alwaysShow": {
                    "name": "bool",
                    "required": false
                  }
                },
                "description": "Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;\npass `alwaysShow` if you don't want the default behavior of only showing on hover",
                "required": false
              },
              "onClick": {
                "name": "func",
                "description": "Make the list item label a button.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems.",
                "required": false
              },
              "wrapText": {
                "name": "bool",
                "description": "Allow link text to wrap",
                "required": false
              },
              "buttonRef": {
                "name": "any",
                "description": "Pass-through ref reference specifically for targeting\ninstances where the item content is rendered as a `button`",
                "required": false
              }
            }
          }
        }]
      },
      "required": false,
      "description": "Extends `EuiListGroupItemProps`, at the very least, expecting a `label`.\nSee #EuiPinnableListGroupItem"
    },
    "onPinClick": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": "Shows the pin icon and calls this function on click.\nReturns `item: EuiPinnableListGroupItemProps`"
    },
    "pinTitle": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "The pin icon needs a title/aria-label for accessibility.\nIt is a function that passes the item back and must return a string `(item) => string`.\nDefault is `\"Pin item\"`"
    },
    "unpinTitle": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "The unpin icon needs a title/aria-label for accessibility.\nIt is a function that passes the item back and must return a string `(item) => string`.\nDefault is `\"Unpin item\"`"
    },
    "className": {
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "bordered": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Add a border to the list container"
    },
    "flush": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Remove container padding, stretching list items to the edges"
    },
    "gutterSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Spacing between list items"
    },
    "color": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.oneOf([\"inherit\", \"primary\", \"text\", \"subdued\", \"ghost\"])"
      },
      "required": false,
      "description": "Change the colors of all `listItems` at once"
    },
    "size": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.oneOf([\"xs\", \"s\", \"m\", \"l\"])"
      },
      "required": false,
      "description": "Change the size of all `listItems` at once"
    },
    "maxWidth": {
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "number"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "Sets the max-width of the page,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement."
    },
    "showToolTips": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Display tooltips on all list items"
    },
    "wrapText": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Allow link text to wrap vs truncated"
    },
    "ariaLabelledby": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};