"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiResizablePanelWithControls = euiResizablePanelWithControls;
exports.EuiResizablePanel = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _context = require("./context");

var _services = require("../../services");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var generatePanelId = (0, _services.htmlIdGenerator)('resizable-panel');

var EuiResizablePanel = function EuiResizablePanel(_ref) {
  var children = _ref.children,
      className = _ref.className,
      id = _ref.id,
      isHorizontal = _ref.isHorizontal,
      size = _ref.size,
      initialSize = _ref.initialSize,
      _ref$minSize = _ref.minSize,
      minSize = _ref$minSize === void 0 ? '0px' : _ref$minSize,
      _ref$scrollable = _ref.scrollable,
      scrollable = _ref$scrollable === void 0 ? true : _ref$scrollable,
      _ref$style = _ref.style,
      style = _ref$style === void 0 ? {} : _ref$style,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "id", "isHorizontal", "size", "initialSize", "minSize", "scrollable", "style"]);

  var _useState = (0, _react.useState)(initialSize && !size ? initialSize : 0),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      innerSize = _useState2[0],
      setInnerSize = _useState2[1];

  var _useEuiResizablePanel = (0, _context.useEuiResizablePanelContext)(),
      registry = _useEuiResizablePanel.registry;

  var divRef = (0, _react.useRef)(null);
  var panelId = (0, _react.useRef)(id || generatePanelId());
  var classes = (0, _classnames.default)({
    euiResizablePanel: scrollable
  }, className);
  var dimensions;

  if (size) {
    dimensions = {
      width: isHorizontal ? "".concat(size, "%") : '100%',
      height: isHorizontal ? '100%' : "".concat(size, "%")
    };
  } else {
    dimensions = {
      width: isHorizontal ? "".concat(innerSize, "%") : '100%',
      height: isHorizontal ? '100%' : "".concat(innerSize, "%")
    };
  }

  var styles = _objectSpread({}, style, {}, dimensions, {
    minWidth: isHorizontal ? minSize : 0,
    minHeight: isHorizontal ? 0 : minSize
  });

  (0, _react.useEffect)(function () {
    var id = panelId.current;
    registry && registry.registerPanel({
      id: id,
      setSize: function setSize(panelSize) {
        if (initialSize && !size) {
          setInnerSize(panelSize);
        }
      },
      getSizePx: function getSizePx() {
        return isHorizontal ? divRef.current.getBoundingClientRect().width : divRef.current.getBoundingClientRect().height;
      },
      minSize: minSize
    });
    return function () {
      registry && registry.deregisterPanel(id);
    };
  }, [initialSize, isHorizontal, minSize, registry, size]);
  return _react.default.createElement("div", (0, _extends2.default)({
    className: classes,
    id: panelId.current,
    ref: divRef,
    style: styles
  }, rest), children);
};

exports.EuiResizablePanel = EuiResizablePanel;
EuiResizablePanel.propTypes = {
  /**
     * Specify minimum panel size in pixels or percents,
     * for example "300px" or "30%"
     */
  minSize: _propTypes.default.string,

  /**
     * Specify id of panel if you want to track panel size in "onPanelWidthChange" callback
     */
  id: _propTypes.default.string,

  /**
     * Initial size of the panel in percents
     * Specify this prop if you don't need to handle the panel size from outside
     */
  initialSize: _propTypes.default.number,

  /**
     * Size of the panel in percents.
     * Specify this prop if you want to control the size from outside, the panel will ignore the "initialSize"
     */
  size: _propTypes.default.number,

  /**
     * Add Eui scroll and overflow for the panel
     */
  scrollable: _propTypes.default.bool,
  children: _propTypes.default.node.isRequired,

  /**
     * Custom CSS properties
     */
  style: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

function euiResizablePanelWithControls(controls) {
  return function (props) {
    return _react.default.createElement(EuiResizablePanel, (0, _extends2.default)({}, controls, props));
  };
}

EuiResizablePanel.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiResizablePanel",
  "props": {
    "minSize": {
      "defaultValue": {
        "value": "'0px'",
        "computed": false
      },
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Specify minimum panel size in pixels or percents,\nfor example \"300px\" or \"30%\""
    },
    "scrollable": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Add Eui scroll and overflow for the panel"
    },
    "style": {
      "defaultValue": {
        "value": "{}",
        "computed": false
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Custom CSS properties"
    },
    "id": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Specify id of panel if you want to track panel size in \"onPanelWidthChange\" callback"
    },
    "initialSize": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": "Initial size of the panel in percents\nSpecify this prop if you don't need to handle the panel size from outside"
    },
    "size": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": "Size of the panel in percents.\nSpecify this prop if you want to control the size from outside, the panel will ignore the \"initialSize\""
    },
    "children": {
      "type": {
        "name": "node"
      },
      "required": true,
      "description": ""
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};