"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiWindowEvent = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _react = require("react");

var _propTypes = _interopRequireDefault(require("prop-types"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiWindowEvent =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiWindowEvent, _Component);

  function EuiWindowEvent() {
    (0, _classCallCheck2.default)(this, EuiWindowEvent);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(EuiWindowEvent).apply(this, arguments));
  }

  (0, _createClass2.default)(EuiWindowEvent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.addEvent(this.props);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.event !== this.props.event || prevProps.handler !== this.props.handler) {
        this.removeEvent(prevProps);
        this.addEvent(this.props);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.removeEvent(this.props);
    }
  }, {
    key: "addEvent",
    value: function addEvent(_ref) {
      var event = _ref.event,
          handler = _ref.handler;
      window.addEventListener(event, handler);
    }
  }, {
    key: "removeEvent",
    value: function removeEvent(_ref2) {
      var event = _ref2.event,
          handler = _ref2.handler;
      window.removeEventListener(event, handler);
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);
  return EuiWindowEvent;
}(_react.Component);

exports.EuiWindowEvent = EuiWindowEvent;
EuiWindowEvent.propTypes = {
  event: _propTypes.default.any.isRequired,
  handler: _propTypes.default.func.isRequired
};
EuiWindowEvent.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "addEvent",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "{\n  event,\n  handler\n}",
      "type": null
    }],
    "returns": null
  }, {
    "name": "removeEvent",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "{\n  event,\n  handler\n}",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiWindowEvent",
  "props": {
    "event": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": ""
    },
    "handler": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    }
  }
};