"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compatibleSchemaTypes = compatibleSchemaTypes;
exports.isObjectMapping = isObjectMapping;
exports.generateMapping = generateMapping;

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function compatibleSchemaTypes(type) {
  switch (type) {
    case 'keyword':
    case 'text':
    case 'date':
      return 'string';

    case 'boolean':
      return 'boolean';

    case 'number':
    case 'float':
    case 'long':
      return 'number';

    default:
      throw new Error(`Unknown schema type ${type}`);
  }
}

function isObjectMapping(entity) {
  if (typeof entity === 'object') {
    // 'type' is explicitly specified to be an object.
    if (typeof entity.type === 'string' && entity.type === 'object') {
      return true;
    } // 'type' is not set; ES defaults to object mapping for when type is unspecified.


    if (typeof entity.type === 'undefined') {
      return true;
    } // 'type' is a field in the mapping and is not the type of the mapping.


    if (typeof entity.type === 'object') {
      return true;
    }
  }

  return false;
}

function transformToEsMapping(usageMappingValue) {
  const fieldMapping = {
    properties: {}
  };

  for (const [key, value] of Object.entries(usageMappingValue)) {
    fieldMapping.properties[key] = isObjectMapping(value) ? transformToEsMapping(value) : value;
  }

  return fieldMapping;
}

function generateMapping(usageCollections) {
  const esMapping = {
    properties: {}
  };

  for (const [, collecionDetails] of usageCollections) {
    esMapping.properties[collecionDetails.collectorName] = transformToEsMapping(collecionDetails.schema.value);
  }

  return esMapping;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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