import tabbables from './tabbables';
import { toArray } from './array';
import { FOCUS_AUTO } from '../constants';

export var getFocusables = function getFocusables(parents) {
  return parents.reduce(function (acc, parent) {
    return acc.concat(toArray(parent.querySelectorAll(tabbables.join(','))));
  }, []);
};

export var getParentAutofocusables = function getParentAutofocusables(parent) {
  var parentFocus = parent.querySelectorAll('[' + FOCUS_AUTO + ']');
  return toArray(parentFocus).map(function (node) {
    return getFocusables([node]);
  }).reduce(function (acc, nodes) {
    return acc.concat(nodes);
  }, []);
};