function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { I18nProvider } from '@kbn/i18n/react';
import { AppWrapper, AppContainer } from './app_containers';

/**
 * Renders all Core UI in a single React tree.
 *
 * @internalRemarks Currently this only renders Chrome UI. Notifications and
 * Overlays UI should be moved here as well.
 *
 * @returns a DOM element for the legacy platform to render into.
 *
 * @internal
 */
export var RenderingService = /*#__PURE__*/function () {
  function RenderingService() {
    _classCallCheck(this, RenderingService);
  }

  _createClass(RenderingService, [{
    key: "start",
    value: function start(_ref) {
      var application = _ref.application,
          chrome = _ref.chrome,
          injectedMetadata = _ref.injectedMetadata,
          overlays = _ref.overlays,
          targetDomElement = _ref.targetDomElement;
      var chromeUi = chrome.getHeaderComponent();
      var appUi = application.getComponent();
      var bannerUi = overlays.banners.getComponent();
      var legacyMode = injectedMetadata.getLegacyMode();
      var legacyRef = legacyMode ? /*#__PURE__*/React.createRef() : null;
      ReactDOM.render( /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement("div", {
        className: "content",
        "data-test-subj": "kibanaChrome"
      }, chromeUi, !legacyMode && /*#__PURE__*/React.createElement(AppWrapper, {
        chromeVisible$: chrome.getIsVisible$()
      }, /*#__PURE__*/React.createElement("div", {
        className: "app-wrapper-panel"
      }, /*#__PURE__*/React.createElement("div", {
        id: "globalBannerList"
      }, bannerUi), /*#__PURE__*/React.createElement(AppContainer, {
        classes$: chrome.getApplicationClasses$()
      }, appUi))), legacyMode && /*#__PURE__*/React.createElement("div", {
        ref: legacyRef
      }))), targetDomElement);
      return {
        // When in legacy mode, return legacy div, otherwise undefined.
        legacyTargetDomElement: legacyRef ? legacyRef.current : undefined
      };
    }
  }]);

  return RenderingService;
}();
/** @internal */