function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { fetchStreaming as fetchStreamingStatic } from './streaming';
import { removeLeadingSlash } from '../common';
import { createStreamingBatchedFunction } from './batching/create_streaming_batched_function'; // eslint-disable-next-line

export var BfetchPublicPlugin = /*#__PURE__*/function () {
  function BfetchPublicPlugin(initializerContext) {
    _classCallCheck(this, BfetchPublicPlugin);

    this.initializerContext = initializerContext;

    _defineProperty(this, "contract", void 0);

    _defineProperty(this, "fetchStreaming", function (version, basePath) {
      return function (params) {
        return fetchStreamingStatic(_objectSpread(_objectSpread({}, params), {}, {
          url: "".concat(basePath, "/").concat(removeLeadingSlash(params.url)),
          headers: _objectSpread({
            'Content-Type': 'application/json',
            'kbn-version': version
          }, params.headers || {})
        }));
      };
    });

    _defineProperty(this, "batchedFunction", function (fetchStreaming) {
      return function (params) {
        return createStreamingBatchedFunction(_objectSpread(_objectSpread({}, params), {}, {
          fetchStreaming: params.fetchStreaming || fetchStreaming
        }));
      };
    });
  }

  _createClass(BfetchPublicPlugin, [{
    key: "setup",
    value: function setup(core, plugins) {
      var version = this.initializerContext.env.packageInfo.version;
      var basePath = core.http.basePath.get();
      var fetchStreaming = this.fetchStreaming(version, basePath);
      var batchedFunction = this.batchedFunction(fetchStreaming);
      this.contract = {
        fetchStreaming: fetchStreaming,
        batchedFunction: batchedFunction
      };
      return this.contract;
    }
  }, {
    key: "start",
    value: function start(core, plugins) {
      return this.contract;
    }
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return BfetchPublicPlugin;
}();