function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useState } from 'react';
import { BehaviorSubject } from 'rxjs';
import { DARK_THEME, LIGHT_THEME } from '@elastic/charts';
import { EUI_CHARTS_THEME_DARK, EUI_CHARTS_THEME_LIGHT } from '@elastic/eui/dist/eui_charts_theme';
export var ThemeService = /*#__PURE__*/function () {
  function ThemeService() {
    var _this = this;

    _classCallCheck(this, ThemeService);

    _defineProperty(this, "chartsDefaultTheme", EUI_CHARTS_THEME_LIGHT.theme);

    _defineProperty(this, "chartsDefaultBaseTheme", LIGHT_THEME);

    _defineProperty(this, "_uiSettingsDarkMode$", void 0);

    _defineProperty(this, "_chartsTheme$", new BehaviorSubject(this.chartsDefaultTheme));

    _defineProperty(this, "_chartsBaseTheme$", new BehaviorSubject(this.chartsDefaultBaseTheme));

    _defineProperty(this, "chartsTheme$", this._chartsTheme$.asObservable());

    _defineProperty(this, "chartsBaseTheme$", this._chartsBaseTheme$.asObservable());

    _defineProperty(this, "useDarkMode", function () {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      var _useState = useState(false),
          _useState2 = _slicedToArray(_useState, 2),
          value = _useState2[0],
          update = _useState2[1]; // eslint-disable-next-line react-hooks/rules-of-hooks


      useEffect(function () {
        var s = _this.darkModeEnabled$.subscribe(update);

        return function () {
          return s.unsubscribe();
        };
      }, []);
      return value;
    });

    _defineProperty(this, "useChartsTheme", function () {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      var _useState3 = useState(_this.chartsDefaultTheme),
          _useState4 = _slicedToArray(_useState3, 2),
          value = _useState4[0],
          update = _useState4[1]; // eslint-disable-next-line react-hooks/rules-of-hooks


      useEffect(function () {
        var s = _this.chartsTheme$.subscribe(update);

        return function () {
          return s.unsubscribe();
        };
      }, []);
      return value;
    });

    _defineProperty(this, "useChartsBaseTheme", function () {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      var _useState5 = useState(_this.chartsDefaultBaseTheme),
          _useState6 = _slicedToArray(_useState5, 2),
          value = _useState6[0],
          update = _useState6[1]; // eslint-disable-next-line react-hooks/rules-of-hooks


      useEffect(function () {
        var s = _this.chartsBaseTheme$.subscribe(update);

        return function () {
          return s.unsubscribe();
        };
      }, []);
      return value;
    });
  }

  _createClass(ThemeService, [{
    key: "init",

    /** initialize service with uiSettings */
    value: function init(uiSettings) {
      var _this2 = this;

      this._uiSettingsDarkMode$ = uiSettings.get$('theme:darkMode');

      this._uiSettingsDarkMode$.subscribe(function (darkMode) {
        _this2._chartsTheme$.next(darkMode ? EUI_CHARTS_THEME_DARK.theme : EUI_CHARTS_THEME_LIGHT.theme);

        _this2._chartsBaseTheme$.next(darkMode ? DARK_THEME : LIGHT_THEME);
      });
    }
  }, {
    key: "darkModeEnabled$",

    /** An observable boolean for dark mode of kibana */
    get: function get() {
      if (!this._uiSettingsDarkMode$) {
        throw new Error('ThemeService not initialized');
      }

      return this._uiSettingsDarkMode$;
    }
    /** A React hook for consuming the dark mode value */

  }]);

  return ThemeService;
}();